package fr.ifremer.tutti.ui.swing.content.actions;

/*
 * #%L
 * Tutti :: UI
 * %%
 * Copyright (C) 2012 - 2014 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.google.common.base.Preconditions;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.service.ValidationService;
import fr.ifremer.tutti.ui.swing.TuttiScreen;
import fr.ifremer.tutti.ui.swing.content.MainUIHandler;
import fr.ifremer.tutti.ui.swing.content.operation.EditFishingOperationUI;
import fr.ifremer.tutti.ui.swing.content.operation.FishingOperationsUI;
import jaxx.runtime.swing.editor.bean.BeanFilterableComboBox;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import javax.swing.*;

/**
 * Opens the operations edition screen to edit the selected operations.
 *
 * @author Tony Chemit - chemit@codelutin.com
 * @since 1.0
 */
public class EditCatchesForSelectedCruiseAction extends AbstractChangeScreenAction {

    /** Logger. */
    private static final Log log =
            LogFactory.getLog(EditCatchesForSelectedCruiseAction.class);

    public EditCatchesForSelectedCruiseAction(MainUIHandler handler) {
        super(handler, true, TuttiScreen.EDIT_FISHING_OPERATION);
    }

    @Override
    public void doAction() throws Exception {
        Preconditions.checkState(getContext().isCruiseFilled());
        if (log.isInfoEnabled()) {
            log.info("Edit operations of cruise: " + getContext().getCruiseId());
        }
        getContext().setValidationContext(ValidationService.VALIDATION_CONTEXT_EDIT);
        loadReferantials(true);
        super.doAction();
    }

    @Override
    public void postSuccessAction() {
        super.postSuccessAction();

        SwingUtilities.invokeLater(
                new Runnable() {
                    @Override
                    public void run() {

                        FishingOperationsUI currentBody = (FishingOperationsUI) getHandler().getCurrentBody();

                        BeanFilterableComboBox<FishingOperation> comboBox = currentBody.getFishingOperationComboBox();
                        if (!comboBox.isEmpty()) {
                            FishingOperation selectedOperation = comboBox.getData().get(0);
                            currentBody.getModel().setSelectedFishingOperation(selectedOperation);
                        }

                        EditFishingOperationUI fishingOperationTabContent = currentBody.getFishingOperationTabContent();

                        JComponent componentToFocus = fishingOperationTabContent.getHandler().getComponentToFocus();
                        componentToFocus.requestFocusInWindow();

                    }
                }
        );

    }

}
