package fr.ifremer.tutti.ui.swing.util.computable;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2016 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.awt.Color;
import java.awt.LayoutManager;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.jaxx.widgets.number.NumberEditor;

public class ComputableDataEditor<E extends Number> extends NumberEditor {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_COMPUTED_DATA_COLOR = "computedDataColor";
    public static final String PROPERTY_DECIMAL_NUMBER = "decimalNumber";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAI1SPW8TQRAdX7CDY8JXRBREkPiq99JQWYIgB4sgExBuItyw9m18G+3dLbtz+GgQP4GfAD0NEh0VoqCmoEH8BYQoaBGzd47PgUPg4mTtvHnz5s179RXq1sDFfZ5lzKQxykiw2zd2d+8O98UIt4QdGakxMVD8ah54A2gFs3eLcHnQc+3+tN3vJJFOYhHPdbd7sGTxiRI2FAIRzh/uGFnr92fldqZTc8A6E1XF+uL7N+958OylB5BpUrdAq1z4V1e5yZEeeDJAOE2THnNf8XhMMoyMx6R32b11FLd2h0fiETyFxR40NDdEhnDp/1fOOfL+TCMcv7KTRkNhbgaSQBsI1/YMk3tGRMIwTBElSyWzExLBUpSKjYg6RT5UxTLF3y2OvGDQOuduIJwqkCJwxU6iEkPT3BKMT5DlDyV4ORAjGXFViKHmHOgcYNsxirFwWAPnDplJZ2LlmUofawOom5SeEdYGf172PpWKm679dlNHmFd/rq58evvlTffgkDWafaYSOpdDMlibRJN86UafKK7oTPPvcN0eQNMKRSHOQ7peIaw/LZM4mldYkHt+i9uQKOqLn9+9X334cQG8LiyphAdd7vDb0MTQkAuJCjJ9fTNXdGxylL4nnTaERijkOKSceFc3Mlp8vWLx2fRh88OPlf7rzfnlz/4VXhpQfwANGSsZizzH04hW5ralrUiDpIxiVThBawpoa0ghTOJ7PBbqF93j9PIeBAAA";
    private static final Log log = LogFactory.getLog(ComputableDataEditor.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected Color computedDataColor;
    protected Integer decimalNumber;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private ComputableDataEditor<E> $NumberEditor0 = this;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setBean(ComputableData<E> bean) {
            super.setBean(bean);
        }
    
        public void init() { super.setProperty(ComputableData.PROPERTY_DATA); super.init(); }
    
        public void setProperty(String property) {
            // cannot change the property
        }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public ComputableDataEditor(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public ComputableDataEditor(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ComputableDataEditor() {
        $initialize();
    }

    public ComputableDataEditor(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    public ComputableDataEditor(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public ComputableDataEditor(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ComputableDataEditor(boolean param0) {
        super(param0);
        $initialize();
    }

    public ComputableDataEditor(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public Color getComputedDataColor() {
        return computedDataColor;
    }

    public Integer getDecimalNumber() {
        return decimalNumber;
    }

    @Override
    public ComputableDataEditorHandler getHandler() {
        return (fr.ifremer.tutti.ui.swing.util.computable.ComputableDataEditorHandler)super.getHandler();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setComputedDataColor(Color computedDataColor) {
        Color oldValue = this.computedDataColor;
        this.computedDataColor = computedDataColor;
        firePropertyChange(PROPERTY_COMPUTED_DATA_COLOR, oldValue, computedDataColor);
    }

    public void setDecimalNumber(Integer decimalNumber) {
        Integer oldValue = this.decimalNumber;
        this.decimalNumber = decimalNumber;
        firePropertyChange(PROPERTY_DECIMAL_NUMBER, oldValue, decimalNumber);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createComputedDataColor() {
        $objectMap.put("computedDataColor", computedDataColor = null);
    }

    protected void createDecimalNumber() {
        $objectMap.put("decimalNumber", decimalNumber = null);
    }

    @Override
    protected ComputableDataEditorHandler createHandler() {
        return new ComputableDataEditorHandler();
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        handler.beforeInit(this);
        $objectMap.put("$NumberEditor0", $NumberEditor0);
        createComputedDataColor();
        createDecimalNumber();
        // inline creation of $NumberEditor0
        setName("$NumberEditor0");
        
        $completeSetup();
        handler.afterInit(this);
    }

}