package fr.ifremer.tutti.ui.swing.content;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2016 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.ui.swing.TuttiHelpBroker;
import fr.ifremer.tutti.ui.swing.TuttiScreen;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GraphicsConfiguration;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.BlockingLayerUI;
import jaxx.runtime.swing.StatusMessagePanel;
import jaxx.runtime.swing.help.JAXXHelpUI;
import jaxx.runtime.validator.swing.SwingValidatorMessageWidget;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTitledPanel;
import static org.nuiton.i18n.I18n.t;

public class MainUI extends JFrame implements JAXXHelpUI<TuttiHelpBroker>, TuttiUI<TuttiUIContext, MainUIHandler>, JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_BUSY_BLOCK_LAYER_UI_BLOCK = "busyBlockLayerUI.block";
    public static final String BINDING_BUSY_BLOCK_LAYER_UI_BLOCKING_COLOR = "busyBlockLayerUI.blockingColor";
    public static final String BINDING_ICHTYOMETER_STATUS_ENABLED = "ichtyometerStatus.enabled";
    public static final String BINDING_ICHTYOMETER_STATUS_TOOL_TIP_TEXT = "ichtyometerStatus.toolTipText";
    public static final String BINDING_MENU_ACTIONS_ENABLED = "menuActions.enabled";
    public static final String BINDING_MENU_ACTION_EDIT_CATCHES_ENABLED = "menuActionEditCatches.enabled";
    public static final String BINDING_MENU_ACTION_EDIT_CRUISE_ENABLED = "menuActionEditCruise.enabled";
    public static final String BINDING_MENU_ACTION_EDIT_PROGRAM_ENABLED = "menuActionEditProgram.enabled";
    public static final String BINDING_MENU_ACTION_EDIT_PROTOCOL_ENABLED = "menuActionEditProtocol.enabled";
    public static final String BINDING_MENU_ACTION_GENERATE_CRUISE_REPORT_ENABLED = "menuActionGenerateCruiseReport.enabled";
    public static final String BINDING_MENU_ACTION_GENERIC_FORMAT_EXPORT_ENABLED = "menuActionGenericFormatExport.enabled";
    public static final String BINDING_MENU_ACTION_GENERIC_FORMAT_IMPORT_ENABLED = "menuActionGenericFormatImport.enabled";
    public static final String BINDING_MENU_ACTION_SELECT_CRUISE_ENABLED = "menuActionSelectCruise.enabled";
    public static final String BINDING_MENU_ACTION_VALIDATE_CATCHES_ENABLED = "menuActionValidateCatches.enabled";
    public static final String BINDING_MENU_ADMINISTRATION_ENABLED = "menuAdministration.enabled";
    public static final String BINDING_MENU_CHANGE_LOCALE_FR_ENABLED = "menuChangeLocaleFR.enabled";
    public static final String BINDING_MENU_CHANGE_LOCALE_UK_ENABLED = "menuChangeLocaleUK.enabled";
    public static final String BINDING_MENU_EDIT_SAMPLE_CATEGORY_MODEL_ENABLED = "menuEditSampleCategoryModel.enabled";
    public static final String BINDING_MENU_FILE_CONFIGURATION_ENABLED = "menuFileConfiguration.enabled";
    public static final String BINDING_MENU_FILE_CONNECT_ICHTYOMETER_VISIBLE = "menuFileConnectIchtyometer.visible";
    public static final String BINDING_MENU_FILE_DISCONNECT_ICHTYOMETER_VISIBLE = "menuFileDisconnectIchtyometer.visible";
    public static final String BINDING_MENU_FILE_MANAGE_DB_ENABLED = "menuFileManageDb.enabled";
    public static final String BINDING_MENU_IMPORT_TEMPORARY_REFERENTIAL_ENABLED = "menuImportTemporaryReferential.enabled";
    public static final String BINDING_STATUS_SHOW_MEMORY_STATUS = "status.showMemoryStatus";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JSEPARATOR3_ENABLED = "$JSeparator3.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(MainUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JXTitledPanel body;
    protected JToolBar bottomBar;
    protected TuttiHelpBroker broker;
    protected BlockingLayerUI busyBlockLayerUI;
    protected final MainUIHandler handler = createHandler();
    protected JLabel ichtyometerStatus;
    protected MainUI mainFrame = this;
    protected JMenuBar menu;
    protected JMenuItem menuActionEditCatches;
    protected JMenuItem menuActionEditCruise;
    protected JMenuItem menuActionEditProgram;
    protected JMenuItem menuActionEditProtocol;
    protected JMenuItem menuActionGenerateCruiseReport;
    protected JMenuItem menuActionGenericFormatExport;
    protected JMenuItem menuActionGenericFormatImport;
    protected JMenuItem menuActionSelectCruise;
    protected JMenuItem menuActionValidateCatches;
    protected JMenu menuActions;
    protected JMenu menuAdministration;
    protected JMenu menuChangeLocale;
    protected JMenuItem menuChangeLocaleFR;
    protected JMenuItem menuChangeLocaleUK;
    protected JMenuItem menuEditSampleCategoryModel;
    protected JMenu menuFile;
    protected JMenuItem menuFileConfiguration;
    protected JMenuItem menuFileConnectIchtyometer;
    protected JMenuItem menuFileDisconnectIchtyometer;
    protected JMenuItem menuFileExit;
    protected JMenuItem menuFileManageDb;
    protected JMenuItem menuFileUpdateApplication;
    protected JMenuItem menuFileUpdateReport;
    protected JMenu menuHelp;
    protected JMenuItem menuHelpAbout;
    protected JMenuItem menuHelpSite;
    protected JMenuItem menuImportTemporaryReferential;
    protected JMenuItem menuShowHelp;
    protected TuttiUIContext model;
    protected JButton showHelp;
    protected StatusMessagePanel status;
    protected SwingValidatorMessageWidget validatorMessageWidget;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JSeparator $JSeparator0;
    private JSeparator $JSeparator1;
    private JSeparator $JSeparator2;
    private JSeparator $JSeparator3;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public MainUI(TuttiUIContext context) {
        TuttiUIUtil.setApplicationContext(this, context);
            $initialize();
    }

    public MainUI() {
        $initialize();
    }

    public MainUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public MainUI(GraphicsConfiguration param0) {
        super(param0);
        $initialize();
    }

    public MainUI(JAXXContext parentContext, GraphicsConfiguration param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public MainUI(String param0) {
        super(param0);
        $initialize();
    }

    public MainUI(JAXXContext parentContext, String param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public MainUI(String param0, GraphicsConfiguration param1) {
        super(param0 ,param1);
        $initialize();
    }

    public MainUI(JAXXContext parentContext, String param1, GraphicsConfiguration param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doWindowClosing__on__mainFrame(WindowEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        menuFileExit.getAction().actionPerformed(null);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JXTitledPanel getBody() {
        return body;
    }

    public JToolBar getBottomBar() {
        return bottomBar;
    }

    public TuttiHelpBroker getBroker() {
        return broker;
    }

    public BlockingLayerUI getBusyBlockLayerUI() {
        return busyBlockLayerUI;
    }

    public MainUIHandler getHandler() {
        return handler;
    }

    public JLabel getIchtyometerStatus() {
        return ichtyometerStatus;
    }

    public JMenuBar getMenu() {
        return menu;
    }

    public JMenuItem getMenuActionEditCatches() {
        return menuActionEditCatches;
    }

    public JMenuItem getMenuActionEditCruise() {
        return menuActionEditCruise;
    }

    public JMenuItem getMenuActionEditProgram() {
        return menuActionEditProgram;
    }

    public JMenuItem getMenuActionEditProtocol() {
        return menuActionEditProtocol;
    }

    public JMenuItem getMenuActionGenerateCruiseReport() {
        return menuActionGenerateCruiseReport;
    }

    public JMenuItem getMenuActionGenericFormatExport() {
        return menuActionGenericFormatExport;
    }

    public JMenuItem getMenuActionGenericFormatImport() {
        return menuActionGenericFormatImport;
    }

    public JMenuItem getMenuActionSelectCruise() {
        return menuActionSelectCruise;
    }

    public JMenuItem getMenuActionValidateCatches() {
        return menuActionValidateCatches;
    }

    public JMenu getMenuActions() {
        return menuActions;
    }

    public JMenu getMenuAdministration() {
        return menuAdministration;
    }

    public JMenu getMenuChangeLocale() {
        return menuChangeLocale;
    }

    public JMenuItem getMenuChangeLocaleFR() {
        return menuChangeLocaleFR;
    }

    public JMenuItem getMenuChangeLocaleUK() {
        return menuChangeLocaleUK;
    }

    public JMenuItem getMenuEditSampleCategoryModel() {
        return menuEditSampleCategoryModel;
    }

    public JMenu getMenuFile() {
        return menuFile;
    }

    public JMenuItem getMenuFileConfiguration() {
        return menuFileConfiguration;
    }

    public JMenuItem getMenuFileConnectIchtyometer() {
        return menuFileConnectIchtyometer;
    }

    public JMenuItem getMenuFileDisconnectIchtyometer() {
        return menuFileDisconnectIchtyometer;
    }

    public JMenuItem getMenuFileExit() {
        return menuFileExit;
    }

    public JMenuItem getMenuFileManageDb() {
        return menuFileManageDb;
    }

    public JMenuItem getMenuFileUpdateApplication() {
        return menuFileUpdateApplication;
    }

    public JMenuItem getMenuFileUpdateReport() {
        return menuFileUpdateReport;
    }

    public JMenu getMenuHelp() {
        return menuHelp;
    }

    public JMenuItem getMenuHelpAbout() {
        return menuHelpAbout;
    }

    public JMenuItem getMenuHelpSite() {
        return menuHelpSite;
    }

    public JMenuItem getMenuImportTemporaryReferential() {
        return menuImportTemporaryReferential;
    }

    public JMenuItem getMenuShowHelp() {
        return menuShowHelp;
    }

    public TuttiUIContext getModel() {
        return model;
    }

    public JButton getShowHelp() {
        return showHelp;
    }

    public StatusMessagePanel getStatus() {
        return status;
    }

    public SwingValidatorMessageWidget getValidatorMessageWidget() {
        return validatorMessageWidget;
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Other methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void registerHelpId(TuttiHelpBroker broker, Component component, String helpId) {
        broker.installUI(component, helpId);
    }

    @Override
    public void showHelp(String helpId) {
        getBroker().showHelp(this, helpId);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JSeparator get$JSeparator0() {
        return $JSeparator0;
    }

    protected JSeparator get$JSeparator1() {
        return $JSeparator1;
    }

    protected JSeparator get$JSeparator2() {
        return $JSeparator2;
    }

    protected JSeparator get$JSeparator3() {
        return $JSeparator3;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToBottomBar() {
        if (!allComponentsCreated) {
            return;
        }
        bottomBar.add(ichtyometerStatus);
        bottomBar.add(validatorMessageWidget);
    }

    protected void addChildrenToMainFrame() {
        if (!allComponentsCreated) {
            return;
        }
        add(bottomBar);
        add(showHelp);
        add(SwingUtil.boxComponentWithJxLayer(body), BorderLayout.CENTER);
        add(status, BorderLayout.SOUTH);
        mainFrame.setJMenuBar(menu);
    }

    protected void addChildrenToMenu() {
        if (!allComponentsCreated) {
            return;
        }
        menu.add(menuFile);
        menu.add(menuActions);
        menu.add(menuAdministration);
        menu.add(menuHelp);
    }

    protected void addChildrenToMenuActions() {
        if (!allComponentsCreated) {
            return;
        }
        menuActions.add(menuActionSelectCruise);
        menuActions.add(menuActionEditProgram);
        menuActions.add(menuActionEditCruise);
        menuActions.add(menuActionEditProtocol);
        menuActions.add(menuActionEditCatches);
        menuActions.add(menuActionValidateCatches);
        menuActions.add(menuActionGenerateCruiseReport);
        menuActions.add($JSeparator3);
        menuActions.add(menuActionGenericFormatExport);
        menuActions.add(menuActionGenericFormatImport);
    }

    protected void addChildrenToMenuAdministration() {
        if (!allComponentsCreated) {
            return;
        }
        menuAdministration.add(menuImportTemporaryReferential);
        menuAdministration.add(menuEditSampleCategoryModel);
    }

    protected void addChildrenToMenuChangeLocale() {
        if (!allComponentsCreated) {
            return;
        }
        menuChangeLocale.add(menuChangeLocaleUK);
        menuChangeLocale.add(menuChangeLocaleFR);
    }

    protected void addChildrenToMenuFile() {
        if (!allComponentsCreated) {
            return;
        }
        menuFile.add(menuFileConfiguration);
        menuFile.add(menuFileUpdateApplication);
        menuFile.add(menuFileUpdateReport);
        menuFile.add($JSeparator0);
        menuFile.add(menuFileConnectIchtyometer);
        menuFile.add(menuFileDisconnectIchtyometer);
        menuFile.add($JSeparator1);
        menuFile.add(menuFileManageDb);
        menuFile.add($JSeparator2);
        menuFile.add(menuFileExit);
    }

    protected void addChildrenToMenuHelp() {
        if (!allComponentsCreated) {
            return;
        }
        menuHelp.add(menuShowHelp);
        menuHelp.add(menuHelpSite);
        menuHelp.add(menuHelpAbout);
        menuHelp.add(menuChangeLocale);
    }

    protected void createBody() {
        $objectMap.put("body", body = new JXTitledPanel());
        
        body.setName("body");
        body.putClientProperty("help", "tutti.main.help");
    }

    protected void createBottomBar() {
        $objectMap.put("bottomBar", bottomBar = new JToolBar());
        
        bottomBar.setName("bottomBar");
        bottomBar.setBorderPainted(false);
        bottomBar.setFloatable(false);
    }

    protected void createBroker() {
        $objectMap.put("broker", broker = new TuttiHelpBroker("tutti.main.help"));
    }

    protected void createBusyBlockLayerUI() {
        $objectMap.put("busyBlockLayerUI", busyBlockLayerUI = new BlockingLayerUI());
        
        busyBlockLayerUI.setUseIcon(false);
    }

    protected MainUIHandler createHandler() {
        return new MainUIHandler();
    }

    protected void createIchtyometerStatus() {
        $objectMap.put("ichtyometerStatus", ichtyometerStatus = new JLabel());
        
        ichtyometerStatus.setName("ichtyometerStatus");
        ichtyometerStatus.putClientProperty("help", "tutti.main.status.ichtyometer.help");
    }

    protected void createMenu() {
        $objectMap.put("menu", menu = new JMenuBar());
        
        menu.setName("menu");
    }

    protected void createMenuActionEditCatches() {
        $objectMap.put("menuActionEditCatches", menuActionEditCatches = new JMenuItem());
        
        menuActionEditCatches.setName("menuActionEditCatches");
        menuActionEditCatches.setText(t("tutti.main.action.editCatches"));
        menuActionEditCatches.setToolTipText(t("tutti.main.action.editCatches.tip"));
        menuActionEditCatches.putClientProperty("help", "tutti.main.menu.action.editCatches.help");
        menuActionEditCatches.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.content.actions.EditCatchesForSelectedCruiseAction.class);
    }

    protected void createMenuActionEditCruise() {
        $objectMap.put("menuActionEditCruise", menuActionEditCruise = new JMenuItem());
        
        menuActionEditCruise.setName("menuActionEditCruise");
        menuActionEditCruise.setText(t("tutti.main.action.editSelectedCruise"));
        menuActionEditCruise.setToolTipText(t("tutti.main.action.editSelectedCruise.tip"));
        menuActionEditCruise.putClientProperty("help", "tutti.main.menu.action.editCruise.help");
        menuActionEditCruise.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.content.actions.EditSelectedCruiseAction.class);
    }

    protected void createMenuActionEditProgram() {
        $objectMap.put("menuActionEditProgram", menuActionEditProgram = new JMenuItem());
        
        menuActionEditProgram.setName("menuActionEditProgram");
        menuActionEditProgram.setText(t("tutti.main.action.editSelectedProgram"));
        menuActionEditProgram.setToolTipText(t("tutti.main.action.editProgram.tip"));
        menuActionEditProgram.putClientProperty("help", "tutti.main.menu.action.editProgram.help");
        menuActionEditProgram.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.content.actions.EditSelectedProgramAction.class);
    }

    protected void createMenuActionEditProtocol() {
        $objectMap.put("menuActionEditProtocol", menuActionEditProtocol = new JMenuItem());
        
        menuActionEditProtocol.setName("menuActionEditProtocol");
        menuActionEditProtocol.setText(t("tutti.main.action.editSelectedProtocol"));
        menuActionEditProtocol.setToolTipText(t("tutti.main.action.editSelectedProtocol.tip"));
        menuActionEditProtocol.putClientProperty("help", "tutti.main.menu.action.editProtocol.help");
        menuActionEditProtocol.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.content.actions.EditSelectedProtocolAction.class);
    }

    protected void createMenuActionGenerateCruiseReport() {
        $objectMap.put("menuActionGenerateCruiseReport", menuActionGenerateCruiseReport = new JMenuItem());
        
        menuActionGenerateCruiseReport.setName("menuActionGenerateCruiseReport");
        menuActionGenerateCruiseReport.setText(t("tutti.main.action.generateSelectedCruiseReport"));
        menuActionGenerateCruiseReport.setToolTipText(t("tutti.main.action.generateSelectedCruiseReport.tip"));
        menuActionGenerateCruiseReport.putClientProperty("help", "tutti.main.menu.action.generateSelectedCruiseReport.help");
        menuActionGenerateCruiseReport.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.content.actions.OpenReportScreenAction.class);
    }

    protected void createMenuActionGenericFormatExport() {
        $objectMap.put("menuActionGenericFormatExport", menuActionGenericFormatExport = new JMenuItem());
        
        menuActionGenericFormatExport.setName("menuActionGenericFormatExport");
        menuActionGenericFormatExport.setText(t("tutti.main.action.genericFormatExport"));
        menuActionGenericFormatExport.setToolTipText(t("tutti.main.action.genericFormatExport.tip"));
        menuActionGenericFormatExport.putClientProperty("help", "tutti.main.menu.action.genericFormatExport.help");
        menuActionGenericFormatExport.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.content.actions.OpenGenericFormatExportScreen.class);
    }

    protected void createMenuActionGenericFormatImport() {
        $objectMap.put("menuActionGenericFormatImport", menuActionGenericFormatImport = new JMenuItem());
        
        menuActionGenericFormatImport.setName("menuActionGenericFormatImport");
        menuActionGenericFormatImport.setText(t("tutti.main.action.genericFormatImport"));
        menuActionGenericFormatImport.setToolTipText(t("tutti.main.action.genericFormatImport.tip"));
        menuActionGenericFormatImport.putClientProperty("help", "tutti.main.menu.action.genericFormatImport.help");
        menuActionGenericFormatImport.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.content.actions.OpenGenericFormatImportScreen.class);
    }

    protected void createMenuActionSelectCruise() {
        $objectMap.put("menuActionSelectCruise", menuActionSelectCruise = new JMenuItem());
        
        menuActionSelectCruise.setName("menuActionSelectCruise");
        menuActionSelectCruise.setText(t("tutti.main.action.selectCruise"));
        menuActionSelectCruise.setToolTipText(t("tutti.main.action.selectCruise.tip"));
        menuActionSelectCruise.putClientProperty("help", "tutti.main.menu.action.selectCruise.help");
        menuActionSelectCruise.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.content.actions.OpenHomeScreenAction.class);
    }

    protected void createMenuActionValidateCatches() {
        $objectMap.put("menuActionValidateCatches", menuActionValidateCatches = new JMenuItem());
        
        menuActionValidateCatches.setName("menuActionValidateCatches");
        menuActionValidateCatches.setText(t("tutti.main.action.validateCatches"));
        menuActionValidateCatches.setToolTipText(t("tutti.main.action.validateCatches.tip"));
        menuActionValidateCatches.putClientProperty("help", "tutti.main.menu.action.validateCatches.help");
        menuActionValidateCatches.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.content.actions.ValidateSelectedCruiseAction.class);
    }

    protected void createMenuActions() {
        $objectMap.put("menuActions", menuActions = new JMenu());
        
        menuActions.setName("menuActions");
        menuActions.setText(t("tutti.main.menu.actions"));
        menuActions.setToolTipText(t("tutti.main.menu.actions.tip"));
        menuActions.putClientProperty("skipAction", true);
    }

    protected void createMenuAdministration() {
        $objectMap.put("menuAdministration", menuAdministration = new JMenu());
        
        menuAdministration.setName("menuAdministration");
        menuAdministration.setText(t("tutti.main.menu.administration"));
        menuAdministration.setToolTipText(t("tutti.main.menu.administration.tip"));
        menuAdministration.putClientProperty("skipAction", true);
    }

    protected void createMenuChangeLocale() {
        $objectMap.put("menuChangeLocale", menuChangeLocale = new JMenu());
        
        menuChangeLocale.setName("menuChangeLocale");
        menuChangeLocale.setText(t("tutti.main.menu.changeLocale"));
        menuChangeLocale.setToolTipText(t("tutti.main.action.changeLocale.tip"));
        menuChangeLocale.putClientProperty("help", "tutti.main.menu.action.changeLocale.help");
        menuChangeLocale.putClientProperty("skipAction", true);
    }

    protected void createMenuChangeLocaleFR() {
        $objectMap.put("menuChangeLocaleFR", menuChangeLocaleFR = new JMenuItem());
        
        menuChangeLocaleFR.setName("menuChangeLocaleFR");
        menuChangeLocaleFR.setText(t("tutti.main.action.changeLocaleFR"));
        menuChangeLocaleFR.setToolTipText(t("tutti.main.action.changeLocaleFR.tip"));
        menuChangeLocaleFR.putClientProperty("help", "tutti.main.menu.action.changeLocaleFR.help");
        menuChangeLocaleFR.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.content.actions.ChangeToLocaleFRAction.class);
    }

    protected void createMenuChangeLocaleUK() {
        $objectMap.put("menuChangeLocaleUK", menuChangeLocaleUK = new JMenuItem());
        
        menuChangeLocaleUK.setName("menuChangeLocaleUK");
        menuChangeLocaleUK.setText(t("tutti.main.action.changeLocaleUK"));
        menuChangeLocaleUK.setToolTipText(t("tutti.main.action.changeLocaleUK.tip"));
        menuChangeLocaleUK.putClientProperty("help", "tutti.main.menu.action.changeLocaleUK.help");
        menuChangeLocaleUK.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.content.actions.ChangeToLocaleUKAction.class);
    }

    protected void createMenuEditSampleCategoryModel() {
        $objectMap.put("menuEditSampleCategoryModel", menuEditSampleCategoryModel = new JMenuItem());
        
        menuEditSampleCategoryModel.setName("menuEditSampleCategoryModel");
        menuEditSampleCategoryModel.setText(t("tutti.main.action.editSampleCategoryModel"));
        menuEditSampleCategoryModel.setToolTipText(t("tutti.main.action.editSampleCategoryModel.tip"));
        menuEditSampleCategoryModel.putClientProperty("help", "tutti.main.menu.action.editSampleCategoryModel.help");
        menuEditSampleCategoryModel.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.content.actions.OpenSampleCategoryModelScreenAction.class);
    }

    protected void createMenuFile() {
        $objectMap.put("menuFile", menuFile = new JMenu());
        
        menuFile.setName("menuFile");
        menuFile.setText(t("tutti.main.menu.file"));
        menuFile.setToolTipText(t("tutti.main.menu.file.tip"));
        menuFile.putClientProperty("skipAction", true);
    }

    protected void createMenuFileConfiguration() {
        $objectMap.put("menuFileConfiguration", menuFileConfiguration = new JMenuItem());
        
        menuFileConfiguration.setName("menuFileConfiguration");
        menuFileConfiguration.setText(t("tutti.main.action.configuration"));
        menuFileConfiguration.setToolTipText(t("tutti.main.action.configuration.tip"));
        menuFileConfiguration.putClientProperty("help", "tutti.main.menu.action.configuration.help");
        menuFileConfiguration.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.content.actions.ShowConfigAction.class);
    }

    protected void createMenuFileConnectIchtyometer() {
        $objectMap.put("menuFileConnectIchtyometer", menuFileConnectIchtyometer = new JMenuItem());
        
        menuFileConnectIchtyometer.setName("menuFileConnectIchtyometer");
        menuFileConnectIchtyometer.setText(t("tutti.main.action.connectIchtyometer"));
        menuFileConnectIchtyometer.setToolTipText(t("tutti.main.action.connectIchtyometer.tip"));
        menuFileConnectIchtyometer.putClientProperty("help", "tutti.main.menu.action.connectIchtyometer.help");
        menuFileConnectIchtyometer.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.content.actions.ConnectIchtyometerAction.class);
    }

    protected void createMenuFileDisconnectIchtyometer() {
        $objectMap.put("menuFileDisconnectIchtyometer", menuFileDisconnectIchtyometer = new JMenuItem());
        
        menuFileDisconnectIchtyometer.setName("menuFileDisconnectIchtyometer");
        menuFileDisconnectIchtyometer.setText(t("tutti.main.action.disconnectIchtyometer"));
        menuFileDisconnectIchtyometer.setToolTipText(t("tutti.main.action.disconnectIchtyometer.tip"));
        menuFileDisconnectIchtyometer.putClientProperty("help", "tutti.main.menu.action.disconnectIchtyometer.help");
        menuFileDisconnectIchtyometer.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.content.actions.DisconnectIchtyometerAction.class);
    }

    protected void createMenuFileExit() {
        $objectMap.put("menuFileExit", menuFileExit = new JMenuItem());
        
        menuFileExit.setName("menuFileExit");
        menuFileExit.setText(t("tutti.main.action.exit"));
        menuFileExit.setToolTipText(t("tutti.main.action.exit.tip"));
        menuFileExit.putClientProperty("help", "tutti.main.menu.action.exit.help");
        menuFileExit.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.content.actions.CloseApplicationAction.class);
    }

    protected void createMenuFileManageDb() {
        $objectMap.put("menuFileManageDb", menuFileManageDb = new JMenuItem());
        
        menuFileManageDb.setName("menuFileManageDb");
        menuFileManageDb.setText(t("tutti.main.action.manageDb"));
        menuFileManageDb.setToolTipText(t("tutti.main.action.manageDb.tip"));
        menuFileManageDb.putClientProperty("help", "tutti.main.menu.action.manageDb.help");
        menuFileManageDb.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.content.actions.OpenDbScreenAction.class);
    }

    protected void createMenuFileUpdateApplication() {
        $objectMap.put("menuFileUpdateApplication", menuFileUpdateApplication = new JMenuItem());
        
        menuFileUpdateApplication.setName("menuFileUpdateApplication");
        menuFileUpdateApplication.setText(t("tutti.main.action.updateApplication"));
        menuFileUpdateApplication.setToolTipText(t("tutti.main.action.updateApplication.tip"));
        menuFileUpdateApplication.putClientProperty("help", "tutti.main.menu.action.updateApplication.help");
        menuFileUpdateApplication.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.update.actions.UpdateApplicationAction.class);
    }

    protected void createMenuFileUpdateReport() {
        $objectMap.put("menuFileUpdateReport", menuFileUpdateReport = new JMenuItem());
        
        menuFileUpdateReport.setName("menuFileUpdateReport");
        menuFileUpdateReport.setText(t("tutti.main.action.updateReport"));
        menuFileUpdateReport.setToolTipText(t("tutti.main.action.updateReport.tip"));
        menuFileUpdateReport.putClientProperty("help", "tutti.main.menu.action.updateReport.help");
        menuFileUpdateReport.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.update.actions.UpdateReportAction.class);
    }

    protected void createMenuHelp() {
        $objectMap.put("menuHelp", menuHelp = new JMenu());
        
        menuHelp.setName("menuHelp");
        menuHelp.setText(t("tutti.main.menu.help"));
        menuHelp.setToolTipText(t("tutti.main.menu.help.tip"));
        menuHelp.putClientProperty("skipAction", true);
    }

    protected void createMenuHelpAbout() {
        $objectMap.put("menuHelpAbout", menuHelpAbout = new JMenuItem());
        
        menuHelpAbout.setName("menuHelpAbout");
        menuHelpAbout.setText(t("tutti.main.action.about"));
        menuHelpAbout.setToolTipText(t("tutti.main.action.about.tip"));
        menuHelpAbout.putClientProperty("help", "tutti.main.menu.action.about.help");
        menuHelpAbout.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.content.actions.ShowAboutAction.class);
    }

    protected void createMenuHelpSite() {
        $objectMap.put("menuHelpSite", menuHelpSite = new JMenuItem());
        
        menuHelpSite.setName("menuHelpSite");
        menuHelpSite.setText(t("tutti.main.action.site"));
        menuHelpSite.setToolTipText(t("tutti.main.action.site.tip"));
        menuHelpSite.putClientProperty("help", "tutti.main.menu.action.site.help");
        menuHelpSite.putClientProperty("simpleAction", fr.ifremer.tutti.ui.swing.content.actions.GotoSiteAction.class);
    }

    protected void createMenuImportTemporaryReferential() {
        $objectMap.put("menuImportTemporaryReferential", menuImportTemporaryReferential = new JMenuItem());
        
        menuImportTemporaryReferential.setName("menuImportTemporaryReferential");
        menuImportTemporaryReferential.setText(t("tutti.main.action.importTemporaryReferential"));
        menuImportTemporaryReferential.setToolTipText(t("tutti.main.action.importTemporaryReferential.tip"));
        menuImportTemporaryReferential.putClientProperty("help", "tutti.main.menu.action.importTemporaryReferential.help");
        menuImportTemporaryReferential.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.content.actions.OpenTemporaryReferentialScreenAction.class);
    }

    protected void createMenuShowHelp() {
        $objectMap.put("menuShowHelp", menuShowHelp = new JMenuItem());
        
        menuShowHelp.setName("menuShowHelp");
        menuShowHelp.setText(t("tutti.main.action.showHelp"));
        menuShowHelp.setToolTipText(t("tutti.main.action.showHelp.tip"));
        menuShowHelp.putClientProperty("help", "tutti.index.help");
        menuShowHelp.putClientProperty("simpleAction", fr.ifremer.tutti.ui.swing.content.actions.ShowHelpAction.class);
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(TuttiUIContext.class));
    }

    protected void createShowHelp() {
        $objectMap.put("showHelp", showHelp = new JButton());
        
        showHelp.setName("showHelp");
        showHelp.setFocusable(false);
        showHelp.setToolTipText(t("tutti.main.action.showHelp.tip"));
        showHelp.putClientProperty("help", "tutti.main.menu.action.showHelp.help");
        showHelp.putClientProperty("skipAction", true);
    }

    protected void createStatus() {
        $objectMap.put("status", status = new StatusMessagePanel());
        
        status.setName("status");
    }

    protected void createValidatorMessageWidget() {
        $objectMap.put("validatorMessageWidget", validatorMessageWidget = new SwingValidatorMessageWidget());
        
        validatorMessageWidget.setName("validatorMessageWidget");
        validatorMessageWidget.setFocusPainted(false);
        validatorMessageWidget.putClientProperty("help", "tutti.main.status.validation.help");
        validatorMessageWidget.putClientProperty("skipAction", true);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToMainFrame();
        addChildrenToMenu();
        addChildrenToMenuFile();
        addChildrenToMenuActions();
        addChildrenToMenuAdministration();
        addChildrenToMenuHelp();
        addChildrenToMenuChangeLocale();
        addChildrenToBottomBar();
        
        // apply 25 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 58 property setters
        setIconImage(SwingUtil.createImageIcon("allegro_32.png").getImage());
        setDefaultCloseOperation(JFrame.DO_NOTHING_ON_CLOSE);
        menuFile.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.main.menu.file.mnemonic"),'Z'));
        menuFileConfiguration.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.main.action.configuration.mnemonic"),'Z'));
        menuFileConfiguration.setIcon(SwingUtil.createActionIcon("config"));
        menuFileUpdateApplication.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.main.action.updateApplication.mnemonic"),'Z'));
        menuFileUpdateApplication.setIcon(SwingUtil.createActionIcon("update-application"));
        menuFileUpdateReport.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.main.action.updateReport.mnemonic"),'Z'));
        menuFileUpdateReport.setIcon(SwingUtil.createActionIcon("update-report"));
        menuFileConnectIchtyometer.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.main.action.connectIchtyometer.mnemonic"),'Z'));
        menuFileConnectIchtyometer.setIcon(SwingUtil.createActionIcon("bluetooth-down"));
        menuFileDisconnectIchtyometer.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.main.action.disconnectIchtyometer.mnemonic"),'Z'));
        menuFileDisconnectIchtyometer.setIcon(SwingUtil.createActionIcon("bluetooth-up"));
        menuFileManageDb.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.main.action.manageDb.mnemonic"),'Z'));
        menuFileManageDb.setIcon(SwingUtil.createActionIcon("manage-db"));
        menuFileExit.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.main.action.exit.mnemonic"),'Z'));
        menuFileExit.setIcon(SwingUtil.createActionIcon("exit"));
        menuActions.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.main.menu.actions.mnemonic"),'Z'));
        menuActionSelectCruise.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.main.action.selectCruise.mnemonic"),'Z'));
        menuActionSelectCruise.setIcon(SwingUtil.createActionIcon("home"));
        menuActionEditProgram.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.main.action.editSelectedProgram.mnemonic"),'Z'));
        menuActionEditProgram.setIcon(SwingUtil.createActionIcon("program"));
        menuActionEditCruise.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.main.action.editSelectedCruise.mnemonic"),'Z'));
        menuActionEditCruise.setIcon(SwingUtil.createActionIcon("cruise"));
        menuActionEditProtocol.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.main.action.editSelectedProtocol.mnemonic"),'Z'));
        menuActionEditProtocol.setIcon(SwingUtil.createActionIcon("protocol"));
        menuActionEditCatches.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.main.action.editCatches.mnemonic"),'Z'));
        menuActionEditCatches.setIcon(SwingUtil.createActionIcon("edit"));
        menuActionValidateCatches.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.main.action.validateCatches.mnemonic"),'Z'));
        menuActionValidateCatches.setIcon(SwingUtil.createActionIcon("validate"));
        menuActionGenerateCruiseReport.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.main.action.generateSelectedCruiseReport.mnemonic"),'Z'));
        menuActionGenerateCruiseReport.setIcon(SwingUtil.createActionIcon("report"));
        menuActionGenericFormatExport.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.main.action.genericFormatExport.mnemonic"),'Z'));
        menuActionGenericFormatExport.setIcon(SwingUtil.createActionIcon("export"));
        menuActionGenericFormatImport.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.main.action.genericFormatImport.mnemonic"),'Z'));
        menuActionGenericFormatImport.setIcon(SwingUtil.createActionIcon("import"));
        menuAdministration.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.main.menu.administration.mnemonic"),'Z'));
        menuImportTemporaryReferential.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.main.action.importTemporaryReferential.mnemonic"),'Z'));
        menuImportTemporaryReferential.setIcon(SwingUtil.createActionIcon("temporary-referential-import"));
        menuEditSampleCategoryModel.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.main.action.editSampleCategoryModel.mnemonic"),'Z'));
        menuEditSampleCategoryModel.setIcon(SwingUtil.createActionIcon("sampleOrder"));
        menuHelp.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.main.menu.help.mnemonic"),'Z'));
        menuShowHelp.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.main.action.showHelp.mnemonic"),'Z'));
        menuShowHelp.setIcon(SwingUtil.createActionIcon("help"));
        menuHelpSite.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.main.action.site.mnemonic"),'Z'));
        menuHelpSite.setIcon(SwingUtil.createActionIcon("site"));
        menuHelpAbout.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.main.action.about.mnemonic"),'Z'));
        menuHelpAbout.setIcon(SwingUtil.createActionIcon("about"));
        menuChangeLocale.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.main.action.changeLocale.mnemonic"),'Z'));
        menuChangeLocale.setIcon(SwingUtil.createActionIcon("translate"));
        menuChangeLocaleUK.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.main.action.changeLocaleUK.mnemonic"),'Z'));
        menuChangeLocaleUK.setIcon(SwingUtil.createActionIcon("i18n-uk"));
        menuChangeLocaleFR.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.main.action.changeLocaleFR.mnemonic"),'Z'));
        menuChangeLocaleFR.setIcon(SwingUtil.createActionIcon("i18n-fr"));
        bottomBar.setMargin(new java.awt.Insets(0, 0, 0, 5));
        ichtyometerStatus.setIcon(SwingUtil.createActionIcon("bluetooth-up"));
        ichtyometerStatus.setDisabledIcon(jaxx.runtime.SwingUtil.createActionIcon("bluetooth-down"));
        showHelp.setIcon(SwingUtil.createActionIcon("show-help"));
        // late initializer
        // help broker setup
        TuttiHelpBroker _broker = getBroker();
        registerHelpId(_broker, menuFileConfiguration, "tutti.main.menu.action.configuration.help");
        registerHelpId(_broker, menuFileUpdateApplication, "tutti.main.menu.action.updateApplication.help");
        registerHelpId(_broker, menuFileUpdateReport, "tutti.main.menu.action.updateReport.help");
        registerHelpId(_broker, menuFileConnectIchtyometer, "tutti.main.menu.action.connectIchtyometer.help");
        registerHelpId(_broker, menuFileDisconnectIchtyometer, "tutti.main.menu.action.disconnectIchtyometer.help");
        registerHelpId(_broker, menuFileManageDb, "tutti.main.menu.action.manageDb.help");
        registerHelpId(_broker, menuFileExit, "tutti.main.menu.action.exit.help");
        registerHelpId(_broker, menuActionSelectCruise, "tutti.main.menu.action.selectCruise.help");
        registerHelpId(_broker, menuActionEditProgram, "tutti.main.menu.action.editProgram.help");
        registerHelpId(_broker, menuActionEditCruise, "tutti.main.menu.action.editCruise.help");
        registerHelpId(_broker, menuActionEditProtocol, "tutti.main.menu.action.editProtocol.help");
        registerHelpId(_broker, menuActionEditCatches, "tutti.main.menu.action.editCatches.help");
        registerHelpId(_broker, menuActionValidateCatches, "tutti.main.menu.action.validateCatches.help");
        registerHelpId(_broker, menuActionGenerateCruiseReport, "tutti.main.menu.action.generateSelectedCruiseReport.help");
        registerHelpId(_broker, menuActionGenericFormatExport, "tutti.main.menu.action.genericFormatExport.help");
        registerHelpId(_broker, menuActionGenericFormatImport, "tutti.main.menu.action.genericFormatImport.help");
        registerHelpId(_broker, menuImportTemporaryReferential, "tutti.main.menu.action.importTemporaryReferential.help");
        registerHelpId(_broker, menuEditSampleCategoryModel, "tutti.main.menu.action.editSampleCategoryModel.help");
        registerHelpId(_broker, menuShowHelp, "tutti.index.help");
        registerHelpId(_broker, menuHelpSite, "tutti.main.menu.action.site.help");
        registerHelpId(_broker, menuHelpAbout, "tutti.main.menu.action.about.help");
        registerHelpId(_broker, menuChangeLocale, "tutti.main.menu.action.changeLocale.help");
        registerHelpId(_broker, menuChangeLocaleUK, "tutti.main.menu.action.changeLocaleUK.help");
        registerHelpId(_broker, menuChangeLocaleFR, "tutti.main.menu.action.changeLocaleFR.help");
        registerHelpId(_broker, ichtyometerStatus, "tutti.main.status.ichtyometer.help");
        registerHelpId(_broker, validatorMessageWidget, "tutti.main.status.validation.help");
        registerHelpId(_broker, showHelp, "tutti.main.menu.action.showHelp.help");
        registerHelpId(_broker, body, "tutti.main.help");
        _broker.prepareUI(this);
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        handler.beforeInit(this);
        $objectMap.put("mainFrame", mainFrame);
        createModel();
        createBroker();
        createBusyBlockLayerUI();
        createMenu();
        createMenuFile();
        createMenuFileConfiguration();
        createMenuFileUpdateApplication();
        createMenuFileUpdateReport();
        // inline creation of $JSeparator0
        $objectMap.put("$JSeparator0", $JSeparator0 = new JSeparator());
        
        $JSeparator0.setName("$JSeparator0");
        createMenuFileConnectIchtyometer();
        createMenuFileDisconnectIchtyometer();
        // inline creation of $JSeparator1
        $objectMap.put("$JSeparator1", $JSeparator1 = new JSeparator());
        
        $JSeparator1.setName("$JSeparator1");
        createMenuFileManageDb();
        // inline creation of $JSeparator2
        $objectMap.put("$JSeparator2", $JSeparator2 = new JSeparator());
        
        $JSeparator2.setName("$JSeparator2");
        createMenuFileExit();
        createMenuActions();
        createMenuActionSelectCruise();
        createMenuActionEditProgram();
        createMenuActionEditCruise();
        createMenuActionEditProtocol();
        createMenuActionEditCatches();
        createMenuActionValidateCatches();
        createMenuActionGenerateCruiseReport();
        // inline creation of $JSeparator3
        $objectMap.put("$JSeparator3", $JSeparator3 = new JSeparator());
        
        $JSeparator3.setName("$JSeparator3");
        createMenuActionGenericFormatExport();
        createMenuActionGenericFormatImport();
        createMenuAdministration();
        createMenuImportTemporaryReferential();
        createMenuEditSampleCategoryModel();
        createMenuHelp();
        createMenuShowHelp();
        createMenuHelpSite();
        createMenuHelpAbout();
        createMenuChangeLocale();
        createMenuChangeLocaleUK();
        createMenuChangeLocaleFR();
        createBottomBar();
        createIchtyometerStatus();
        createValidatorMessageWidget();
        createShowHelp();
        createBody();
        createStatus();
        // inline creation of mainFrame
        setName("mainFrame");
        SwingUtil.setComponentHeight(mainFrame,600);
        SwingUtil.setComponentWidth(mainFrame,800);
        setTitle(t("tutti.main.title.applicationName"));
        mainFrame.addWindowListener(JAXXUtil.getEventListener(WindowListener.class, "windowClosing", this, "doWindowClosing__on__mainFrame"));
        
        // registers 25 data bindings
        $registerDefaultBindings();
        $completeSetup();
        handler.afterInit(this);
    }

    private void $registerDefaultBindings() {
        // register 25 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_BUSY_BLOCK_LAYER_UI_BLOCK, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("busy", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    busyBlockLayerUI.setBlock(model.isBusy());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("busy", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_BUSY_BLOCK_LAYER_UI_BLOCKING_COLOR, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("config", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null && model.getConfig() != null) {
                    busyBlockLayerUI.setBlockingColor(model.getConfig().getColorBlockingLayer());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("config", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MENU_FILE_CONFIGURATION_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("screen", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    menuFileConfiguration.setEnabled(model.getScreen() != TuttiScreen.CONFIG);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("screen", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MENU_FILE_CONNECT_ICHTYOMETER_VISIBLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("ichtyometerConnected", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    menuFileConnectIchtyometer.setVisible(!model.isIchtyometerConnected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("ichtyometerConnected", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MENU_FILE_DISCONNECT_ICHTYOMETER_VISIBLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("ichtyometerConnected", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    menuFileDisconnectIchtyometer.setVisible(model.isIchtyometerConnected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("ichtyometerConnected", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MENU_FILE_MANAGE_DB_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("screen", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    menuFileManageDb.setEnabled(model.getScreen() != TuttiScreen.MANAGE_DB);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("screen", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MENU_ACTIONS_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("dbLoaded", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    menuActions.setEnabled(model.isDbLoaded());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("dbLoaded", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MENU_ACTION_SELECT_CRUISE_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("screen", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    menuActionSelectCruise.setEnabled(model.getScreen() != TuttiScreen.SELECT_CRUISE);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("screen", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MENU_ACTION_EDIT_PROGRAM_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("screen", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("programFilled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    menuActionEditProgram.setEnabled(model.getScreen() != TuttiScreen.EDIT_PROGRAM && model.isProgramFilled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("screen", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("programFilled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MENU_ACTION_EDIT_CRUISE_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("screen", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("cruiseFilled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    menuActionEditCruise.setEnabled(model.getScreen() != TuttiScreen.EDIT_CRUISE && model.isCruiseFilled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("screen", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("cruiseFilled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MENU_ACTION_EDIT_PROTOCOL_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("screen", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("protocolFilled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    menuActionEditProtocol.setEnabled(model.getScreen() != TuttiScreen.EDIT_PROTOCOL && model.isProtocolFilled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("screen", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("protocolFilled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MENU_ACTION_EDIT_CATCHES_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("screen", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("cruiseFilled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    menuActionEditCatches.setEnabled(model.getScreen() != TuttiScreen.EDIT_FISHING_OPERATION && model.isCruiseFilled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("screen", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("cruiseFilled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MENU_ACTION_VALIDATE_CATCHES_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("screen", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("cruiseFilled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    menuActionValidateCatches.setEnabled(model.getScreen() != TuttiScreen.VALIDATE_CRUISE && model.isCruiseFilled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("screen", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("cruiseFilled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MENU_ACTION_GENERATE_CRUISE_REPORT_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("screen", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("cruiseFilled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    menuActionGenerateCruiseReport.setEnabled(model.getScreen() != TuttiScreen.REPORT && model.isCruiseFilled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("screen", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("cruiseFilled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JSEPARATOR3_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("dbLoaded", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    $JSeparator3.setEnabled(model.isDbLoaded());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("dbLoaded", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MENU_ACTION_GENERIC_FORMAT_EXPORT_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("screen", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    menuActionGenericFormatExport.setEnabled(model.getScreen() != TuttiScreen.GENERIC_FORMAT_EXPORT);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("screen", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MENU_ACTION_GENERIC_FORMAT_IMPORT_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("screen", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    menuActionGenericFormatImport.setEnabled(model.getScreen() != TuttiScreen.GENERIC_FORMAT_IMPORT);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("screen", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MENU_ADMINISTRATION_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("dbLoaded", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    menuAdministration.setEnabled(model.isDbLoaded());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("dbLoaded", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MENU_IMPORT_TEMPORARY_REFERENTIAL_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("screen", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    menuImportTemporaryReferential.setEnabled(model.getScreen() != TuttiScreen.IMPORT_TEMPORARY_REFERENTIAL);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("screen", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MENU_EDIT_SAMPLE_CATEGORY_MODEL_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("dbLoaded", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    menuEditSampleCategoryModel.setEnabled(model.isDbLoaded());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("dbLoaded", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MENU_CHANGE_LOCALE_UK_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("locale", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    menuChangeLocaleUK.setEnabled(!handler.acceptLocale(model.getLocale(), "en_GB"));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("locale", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MENU_CHANGE_LOCALE_FR_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("locale", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    menuChangeLocaleFR.setEnabled(!handler.acceptLocale(model.getLocale(), "fr_FR"));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("locale", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_ICHTYOMETER_STATUS_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("ichtyometerConnected", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    ichtyometerStatus.setEnabled(model.isIchtyometerConnected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("ichtyometerConnected", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_ICHTYOMETER_STATUS_TOOL_TIP_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("ichtyometerConnected", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    ichtyometerStatus.setToolTipText(t(handler.getIchtyometerStatusTip(model.isIchtyometerConnected())));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("ichtyometerConnected", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_STATUS_SHOW_MEMORY_STATUS, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("config", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null && model.getConfig() != null) {
                    status.setShowMemoryStatus(model.getConfig().isShowMemoryUsage());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("config", this);
                }
            }
        });
    }

}