// license-header java merge-point
//
// Attention: Generated code! Do not modify by hand!
// Generated by: hibernate/HibernateEntity.vsl in andromda-hibernate-cartridge.
//
package fr.ifremer.adagio.core.dao.data.survey.landing;

import fr.ifremer.adagio.core.dao.administration.programStrategy.Program;
import fr.ifremer.adagio.core.dao.administration.user.Department;
import fr.ifremer.adagio.core.dao.administration.user.Person;
import fr.ifremer.adagio.core.dao.data.batch.CatchBatch;
import fr.ifremer.adagio.core.dao.data.measure.LandingMeasurement;
import fr.ifremer.adagio.core.dao.data.measure.SurveyMeasurement;
import fr.ifremer.adagio.core.dao.data.produce.Produce;
import fr.ifremer.adagio.core.dao.data.survey.fishingTrip.FishingTrip;
import fr.ifremer.adagio.core.dao.data.survey.observedLocation.ObservedLocation;
import fr.ifremer.adagio.core.dao.data.survey.sale.Sale;
import fr.ifremer.adagio.core.dao.data.vessel.Vessel;
import fr.ifremer.adagio.core.dao.referential.QualityFlag;
import fr.ifremer.adagio.core.dao.referential.location.Location;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;

/**
 * Débarquement à la suite d'une marée en mer.
 */
// HibernateEntity.vsl annotations merge-point
public abstract class Landing
    implements Serializable, Comparable<Landing>
{
    /**
     * The serial version UID of this class. Needed for serialization.
     */
    private static final long serialVersionUID = -8857148797771278999L;

    // Generate 12 attributes
    private Integer id;

    /**
     * Idenfiant interne. Généré par le système.
     * @return this.id Integer
     */
    public Integer getId()
    {
        return this.id;
    }

    /**
     * Idenfiant interne. Généré par le système.
     * @param idIn Integer
     */
    public void setId(Integer idIn)
    {
        this.id = idIn;
    }

    private String synchronizationStatus;

    /**
     * Etat de synchronisation (en cours, terminé, en attente de synchro, supprimé). Seulement
     * visible dans la base locale.
     * @return this.synchronizationStatus String
     */
    public String getSynchronizationStatus()
    {
        return this.synchronizationStatus;
    }

    /**
     * Etat de synchronisation (en cours, terminé, en attente de synchro, supprimé). Seulement
     * visible dans la base locale.
     * @param synchronizationStatusIn String
     */
    public void setSynchronizationStatus(String synchronizationStatusIn)
    {
        this.synchronizationStatus = synchronizationStatusIn;
    }

    private Date landingDateTime;

    /**
     * Date (et heure) de débarquement
     * @return this.landingDateTime Date
     */
    public Date getLandingDateTime()
    {
        return this.landingDateTime;
    }

    /**
     * Date (et heure) de débarquement
     * @param landingDateTimeIn Date
     */
    public void setLandingDateTime(Date landingDateTimeIn)
    {
        this.landingDateTime = landingDateTimeIn;
    }

    private Short rankOrder;

    /**
     * 
     * @return this.rankOrder Short
     */
    public Short getRankOrder()
    {
        return this.rankOrder;
    }

    /**
     * 
     * @param rankOrderIn Short
     */
    public void setRankOrder(Short rankOrderIn)
    {
        this.rankOrder = rankOrderIn;
    }

    private String comments;

    /**
     * 
     * @return this.comments String
     */
    public String getComments()
    {
        return this.comments;
    }

    /**
     * 
     * @param commentsIn String
     */
    public void setComments(String commentsIn)
    {
        this.comments = commentsIn;
    }

    private Date creationDate;

    /**
     * 
     * @return this.creationDate Date
     */
    public Date getCreationDate()
    {
        return this.creationDate;
    }

    /**
     * 
     * @param creationDateIn Date
     */
    public void setCreationDate(Date creationDateIn)
    {
        this.creationDate = creationDateIn;
    }

    private Date controlDate;

    /**
     * 
     * @return this.controlDate Date
     */
    public Date getControlDate()
    {
        return this.controlDate;
    }

    /**
     * 
     * @param controlDateIn Date
     */
    public void setControlDate(Date controlDateIn)
    {
        this.controlDate = controlDateIn;
    }

    private Date validationDate;

    /**
     * 
     * @return this.validationDate Date
     */
    public Date getValidationDate()
    {
        return this.validationDate;
    }

    /**
     * 
     * @param validationDateIn Date
     */
    public void setValidationDate(Date validationDateIn)
    {
        this.validationDate = validationDateIn;
    }

    private Date qualificationDate;

    /**
     * 
     * @return this.qualificationDate Date
     */
    public Date getQualificationDate()
    {
        return this.qualificationDate;
    }

    /**
     * 
     * @param qualificationDateIn Date
     */
    public void setQualificationDate(Date qualificationDateIn)
    {
        this.qualificationDate = qualificationDateIn;
    }

    private String qualificationComments;

    /**
     * 
     * @return this.qualificationComments String
     */
    public String getQualificationComments()
    {
        return this.qualificationComments;
    }

    /**
     * 
     * @param qualificationCommentsIn String
     */
    public void setQualificationComments(String qualificationCommentsIn)
    {
        this.qualificationComments = qualificationCommentsIn;
    }

    private Timestamp updateDate;

    /**
     * 
     * @return this.updateDate Timestamp
     */
    public Timestamp getUpdateDate()
    {
        return this.updateDate;
    }

    /**
     * 
     * @param updateDateIn Timestamp
     */
    public void setUpdateDate(Timestamp updateDateIn)
    {
        this.updateDate = updateDateIn;
    }

    private Integer remoteId;

    /**
     * 
     * @return this.remoteId Integer
     */
    public Integer getRemoteId()
    {
        return this.remoteId;
    }

    /**
     * 
     * @param remoteIdIn Integer
     */
    public void setRemoteId(Integer remoteIdIn)
    {
        this.remoteId = remoteIdIn;
    }

    // Generate 15 associations
    private Location landingLocation;

    /**
     * Représente un lieu au sens général du terme. Il peut s'agir d'un lieu ponctuel, linéaire ou
     * surfacique.
     * Suivant sa classification et son niveau, il peut s'agir d'un secteur FAO, un port de pêche,
     * un
     * quartier maritime, une criée, etc.
     * Nombre de lignes : lieux terrestre : 4500 + secteurs : 11210 + strates : 1000 + localités :
     * 200
     * @return this.landingLocation Location
     */
    public Location getLandingLocation()
    {
        return this.landingLocation;
    }

    /**
     * Représente un lieu au sens général du terme. Il peut s'agir d'un lieu ponctuel, linéaire ou
     * surfacique.
     * Suivant sa classification et son niveau, il peut s'agir d'un secteur FAO, un port de pêche,
     * un
     * quartier maritime, une criée, etc.
     * Nombre de lignes : lieux terrestre : 4500 + secteurs : 11210 + strates : 1000 + localités :
     * 200
     * @param landingLocationIn Location
     */
    public void setLandingLocation(Location landingLocationIn)
    {
        this.landingLocation = landingLocationIn;
    }

    private ObservedLocation observedLocation;

    /**
     * Lieu observé (ex: un site de débarquement, etc.).
     * An observed location (i.e. a landing site).
     * @return this.observedLocation ObservedLocation
     */
    public ObservedLocation getObservedLocation()
    {
        return this.observedLocation;
    }

    /**
     * Lieu observé (ex: un site de débarquement, etc.).
     * An observed location (i.e. a landing site).
     * @param observedLocationIn ObservedLocation
     */
    public void setObservedLocation(ObservedLocation observedLocationIn)
    {
        this.observedLocation = observedLocationIn;
    }

    private Department recorderDepartment;

    /**
     * Service saisisseur.
     * @return this.recorderDepartment Department
     */
    public Department getRecorderDepartment()
    {
        return this.recorderDepartment;
    }

    /**
     * Service saisisseur.
     * @param recorderDepartmentIn Department
     */
    public void setRecorderDepartment(Department recorderDepartmentIn)
    {
        this.recorderDepartment = recorderDepartmentIn;
    }

    private Person recorderPerson;

    /**
     * Personne du référentiel (utilisateur ou non du système).
     * Nombre de lignes : 100
     * @return this.recorderPerson Person
     */
    public Person getRecorderPerson()
    {
        return this.recorderPerson;
    }

    /**
     * Personne du référentiel (utilisateur ou non du système).
     * Nombre de lignes : 100
     * @param recorderPersonIn Person
     */
    public void setRecorderPerson(Person recorderPersonIn)
    {
        this.recorderPerson = recorderPersonIn;
    }

    private CatchBatch catchBatch;

    /**
     * Capture réalisée au cours d'une opération, et sur laquelle un échantillonnage est réalisé.
     * La capture porte donc l'arbre d''échantillonnage.
     * @return this.catchBatch CatchBatch
     */
    public CatchBatch getCatchBatch()
    {
        return this.catchBatch;
    }

    /**
     * Capture réalisée au cours d'une opération, et sur laquelle un échantillonnage est réalisé.
     * La capture porte donc l'arbre d''échantillonnage.
     * @param catchBatchIn CatchBatch
     */
    public void setCatchBatch(CatchBatch catchBatchIn)
    {
        this.catchBatch = catchBatchIn;
    }

    private FishingTrip fishingTrip;

    /**
     * Voyage en mer, ayant pour vocation une activité de peche (peut etre une campagnes halieutique
     * ou une
     * marée d'un navire professionnel, etc.)
     * Un voyage peut représenter type de données :
     * - Une marée observée (en mer, au débarquement), qui désigne une marée de pêche
     * professionnelle au
     * cours de laquelle des relevés sont effectués par un observateur.
     * - Une marée déclarée. Principalement issue du log book électronique (flux SACAPT). Une marée
     * déclarée peut etre un ensemble de marée ou de sous-ensembles de marée (Exemple de la fiche de
     * peche)
     * - une sortie effectuée lors d"une campagne scientifique
     * @return this.fishingTrip FishingTrip
     */
    public FishingTrip getFishingTrip()
    {
        return this.fishingTrip;
    }

    /**
     * Voyage en mer, ayant pour vocation une activité de peche (peut etre une campagnes halieutique
     * ou une
     * marée d'un navire professionnel, etc.)
     * Un voyage peut représenter type de données :
     * - Une marée observée (en mer, au débarquement), qui désigne une marée de pêche
     * professionnelle au
     * cours de laquelle des relevés sont effectués par un observateur.
     * - Une marée déclarée. Principalement issue du log book électronique (flux SACAPT). Une marée
     * déclarée peut etre un ensemble de marée ou de sous-ensembles de marée (Exemple de la fiche de
     * peche)
     * - une sortie effectuée lors d"une campagne scientifique
     * @param fishingTripIn FishingTrip
     */
    public void setFishingTrip(FishingTrip fishingTripIn)
    {
        this.fishingTrip = fishingTripIn;
    }

    private Collection<Sale> sales = new HashSet<Sale>();

    /**
     * Vente liée à un navire, effectuée en un lieu et une date données. Une vente regroupe
     * plusieurs
     * produits vendus (Produce).
     * Attention : une vente est ponctuelle dans le temps. Si l'on souhaite recencer une vente qui
     * s'étale
     * sur plusieurs jours,
     * @return this.sales Collection<Sale>
     */
    public Collection<Sale> getSales()
    {
        return this.sales;
    }

    /**
     * Vente liée à un navire, effectuée en un lieu et une date données. Une vente regroupe
     * plusieurs
     * produits vendus (Produce).
     * Attention : une vente est ponctuelle dans le temps. Si l'on souhaite recencer une vente qui
     * s'étale
     * sur plusieurs jours,
     * @param salesIn Collection<Sale>
     */
    public void setSales(Collection<Sale> salesIn)
    {
        this.sales = salesIn;
    }

    /**
     * Vente liée à un navire, effectuée en un lieu et une date données. Une vente regroupe
     * plusieurs
     * produits vendus (Produce).
     * Attention : une vente est ponctuelle dans le temps. Si l'on souhaite recencer une vente qui
     * s'étale
     * sur plusieurs jours,
     * @param elementToAdd Sale
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean addSales(Sale elementToAdd)
    {
        return this.sales.add(elementToAdd);
    }

    /**
     * Vente liée à un navire, effectuée en un lieu et une date données. Une vente regroupe
     * plusieurs
     * produits vendus (Produce).
     * Attention : une vente est ponctuelle dans le temps. Si l'on souhaite recencer une vente qui
     * s'étale
     * sur plusieurs jours,
     * @param elementToRemove Sale
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean removeSales(Sale elementToRemove)
    {
        return this.sales.remove(elementToRemove);
    }

    private Collection<LandingOrigin> landingOrigins = new HashSet<LandingOrigin>();

    /**
     * Origines (sources) des données du débarquement.
     * Généralement, il n'y a qu'une seule origine pour un débarquement, mais des traitements de
     * croisement de données peuvent lier un débarquement à plusieurs sources de données
     * différentes. ATTENTION : voir dans Allegro comment plusieurs sources sont gérées.
     * @return this.landingOrigins Collection<LandingOrigin>
     */
    public Collection<LandingOrigin> getLandingOrigins()
    {
        return this.landingOrigins;
    }

    /**
     * Origines (sources) des données du débarquement.
     * Généralement, il n'y a qu'une seule origine pour un débarquement, mais des traitements de
     * croisement de données peuvent lier un débarquement à plusieurs sources de données
     * différentes. ATTENTION : voir dans Allegro comment plusieurs sources sont gérées.
     * @param landingOriginsIn Collection<LandingOrigin>
     */
    public void setLandingOrigins(Collection<LandingOrigin> landingOriginsIn)
    {
        this.landingOrigins = landingOriginsIn;
    }

    /**
     * Origines (sources) des données du débarquement.
     * Généralement, il n'y a qu'une seule origine pour un débarquement, mais des traitements de
     * croisement de données peuvent lier un débarquement à plusieurs sources de données
     * différentes. ATTENTION : voir dans Allegro comment plusieurs sources sont gérées.
     * @param elementToAdd LandingOrigin
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean addLandingOrigins(LandingOrigin elementToAdd)
    {
        return this.landingOrigins.add(elementToAdd);
    }

    /**
     * Origines (sources) des données du débarquement.
     * Généralement, il n'y a qu'une seule origine pour un débarquement, mais des traitements de
     * croisement de données peuvent lier un débarquement à plusieurs sources de données
     * différentes. ATTENTION : voir dans Allegro comment plusieurs sources sont gérées.
     * @param elementToRemove LandingOrigin
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean removeLandingOrigins(LandingOrigin elementToRemove)
    {
        return this.landingOrigins.remove(elementToRemove);
    }

    private QualityFlag qualityFlag;

    /**
     * Niveau de qualité de la donnée.
     * "Non qualifiée" par défaut
     * @return this.qualityFlag QualityFlag
     */
    public QualityFlag getQualityFlag()
    {
        return this.qualityFlag;
    }

    /**
     * Niveau de qualité de la donnée.
     * "Non qualifiée" par défaut
     * @param qualityFlagIn QualityFlag
     */
    public void setQualityFlag(QualityFlag qualityFlagIn)
    {
        this.qualityFlag = qualityFlagIn;
    }

    private Program program;

    /**
     * Programme d'observation à l'origine d'une collecte de données.
     * Désigne les activités qui sont à l'origine de la collecte d'un ensemble cohérent de données,
     * que ce
     * soit pour des collectes continues (marées observées en mer, SIPA) ou pour des études limitées
     * dans
     * le temps. La quantité de données rattachées à un programme peut être variable, selon qu'il
     * s'agit
     * d'une activité longue ou intensive, ou d'une opération plus ponctuelle (étude) mais toujours
     * mise en
     * œuvre selon un schéma décidé à l'avance.
     * Exemple de programmes d'observations :
     * - SIH-OBSMER (marées observées en mer)
     * - SIH-STATPECHE (enquete d'activité et d'effort...)
     * - SIPA : données déclaratives transmises par la DPMA
     * - VMS : données satellitaires
     * - OFIMER : données du SI de l'OFIMER
     * @return this.program Program
     */
    public Program getProgram()
    {
        return this.program;
    }

    /**
     * Programme d'observation à l'origine d'une collecte de données.
     * Désigne les activités qui sont à l'origine de la collecte d'un ensemble cohérent de données,
     * que ce
     * soit pour des collectes continues (marées observées en mer, SIPA) ou pour des études limitées
     * dans
     * le temps. La quantité de données rattachées à un programme peut être variable, selon qu'il
     * s'agit
     * d'une activité longue ou intensive, ou d'une opération plus ponctuelle (étude) mais toujours
     * mise en
     * œuvre selon un schéma décidé à l'avance.
     * Exemple de programmes d'observations :
     * - SIH-OBSMER (marées observées en mer)
     * - SIH-STATPECHE (enquete d'activité et d'effort...)
     * - SIPA : données déclaratives transmises par la DPMA
     * - VMS : données satellitaires
     * - OFIMER : données du SI de l'OFIMER
     * @param programIn Program
     */
    public void setProgram(Program programIn)
    {
        this.program = programIn;
    }

    private Vessel vessel;

    /**
     * Navire. Peut etre un navire de peche professionnel ou non, un navire océanographique, etc.
     * @return this.vessel Vessel
     */
    public Vessel getVessel()
    {
        return this.vessel;
    }

    /**
     * Navire. Peut etre un navire de peche professionnel ou non, un navire océanographique, etc.
     * @param vesselIn Vessel
     */
    public void setVessel(Vessel vesselIn)
    {
        this.vessel = vesselIn;
    }

    private Collection<Produce> produces = new HashSet<Produce>();

    /**
     * <html>
     * <head>
     * </head>
     * <body>
     * <p>
     * Un produit est identifi&#233; par une esp&#232;ce commerciale, un &#233;tat, une
     * qualit&#233;, pr&#233;sentation et cat&#233;gorie commerciale.
     * </p>
     * <p>
     * </p>
     * <p>
     * <u>Si le produit est un &quot;produit vendu&quot; :</u>
     * </p>
     * <p>
     * On pourra allors utiliser SortingMeasurement pour stocker des donn&#233;es
     * &#233;conomiques, comme par exemple :
     * </p>
     * <p>
     * - Le prix du produit. Il peut y avoir plusieurds prix (plusieurs PSFMs),
     * par exemple : prix au kilo, et prix total en euros.
     * </p>
     * <p>
     * - Valorisation de la commercialisation : Label rouge, Eco Label, marque
     * collective control&#233;e par un organisme tier. (cf SACROIS)
     * </p>
     * <p>
     * - Destination commerciale : consommation humaine, consommation animale,
     * etc .
     * </p>
     * </body>
     * </html>
     * @return this.produces Collection<Produce>
     */
    public Collection<Produce> getProduces()
    {
        return this.produces;
    }

    /**
     * <html>
     * <head>
     * </head>
     * <body>
     * <p>
     * Un produit est identifi&#233; par une esp&#232;ce commerciale, un &#233;tat, une
     * qualit&#233;, pr&#233;sentation et cat&#233;gorie commerciale.
     * </p>
     * <p>
     * </p>
     * <p>
     * <u>Si le produit est un &quot;produit vendu&quot; :</u>
     * </p>
     * <p>
     * On pourra allors utiliser SortingMeasurement pour stocker des donn&#233;es
     * &#233;conomiques, comme par exemple :
     * </p>
     * <p>
     * - Le prix du produit. Il peut y avoir plusieurds prix (plusieurs PSFMs),
     * par exemple : prix au kilo, et prix total en euros.
     * </p>
     * <p>
     * - Valorisation de la commercialisation : Label rouge, Eco Label, marque
     * collective control&#233;e par un organisme tier. (cf SACROIS)
     * </p>
     * <p>
     * - Destination commerciale : consommation humaine, consommation animale,
     * etc .
     * </p>
     * </body>
     * </html>
     * @param producesIn Collection<Produce>
     */
    public void setProduces(Collection<Produce> producesIn)
    {
        this.produces = producesIn;
    }

    /**
     * <html>
     * <head>
     * </head>
     * <body>
     * <p>
     * Un produit est identifi&#233; par une esp&#232;ce commerciale, un &#233;tat, une
     * qualit&#233;, pr&#233;sentation et cat&#233;gorie commerciale.
     * </p>
     * <p>
     * </p>
     * <p>
     * <u>Si le produit est un &quot;produit vendu&quot; :</u>
     * </p>
     * <p>
     * On pourra allors utiliser SortingMeasurement pour stocker des donn&#233;es
     * &#233;conomiques, comme par exemple :
     * </p>
     * <p>
     * - Le prix du produit. Il peut y avoir plusieurds prix (plusieurs PSFMs),
     * par exemple : prix au kilo, et prix total en euros.
     * </p>
     * <p>
     * - Valorisation de la commercialisation : Label rouge, Eco Label, marque
     * collective control&#233;e par un organisme tier. (cf SACROIS)
     * </p>
     * <p>
     * - Destination commerciale : consommation humaine, consommation animale,
     * etc .
     * </p>
     * </body>
     * </html>
     * @param elementToAdd Produce
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean addProduces(Produce elementToAdd)
    {
        return this.produces.add(elementToAdd);
    }

    /**
     * <html>
     * <head>
     * </head>
     * <body>
     * <p>
     * Un produit est identifi&#233; par une esp&#232;ce commerciale, un &#233;tat, une
     * qualit&#233;, pr&#233;sentation et cat&#233;gorie commerciale.
     * </p>
     * <p>
     * </p>
     * <p>
     * <u>Si le produit est un &quot;produit vendu&quot; :</u>
     * </p>
     * <p>
     * On pourra allors utiliser SortingMeasurement pour stocker des donn&#233;es
     * &#233;conomiques, comme par exemple :
     * </p>
     * <p>
     * - Le prix du produit. Il peut y avoir plusieurds prix (plusieurs PSFMs),
     * par exemple : prix au kilo, et prix total en euros.
     * </p>
     * <p>
     * - Valorisation de la commercialisation : Label rouge, Eco Label, marque
     * collective control&#233;e par un organisme tier. (cf SACROIS)
     * </p>
     * <p>
     * - Destination commerciale : consommation humaine, consommation animale,
     * etc .
     * </p>
     * </body>
     * </html>
     * @param elementToRemove Produce
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean removeProduces(Produce elementToRemove)
    {
        return this.produces.remove(elementToRemove);
    }

    private Collection<SurveyMeasurement> surveyMeasurements = new HashSet<SurveyMeasurement>();

    /**
     * Caractéristiques de l'enquete.
     * Par exemple : qualification d'une enquête sur un navire.
     * Permet de qualifier les enquetes en :
     * - Enquête Directe
     * - Enquête Indirecte
     * - Estimation
     * @return this.surveyMeasurements Collection<SurveyMeasurement>
     */
    public Collection<SurveyMeasurement> getSurveyMeasurements()
    {
        return this.surveyMeasurements;
    }

    /**
     * Caractéristiques de l'enquete.
     * Par exemple : qualification d'une enquête sur un navire.
     * Permet de qualifier les enquetes en :
     * - Enquête Directe
     * - Enquête Indirecte
     * - Estimation
     * @param surveyMeasurementsIn Collection<SurveyMeasurement>
     */
    public void setSurveyMeasurements(Collection<SurveyMeasurement> surveyMeasurementsIn)
    {
        this.surveyMeasurements = surveyMeasurementsIn;
    }

    /**
     * Caractéristiques de l'enquete.
     * Par exemple : qualification d'une enquête sur un navire.
     * Permet de qualifier les enquetes en :
     * - Enquête Directe
     * - Enquête Indirecte
     * - Estimation
     * @param elementToAdd SurveyMeasurement
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean addSurveyMeasurements(SurveyMeasurement elementToAdd)
    {
        return this.surveyMeasurements.add(elementToAdd);
    }

    /**
     * Caractéristiques de l'enquete.
     * Par exemple : qualification d'une enquête sur un navire.
     * Permet de qualifier les enquetes en :
     * - Enquête Directe
     * - Enquête Indirecte
     * - Estimation
     * @param elementToRemove SurveyMeasurement
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean removeSurveyMeasurements(SurveyMeasurement elementToRemove)
    {
        return this.surveyMeasurements.remove(elementToRemove);
    }

    private Collection<LandingMeasurement> landingMeasurements = new HashSet<LandingMeasurement>();

    /**
     * 
     * @return this.landingMeasurements Collection<LandingMeasurement>
     */
    public Collection<LandingMeasurement> getLandingMeasurements()
    {
        return this.landingMeasurements;
    }

    /**
     * 
     * @param landingMeasurementsIn Collection<LandingMeasurement>
     */
    public void setLandingMeasurements(Collection<LandingMeasurement> landingMeasurementsIn)
    {
        this.landingMeasurements = landingMeasurementsIn;
    }

    /**
     * 
     * @param elementToAdd LandingMeasurement
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean addLandingMeasurements(LandingMeasurement elementToAdd)
    {
        return this.landingMeasurements.add(elementToAdd);
    }

    /**
     * 
     * @param elementToRemove LandingMeasurement
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean removeLandingMeasurements(LandingMeasurement elementToRemove)
    {
        return this.landingMeasurements.remove(elementToRemove);
    }

    /**
     * Returns <code>true</code> if the argument is an Landing instance and all identifiers for this entity
     * equal the identifiers of the argument entity. Returns <code>false</code> otherwise.
     */
    @Override
    public boolean equals(Object object)
    {
        if (this == object)
        {
            return true;
        }
        if (!(object instanceof Landing))
        {
            return false;
        }
        final Landing that = (Landing)object;
        if (this.id == null || that.getId() == null || !this.id.equals(that.getId()))
        {
            return false;
        }
        return true;
    }

    /**
     * Returns a hash code based on this entity's identifiers.
     */
    @Override
    public int hashCode()
    {
        int hashCode = 0;
        hashCode = 29 * hashCode + (this.id == null ? 0 : this.id.hashCode());

        return hashCode;
    }

    /**
     * Constructs new instances of {@link Landing}.
     */
    public static final class Factory
    {
        /**
         * Constructs a new instance of {@link Landing}.
         * @return new LandingImpl()
         */
        public static Landing newInstance()
        {
            return new LandingImpl();
        }

        /**
         * Constructs a new instance of {@link Landing}, taking all required and/or
         * read-only properties as arguments, except for identifiers.
         * @param synchronizationStatus String
         * @param landingDateTime Date
         * @param creationDate Date
         * @param landingLocation Location
         * @param recorderDepartment Department
         * @param qualityFlag QualityFlag
         * @param program Program
         * @param vessel Vessel
         * @return newInstance
         */
        public static Landing newInstance(String synchronizationStatus, Date landingDateTime, Date creationDate, Location landingLocation, Department recorderDepartment, QualityFlag qualityFlag, Program program, Vessel vessel)
        {
            final Landing entity = new LandingImpl();
            entity.setSynchronizationStatus(synchronizationStatus);
            entity.setLandingDateTime(landingDateTime);
            entity.setCreationDate(creationDate);
            entity.setLandingLocation(landingLocation);
            entity.setRecorderDepartment(recorderDepartment);
            entity.setQualityFlag(qualityFlag);
            entity.setProgram(program);
            entity.setVessel(vessel);
            return entity;
        }

        /**
         * Constructs a new instance of {@link Landing}, taking all possible properties
         * (except the identifier(s))as arguments.
         * @param synchronizationStatus String
         * @param landingDateTime Date
         * @param rankOrder Short
         * @param comments String
         * @param creationDate Date
         * @param controlDate Date
         * @param validationDate Date
         * @param qualificationDate Date
         * @param qualificationComments String
         * @param updateDate Timestamp
         * @param remoteId Integer
         * @param landingLocation Location
         * @param observedLocation ObservedLocation
         * @param recorderDepartment Department
         * @param recorderPerson Person
         * @param catchBatch CatchBatch
         * @param fishingTrip FishingTrip
         * @param sales Collection<Sale>
         * @param landingOrigins Collection<LandingOrigin>
         * @param qualityFlag QualityFlag
         * @param program Program
         * @param vessel Vessel
         * @param produces Collection<Produce>
         * @param surveyMeasurements Collection<SurveyMeasurement>
         * @param landingMeasurements Collection<LandingMeasurement>
         * @return newInstance Landing
         */
        public static Landing newInstance(String synchronizationStatus, Date landingDateTime, Short rankOrder, String comments, Date creationDate, Date controlDate, Date validationDate, Date qualificationDate, String qualificationComments, Timestamp updateDate, Integer remoteId, Location landingLocation, ObservedLocation observedLocation, Department recorderDepartment, Person recorderPerson, CatchBatch catchBatch, FishingTrip fishingTrip, Collection<Sale> sales, Collection<LandingOrigin> landingOrigins, QualityFlag qualityFlag, Program program, Vessel vessel, Collection<Produce> produces, Collection<SurveyMeasurement> surveyMeasurements, Collection<LandingMeasurement> landingMeasurements)
        {
            final Landing entity = new LandingImpl();
            entity.setSynchronizationStatus(synchronizationStatus);
            entity.setLandingDateTime(landingDateTime);
            entity.setRankOrder(rankOrder);
            entity.setComments(comments);
            entity.setCreationDate(creationDate);
            entity.setControlDate(controlDate);
            entity.setValidationDate(validationDate);
            entity.setQualificationDate(qualificationDate);
            entity.setQualificationComments(qualificationComments);
            entity.setUpdateDate(updateDate);
            entity.setRemoteId(remoteId);
            entity.setLandingLocation(landingLocation);
            entity.setObservedLocation(observedLocation);
            entity.setRecorderDepartment(recorderDepartment);
            entity.setRecorderPerson(recorderPerson);
            entity.setCatchBatch(catchBatch);
            entity.setFishingTrip(fishingTrip);
            entity.setSales(sales);
            entity.setLandingOrigins(landingOrigins);
            entity.setQualityFlag(qualityFlag);
            entity.setProgram(program);
            entity.setVessel(vessel);
            entity.setProduces(produces);
            entity.setSurveyMeasurements(surveyMeasurements);
            entity.setLandingMeasurements(landingMeasurements);
            return entity;
        }
    }

    /**
     * @see Comparable#compareTo
     */
    public int compareTo(Landing o)
    {
        int cmp = 0;
        if (this.getId() != null)
        {
            cmp = this.getId().compareTo(o.getId());
        }
        else
        {
            if (this.getSynchronizationStatus() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getSynchronizationStatus().compareTo(o.getSynchronizationStatus()));
            }
            if (this.getLandingDateTime() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getLandingDateTime().compareTo(o.getLandingDateTime()));
            }
            if (this.getRankOrder() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getRankOrder().compareTo(o.getRankOrder()));
            }
            if (this.getComments() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getComments().compareTo(o.getComments()));
            }
            if (this.getCreationDate() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getCreationDate().compareTo(o.getCreationDate()));
            }
            if (this.getControlDate() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getControlDate().compareTo(o.getControlDate()));
            }
            if (this.getValidationDate() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getValidationDate().compareTo(o.getValidationDate()));
            }
            if (this.getQualificationDate() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getQualificationDate().compareTo(o.getQualificationDate()));
            }
            if (this.getQualificationComments() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getQualificationComments().compareTo(o.getQualificationComments()));
            }
            if (this.getUpdateDate() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getUpdateDate().compareTo(o.getUpdateDate()));
            }
            if (this.getRemoteId() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getRemoteId().compareTo(o.getRemoteId()));
            }
        }
        return cmp;
    }
// HibernateEntity.vsl merge-point
// Landing.java merge-point
}