/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.core.service;

import fr.ifremer.adagio.core.AdagioTechnicalException;
import fr.ifremer.adagio.core.config.AdagioConfiguration;
import fr.ifremer.adagio.core.dao.technical.DatabaseSchemaDao;
import fr.ifremer.adagio.core.dao.technical.DatabaseSchemaUpdateException;
import fr.ifremer.adagio.core.dao.technical.VersionNotFoundException;
import fr.ifremer.adagio.core.service.DatabaseSchemaService;
import java.io.File;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.version.Version;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="databaseSchemaService")
public class DatabaseSchemaServiceImpl
implements DatabaseSchemaService {
    private static final Log log = LogFactory.getLog(DatabaseSchemaServiceImpl.class);
    @Autowired
    protected AdagioConfiguration config;
    @Autowired
    protected DatabaseSchemaDao databaseSchemaDao;

    @Override
    public Version getDbVersion() {
        Version result;
        try {
            if (!this.isDbLoaded()) {
                throw new VersionNotFoundException("db is not open");
            }
            result = this.databaseSchemaDao.getSchemaVersion();
        }
        catch (VersionNotFoundException e) {
            if (log.isWarnEnabled()) {
                log.warn((Object)e.getMessage());
            }
            result = null;
        }
        return result;
    }

    @Override
    public Version getApplicationVersion() {
        Version result = this.databaseSchemaDao.getSchemaVersionIfUpdate();
        return result;
    }

    @Override
    public void updateSchema() {
        try {
            this.databaseSchemaDao.updateSchema();
        }
        catch (DatabaseSchemaUpdateException e) {
            throw new AdagioTechnicalException(e.getCause());
        }
    }

    @Override
    public boolean isDbLoaded() {
        return this.databaseSchemaDao.isDbLoaded();
    }

    @Override
    public boolean isDbExists() {
        return this.databaseSchemaDao.isDbExists();
    }

    @Override
    public void generateStatusReport(File outputFile) throws IOException {
        if (outputFile == null || !outputFile.getParentFile().isDirectory() || !outputFile.canWrite()) {
            log.error((Object)"Could not write into the output file. Please make sure the given path is a valid path.");
            return;
        }
        this.databaseSchemaDao.generateStatusReport(outputFile);
    }

    @Override
    public void generateDiffReport(File outputFile) throws IOException {
        if (outputFile == null || !outputFile.getParentFile().isDirectory() || !outputFile.canWrite()) {
            log.error((Object)"Could not write into the output file. Please make sure the given path is a valid path.");
            return;
        }
        this.databaseSchemaDao.generateDiffReport(outputFile, this.config.getLiquibaseDiffTypes());
    }

    @Override
    public void generateDiffChangeLog(File outputFile) throws IOException {
        if (outputFile == null || !outputFile.getParentFile().isDirectory() || outputFile.exists() && !outputFile.canWrite()) {
            log.error((Object)"Could not write into the output file. Please make sure the given path is a valid path.");
            return;
        }
        this.databaseSchemaDao.generateDiffChangeLog(outputFile, this.config.getLiquibaseDiffTypes());
    }
}

