/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.registry;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.hibernate.boot.registry.BootstrapServiceRegistry;
import org.hibernate.boot.registry.BootstrapServiceRegistryBuilder;
import org.hibernate.boot.registry.StandardServiceInitiator;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.registry.internal.StandardServiceRegistryImpl;
import org.hibernate.cfg.Environment;
import org.hibernate.integrator.spi.Integrator;
import org.hibernate.integrator.spi.IntegratorService;
import org.hibernate.integrator.spi.ServiceContributingIntegrator;
import org.hibernate.internal.jaxb.cfg.JaxbHibernateConfiguration;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.service.ConfigLoader;
import org.hibernate.service.Service;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.service.StandardServiceInitiators;
import org.hibernate.service.internal.ProvidedService;
import org.hibernate.service.spi.ServiceContributor;

public class StandardServiceRegistryBuilder {
    public static final String DEFAULT_CFG_RESOURCE_NAME = "hibernate.cfg.xml";
    private final Map settings;
    private final List<StandardServiceInitiator> initiators = StandardServiceRegistryBuilder.standardInitiatorList();
    private final List<ProvidedService> providedServices = new ArrayList<ProvidedService>();
    private boolean autoCloseRegistry = true;
    private final BootstrapServiceRegistry bootstrapServiceRegistry;
    private final ConfigLoader configLoader;

    public StandardServiceRegistryBuilder() {
        this(new BootstrapServiceRegistryBuilder().build());
    }

    public StandardServiceRegistryBuilder(BootstrapServiceRegistry bootstrapServiceRegistry) {
        this.settings = Environment.getProperties();
        this.bootstrapServiceRegistry = bootstrapServiceRegistry;
        this.configLoader = new ConfigLoader(bootstrapServiceRegistry);
    }

    private static List<StandardServiceInitiator> standardInitiatorList() {
        ArrayList<StandardServiceInitiator> initiators = new ArrayList<StandardServiceInitiator>();
        initiators.addAll(StandardServiceInitiators.LIST);
        return initiators;
    }

    public BootstrapServiceRegistry getBootstrapServiceRegistry() {
        return this.bootstrapServiceRegistry;
    }

    public StandardServiceRegistryBuilder loadProperties(String resourceName) {
        this.settings.putAll(this.configLoader.loadProperties(resourceName));
        return this;
    }

    public StandardServiceRegistryBuilder configure() {
        return this.configure(DEFAULT_CFG_RESOURCE_NAME);
    }

    public StandardServiceRegistryBuilder configure(String resourceName) {
        JaxbHibernateConfiguration configurationElement = this.configLoader.loadConfigXmlResource(resourceName);
        for (JaxbHibernateConfiguration.JaxbSessionFactory.JaxbProperty xmlProperty : configurationElement.getSessionFactory().getProperty()) {
            this.settings.put(xmlProperty.getName(), xmlProperty.getValue());
        }
        return this;
    }

    public StandardServiceRegistryBuilder applySetting(String settingName, Object value) {
        this.settings.put(settingName, value);
        return this;
    }

    public StandardServiceRegistryBuilder applySettings(Map settings) {
        this.settings.putAll(settings);
        return this;
    }

    public StandardServiceRegistryBuilder addInitiator(StandardServiceInitiator initiator) {
        this.initiators.add(initiator);
        return this;
    }

    public StandardServiceRegistryBuilder addService(Class serviceRole, Service service) {
        this.providedServices.add(new ProvidedService<Service>(serviceRole, service));
        return this;
    }

    public StandardServiceRegistryBuilder disableAutoClose() {
        this.autoCloseRegistry = false;
        return this;
    }

    public StandardServiceRegistryBuilder enableAutoClose() {
        this.autoCloseRegistry = true;
        return this;
    }

    public StandardServiceRegistry build() {
        HashMap settingsCopy = new HashMap();
        settingsCopy.putAll(this.settings);
        Environment.verifyProperties(settingsCopy);
        ConfigurationHelper.resolvePlaceHolders(settingsCopy);
        this.applyServiceContributingIntegrators();
        this.applyServiceContributors();
        return new StandardServiceRegistryImpl(this.autoCloseRegistry, this.bootstrapServiceRegistry, this.initiators, this.providedServices, settingsCopy);
    }

    private void applyServiceContributingIntegrators() {
        for (Integrator integrator : this.bootstrapServiceRegistry.getService(IntegratorService.class).getIntegrators()) {
            if (!ServiceContributingIntegrator.class.isInstance(integrator)) continue;
            ((ServiceContributingIntegrator)ServiceContributingIntegrator.class.cast(integrator)).prepareServices(this);
        }
    }

    private void applyServiceContributors() {
        LinkedHashSet<ServiceContributor> serviceContributors = this.bootstrapServiceRegistry.getService(ClassLoaderService.class).loadJavaServices(ServiceContributor.class);
        for (ServiceContributor serviceContributor : serviceContributors) {
            serviceContributor.contribute(this);
        }
    }

    @Deprecated
    public Map getSettings() {
        return this.settings;
    }

    public static void destroy(ServiceRegistry serviceRegistry) {
        ((StandardServiceRegistryImpl)serviceRegistry).destroy();
    }
}

