/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.toc;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.birt.core.archive.IDocArchiveReader;
import org.eclipse.birt.core.archive.RAInputStream;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.report.engine.toc.ITOCConstants;
import org.eclipse.birt.report.engine.toc.ITOCReader;
import org.eclipse.birt.report.engine.toc.ITreeNode;
import org.eclipse.birt.report.engine.toc.document.TOCReaderV0;
import org.eclipse.birt.report.engine.toc.document.TOCReaderV1;
import org.eclipse.birt.report.engine.toc.document.TOCReaderV2;
import org.eclipse.birt.report.engine.toc.document.TOCReaderV3;

public class TOCReader
implements ITOCReader,
ITOCConstants {
    protected String version;
    protected ITOCReader reader;
    protected boolean ownedStream;
    protected RAInputStream stream;

    public TOCReader(IDocArchiveReader archive, ClassLoader loader) throws IOException {
        this(archive.getInputStream("/toc"), loader);
        this.ownedStream = true;
    }

    public TOCReader(RAInputStream in, ClassLoader loader) throws IOException {
        this.stream = in;
        this.version = TOCReader.getVersion(in);
        if ("__Version : 0.0".equals(this.version)) {
            this.reader = new TOCReaderV0(in, false);
        } else if ("__Version : 1.0".equals(this.version)) {
            this.reader = new TOCReaderV1(in, loader, false);
        } else if ("__Version : 2.0".equals(this.version)) {
            this.reader = new TOCReaderV2(in, loader, false);
        } else if ("__Version : 3.0".equals(this.version)) {
            this.reader = new TOCReaderV3(in, loader, false);
        } else {
            in.close();
            throw new IOException("Unsupporter version :" + this.version);
        }
    }

    public TOCReader(InputStream in, ClassLoader loader) throws IOException {
        this.version = TOCReader.getVersion(in);
        if ("__Version : 0.0".equals(this.version)) {
            this.reader = new TOCReaderV0(in);
        } else if ("__Version : 1.0".equals(this.version)) {
            this.reader = new TOCReaderV1(in, loader);
        } else if ("__Version : 2.0".equals(this.version)) {
            this.reader = new TOCReaderV2(in, loader);
        } else {
            throw new IOException("Unsupporter version :" + this.version);
        }
    }

    public String getVersion() {
        return this.version;
    }

    @Override
    public ITreeNode readTree() throws IOException {
        if (this.reader != null) {
            return this.reader.readTree();
        }
        return null;
    }

    @Override
    public void close() throws IOException {
        try {
            if (this.reader != null) {
                this.reader.close();
            }
        }
        finally {
            this.reader = null;
            if (this.ownedStream && this.stream != null) {
                try {
                    this.stream.close();
                }
                finally {
                    this.stream = null;
                }
            }
        }
    }

    static String getVersion(IDocArchiveReader archive) throws IOException {
        RAInputStream in = archive.getInputStream("/toc");
        try {
            String string = TOCReader.getVersion(in);
            return string;
        }
        finally {
            in.close();
        }
    }

    static String getVersion(InputStream in) throws IOException {
        DataInputStream input = new DataInputStream(in);
        String header = IOUtil.readString(input);
        if (header.startsWith("__Version : ")) {
            return header;
        }
        return "__Version : 0.0";
    }
}

