/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.util.attachment.actions;

import fr.ifremer.tutti.ui.swing.util.actions.LongActionSupport;
import fr.ifremer.tutti.ui.swing.util.attachment.AttachmentEditorUI;
import fr.ifremer.tutti.ui.swing.util.attachment.AttachmentItem;
import fr.ifremer.tutti.ui.swing.util.attachment.AttachmentItemHandler;
import fr.ifremer.tutti.ui.swing.util.attachment.AttachmentItemModel;
import java.io.File;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.ApplicationIOUtil;

public class SaveAttachmentAction
extends LongActionSupport<AttachmentItemModel, AttachmentItem, AttachmentItemHandler> {
    protected File file;
    protected File attachmentFile;

    public SaveAttachmentAction(AttachmentItemHandler handler) {
        super(handler, false);
    }

    public boolean prepareAction() throws Exception {
        boolean doAction = super.prepareAction();
        if (doAction) {
            AttachmentItemModel model = (AttachmentItemModel)this.getModel();
            this.attachmentFile = this.getContext().getPersistenceService().getAttachmentFile(model.getId());
            this.file = this.saveFile(ApplicationIOUtil.getBaseName((String)model.getName()), ApplicationIOUtil.getExtension((String)this.attachmentFile.getName()), I18n.t((String)"tutti.attachmentEditor.saveAttachment.title", (Object[])new Object[0]), I18n.t((String)"tutti.attachmentEditor.saveAttachment.button", (Object[])new Object[0]), new String[0]);
            doAction = this.file != null;
        }
        return doAction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doAction() throws Exception {
        AttachmentEditorUI upperUI = ((AttachmentItem)this.getUI()).getParentContainer(AttachmentEditorUI.class);
        boolean hackDialog = upperUI.isAlwaysOnTop();
        if (hackDialog) {
            upperUI.setAlwaysOnTop(false);
        }
        try {
            ApplicationIOUtil.copyFile((File)this.attachmentFile, (File)this.file, (String)I18n.t((String)"tutti.attachmentEditor.saveAttachment.error.message", (Object[])new Object[]{this.attachmentFile, this.file.getName()}));
            this.sendMessage(I18n.t((String)"tutti.attachmentEditor.saveAttachment.success.message", (Object[])new Object[]{this.file.getName()}));
        }
        finally {
            if (hackDialog) {
                upperUI.setAlwaysOnTop(true);
            }
        }
    }

    public void releaseAction() {
        super.releaseAction();
        this.attachmentFile = null;
        this.file = null;
    }
}

