/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.internal.util;

import org.eclipse.birt.report.engine.content.IBandContent;
import org.eclipse.birt.report.engine.content.ICellContent;
import org.eclipse.birt.report.engine.content.IGroupContent;
import org.eclipse.birt.report.engine.content.IRowContent;
import org.eclipse.birt.report.model.api.FilterConditionHandle;

public class HTMLUtil {
    public static String getFilterDescription(FilterConditionHandle filterCondition) {
        if (filterCondition == null) {
            return null;
        }
        char space = ' ';
        StringBuffer result = new StringBuffer();
        result.append(filterCondition.getExpr());
        result.append(space);
        result.append(filterCondition.getOperator());
        String operator1 = filterCondition.getValue1();
        String operator2 = filterCondition.getValue2();
        if (operator1 != null) {
            result.append(space);
            result.append(operator1);
        }
        if (operator2 != null) {
            if (operator1 != null) {
                result.append(" or ");
            }
            result.append(space);
            result.append(operator2);
        }
        return result.toString();
    }

    public static int getGroupLevel(ICellContent cellContent) {
        IRowContent row = (IRowContent)cellContent.getParent();
        return HTMLUtil.getGroupLevel(row);
    }

    public static int getGroupLevel(IRowContent rowContent) {
        IGroupContent group = rowContent.getGroup();
        IBandContent band = rowContent.getBand();
        if (group != null && band != null) {
            int bandType = band.getBandType();
            if (bandType == 0) {
                return group.getGroupLevel() + 2;
            }
            if (bandType == 3 || bandType == 4) {
                return group.getGroupLevel() + 1;
            }
        }
        return -1;
    }
}

