/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.data.impl.aggregation.function;

import com.ibm.icu.util.Calendar;
import com.ibm.icu.util.GregorianCalendar;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.data.engine.api.timefunction.IPeriodsFunction;
import org.eclipse.birt.data.engine.api.timefunction.TimeMember;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.function.AbstractMDX;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.function.TimeMemberUtil;

public class MonthToDateFunction
extends AbstractMDX
implements IPeriodsFunction {
    @Override
    public List<TimeMember> getResult(TimeMember member) {
        ArrayList<TimeMember> timeMembers = new ArrayList<TimeMember>();
        String[] levelTypes = member.getLevelType();
        int[] values = member.getMemberValue();
        GregorianCalendar cal = new GregorianCalendar(TimeMemberUtil.getTimeZone(), TimeMemberUtil.getDefaultLocale());
        cal.clear();
        String baseType = this.translateToCal((Calendar)cal, levelTypes, values);
        if (this.isCurrent) {
            int month = cal.get(2);
            while (true) {
                if (cal.get(2) != month) {
                    cal.add(6, -1);
                    break;
                }
                cal.add(6, 1);
            }
        }
        if (baseType.equals("month")) {
            timeMembers.add(member);
        } else if (baseType.equals("week")) {
            this.retrieveWeek(timeMembers, (Calendar)cal, levelTypes, "monthToDate");
        } else if (baseType.equals("day")) {
            int dayOfMonth = cal.get(5);
            int i = 1;
            while (i <= dayOfMonth) {
                cal.set(5, i);
                int[] tmp = this.getValueFromCal((Calendar)cal, levelTypes);
                TimeMember timeMember = new TimeMember(tmp, levelTypes);
                timeMembers.add(timeMember);
                ++i;
            }
        }
        return timeMembers;
    }
}

