/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.persistence.service.referential.synchro;

import fr.ifremer.tutti.persistence.service.referential.synchro.ReferentialUpdateTask;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ReplaceReferenceTaxonReferentialUpdateTaskImpl
implements ReferentialUpdateTask {
    private static final Log log = LogFactory.getLog(ReplaceReferenceTaxonReferentialUpdateTaskImpl.class);
    public static final String GET_REFTAX_TO_REPLACE_QUERY = "SELECT object_id, external_code FROM transcribing_item ti JOIN transcribing_item_type tit ON ti.transcribing_item_type_fk = tit.id AND tit.label = 'TAXINOMIE-COMMUN.REFERENCE_HISTORY' WHERE (update_date IS NULL OR update_date > ?)";
    public static final String REPLACE_REFTAX_IN_BATCH_QUERY = "UPDATE batch SET reference_taxon_fk = ? WHERE reference_taxon_fk = ?";
    public static final String REPLACE_REFTAX_IN_SAMPLE_QUERY = "UPDATE sample SET reference_taxon_fk = ? WHERE reference_taxon_fk = ?";

    @Override
    public String getTable() {
        return "TRANSCRIBING_ITEM";
    }

    @Override
    public void update(Connection localConnection, Timestamp lastUpdate) throws SQLException {
        PreparedStatement preparedStatement = localConnection.prepareStatement(GET_REFTAX_TO_REPLACE_QUERY);
        preparedStatement.setTimestamp(1, lastUpdate);
        ResultSet reftaxToReplace = preparedStatement.executeQuery();
        PreparedStatement replaceReftaxInBatchStatement = localConnection.prepareStatement(REPLACE_REFTAX_IN_BATCH_QUERY);
        PreparedStatement replaceReftaxInSampleStatement = localConnection.prepareStatement(REPLACE_REFTAX_IN_SAMPLE_QUERY);
        while (reftaxToReplace.next()) {
            Integer newRefTax = reftaxToReplace.getInt(1);
            Integer oldRefTax = reftaxToReplace.getInt(2);
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("[%s] Remplacement du taxon %s par le taxon %s", this.getTable(), oldRefTax, newRefTax));
            }
            replaceReftaxInBatchStatement.setInt(1, newRefTax);
            replaceReftaxInBatchStatement.setInt(2, oldRefTax);
            int batchUpdated = replaceReftaxInBatchStatement.executeUpdate();
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("[%s] %s batchs mis \u00e0 jour", this.getTable(), batchUpdated));
            }
            replaceReftaxInSampleStatement.setInt(1, newRefTax);
            replaceReftaxInSampleStatement.setInt(2, oldRefTax);
            int sampleUpdated = replaceReftaxInSampleStatement.executeUpdate();
            if (!log.isInfoEnabled()) continue;
            log.info((Object)String.format("[%s] %s samples mis \u00e0 jour", this.getTable(), sampleUpdated));
        }
    }
}

