/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image.spi;

import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.io.InputStream;
import org.apache.batik.ext.awt.image.GraphicsUtil;
import org.apache.batik.ext.awt.image.codec.PNGDecodeParam;
import org.apache.batik.ext.awt.image.codec.PNGRed;
import org.apache.batik.ext.awt.image.renderable.DeferRable;
import org.apache.batik.ext.awt.image.renderable.Filter;
import org.apache.batik.ext.awt.image.renderable.RedRable;
import org.apache.batik.ext.awt.image.rendered.Any2sRGBRed;
import org.apache.batik.ext.awt.image.rendered.CachableRed;
import org.apache.batik.ext.awt.image.rendered.FormatRed;
import org.apache.batik.ext.awt.image.spi.ImageTagRegistry;
import org.apache.batik.ext.awt.image.spi.MagicNumberRegistryEntry;
import org.apache.batik.util.ParsedURL;

public class PNGRegistryEntry
extends MagicNumberRegistryEntry {
    static final byte[] signature = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};

    public PNGRegistryEntry() {
        super("PNG", "png", "image/png", 0, signature);
    }

    public Filter handleStream(InputStream inputStream, ParsedURL parsedURL, boolean bl) {
        Object[] objectArray;
        String string;
        final DeferRable deferRable = new DeferRable();
        final InputStream inputStream2 = inputStream;
        final boolean bl2 = bl;
        if (parsedURL != null) {
            string = "url.format.unreadable";
            objectArray = new Object[]{"PNG", parsedURL};
        } else {
            string = "stream.format.unreadable";
            objectArray = new Object[]{"PNG"};
        }
        Thread thread = new Thread(){

            public void run() {
                Filter filter;
                try {
                    PNGDecodeParam pNGDecodeParam = new PNGDecodeParam();
                    pNGDecodeParam.setExpandPalette(true);
                    if (bl2) {
                        pNGDecodeParam.setPerformGammaCorrection(false);
                    } else {
                        pNGDecodeParam.setPerformGammaCorrection(true);
                        pNGDecodeParam.setDisplayExponent(2.2f);
                    }
                    CachableRed cachableRed = new PNGRed(inputStream2, pNGDecodeParam);
                    deferRable.setBounds(new Rectangle2D.Double(0.0, 0.0, cachableRed.getWidth(), cachableRed.getHeight()));
                    cachableRed = new Any2sRGBRed(cachableRed);
                    cachableRed = new FormatRed(cachableRed, GraphicsUtil.sRGB_Unpre);
                    WritableRaster writableRaster = (WritableRaster)cachableRed.getData();
                    ColorModel colorModel = cachableRed.getColorModel();
                    BufferedImage bufferedImage = new BufferedImage(colorModel, writableRaster, colorModel.isAlphaPremultiplied(), null);
                    cachableRed = GraphicsUtil.wrap(bufferedImage);
                    filter = new RedRable(cachableRed);
                }
                catch (IOException iOException) {
                    filter = ImageTagRegistry.getBrokenLinkImage(this, string, objectArray);
                }
                catch (ThreadDeath threadDeath) {
                    throw threadDeath;
                }
                catch (Throwable throwable) {
                    filter = ImageTagRegistry.getBrokenLinkImage(this, string, objectArray);
                }
                deferRable.setSource(filter);
            }
        };
        thread.start();
        return deferRable;
    }
}

