// license-header java merge-point
//
// Attention: Generated code! Do not modify by hand!
// Generated by: hibernate/HibernateEntity.vsl in andromda-hibernate-cartridge.
//
package fr.ifremer.adagio.core.dao.referential.regulation;

import fr.ifremer.adagio.core.dao.administration.programStrategy.Program;
import fr.ifremer.adagio.core.dao.data.vessel.Vessel;
import fr.ifremer.adagio.core.dao.data.vessel.VesselOwner;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;

/**
 * Un droit de produire est une autorisation administrative pour prélever de ou exploiter de la
 * ressource. Il peut concerner un ensemble de navires de peche, ou un seul navire ou pecheur à
 * pied. L'autorisation peut etre relative à une espèce, ou bien à un couple engin/espèce (=métier)
 * il peut etre défini dans le cadre d'un corpus ou non (ex : droit de produire défini par les
 * autorités locales).
 */
// HibernateEntity.vsl annotations merge-point
public abstract class RightToProduce
    implements Serializable, Comparable<RightToProduce>
{
    /**
     * The serial version UID of this class. Needed for serialization.
     */
    private static final long serialVersionUID = 7864747913504035122L;

    // Generate 6 attributes
    private Integer id;

    /**
     * Idenfiant interne. Généré par le système.
     * @return this.id Integer
     */
    public Integer getId()
    {
        return this.id;
    }

    /**
     * Idenfiant interne. Généré par le système.
     * @param idIn Integer
     */
    public void setId(Integer idIn)
    {
        this.id = idIn;
    }

    private Date startDate;

    /**
     * 
     * @return this.startDate Date
     */
    public Date getStartDate()
    {
        return this.startDate;
    }

    /**
     * 
     * @param startDateIn Date
     */
    public void setStartDate(Date startDateIn)
    {
        this.startDate = startDateIn;
    }

    private Short rankOrderOnPeriod;

    /**
     * 
     * @return this.rankOrderOnPeriod Short
     */
    public Short getRankOrderOnPeriod()
    {
        return this.rankOrderOnPeriod;
    }

    /**
     * 
     * @param rankOrderOnPeriodIn Short
     */
    public void setRankOrderOnPeriod(Short rankOrderOnPeriodIn)
    {
        this.rankOrderOnPeriod = rankOrderOnPeriodIn;
    }

    private Date endDate;

    /**
     * 
     * @return this.endDate Date
     */
    public Date getEndDate()
    {
        return this.endDate;
    }

    /**
     * 
     * @param endDateIn Date
     */
    public void setEndDate(Date endDateIn)
    {
        this.endDate = endDateIn;
    }

    private String reference;

    /**
     * Reference du droit à produire.
     * Par exemple, si le droit de produire concerne un seul navire, il peut s'agir d'un numéro de
     * licence de peche.
     * @return this.reference String
     */
    public String getReference()
    {
        return this.reference;
    }

    /**
     * Reference du droit à produire.
     * Par exemple, si le droit de produire concerne un seul navire, il peut s'agir d'un numéro de
     * licence de peche.
     * @param referenceIn String
     */
    public void setReference(String referenceIn)
    {
        this.reference = referenceIn;
    }

    private Timestamp updateDate;

    /**
     * 
     * @return this.updateDate Timestamp
     */
    public Timestamp getUpdateDate()
    {
        return this.updateDate;
    }

    /**
     * 
     * @param updateDateIn Timestamp
     */
    public void setUpdateDate(Timestamp updateDateIn)
    {
        this.updateDate = updateDateIn;
    }

    // Generate 5 associations
    private Program program;

    /**
     * Programme d'observation à l'origine d'une collecte de données.
     * Désigne les activités qui sont à l'origine de la collecte d'un ensemble cohérent de données,
     * que ce
     * soit pour des collectes continues (marées observées en mer, SIPA) ou pour des études limitées
     * dans
     * le temps. La quantité de données rattachées à un programme peut être variable, selon qu'il
     * s'agit
     * d'une activité longue ou intensive, ou d'une opération plus ponctuelle (étude) mais toujours
     * mise en
     * œuvre selon un schéma décidé à l'avance.
     * Exemple de programmes d'observations :
     * - SIH-OBSMER (marées observées en mer)
     * - SIH-STATPECHE (enquete d'activité et d'effort...)
     * - SIPA : données déclaratives transmises par la DPMA
     * - VMS : données satellitaires
     * - OFIMER : données du SI de l'OFIMER
     * @return this.program Program
     */
    public Program getProgram()
    {
        return this.program;
    }

    /**
     * Programme d'observation à l'origine d'une collecte de données.
     * Désigne les activités qui sont à l'origine de la collecte d'un ensemble cohérent de données,
     * que ce
     * soit pour des collectes continues (marées observées en mer, SIPA) ou pour des études limitées
     * dans
     * le temps. La quantité de données rattachées à un programme peut être variable, selon qu'il
     * s'agit
     * d'une activité longue ou intensive, ou d'une opération plus ponctuelle (étude) mais toujours
     * mise en
     * œuvre selon un schéma décidé à l'avance.
     * Exemple de programmes d'observations :
     * - SIH-OBSMER (marées observées en mer)
     * - SIH-STATPECHE (enquete d'activité et d'effort...)
     * - SIPA : données déclaratives transmises par la DPMA
     * - VMS : données satellitaires
     * - OFIMER : données du SI de l'OFIMER
     * @param programIn Program
     */
    public void setProgram(Program programIn)
    {
        this.program = programIn;
    }

    private Collection<Vessel> vessels = new HashSet<Vessel>();

    /**
     * Les droits de produire peuvent s'appliquer à des navires de pêche professionnelle, des
     * navires de plaisance, ou des pêcheurs à pied.
     * @return this.vessels Collection<Vessel>
     */
    public Collection<Vessel> getVessels()
    {
        return this.vessels;
    }

    /**
     * Les droits de produire peuvent s'appliquer à des navires de pêche professionnelle, des
     * navires de plaisance, ou des pêcheurs à pied.
     * @param vesselsIn Collection<Vessel>
     */
    public void setVessels(Collection<Vessel> vesselsIn)
    {
        this.vessels = vesselsIn;
    }

    /**
     * Les droits de produire peuvent s'appliquer à des navires de pêche professionnelle, des
     * navires de plaisance, ou des pêcheurs à pied.
     * @param elementToAdd Vessel
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean addVessels(Vessel elementToAdd)
    {
        return this.vessels.add(elementToAdd);
    }

    /**
     * Les droits de produire peuvent s'appliquer à des navires de pêche professionnelle, des
     * navires de plaisance, ou des pêcheurs à pied.
     * @param elementToRemove Vessel
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean removeVessels(Vessel elementToRemove)
    {
        return this.vessels.remove(elementToRemove);
    }

    private Collection<VesselOwner> vesselOwners = new HashSet<VesselOwner>();

    /**
     * Un droit de produire peu aussi etre lié à un propriétaire de navire (exemple du contexte
     * seychellois)
     * @return this.vesselOwners Collection<VesselOwner>
     */
    public Collection<VesselOwner> getVesselOwners()
    {
        return this.vesselOwners;
    }

    /**
     * Un droit de produire peu aussi etre lié à un propriétaire de navire (exemple du contexte
     * seychellois)
     * @param vesselOwnersIn Collection<VesselOwner>
     */
    public void setVesselOwners(Collection<VesselOwner> vesselOwnersIn)
    {
        this.vesselOwners = vesselOwnersIn;
    }

    /**
     * Un droit de produire peu aussi etre lié à un propriétaire de navire (exemple du contexte
     * seychellois)
     * @param elementToAdd VesselOwner
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean addVesselOwners(VesselOwner elementToAdd)
    {
        return this.vesselOwners.add(elementToAdd);
    }

    /**
     * Un droit de produire peu aussi etre lié à un propriétaire de navire (exemple du contexte
     * seychellois)
     * @param elementToRemove VesselOwner
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean removeVesselOwners(VesselOwner elementToRemove)
    {
        return this.vesselOwners.remove(elementToRemove);
    }

    private Collection<Fishery> fisheries = new HashSet<Fishery>();

    /**
     * <html>
     * <head>
     * </head>
     * <body>
     * Un pecherie, peut etre, si elle n'a pas d'engin, similaire &#224; un
     * stock.<br><br><u>D&#233;finition
     * </u>:<br>A unit determined by an authority or other entity that isengaged
     * in raising and/or harvesting fish. Typically, the unit is defined in terms
     * of some or all of the following: people involved, species or type of fish,
     * area of water or seabed, method of fishing, class of boats and purpose of
     * the activities.<br><br><font size="-2">Fletcher, W.J., Chesson, J. Fisher,
     * M., Sainsbury K.J., Hundloe, T. Smith A.D.M., and B. Whitworth (2002):
     * National ESD reporting framework for Australian fisheries: The &quot;How To&quot;
     * guide for wild capture fisheries. FRDC Project 2000/145. Canberra,
     * Australia</font>
     * </body>
     * </html>
     * @return this.fisheries Collection<Fishery>
     */
    public Collection<Fishery> getFisheries()
    {
        return this.fisheries;
    }

    /**
     * <html>
     * <head>
     * </head>
     * <body>
     * Un pecherie, peut etre, si elle n'a pas d'engin, similaire &#224; un
     * stock.<br><br><u>D&#233;finition
     * </u>:<br>A unit determined by an authority or other entity that isengaged
     * in raising and/or harvesting fish. Typically, the unit is defined in terms
     * of some or all of the following: people involved, species or type of fish,
     * area of water or seabed, method of fishing, class of boats and purpose of
     * the activities.<br><br><font size="-2">Fletcher, W.J., Chesson, J. Fisher,
     * M., Sainsbury K.J., Hundloe, T. Smith A.D.M., and B. Whitworth (2002):
     * National ESD reporting framework for Australian fisheries: The &quot;How To&quot;
     * guide for wild capture fisheries. FRDC Project 2000/145. Canberra,
     * Australia</font>
     * </body>
     * </html>
     * @param fisheriesIn Collection<Fishery>
     */
    public void setFisheries(Collection<Fishery> fisheriesIn)
    {
        this.fisheries = fisheriesIn;
    }

    /**
     * <html>
     * <head>
     * </head>
     * <body>
     * Un pecherie, peut etre, si elle n'a pas d'engin, similaire &#224; un
     * stock.<br><br><u>D&#233;finition
     * </u>:<br>A unit determined by an authority or other entity that isengaged
     * in raising and/or harvesting fish. Typically, the unit is defined in terms
     * of some or all of the following: people involved, species or type of fish,
     * area of water or seabed, method of fishing, class of boats and purpose of
     * the activities.<br><br><font size="-2">Fletcher, W.J., Chesson, J. Fisher,
     * M., Sainsbury K.J., Hundloe, T. Smith A.D.M., and B. Whitworth (2002):
     * National ESD reporting framework for Australian fisheries: The &quot;How To&quot;
     * guide for wild capture fisheries. FRDC Project 2000/145. Canberra,
     * Australia</font>
     * </body>
     * </html>
     * @param elementToAdd Fishery
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean addFisheries(Fishery elementToAdd)
    {
        return this.fisheries.add(elementToAdd);
    }

    /**
     * <html>
     * <head>
     * </head>
     * <body>
     * Un pecherie, peut etre, si elle n'a pas d'engin, similaire &#224; un
     * stock.<br><br><u>D&#233;finition
     * </u>:<br>A unit determined by an authority or other entity that isengaged
     * in raising and/or harvesting fish. Typically, the unit is defined in terms
     * of some or all of the following: people involved, species or type of fish,
     * area of water or seabed, method of fishing, class of boats and purpose of
     * the activities.<br><br><font size="-2">Fletcher, W.J., Chesson, J. Fisher,
     * M., Sainsbury K.J., Hundloe, T. Smith A.D.M., and B. Whitworth (2002):
     * National ESD reporting framework for Australian fisheries: The &quot;How To&quot;
     * guide for wild capture fisheries. FRDC Project 2000/145. Canberra,
     * Australia</font>
     * </body>
     * </html>
     * @param elementToRemove Fishery
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean removeFisheries(Fishery elementToRemove)
    {
        return this.fisheries.remove(elementToRemove);
    }

    private Corpus corpus;

    /**
     * Recueil de textes, de documents qui ont trait à une même matière.
     * Ex :
     * * Corpus 1 : réglemente/défini la peche sur des espèces données, sur une zone particulière,
     * mais
     * sans définir de droit de produire.
     * * UGS : Unité de Gestion Statistique. Sert à définir les "stocks réglementaires annuels" liés
     * aux
     * quotas.
     * * zone d'effort
     * @return this.corpus Corpus
     */
    public Corpus getCorpus()
    {
        return this.corpus;
    }

    /**
     * Recueil de textes, de documents qui ont trait à une même matière.
     * Ex :
     * * Corpus 1 : réglemente/défini la peche sur des espèces données, sur une zone particulière,
     * mais
     * sans définir de droit de produire.
     * * UGS : Unité de Gestion Statistique. Sert à définir les "stocks réglementaires annuels" liés
     * aux
     * quotas.
     * * zone d'effort
     * @param corpusIn Corpus
     */
    public void setCorpus(Corpus corpusIn)
    {
        this.corpus = corpusIn;
    }

    /**
     * Returns <code>true</code> if the argument is an RightToProduce instance and all identifiers for this entity
     * equal the identifiers of the argument entity. Returns <code>false</code> otherwise.
     */
    @Override
    public boolean equals(Object object)
    {
        if (this == object)
        {
            return true;
        }
        if (!(object instanceof RightToProduce))
        {
            return false;
        }
        final RightToProduce that = (RightToProduce)object;
        if (this.id == null || that.getId() == null || !this.id.equals(that.getId()))
        {
            return false;
        }
        return true;
    }

    /**
     * Returns a hash code based on this entity's identifiers.
     */
    @Override
    public int hashCode()
    {
        int hashCode = 0;
        hashCode = 29 * hashCode + (this.id == null ? 0 : this.id.hashCode());

        return hashCode;
    }

    /**
     * Constructs new instances of {@link RightToProduce}.
     */
    public static final class Factory
    {
        /**
         * Constructs a new instance of {@link RightToProduce}.
         * @return new RightToProduceImpl()
         */
        public static RightToProduce newInstance()
        {
            return new RightToProduceImpl();
        }

        /**
         * Constructs a new instance of {@link RightToProduce}, taking all required and/or
         * read-only properties as arguments, except for identifiers.
         * @param startDate Date
         * @param program Program
         * @return newInstance
         */
        public static RightToProduce newInstance(Date startDate, Program program)
        {
            final RightToProduce entity = new RightToProduceImpl();
            entity.setStartDate(startDate);
            entity.setProgram(program);
            return entity;
        }

        /**
         * Constructs a new instance of {@link RightToProduce}, taking all possible properties
         * (except the identifier(s))as arguments.
         * @param startDate Date
         * @param rankOrderOnPeriod Short
         * @param endDate Date
         * @param reference String
         * @param updateDate Timestamp
         * @param program Program
         * @param vessels Collection<Vessel>
         * @param vesselOwners Collection<VesselOwner>
         * @param fisheries Collection<Fishery>
         * @param corpus Corpus
         * @return newInstance RightToProduce
         */
        public static RightToProduce newInstance(Date startDate, Short rankOrderOnPeriod, Date endDate, String reference, Timestamp updateDate, Program program, Collection<Vessel> vessels, Collection<VesselOwner> vesselOwners, Collection<Fishery> fisheries, Corpus corpus)
        {
            final RightToProduce entity = new RightToProduceImpl();
            entity.setStartDate(startDate);
            entity.setRankOrderOnPeriod(rankOrderOnPeriod);
            entity.setEndDate(endDate);
            entity.setReference(reference);
            entity.setUpdateDate(updateDate);
            entity.setProgram(program);
            entity.setVessels(vessels);
            entity.setVesselOwners(vesselOwners);
            entity.setFisheries(fisheries);
            entity.setCorpus(corpus);
            return entity;
        }
    }

    /**
     * @see Comparable#compareTo
     */
    public int compareTo(RightToProduce o)
    {
        int cmp = 0;
        if (this.getId() != null)
        {
            cmp = this.getId().compareTo(o.getId());
        }
        else
        {
            if (this.getStartDate() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getStartDate().compareTo(o.getStartDate()));
            }
            if (this.getRankOrderOnPeriod() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getRankOrderOnPeriod().compareTo(o.getRankOrderOnPeriod()));
            }
            if (this.getEndDate() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getEndDate().compareTo(o.getEndDate()));
            }
            if (this.getReference() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getReference().compareTo(o.getReference()));
            }
            if (this.getUpdateDate() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getUpdateDate().compareTo(o.getUpdateDate()));
            }
        }
        return cmp;
    }
// HibernateEntity.vsl merge-point
// RightToProduce.java merge-point
}