/*
 * Decompiled with CFR 0.152.
 */
package liquibase.structure;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.serializer.LiquibaseSerializable;
import liquibase.structure.DatabaseObject;
import liquibase.util.StringUtils;

public abstract class AbstractDatabaseObject
implements DatabaseObject {
    private Map<String, Object> attributes = new HashMap<String, Object>();
    private UUID snapshotId;

    @Override
    public String getObjectTypeName() {
        return StringUtils.lowerCaseFirst(this.getClass().getSimpleName());
    }

    @Override
    public UUID getSnapshotId() {
        return this.snapshotId;
    }

    @Override
    public void setSnapshotId(UUID snapshotId) {
        if (snapshotId == null) {
            throw new UnexpectedLiquibaseException("Must be a non null uuid");
        }
        if (this.snapshotId != null) {
            throw new UnexpectedLiquibaseException("snapshotId already set");
        }
        this.snapshotId = snapshotId;
    }

    @Override
    public boolean snapshotByDefault() {
        return true;
    }

    public int compareTo(Object o) {
        return this.getName().compareTo(((AbstractDatabaseObject)o).getName());
    }

    @Override
    public Set<String> getAttributes() {
        return this.attributes.keySet();
    }

    @Override
    public <T> T getAttribute(String attribute, Class<T> type) {
        return (T)this.attributes.get(attribute);
    }

    @Override
    public DatabaseObject setAttribute(String attribute, Object value) {
        if (value == null) {
            this.attributes.remove(attribute);
        } else {
            this.attributes.put(attribute, value);
        }
        return this;
    }

    @Override
    public String getSerializedObjectName() {
        return this.getObjectTypeName();
    }

    @Override
    public String getSerializedObjectNamespace() {
        return "http://www.liquibase.org/xml/ns/snapshot";
    }

    @Override
    public Set<String> getSerializableFields() {
        TreeSet<String> fields = new TreeSet<String>(this.attributes.keySet());
        fields.add("snapshotId");
        return fields;
    }

    @Override
    public Object getSerializableFieldValue(String field) {
        if (field.equals("snapshotId")) {
            return this.snapshotId;
        }
        if (!this.attributes.containsKey(field)) {
            throw new UnexpectedLiquibaseException("Unknown field " + field);
        }
        Object value = this.attributes.get(field);
        if (value instanceof DatabaseObject) {
            try {
                DatabaseObject clone = (DatabaseObject)value.getClass().newInstance();
                clone.setName(((DatabaseObject)value).getName());
                clone.setSnapshotId(((DatabaseObject)value).getSnapshotId());
                return clone;
            }
            catch (Exception e) {
                throw new UnexpectedLiquibaseException(e);
            }
        }
        return value;
    }

    @Override
    public LiquibaseSerializable.SerializationType getSerializableFieldType(String field) {
        if (this.getSerializableFieldValue(field) instanceof DatabaseObject) {
            return LiquibaseSerializable.SerializationType.NAMED_FIELD;
        }
        return LiquibaseSerializable.SerializationType.NAMED_FIELD;
    }

    public String toString() {
        return this.getName();
    }
}

