/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.protocol.actions;

import com.google.common.base.Preconditions;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolSpeciesRowModel;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolSpeciesTableModel;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolUI;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolUIHandler;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolUIModel;
import fr.ifremer.tutti.ui.swing.util.actions.LongActionSupport;
import java.io.Serializable;
import java.util.Collection;
import javax.swing.JTable;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.swing.editor.bean.BeanFilterableComboBox;
import org.nuiton.i18n.I18n;

public class AddSpeciesProtocolAction
extends LongActionSupport<EditProtocolUIModel, EditProtocolUI, EditProtocolUIHandler> {
    protected Species species;
    protected EditProtocolSpeciesRowModel newRow;

    public AddSpeciesProtocolAction(EditProtocolUIHandler handler) {
        super(handler, false);
    }

    @Override
    public void doAction() throws Exception {
        EditProtocolUI ui = (EditProtocolUI)this.getUI();
        EditProtocolSpeciesTableModel tableModel = ((EditProtocolUIHandler)this.handler).getSpeciesTableModel();
        BeanFilterableComboBox<Species> speciesComboBox = ui.getSpeciesComboBox();
        this.species = (Species)speciesComboBox.getSelectedItem();
        Preconditions.checkNotNull((Object)this.species, (Object)"Can't add a speciesProtocol with a null species");
        Preconditions.checkArgument((boolean)this.species.isReferenceTaxon(), (Object)"Can't add a speciesProtocol with a not referent species");
        Integer taxonId = this.species.getReferenceTaxonId();
        String taxonIdStr = String.valueOf(taxonId);
        Collection<Species> allSynonyms = ((EditProtocolUIModel)this.getModel()).getAllSynonyms(taxonIdStr);
        ((EditProtocolUIModel)this.getModel()).getAllSynonyms().removeAll(allSynonyms);
        this.newRow = tableModel.createNewRow();
        this.newRow.setSpecies(this.species);
        ((EditProtocolUIModel)this.getModel()).getSpeciesRow().add(this.newRow);
    }

    public void postSuccessAction() {
        super.postSuccessAction();
        ((EditProtocolUI)this.getUI()).getBenthosComboBox().removeItem((Object)this.species);
        ((EditProtocolUI)this.getUI()).getSpeciesComboBox().removeItem((Object)this.species);
        EditProtocolSpeciesTableModel tableModel = ((EditProtocolUIHandler)this.getHandler()).getSpeciesTableModel();
        tableModel.fireTableRowsInserted((Serializable)((Object)this.newRow));
        int rowIndex = tableModel.getRowIndex((Serializable)((Object)this.newRow));
        SwingUtil.setSelectionInterval((JTable)((EditProtocolUIHandler)this.handler).getSpeciesTable(), (int)rowIndex);
        String speciesStr = this.decorate(this.species);
        this.sendMessage(I18n.t((String)"tutti.flash.info.species.add.to.protocol", (Object[])new Object[]{speciesStr}));
    }
}

