/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.genericformat.importactions;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.data.SampleCategoryModel;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocol;
import fr.ifremer.tutti.persistence.entities.referential.Gear;
import fr.ifremer.tutti.persistence.entities.referential.Person;
import fr.ifremer.tutti.persistence.entities.referential.Speciess;
import fr.ifremer.tutti.persistence.entities.referential.Vessel;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.service.genericformat.GenericFormatContextSupport;
import fr.ifremer.tutti.service.genericformat.GenericFormatImportRequest;
import fr.ifremer.tutti.service.genericformat.GenericFormatReferentialImportResult;
import fr.ifremer.tutti.service.genericformat.GenericFormatReferentialSpeciesImportResult;
import fr.ifremer.tutti.service.genericformat.importactions.ImportActionSupport;
import java.util.HashSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RestoreAfterValidateAction
extends ImportActionSupport {
    private static final Log log = LogFactory.getLog(RestoreAfterValidateAction.class);
    private final PersistenceService persistenceService;

    public RestoreAfterValidateAction(GenericFormatContextSupport importContext, PersistenceService persistenceService) {
        super(importContext);
        this.persistenceService = persistenceService;
    }

    @Override
    protected boolean canExecute() {
        return true;
    }

    @Override
    protected void doExecute() {
        HashSet<Runnable> actions = new HashSet<Runnable>();
        actions.add(new Runnable(){

            @Override
            public void run() {
                RestoreAfterValidateAction.this.rollbackSampleCategoryModel(RestoreAfterValidateAction.this.importContext.getImportRequest());
            }
        });
        actions.add(new Runnable(){

            @Override
            public void run() {
                RestoreAfterValidateAction.this.rollbackProtocol();
            }
        });
        actions.add(new Runnable(){

            @Override
            public void run() {
                RestoreAfterValidateAction.this.rollbackPreviousProtocol(RestoreAfterValidateAction.this.importContext.getImportRequest());
            }
        });
        actions.add(new Runnable(){

            @Override
            public void run() {
                RestoreAfterValidateAction.this.rollbackTemporaryGears();
            }
        });
        actions.add(new Runnable(){

            @Override
            public void run() {
                RestoreAfterValidateAction.this.rollbackTemporaryPersons();
            }
        });
        actions.add(new Runnable(){

            @Override
            public void run() {
                RestoreAfterValidateAction.this.rollbackTemporarySpecies();
            }
        });
        actions.add(new Runnable(){

            @Override
            public void run() {
                RestoreAfterValidateAction.this.rollbackTemporaryVessels();
            }
        });
        for (Runnable action : actions) {
            try {
                action.run();
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) continue;
                log.error((Object)"Could not execute rollback action", (Throwable)e);
            }
        }
    }

    protected void rollbackSampleCategoryModel(GenericFormatImportRequest importRequest) {
        SampleCategoryModel sampleCategoryModel = importRequest.getSampleCategoryModel();
        if (log.isInfoEnabled()) {
            log.info((Object)("Rollback previous sample cateogry model: " + sampleCategoryModel));
        }
        this.persistenceService.setSampleCategoryModel(sampleCategoryModel);
    }

    protected void rollbackPreviousProtocol(GenericFormatImportRequest importRequest) {
        TuttiProtocol previousProtocol = importRequest.getProtocol();
        if (previousProtocol != null) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Rollback previous protocol: " + previousProtocol));
            }
            this.persistenceService.setProtocol(previousProtocol);
        }
    }

    protected void rollbackProtocol() {
        TuttiProtocol importedProtocol = this.importContext.getImportedProtocol();
        if (importedProtocol != null) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Delete imported protocol: " + importedProtocol));
            }
            this.persistenceService.setProtocol(null);
            this.persistenceService.deleteProtocol(importedProtocol.getId());
        }
    }

    protected void rollbackTemporaryGears() {
        GenericFormatReferentialImportResult<Gear, Integer> fileResult = this.importContext.getReferentialTemporaryGearFileResult();
        HashSet addedEntriesIds = Sets.newHashSet((Iterable)Iterables.transform(fileResult.getEntitiesAdded(), (Function)TuttiEntities.GET_ID_AS_INT));
        if (!addedEntriesIds.isEmpty()) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Rollback previous imported temporary gears: " + addedEntriesIds));
            }
            this.persistenceService.deleteTemporaryGears(addedEntriesIds);
        }
    }

    protected void rollbackTemporaryPersons() {
        GenericFormatReferentialImportResult<Person, Integer> fileResult = this.importContext.getReferentialTemporaryPersonFileResult();
        HashSet addedEntriesIds = Sets.newHashSet((Iterable)Iterables.transform(fileResult.getEntitiesAdded(), (Function)TuttiEntities.GET_ID_AS_INT));
        if (!addedEntriesIds.isEmpty()) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Rollback previous imported temporary persons: " + addedEntriesIds));
            }
            this.persistenceService.deleteTemporaryPersons(addedEntriesIds);
        }
    }

    protected void rollbackTemporarySpecies() {
        GenericFormatReferentialSpeciesImportResult fileResult = this.importContext.getReferentialTemporarySpeciesFileResult();
        HashSet addedEntriesIds = Sets.newHashSet((Iterable)Iterables.transform(fileResult.getEntitiesAdded(), (Function)Speciess.GET_REFERECE_TAXON_ID_AS_INT));
        if (!addedEntriesIds.isEmpty()) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Rollback previous imported temporary species: " + addedEntriesIds));
            }
            this.persistenceService.deleteTemporarySpecies(addedEntriesIds);
        }
    }

    protected void rollbackTemporaryVessels() {
        GenericFormatReferentialImportResult<Vessel, String> fileResult = this.importContext.getReferentialTemporaryVesselFileResult();
        HashSet addedEntriesIds = Sets.newHashSet((Iterable)Iterables.transform(fileResult.getEntitiesAdded(), (Function)TuttiEntities.GET_ID));
        if (!addedEntriesIds.isEmpty()) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Rollback previous imported temporary vessels: " + addedEntriesIds));
            }
            this.persistenceService.deleteTemporaryVessels(addedEntriesIds);
        }
    }
}

