package fr.ifremer.tutti.ui.swing.util.auth;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2015 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dialog.ModalityType;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n.t;

public class LoginUI extends JDialog implements TuttiUI<TuttiUIContext, LoginUIHandler>, JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK1Uz28bRRR+NrEbx0nTEhpKKWBKD5VA63JBlYKgIcUikUMrkkpVfaDj3Uky1ezMMDPbbBWB+BP4E+DOBYkbJ8SBMwcuiH8BIQ5cEW9m17veZE2CVEte2+/H9977/L737R/QMhpef0zSNNCJsCymwdb6gwd3x49paO9QE2qmrNSQvRpNaI6gGxV2Y+GN0dCl9/P0/oaMlRRUTGWvDWHB2KecmgNKrYVXqhmhMf2dwr2WqkRPUIum6lC//uvP5lfRl980AVKF3XVxlN5pWeUkc0NossjC81jpCelzIvaxDc3EPva75GwbnBjzMYnpZ/AFnBtCWxGNYBaunX1kj+HzU2Why+U+E3cYwU8Lb+7pgO1pGlMd2MRaFiQsMIfYQZBYxgOS2INg6DLubyrlUdoWWrGMKLdwY3b2rvt5f3NDCktTW6Z2YsLEPSJc+uUKU3keGXM/bKdI6TKxJ7epMWSfIleOljSP3hqSMeUubrkIX/ADFo4X6rwDRjnyvlrB2sVGvaOasaSQvkOpo1mQRUCOeqWCem/aWU2cv77lmbh5fCpvrcYuhkSElH+AtCKlsFKJz6wu8rUygYQhVbZ0Xc/9Gl6u8I67H5S7Xy5nYwQtnaAZ/6jRSbl8gq5MKJePCcUBeu8/qyu//vD794OJOuax9qXa0Clx49YqLRXVlrnSy5k03DL2t4laG0HHUI6XwSv/ak1jO7kbm8N6F116tssfEXOAEK1zv/340+qjX56D5sCtA4kGxMVvQsceaGRB8ihV79/2HS0ezuPzAr6buPaWWY4UXcx23W9SkNucJAju9JzVCU2Rlas1rBStjTs//72y893tCTMN7PSlmeElO62H0GaCM0H95ciPQu2l6CpDk0iW4q87B1C9ByrX6Vv+efMEBw3UD3LFpNgM3RbOOWWmiQt+x0/hvt2CqmRPA0Vi57mT1kBqC+ePeqVCe587QlGWFl6c5nzPObPvddWnLsD/K758VJFyWf3KyeqTyLoGqifjtB5aRZmVrEwo41iKIFP8McrbE+vSp4bFitN177Tw4dFZTnkGZbKTvuGhMoAgdGuBEy+yt2+JbUGxAxaiwmpaCuLC3bVS8l2mdmf2X8dP5ZidnZ5LFfgnhLOIWHqcoOzuPROC1j3UfxP0am1TMymqn6GWpOkDfgZltjl5KjEYzr+LkKQ3ZiLC2d47gd1wz4VTEZ3ZukdSj9BDhH8BrgoqGL4JAAA=";
    private static final Log log = LogFactory.getLog(LoginUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton acceptButton;
    protected JButton cancelButton;
    protected final LoginUIHandler handler = createHandler();
    protected JLabel infoMessage;
    protected LoginUI loginDialog = this;
    protected JTextField loginField;
    protected JLabel loginLabel;
    protected Table mainPanel;
    protected TuttiUIContext model;
    protected JPasswordField passwordField;
    protected JLabel passwordLabel;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JPanel $JPanel0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
    
    public LoginUI open(String url, AuthenticationInfo authenticationInfo) {
        handler.open(url, authenticationInfo);
        return this;
    }
    
    public AuthenticationInfo getAuthenticationInfo() { return handler.getAuthenticationInfo(); }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public LoginUI(TuttiUIContext context) {
        super(context.getExistingActionUI());
            TuttiUIUtil.setApplicationContext(this, context);
            $initialize();
    }

    public LoginUI(Frame param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public LoginUI(JAXXContext parentContext, Frame param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public LoginUI() {
        $initialize();
    }

    public LoginUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public LoginUI(Frame param0) {
        super(param0);
        $initialize();
    }

    public LoginUI(JAXXContext parentContext, Frame param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public LoginUI(Window param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public LoginUI(JAXXContext parentContext, Window param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public LoginUI(Window param0, String param1, ModalityType param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public LoginUI(JAXXContext parentContext, Window param1, String param2, ModalityType param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public LoginUI(Window param0, String param1, ModalityType param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public LoginUI(JAXXContext parentContext, Window param1, String param2, ModalityType param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public LoginUI(Dialog param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public LoginUI(JAXXContext parentContext, Dialog param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public LoginUI(Window param0, ModalityType param1) {
        super(param0 ,param1);
        $initialize();
    }

    public LoginUI(JAXXContext parentContext, Window param1, ModalityType param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public LoginUI(Window param0) {
        super(param0);
        $initialize();
    }

    public LoginUI(JAXXContext parentContext, Window param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public LoginUI(Dialog param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public LoginUI(JAXXContext parentContext, Dialog param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public LoginUI(Frame param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public LoginUI(JAXXContext parentContext, Frame param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public LoginUI(Dialog param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public LoginUI(JAXXContext parentContext, Dialog param1, String param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public LoginUI(Frame param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public LoginUI(JAXXContext parentContext, Frame param1, String param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public LoginUI(Frame param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public LoginUI(JAXXContext parentContext, Frame param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public LoginUI(Dialog param0) {
        super(param0);
        $initialize();
    }

    public LoginUI(JAXXContext parentContext, Dialog param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public LoginUI(Dialog param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public LoginUI(JAXXContext parentContext, Dialog param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JButton getAcceptButton() {
        return acceptButton;
    }

    public JButton getCancelButton() {
        return cancelButton;
    }

    public LoginUIHandler getHandler() {
        return handler;
    }

    public JLabel getInfoMessage() {
        return infoMessage;
    }

    public JTextField getLoginField() {
        return loginField;
    }

    public JLabel getLoginLabel() {
        return loginLabel;
    }

    public Table getMainPanel() {
        return mainPanel;
    }

    public TuttiUIContext getModel() {
        return model;
    }

    public JPasswordField getPasswordField() {
        return passwordField;
    }

    public JLabel getPasswordLabel() {
        return passwordLabel;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToLoginDialog() {
        if (!allComponentsCreated) {
            return;
        }
        add(mainPanel);
    }

    protected void addChildrenToMainPanel() {
        if (!allComponentsCreated) {
            return;
        }
        mainPanel.add(infoMessage, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        mainPanel.add(loginLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        mainPanel.add(loginField, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        mainPanel.add(passwordLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        mainPanel.add(passwordField, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        mainPanel.add($JPanel0, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void createAcceptButton() {
        $objectMap.put("acceptButton", acceptButton = new JButton());
        
        acceptButton.setName("acceptButton");
        acceptButton.setText(t("tutti.common.validate"));
        acceptButton.setToolTipText(t("tutti.common.validate"));
        acceptButton.putClientProperty("simpleAction", fr.ifremer.tutti.ui.swing.util.auth.actions.LoginAcceptAction.class);
    }

    protected void createCancelButton() {
        $objectMap.put("cancelButton", cancelButton = new JButton());
        
        cancelButton.setName("cancelButton");
        cancelButton.setText(t("tutti.common.cancel"));
        cancelButton.setToolTipText(t("tutti.common.cancel"));
        cancelButton.putClientProperty("simpleAction", fr.ifremer.tutti.ui.swing.util.auth.actions.LoginCancelAction.class);
    }

    protected LoginUIHandler createHandler() {
        return new LoginUIHandler();
    }

    protected void createInfoMessage() {
        $objectMap.put("infoMessage", infoMessage = new JLabel());
        
        infoMessage.setName("infoMessage");
    }

    protected void createLoginField() {
        $objectMap.put("loginField", loginField = new JTextField());
        
        loginField.setName("loginField");
        loginField.setColumns(15);
    }

    protected void createLoginLabel() {
        $objectMap.put("loginLabel", loginLabel = new JLabel());
        
        loginLabel.setName("loginLabel");
        loginLabel.setText(t("tutti.login.field.login"));
    }

    protected void createMainPanel() {
        $objectMap.put("mainPanel", mainPanel = new Table());
        
        mainPanel.setName("mainPanel");
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(TuttiUIContext.class));
    }

    protected void createPasswordField() {
        $objectMap.put("passwordField", passwordField = new JPasswordField());
        
        passwordField.setName("passwordField");
        passwordField.setColumns(15);
    }

    protected void createPasswordLabel() {
        $objectMap.put("passwordLabel", passwordLabel = new JLabel());
        
        passwordLabel.setName("passwordLabel");
        passwordLabel.setText(t("tutti.login.field.password"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToLoginDialog();
        addChildrenToMainPanel();
        // inline complete setup of $JPanel0
        $JPanel0.add(cancelButton);
        $JPanel0.add(acceptButton);
        
        // apply 9 property setters
        infoMessage.setIcon(SwingUtil.createActionIcon("info"));
        loginLabel.setLabelFor( loginField );
        passwordLabel.setLabelFor(passwordField);
        cancelButton.setIcon(SwingUtil.createActionIcon("cancel"));
        cancelButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.common.cancel.mnemonic"),'Z'));
        acceptButton.setIcon(SwingUtil.createActionIcon("accept"));
        acceptButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.common.validate.mnemonic"),'Z'));
        // late initializer
        loginDialog.pack();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        handler.beforeInit(this);
        $objectMap.put("loginDialog", loginDialog);
        createModel();
        createMainPanel();
        createInfoMessage();
        createLoginLabel();
        createLoginField();
        createPasswordLabel();
        createPasswordField();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new GridLayout(1,0));
        createCancelButton();
        createAcceptButton();
        // inline creation of loginDialog
        setName("loginDialog");
        loginDialog.getContentPane().setLayout(new BorderLayout());
        setTitle(t("tutti.login.title"));
        setModal(true);
        
        $completeSetup();
        handler.afterInit(this);
    }

}