package fr.ifremer.tutti.ui.swing.content.validation.actions;

/*
 * #%L
 * Tutti :: UI
 * %%
 * Copyright (C) 2012 - 2014 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.google.common.base.Preconditions;
import fr.ifremer.tutti.persistence.ProgressionModel;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.ui.swing.util.actions.LongActionSupport;
import fr.ifremer.tutti.ui.swing.content.validation.ValidateCruiseUI;
import fr.ifremer.tutti.ui.swing.content.validation.ValidateCruiseUIHandler;
import fr.ifremer.tutti.ui.swing.content.validation.ValidateCruiseUIModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import javax.swing.JOptionPane;
import java.util.List;

import static org.nuiton.i18n.I18n.t;

/**
 * Created on 4/24/14.
 *
 * @author Tony Chemit <chemit@codelutin.com>
 * @since 3.5
 */
public class SaveCruiseToReadyToSynchAction extends LongActionSupport<ValidateCruiseUIModel, ValidateCruiseUI, ValidateCruiseUIHandler> {

    /** Logger. */
    private static final Log log = LogFactory.getLog(SaveCruiseToReadyToSynchAction.class);

    public SaveCruiseToReadyToSynchAction(ValidateCruiseUIHandler handler) {
        super(handler, false);
        setActionDescription(t("tutti.validationCruise.action.saveCruiseToReadyToSynch.tip"));
    }

    @Override
    public boolean prepareAction() throws Exception {
        boolean doAction = super.prepareAction();
        if (doAction) {
            int answer = JOptionPane.showConfirmDialog(getContext().getActionUI(),
                                                       t("tutti.validationCruise.action.saveCruiseToReadyToSynch.message"),
                                                       t("tutti.validationCruise.action.saveCruiseToReadyToSynch.title"),
                                                       JOptionPane.YES_NO_OPTION);
            doAction = answer == JOptionPane.YES_OPTION;
        }

        PersistenceService persistenceService = getContext().getPersistenceService();
        int fishingOperationCount = persistenceService.getFishingOperationCount(getModel().getCruise().getId());
        createProgressionModelIfRequired(fishingOperationCount + 1);

        return doAction;
    }

    @Override
    public void doAction() throws Exception {

        Preconditions.checkState(getContext().isProgramFilled());
        Preconditions.checkState(getContext().isCruiseFilled());

        PersistenceService persistenceService = getContext().getPersistenceService();

        ProgressionModel progressionModel = getProgressionModel();

        List<String> allFishingOperation = persistenceService.getAllFishingOperationIds(getModel().getCruise().getId());

        for (String fishingOperationId : allFishingOperation) {

            if (log.isInfoEnabled()) {
                log.info("Recompute sample ratios for operation " + fishingOperationId);
            }
            persistenceService.recomputeCatchBatchSampleRatios(fishingOperationId);

            progressionModel.increments("Recalcul des poids référents pour l'opération " + fishingOperationId);
        }

        Integer cruiseId = getModel().getCruise().getIdAsInt();

        if (log.isInfoEnabled()) {
            log.info("Pass synchronizationStatus to *ready to synch* for cruise: " + cruiseId);
        }

        progressionModel.increments("Mise en place des données synchronisables");

        persistenceService.setCruiseReadyToSynch(cruiseId);

    }

    @Override
    public void postSuccessAction() {
        super.postSuccessAction();

        // reload cruise in data context
        getDataContext().reloadCruise();

        // reload it in our model
        getModel().setCruise(getDataContext().getCruise());
    }
}
