// license-header java merge-point
//
// Attention: Generated code! Do not modify by hand!
// Generated by: hibernate/HibernateEntity.vsl in andromda-hibernate-cartridge.
//
package fr.ifremer.adagio.core.dao.data.produce;

import fr.ifremer.adagio.core.dao.data.batch.Batch;
import fr.ifremer.adagio.core.dao.data.fishingArea.FishingArea;
import fr.ifremer.adagio.core.dao.data.measure.ProduceQuantificationMeasurement;
import fr.ifremer.adagio.core.dao.data.measure.ProduceSortingMeasurement;
import fr.ifremer.adagio.core.dao.data.operation.FishingOperation;
import fr.ifremer.adagio.core.dao.data.sale.ExpectedSale;
import fr.ifremer.adagio.core.dao.data.survey.landing.Landing;
import fr.ifremer.adagio.core.dao.data.survey.sale.Sale;
import fr.ifremer.adagio.core.dao.data.survey.takeOver.TakeOver;
import fr.ifremer.adagio.core.dao.data.transshipment.Transshipment;
import fr.ifremer.adagio.core.dao.referential.QualityFlag;
import fr.ifremer.adagio.core.dao.referential.SaleType;
import fr.ifremer.adagio.core.dao.referential.buyer.Buyer;
import fr.ifremer.adagio.core.dao.referential.gear.Gear;
import fr.ifremer.adagio.core.dao.referential.pmfm.Method;
import fr.ifremer.adagio.core.dao.referential.pmfm.QualitativeValue;
import fr.ifremer.adagio.core.dao.referential.taxon.TaxonGroup;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;

/**
 * <html>
 * <head>
 * </head>
 * <body>
 * <p>
 * Un produit est identifi&#233; par une esp&#232;ce commerciale, un &#233;tat, une
 * qualit&#233;, pr&#233;sentation et cat&#233;gorie commerciale.
 * </p>
 * <p>
 * </p>
 * <p>
 * <u>Si le produit est un &quot;produit vendu&quot; :</u>
 * </p>
 * <p>
 * On pourra allors utiliser SortingMeasurement pour stocker des donn&#233;es
 * &#233;conomiques, comme par exemple :
 * </p>
 * <p>
 * - Le prix du produit. Il peut y avoir plusieurds prix (plusieurs PSFMs),
 * par exemple : prix au kilo, et prix total en euros.
 * </p>
 * <p>
 * - Valorisation de la commercialisation : Label rouge, Eco Label, marque
 * collective control&#233;e par un organisme tier. (cf SACROIS)
 * </p>
 * <p>
 * - Destination commerciale : consommation humaine, consommation animale,
 * etc .
 * </p>
 * </body>
 * </html>
 */
// HibernateEntity.vsl annotations merge-point
public abstract class Produce
    implements Serializable, Comparable<Produce>
{
    /**
     * The serial version UID of this class. Needed for serialization.
     */
    private static final long serialVersionUID = 2475689423996229615L;

    // Generate 12 attributes
    private Integer id;

    /**
     * Identifiant interne du produit. Généré par le système.
     * @return this.id Integer
     */
    public Integer getId()
    {
        return this.id;
    }

    /**
     * Identifiant interne du produit. Généré par le système.
     * @param idIn Integer
     */
    public void setId(Integer idIn)
    {
        this.id = idIn;
    }

    private Boolean isDiscard = Boolean.valueOf(false);

    /**
     * Le produit est-il un rejet ou non ?
     * @return this.isDiscard Boolean
     */
    public Boolean isIsDiscard()
    {
        return this.isDiscard;
    }

    /**
     * Le produit est-il un rejet ou non ?
     * @param isDiscardIn Boolean
     */
    public void setIsDiscard(Boolean isDiscardIn)
    {
        this.isDiscard = isDiscardIn;
    }

    private Float subgroupCount;

    /**
     * Nombre de sous ensembles ayant servit à la quantification.
     * Par exemple il pourra s'agir d'un nombre de caisse servant à quantifié le produit.
     * Par exemple, pour une détermination de la quantification par les volumes :
     * - nombre_sous_ensembles_quantifiés = 3
     * - poids moyen par sous-ensemble = 5 kg
     * => Poids total du lot = 3 x 5 = 15kg
     * @return this.subgroupCount Float
     */
    public Float getSubgroupCount()
    {
        return this.subgroupCount;
    }

    /**
     * Nombre de sous ensembles ayant servit à la quantification.
     * Par exemple il pourra s'agir d'un nombre de caisse servant à quantifié le produit.
     * Par exemple, pour une détermination de la quantification par les volumes :
     * - nombre_sous_ensembles_quantifiés = 3
     * - poids moyen par sous-ensemble = 5 kg
     * => Poids total du lot = 3 x 5 = 15kg
     * @param subgroupCountIn Float
     */
    public void setSubgroupCount(Float subgroupCountIn)
    {
        this.subgroupCount = subgroupCountIn;
    }

    private Short individualCount;

    /**
     * Nombre d'individus (optionnel). Utile pour les très gros individu.
     * Ex : 1 espadon de 150kg
     * @return this.individualCount Short
     */
    public Short getIndividualCount()
    {
        return this.individualCount;
    }

    /**
     * Nombre d'individus (optionnel). Utile pour les très gros individu.
     * Ex : 1 espadon de 150kg
     * @param individualCountIn Short
     */
    public void setIndividualCount(Short individualCountIn)
    {
        this.individualCount = individualCountIn;
    }

    private String taxonGroupOtherInformation;

    /**
     * Autre information sur l'espèce du produit.
     * Utilisé dans SACROIS/RIC2, pour stocker des informations complémentaires issues du
     * référentiel espèce du Réseau Inter Criée (RIC).
     * @return this.taxonGroupOtherInformation String
     */
    public String getTaxonGroupOtherInformation()
    {
        return this.taxonGroupOtherInformation;
    }

    /**
     * Autre information sur l'espèce du produit.
     * Utilisé dans SACROIS/RIC2, pour stocker des informations complémentaires issues du
     * référentiel espèce du Réseau Inter Criée (RIC).
     * @param taxonGroupOtherInformationIn String
     */
    public void setTaxonGroupOtherInformation(String taxonGroupOtherInformationIn)
    {
        this.taxonGroupOtherInformation = taxonGroupOtherInformationIn;
    }

    private Date controlDate;

    /**
     * 
     * @return this.controlDate Date
     */
    public Date getControlDate()
    {
        return this.controlDate;
    }

    /**
     * 
     * @param controlDateIn Date
     */
    public void setControlDate(Date controlDateIn)
    {
        this.controlDate = controlDateIn;
    }

    private Date validationDate;

    /**
     * 
     * @return this.validationDate Date
     */
    public Date getValidationDate()
    {
        return this.validationDate;
    }

    /**
     * 
     * @param validationDateIn Date
     */
    public void setValidationDate(Date validationDateIn)
    {
        this.validationDate = validationDateIn;
    }

    private Date qualificationDate;

    /**
     * 
     * @return this.qualificationDate Date
     */
    public Date getQualificationDate()
    {
        return this.qualificationDate;
    }

    /**
     * 
     * @param qualificationDateIn Date
     */
    public void setQualificationDate(Date qualificationDateIn)
    {
        this.qualificationDate = qualificationDateIn;
    }

    private String qualificationComments;

    /**
     * 
     * @return this.qualificationComments String
     */
    public String getQualificationComments()
    {
        return this.qualificationComments;
    }

    /**
     * 
     * @param qualificationCommentsIn String
     */
    public void setQualificationComments(String qualificationCommentsIn)
    {
        this.qualificationComments = qualificationCommentsIn;
    }

    private Float weight;

    /**
     * Poids total du lot/produit (en kg).
     * Il peut s'agir d'une poids vif ou d'un poids brut, suivant si la la présence ou l'absence de
     * l’état et de la présentation.
     * @since 3.5.0
     * @return this.weight Float
     */
    public Float getWeight()
    {
        return this.weight;
    }

    /**
     * Poids total du lot/produit (en kg).
     * Il peut s'agir d'une poids vif ou d'un poids brut, suivant si la la présence ou l'absence de
     * l’état et de la présentation.
     * @since 3.5.0
     * @param weightIn Float
     */
    public void setWeight(Float weightIn)
    {
        this.weight = weightIn;
    }

    private Float cost;

    /**
     * Prix total, exprimé dans l'unité utilisée par du système SIH (€, DH, SR, ...)
     * @since 3.5.0
     * @return this.cost Float
     */
    public Float getCost()
    {
        return this.cost;
    }

    /**
     * Prix total, exprimé dans l'unité utilisée par du système SIH (€, DH, SR, ...)
     * @since 3.5.0
     * @param costIn Float
     */
    public void setCost(Float costIn)
    {
        this.cost = costIn;
    }

    private Integer remoteId;

    /**
     * 
     * @return this.remoteId Integer
     */
    public Integer getRemoteId()
    {
        return this.remoteId;
    }

    /**
     * 
     * @param remoteIdIn Integer
     */
    public void setRemoteId(Integer remoteIdIn)
    {
        this.remoteId = remoteIdIn;
    }

    // Generate 23 associations
    private TaxonGroup otherTaxonGroup;

    /**
     * Espèce du produit, de la classification BCS (espèce commerciale)
     * @return this.otherTaxonGroup TaxonGroup
     */
    public TaxonGroup getOtherTaxonGroup()
    {
        return this.otherTaxonGroup;
    }

    /**
     * Espèce du produit, de la classification BCS (espèce commerciale)
     * @param otherTaxonGroupIn TaxonGroup
     */
    public void setOtherTaxonGroup(TaxonGroup otherTaxonGroupIn)
    {
        this.otherTaxonGroup = otherTaxonGroupIn;
    }

    private TaxonGroup taxonGroup;

    /**
     * Il s'agit d'une autre référence de l'espèce du produit, dans une autre classification
     * d'espèce.
     * Pour SACROIS/RIC2, on utilise en espèce secondaire la classification FAO.
     * @return this.taxonGroup TaxonGroup
     */
    public TaxonGroup getTaxonGroup()
    {
        return this.taxonGroup;
    }

    /**
     * Il s'agit d'une autre référence de l'espèce du produit, dans une autre classification
     * d'espèce.
     * Pour SACROIS/RIC2, on utilise en espèce secondaire la classification FAO.
     * @param taxonGroupIn TaxonGroup
     */
    public void setTaxonGroup(TaxonGroup taxonGroupIn)
    {
        this.taxonGroup = taxonGroupIn;
    }

    private SaleType saleType;

    /**
     * <html>
     * <head>
     * <style>
     * p {padding:0px; margin:0px;}
     * </style>
     * </head>
     * <body>
     * <p>
     * Type de vente (ou mode de commercialisation)
     * </p>
     * <p>
     * &#160;
     * </p>
     * <p>
     * Changes history :
     * </p>
     * <p>
     * - 05/06/2014 BLA Add a link between Produce and SaleType
     * </p>
     * </body>
     * </html>
     * @return this.saleType SaleType
     */
    public SaleType getSaleType()
    {
        return this.saleType;
    }

    /**
     * <html>
     * <head>
     * <style>
     * p {padding:0px; margin:0px;}
     * </style>
     * </head>
     * <body>
     * <p>
     * Type de vente (ou mode de commercialisation)
     * </p>
     * <p>
     * &#160;
     * </p>
     * <p>
     * Changes history :
     * </p>
     * <p>
     * - 05/06/2014 BLA Add a link between Produce and SaleType
     * </p>
     * </body>
     * </html>
     * @param saleTypeIn SaleType
     */
    public void setSaleType(SaleType saleTypeIn)
    {
        this.saleType = saleTypeIn;
    }

    private Gear otherGear;

    /**
     * <html>
     * <head>
     * <style>
     * p {padding:0px; margin:0px;}
     * </style>
     * </head>
     * <body>
     * <p>
     * L'engin <b>dans un référentiel</b> <b>distinct</b> que celui
     * défini dans le programme de collecte.
     * </p>
     * <p>
     * </p>
     * <p>
     * Cas d'utilisation :
     * </p>
     * <ul>
     * <li>
     * l'engin a été collecté dans deux référentiels distincts
     * </li>
     * <li>
     * ou encore : l'engin collecté a été transcodé dans le référentiel
     * actuel du SIH. (cas des donénes historiques provenant de Harmonie1 :
     * le champ OTHER_GEAR_FK stocke l'engin CNTS tel que collecté, et
     * GEAR_FK l'engin transcodé en FAO).
     * </li>
     * </ul>
     * </body>
     * </html>
     * @return this.otherGear Gear
     */
    public Gear getOtherGear()
    {
        return this.otherGear;
    }

    /**
     * <html>
     * <head>
     * <style>
     * p {padding:0px; margin:0px;}
     * </style>
     * </head>
     * <body>
     * <p>
     * L'engin <b>dans un référentiel</b> <b>distinct</b> que celui
     * défini dans le programme de collecte.
     * </p>
     * <p>
     * </p>
     * <p>
     * Cas d'utilisation :
     * </p>
     * <ul>
     * <li>
     * l'engin a été collecté dans deux référentiels distincts
     * </li>
     * <li>
     * ou encore : l'engin collecté a été transcodé dans le référentiel
     * actuel du SIH. (cas des donénes historiques provenant de Harmonie1 :
     * le champ OTHER_GEAR_FK stocke l'engin CNTS tel que collecté, et
     * GEAR_FK l'engin transcodé en FAO).
     * </li>
     * </ul>
     * </body>
     * </html>
     * @param otherGearIn Gear
     */
    public void setOtherGear(Gear otherGearIn)
    {
        this.otherGear = otherGearIn;
    }

    private QualitativeValue dressing;

    /**
     * Liste des valeurs qualitatives que peut prendre un paramètre.
     * Par exemple :
     * - pour le paramètre Sexe : "Mâle" et "Femelle"
     * - pour le paramètre Présentation : "Vidé", "Entier", ...
     * - pour le paramètre Catégorie : "Gros", "Moyen", ...
     * @return this.dressing QualitativeValue
     */
    public QualitativeValue getDressing()
    {
        return this.dressing;
    }

    /**
     * Liste des valeurs qualitatives que peut prendre un paramètre.
     * Par exemple :
     * - pour le paramètre Sexe : "Mâle" et "Femelle"
     * - pour le paramètre Présentation : "Vidé", "Entier", ...
     * - pour le paramètre Catégorie : "Gros", "Moyen", ...
     * @param dressingIn QualitativeValue
     */
    public void setDressing(QualitativeValue dressingIn)
    {
        this.dressing = dressingIn;
    }

    private QualitativeValue preservation;

    /**
     * Liste des valeurs qualitatives que peut prendre un paramètre.
     * Par exemple :
     * - pour le paramètre Sexe : "Mâle" et "Femelle"
     * - pour le paramètre Présentation : "Vidé", "Entier", ...
     * - pour le paramètre Catégorie : "Gros", "Moyen", ...
     * @return this.preservation QualitativeValue
     */
    public QualitativeValue getPreservation()
    {
        return this.preservation;
    }

    /**
     * Liste des valeurs qualitatives que peut prendre un paramètre.
     * Par exemple :
     * - pour le paramètre Sexe : "Mâle" et "Femelle"
     * - pour le paramètre Présentation : "Vidé", "Entier", ...
     * - pour le paramètre Catégorie : "Gros", "Moyen", ...
     * @param preservationIn QualitativeValue
     */
    public void setPreservation(QualitativeValue preservationIn)
    {
        this.preservation = preservationIn;
    }

    private QualitativeValue transaction;

    /**
     * Liste des valeurs qualitatives que peut prendre un paramètre.
     * Par exemple :
     * - pour le paramètre Sexe : "Mâle" et "Femelle"
     * - pour le paramètre Présentation : "Vidé", "Entier", ...
     * - pour le paramètre Catégorie : "Gros", "Moyen", ...
     * @return this.transaction QualitativeValue
     */
    public QualitativeValue getTransaction()
    {
        return this.transaction;
    }

    /**
     * Liste des valeurs qualitatives que peut prendre un paramètre.
     * Par exemple :
     * - pour le paramètre Sexe : "Mâle" et "Femelle"
     * - pour le paramètre Présentation : "Vidé", "Entier", ...
     * - pour le paramètre Catégorie : "Gros", "Moyen", ...
     * @param transactionIn QualitativeValue
     */
    public void setTransaction(QualitativeValue transactionIn)
    {
        this.transaction = transactionIn;
    }

    private QualitativeValue freshnessCategory;

    /**
     * Liste des valeurs qualitatives que peut prendre un paramètre.
     * Par exemple :
     * - pour le paramètre Sexe : "Mâle" et "Femelle"
     * - pour le paramètre Présentation : "Vidé", "Entier", ...
     * - pour le paramètre Catégorie : "Gros", "Moyen", ...
     * @return this.freshnessCategory QualitativeValue
     */
    public QualitativeValue getFreshnessCategory()
    {
        return this.freshnessCategory;
    }

    /**
     * Liste des valeurs qualitatives que peut prendre un paramètre.
     * Par exemple :
     * - pour le paramètre Sexe : "Mâle" et "Femelle"
     * - pour le paramètre Présentation : "Vidé", "Entier", ...
     * - pour le paramètre Catégorie : "Gros", "Moyen", ...
     * @param freshnessCategoryIn QualitativeValue
     */
    public void setFreshnessCategory(QualitativeValue freshnessCategoryIn)
    {
        this.freshnessCategory = freshnessCategoryIn;
    }

    private QualitativeValue sizeCategory;

    /**
     * Liste des valeurs qualitatives que peut prendre un paramètre.
     * Par exemple :
     * - pour le paramètre Sexe : "Mâle" et "Femelle"
     * - pour le paramètre Présentation : "Vidé", "Entier", ...
     * - pour le paramètre Catégorie : "Gros", "Moyen", ...
     * @return this.sizeCategory QualitativeValue
     */
    public QualitativeValue getSizeCategory()
    {
        return this.sizeCategory;
    }

    /**
     * Liste des valeurs qualitatives que peut prendre un paramètre.
     * Par exemple :
     * - pour le paramètre Sexe : "Mâle" et "Femelle"
     * - pour le paramètre Présentation : "Vidé", "Entier", ...
     * - pour le paramètre Catégorie : "Gros", "Moyen", ...
     * @param sizeCategoryIn QualitativeValue
     */
    public void setSizeCategory(QualitativeValue sizeCategoryIn)
    {
        this.sizeCategory = sizeCategoryIn;
    }

    private Method weightMethod;

    /**
     * Les méthodes sont rassemblées dans une liste qui couvre tous les domaines pour lesquels il
     * existe un
     * paramètre.
     * La liste des méthodes est générique et porte sur toutes les phases du processus de mesure des
     * paramètres. Chaque méthode n'est pas non plus systématiquement spécifique à l'une de ces
     * phases ou à
     * une nature particulière de paramètre. En effet, une méthode peut couvrir tout le cycle du
     * processus
     * et/ou être utilisable pour une phase quelle que soit la nature du paramètre.
     * Les méthodes peuvent être référencées par les paramètres à différentes phases de leur
     * processus de
     * mesure que sont :
     * pour les paramètres biologique :
     * - le prélèvement et l'échantillonnage ;
     * - la conservation et le transport ;
     * - le fractionnement ;
     * - l'analyse ;
     * pour les paramètres environnementaux :
     * - l'observation ;
     * @return this.weightMethod Method
     */
    public Method getWeightMethod()
    {
        return this.weightMethod;
    }

    /**
     * Les méthodes sont rassemblées dans une liste qui couvre tous les domaines pour lesquels il
     * existe un
     * paramètre.
     * La liste des méthodes est générique et porte sur toutes les phases du processus de mesure des
     * paramètres. Chaque méthode n'est pas non plus systématiquement spécifique à l'une de ces
     * phases ou à
     * une nature particulière de paramètre. En effet, une méthode peut couvrir tout le cycle du
     * processus
     * et/ou être utilisable pour une phase quelle que soit la nature du paramètre.
     * Les méthodes peuvent être référencées par les paramètres à différentes phases de leur
     * processus de
     * mesure que sont :
     * pour les paramètres biologique :
     * - le prélèvement et l'échantillonnage ;
     * - la conservation et le transport ;
     * - le fractionnement ;
     * - l'analyse ;
     * pour les paramètres environnementaux :
     * - l'observation ;
     * @param weightMethodIn Method
     */
    public void setWeightMethod(Method weightMethodIn)
    {
        this.weightMethod = weightMethodIn;
    }

    private FishingOperation fishingOperation;

    /**
     * Opération de peche durant laquelle un prélèvement peut etre effectué, au cours d'une sortie
     * en mer
     * (marée observée en mer, marée enquetée au débarquement, sortie lors d'une campagne à la mer,
     * etc.).
     * Il peut également s'agir d'une séquence de peche, lorsque les dates début/fin ne sont pas
     * connus, et
     * si la zone de peche est unique.
     * Les dates/heures et lat/long de début/fin caractérisent le début/fin de la capture réalisée
     * (hors
     * temps d'établissement de l'engin).
     * REMARQUE : les caractéristiques "indicateur jour/nuit" et "Trajectoire rectiligne ou non"
     * sont
     * présent à ce niveau dans Harmonie, mais gérés dans Allegro via les "cracatéristique
     * d'utilisation du
     * navire" (VesselUseFeatures) rattachée à l'opération parente.
     * @return this.fishingOperation FishingOperation
     */
    public FishingOperation getFishingOperation()
    {
        return this.fishingOperation;
    }

    /**
     * Opération de peche durant laquelle un prélèvement peut etre effectué, au cours d'une sortie
     * en mer
     * (marée observée en mer, marée enquetée au débarquement, sortie lors d'une campagne à la mer,
     * etc.).
     * Il peut également s'agir d'une séquence de peche, lorsque les dates début/fin ne sont pas
     * connus, et
     * si la zone de peche est unique.
     * Les dates/heures et lat/long de début/fin caractérisent le début/fin de la capture réalisée
     * (hors
     * temps d'établissement de l'engin).
     * REMARQUE : les caractéristiques "indicateur jour/nuit" et "Trajectoire rectiligne ou non"
     * sont
     * présent à ce niveau dans Harmonie, mais gérés dans Allegro via les "cracatéristique
     * d'utilisation du
     * navire" (VesselUseFeatures) rattachée à l'opération parente.
     * @param fishingOperationIn FishingOperation
     */
    public void setFishingOperation(FishingOperation fishingOperationIn)
    {
        this.fishingOperation = fishingOperationIn;
    }

    private ExpectedSale expectedSale;

    /**
     * Mode de vente escompté (d’une marée observée ou d'un débarquement observé).
     * @return this.expectedSale ExpectedSale
     */
    public ExpectedSale getExpectedSale()
    {
        return this.expectedSale;
    }

    /**
     * Mode de vente escompté (d’une marée observée ou d'un débarquement observé).
     * @param expectedSaleIn ExpectedSale
     */
    public void setExpectedSale(ExpectedSale expectedSaleIn)
    {
        this.expectedSale = expectedSaleIn;
    }

    private Batch batch;

    /**
     * Lot d'origine du produit (Optionel)
     * @return this.batch Batch
     */
    public Batch getBatch()
    {
        return this.batch;
    }

    /**
     * Lot d'origine du produit (Optionel)
     * @param batchIn Batch
     */
    public void setBatch(Batch batchIn)
    {
        this.batch = batchIn;
    }

    private Buyer buyer;

    /**
     * 
     * @return this.buyer Buyer
     */
    public Buyer getBuyer()
    {
        return this.buyer;
    }

    /**
     * 
     * @param buyerIn Buyer
     */
    public void setBuyer(Buyer buyerIn)
    {
        this.buyer = buyerIn;
    }

    private Sale sale;

    /**
     * Vente liée à un navire, effectuée en un lieu et une date données. Une vente regroupe
     * plusieurs
     * produits vendus (Produce).
     * Attention : une vente est ponctuelle dans le temps. Si l'on souhaite recencer une vente qui
     * s'étale
     * sur plusieurs jours,
     * @return this.sale Sale
     */
    public Sale getSale()
    {
        return this.sale;
    }

    /**
     * Vente liée à un navire, effectuée en un lieu et une date données. Une vente regroupe
     * plusieurs
     * produits vendus (Produce).
     * Attention : une vente est ponctuelle dans le temps. Si l'on souhaite recencer une vente qui
     * s'étale
     * sur plusieurs jours,
     * @param saleIn Sale
     */
    public void setSale(Sale saleIn)
    {
        this.sale = saleIn;
    }

    private Gear gear;

    /**
     * Engin de peche principal (groupe d'engin) ayant servi à prélever le produit en mer.
     * @return this.gear Gear
     */
    public Gear getGear()
    {
        return this.gear;
    }

    /**
     * Engin de peche principal (groupe d'engin) ayant servi à prélever le produit en mer.
     * @param gearIn Gear
     */
    public void setGear(Gear gearIn)
    {
        this.gear = gearIn;
    }

    private Landing landing;

    /**
     * Information sur le débarquement du produit.
     * @return this.landing Landing
     */
    public Landing getLanding()
    {
        return this.landing;
    }

    /**
     * Information sur le débarquement du produit.
     * @param landingIn Landing
     */
    public void setLanding(Landing landingIn)
    {
        this.landing = landingIn;
    }

    private TakeOver takeOver;

    /**
     * Prise en charge, d'une marée ou d'un débarquement, par un organisme (Seller) chargé de mettre
     * en
     * vente les produits débarqués.
     * @return this.takeOver TakeOver
     */
    public TakeOver getTakeOver()
    {
        return this.takeOver;
    }

    /**
     * Prise en charge, d'une marée ou d'un débarquement, par un organisme (Seller) chargé de mettre
     * en
     * vente les produits débarqués.
     * @param takeOverIn TakeOver
     */
    public void setTakeOver(TakeOver takeOverIn)
    {
        this.takeOver = takeOverIn;
    }

    private QualityFlag qualityFlag;

    /**
     * Niveau de qualité de la donnée.
     * "Non qualifiée" par défaut
     * @return this.qualityFlag QualityFlag
     */
    public QualityFlag getQualityFlag()
    {
        return this.qualityFlag;
    }

    /**
     * Niveau de qualité de la donnée.
     * "Non qualifiée" par défaut
     * @param qualityFlagIn QualityFlag
     */
    public void setQualityFlag(QualityFlag qualityFlagIn)
    {
        this.qualityFlag = qualityFlagIn;
    }

    private Collection<FishingArea> fishingAreas = new HashSet<FishingArea>();

    /**
     * Lieu d'origine du produit (en mer).
     * Au minimum la zone FAO, ou plus précis (sous-zone FAO, etc.).
     * @return this.fishingAreas Collection<FishingArea>
     */
    public Collection<FishingArea> getFishingAreas()
    {
        return this.fishingAreas;
    }

    /**
     * Lieu d'origine du produit (en mer).
     * Au minimum la zone FAO, ou plus précis (sous-zone FAO, etc.).
     * @param fishingAreasIn Collection<FishingArea>
     */
    public void setFishingAreas(Collection<FishingArea> fishingAreasIn)
    {
        this.fishingAreas = fishingAreasIn;
    }

    /**
     * Lieu d'origine du produit (en mer).
     * Au minimum la zone FAO, ou plus précis (sous-zone FAO, etc.).
     * @param elementToAdd FishingArea
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean addFishingAreas(FishingArea elementToAdd)
    {
        return this.fishingAreas.add(elementToAdd);
    }

    /**
     * Lieu d'origine du produit (en mer).
     * Au minimum la zone FAO, ou plus précis (sous-zone FAO, etc.).
     * @param elementToRemove FishingArea
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean removeFishingAreas(FishingArea elementToRemove)
    {
        return this.fishingAreas.remove(elementToRemove);
    }

    private Transshipment transshipment;

    /**
     * Transbordement d'un produit (capturé) d'un navire à l'autre.
     * Pour connaitre le navire d'origine des produits (celui qui les possédait avant le
     * transbordement),
     * il faut utiliser les liens vers FishingTrip ou MetaFishingTrip, qui possèdent un lien vers
     * Vessel.
     * @return this.transshipment Transshipment
     */
    public Transshipment getTransshipment()
    {
        return this.transshipment;
    }

    /**
     * Transbordement d'un produit (capturé) d'un navire à l'autre.
     * Pour connaitre le navire d'origine des produits (celui qui les possédait avant le
     * transbordement),
     * il faut utiliser les liens vers FishingTrip ou MetaFishingTrip, qui possèdent un lien vers
     * Vessel.
     * @param transshipmentIn Transshipment
     */
    public void setTransshipment(Transshipment transshipmentIn)
    {
        this.transshipment = transshipmentIn;
    }

    private Collection<ProduceQuantificationMeasurement> produceQuantificationMeasurements = new HashSet<ProduceQuantificationMeasurement>();

    /**
     * Mesures de quantification du produit (poids)
     * @return this.produceQuantificationMeasurements Collection<ProduceQuantificationMeasurement>
     */
    public Collection<ProduceQuantificationMeasurement> getProduceQuantificationMeasurements()
    {
        return this.produceQuantificationMeasurements;
    }

    /**
     * Mesures de quantification du produit (poids)
     * @param produceQuantificationMeasurementsIn Collection<ProduceQuantificationMeasurement>
     */
    public void setProduceQuantificationMeasurements(Collection<ProduceQuantificationMeasurement> produceQuantificationMeasurementsIn)
    {
        this.produceQuantificationMeasurements = produceQuantificationMeasurementsIn;
    }

    /**
     * Mesures de quantification du produit (poids)
     * @param elementToAdd ProduceQuantificationMeasurement
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean addProduceQuantificationMeasurements(ProduceQuantificationMeasurement elementToAdd)
    {
        return this.produceQuantificationMeasurements.add(elementToAdd);
    }

    /**
     * Mesures de quantification du produit (poids)
     * @param elementToRemove ProduceQuantificationMeasurement
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean removeProduceQuantificationMeasurements(ProduceQuantificationMeasurement elementToRemove)
    {
        return this.produceQuantificationMeasurements.remove(elementToRemove);
    }

    private Collection<ProduceSortingMeasurement> produceSortingMeasurements = new HashSet<ProduceSortingMeasurement>();

    /**
     * Contient au moins les critère de classement suivants :
     * - Présentation du produit (preserving)
     * - Qualité du produit (quality)
     * - Catégorie du produit (calibration)
     * - Etat du produit (dressing)
     * - Type de valorisation du produit de vente (optionnel) (valorization)
     * - Prix,
     * - etc.
     * @return this.produceSortingMeasurements Collection<ProduceSortingMeasurement>
     */
    public Collection<ProduceSortingMeasurement> getProduceSortingMeasurements()
    {
        return this.produceSortingMeasurements;
    }

    /**
     * Contient au moins les critère de classement suivants :
     * - Présentation du produit (preserving)
     * - Qualité du produit (quality)
     * - Catégorie du produit (calibration)
     * - Etat du produit (dressing)
     * - Type de valorisation du produit de vente (optionnel) (valorization)
     * - Prix,
     * - etc.
     * @param produceSortingMeasurementsIn Collection<ProduceSortingMeasurement>
     */
    public void setProduceSortingMeasurements(Collection<ProduceSortingMeasurement> produceSortingMeasurementsIn)
    {
        this.produceSortingMeasurements = produceSortingMeasurementsIn;
    }

    /**
     * Contient au moins les critère de classement suivants :
     * - Présentation du produit (preserving)
     * - Qualité du produit (quality)
     * - Catégorie du produit (calibration)
     * - Etat du produit (dressing)
     * - Type de valorisation du produit de vente (optionnel) (valorization)
     * - Prix,
     * - etc.
     * @param elementToAdd ProduceSortingMeasurement
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean addProduceSortingMeasurements(ProduceSortingMeasurement elementToAdd)
    {
        return this.produceSortingMeasurements.add(elementToAdd);
    }

    /**
     * Contient au moins les critère de classement suivants :
     * - Présentation du produit (preserving)
     * - Qualité du produit (quality)
     * - Catégorie du produit (calibration)
     * - Etat du produit (dressing)
     * - Type de valorisation du produit de vente (optionnel) (valorization)
     * - Prix,
     * - etc.
     * @param elementToRemove ProduceSortingMeasurement
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean removeProduceSortingMeasurements(ProduceSortingMeasurement elementToRemove)
    {
        return this.produceSortingMeasurements.remove(elementToRemove);
    }

    /**
     * Returns <code>true</code> if the argument is an Produce instance and all identifiers for this entity
     * equal the identifiers of the argument entity. Returns <code>false</code> otherwise.
     */
    @Override
    public boolean equals(Object object)
    {
        if (this == object)
        {
            return true;
        }
        if (!(object instanceof Produce))
        {
            return false;
        }
        final Produce that = (Produce)object;
        if (this.id == null || that.getId() == null || !this.id.equals(that.getId()))
        {
            return false;
        }
        return true;
    }

    /**
     * Returns a hash code based on this entity's identifiers.
     */
    @Override
    public int hashCode()
    {
        int hashCode = 0;
        hashCode = 29 * hashCode + (this.id == null ? 0 : this.id.hashCode());

        return hashCode;
    }

    /**
     * Constructs new instances of {@link Produce}.
     */
    public static final class Factory
    {
        /**
         * Constructs a new instance of {@link Produce}.
         * @return new ProduceImpl()
         */
        public static Produce newInstance()
        {
            return new ProduceImpl();
        }

        /**
         * Constructs a new instance of {@link Produce}, taking all required and/or
         * read-only properties as arguments, except for identifiers.
         * @param isDiscard Boolean
         * @param taxonGroup TaxonGroup
         * @param qualityFlag QualityFlag
         * @param produceQuantificationMeasurements Collection<ProduceQuantificationMeasurement>
         * @return newInstance
         */
        public static Produce newInstance(Boolean isDiscard, TaxonGroup taxonGroup, QualityFlag qualityFlag, Collection<ProduceQuantificationMeasurement> produceQuantificationMeasurements)
        {
            final Produce entity = new ProduceImpl();
            entity.setIsDiscard(isDiscard);
            entity.setTaxonGroup(taxonGroup);
            entity.setQualityFlag(qualityFlag);
            entity.setProduceQuantificationMeasurements(produceQuantificationMeasurements);
            return entity;
        }

        /**
         * Constructs a new instance of {@link Produce}, taking all possible properties
         * (except the identifier(s))as arguments.
         * @param isDiscard Boolean
         * @param subgroupCount Float
         * @param individualCount Short
         * @param taxonGroupOtherInformation String
         * @param controlDate Date
         * @param validationDate Date
         * @param qualificationDate Date
         * @param qualificationComments String
         * @param weight Float
         * @param cost Float
         * @param remoteId Integer
         * @param otherTaxonGroup TaxonGroup
         * @param taxonGroup TaxonGroup
         * @param saleType SaleType
         * @param otherGear Gear
         * @param dressing QualitativeValue
         * @param preservation QualitativeValue
         * @param transaction QualitativeValue
         * @param freshnessCategory QualitativeValue
         * @param sizeCategory QualitativeValue
         * @param weightMethod Method
         * @param fishingOperation FishingOperation
         * @param expectedSale ExpectedSale
         * @param batch Batch
         * @param buyer Buyer
         * @param sale Sale
         * @param gear Gear
         * @param landing Landing
         * @param takeOver TakeOver
         * @param qualityFlag QualityFlag
         * @param fishingAreas Collection<FishingArea>
         * @param transshipment Transshipment
         * @param produceQuantificationMeasurements Collection<ProduceQuantificationMeasurement>
         * @param produceSortingMeasurements Collection<ProduceSortingMeasurement>
         * @return newInstance Produce
         */
        public static Produce newInstance(Boolean isDiscard, Float subgroupCount, Short individualCount, String taxonGroupOtherInformation, Date controlDate, Date validationDate, Date qualificationDate, String qualificationComments, Float weight, Float cost, Integer remoteId, TaxonGroup otherTaxonGroup, TaxonGroup taxonGroup, SaleType saleType, Gear otherGear, QualitativeValue dressing, QualitativeValue preservation, QualitativeValue transaction, QualitativeValue freshnessCategory, QualitativeValue sizeCategory, Method weightMethod, FishingOperation fishingOperation, ExpectedSale expectedSale, Batch batch, Buyer buyer, Sale sale, Gear gear, Landing landing, TakeOver takeOver, QualityFlag qualityFlag, Collection<FishingArea> fishingAreas, Transshipment transshipment, Collection<ProduceQuantificationMeasurement> produceQuantificationMeasurements, Collection<ProduceSortingMeasurement> produceSortingMeasurements)
        {
            final Produce entity = new ProduceImpl();
            entity.setIsDiscard(isDiscard);
            entity.setSubgroupCount(subgroupCount);
            entity.setIndividualCount(individualCount);
            entity.setTaxonGroupOtherInformation(taxonGroupOtherInformation);
            entity.setControlDate(controlDate);
            entity.setValidationDate(validationDate);
            entity.setQualificationDate(qualificationDate);
            entity.setQualificationComments(qualificationComments);
            entity.setWeight(weight);
            entity.setCost(cost);
            entity.setRemoteId(remoteId);
            entity.setOtherTaxonGroup(otherTaxonGroup);
            entity.setTaxonGroup(taxonGroup);
            entity.setSaleType(saleType);
            entity.setOtherGear(otherGear);
            entity.setDressing(dressing);
            entity.setPreservation(preservation);
            entity.setTransaction(transaction);
            entity.setFreshnessCategory(freshnessCategory);
            entity.setSizeCategory(sizeCategory);
            entity.setWeightMethod(weightMethod);
            entity.setFishingOperation(fishingOperation);
            entity.setExpectedSale(expectedSale);
            entity.setBatch(batch);
            entity.setBuyer(buyer);
            entity.setSale(sale);
            entity.setGear(gear);
            entity.setLanding(landing);
            entity.setTakeOver(takeOver);
            entity.setQualityFlag(qualityFlag);
            entity.setFishingAreas(fishingAreas);
            entity.setTransshipment(transshipment);
            entity.setProduceQuantificationMeasurements(produceQuantificationMeasurements);
            entity.setProduceSortingMeasurements(produceSortingMeasurements);
            return entity;
        }
    }

    /**
     * @see Comparable#compareTo
     */
    public int compareTo(Produce o)
    {
        int cmp = 0;
        if (this.getId() != null)
        {
            cmp = this.getId().compareTo(o.getId());
        }
        else
        {
            if (this.isIsDiscard() != null)
            {
                cmp = (cmp != 0 ? cmp : this.isIsDiscard().compareTo(o.isIsDiscard()));
            }
            if (this.getSubgroupCount() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getSubgroupCount().compareTo(o.getSubgroupCount()));
            }
            if (this.getIndividualCount() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getIndividualCount().compareTo(o.getIndividualCount()));
            }
            if (this.getTaxonGroupOtherInformation() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getTaxonGroupOtherInformation().compareTo(o.getTaxonGroupOtherInformation()));
            }
            if (this.getControlDate() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getControlDate().compareTo(o.getControlDate()));
            }
            if (this.getValidationDate() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getValidationDate().compareTo(o.getValidationDate()));
            }
            if (this.getQualificationDate() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getQualificationDate().compareTo(o.getQualificationDate()));
            }
            if (this.getQualificationComments() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getQualificationComments().compareTo(o.getQualificationComments()));
            }
            if (this.getWeight() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getWeight().compareTo(o.getWeight()));
            }
            if (this.getCost() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getCost().compareTo(o.getCost()));
            }
            if (this.getRemoteId() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getRemoteId().compareTo(o.getRemoteId()));
            }
        }
        return cmp;
    }
// HibernateEntity.vsl merge-point
// Produce.java merge-point
}