package fr.ifremer.tutti.ui.swing.content.operation.catches.species;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2014 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.ui.swing.TuttiHelpBroker;
import fr.ifremer.tutti.ui.swing.content.operation.catches.SpeciesSortMode;
import fr.ifremer.tutti.ui.swing.content.operation.catches.TableViewMode;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import fr.ifremer.tutti.ui.swing.util.computable.ComputableDataEditor;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.border.TitledBorder;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.JAXXButtonGroup;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.help.JAXXHelpUI;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import jaxx.runtime.validator.swing.ui.ImageValidationUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import static org.nuiton.i18n.I18n.t;

public class SpeciesBatchUI extends JPanel implements JAXXHelpUI<TuttiHelpBroker>, TuttiUI<SpeciesBatchUIModel, SpeciesBatchUIHandler>, JAXXObject, JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_ADD_SAMPLE_CATEGORY_MENU_ENABLED = "addSampleCategoryMenu.enabled";
    public static final String BINDING_CHANGE_SAMPLE_CATEGORY_MENU_ENABLED = "changeSampleCategoryMenu.enabled";
    public static final String BINDING_CREATE_SPECIES_MELAG_MENU_ENABLED = "createSpeciesMelagMenu.enabled";
    public static final String BINDING_EDIT_FREQUENCIES_MENU_ENABLED = "editFrequenciesMenu.enabled";
    public static final String BINDING_FILTER_SPECIES_BATCH_ALL_BUTTON_SELECTED = "filterSpeciesBatchAllButton.selected";
    public static final String BINDING_FILTER_SPECIES_BATCH_LEAF_BUTTON_SELECTED = "filterSpeciesBatchLeafButton.selected";
    public static final String BINDING_FILTER_SPECIES_BATCH_ROOT_BUTTON_SELECTED = "filterSpeciesBatchRootButton.selected";
    public static final String BINDING_FILTER_SPECIES_BATCH_ROOT_BUTTON_TEXT = "filterSpeciesBatchRootButton.text";
    public static final String BINDING_REMOVE_SPECIES_BATCH_MENU_ENABLED = "removeSpeciesBatchMenu.enabled";
    public static final String BINDING_REMOVE_SPECIES_SUB_BATCH_MENU_ENABLED = "removeSpeciesSubBatchMenu.enabled";
    public static final String BINDING_RENAME_SPECIES_BATCH_MENU_ENABLED = "renameSpeciesBatchMenu.enabled";
    public static final String BINDING_SPECIES_SORT_MODE_ASC_BUTTON_SELECTED = "speciesSortModeAscButton.selected";
    public static final String BINDING_SPECIES_SORT_MODE_DESC_BUTTON_SELECTED = "speciesSortModeDescButton.selected";
    public static final String BINDING_SPECIES_SORT_MODE_NONE_BUTTON_SELECTED = "speciesSortModeNoneButton.selected";
    public static final String BINDING_SPECIES_TOTAL_INERT_WEIGHT_FIELD_BEAN = "speciesTotalInertWeightField.bean";
    public static final String BINDING_SPECIES_TOTAL_INERT_WEIGHT_FIELD_MODEL = "speciesTotalInertWeightField.model";
    public static final String BINDING_SPECIES_TOTAL_LIVING_NOT_ITEMIZED_WEIGHT_FIELD_BEAN = "speciesTotalLivingNotItemizedWeightField.bean";
    public static final String BINDING_SPECIES_TOTAL_LIVING_NOT_ITEMIZED_WEIGHT_FIELD_MODEL = "speciesTotalLivingNotItemizedWeightField.model";
    public static final String BINDING_SPECIES_TOTAL_SAMPLE_SORTED_WEIGHT_FIELD_TEXT = "speciesTotalSampleSortedWeightField.text";
    public static final String BINDING_SPECIES_TOTAL_SORTED_WEIGHT_FIELD_BEAN = "speciesTotalSortedWeightField.bean";
    public static final String BINDING_SPECIES_TOTAL_SORTED_WEIGHT_FIELD_MODEL = "speciesTotalSortedWeightField.model";
    public static final String BINDING_SPECIES_TOTAL_UNSORTED_WEIGHT_FIELD_TEXT = "speciesTotalUnsortedWeightField.text";
    public static final String BINDING_SPECIES_TOTAL_WEIGHT_FIELD_TEXT = "speciesTotalWeightField.text";
    public static final String BINDING_SPLIT_SPECIES_BATCH_MENU_ENABLED = "splitSpeciesBatchMenu.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(SpeciesBatchUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JMenuItem addSampleCategoryMenu;
    protected TuttiHelpBroker broker;
    protected JMenuItem changeSampleCategoryMenu;
    protected JButton createSpeciesBatchButton;
    protected JMenuItem createSpeciesMelagMenu;
    protected JMenuItem editFrequenciesMenu;
    protected SpeciesBatchUI editSpeciesBatchTopPanel = this;
    protected JButton exportMultiPostButton;
    protected JRadioButton filterSpeciesBatchAllButton;
    protected JLabel filterSpeciesBatchLabel;
    protected JRadioButton filterSpeciesBatchLeafButton;
    protected JAXXButtonGroup filterSpeciesBatchMode;
    protected JRadioButton filterSpeciesBatchRootButton;
    protected JPanel filterTablePane;
    protected Table form;
    protected final SpeciesBatchUIHandler handler = new SpeciesBatchUIHandler();
    protected JButton importBigfinButton;
    protected JButton importMultiPostButton;
    protected JButton importPsionButton;
    protected JButton importPupitriButton;
    protected SpeciesBatchUIModel model;
    protected JMenuItem removeSpeciesBatchMenu;
    protected JMenuItem removeSpeciesSubBatchMenu;
    protected JMenuItem renameSpeciesBatchMenu;
    protected JToolBar speciesBatchTabToolBar;
    protected JAXXButtonGroup speciesSort;
    protected JLabel speciesSortBatchLabel;
    protected JRadioButton speciesSortModeAscButton;
    protected JRadioButton speciesSortModeDescButton;
    protected JRadioButton speciesSortModeNoneButton;
    protected JPanel speciesSortTablePane;
    protected ComputableDataEditor<Float> speciesTotalInertWeightField;
    protected JLabel speciesTotalInertWeightLabel;
    protected ComputableDataEditor<Float> speciesTotalLivingNotItemizedWeightField;
    protected JLabel speciesTotalLivingNotItemizedWeightLabel;
    protected JTextField speciesTotalSampleSortedWeightField;
    protected JLabel speciesTotalSampleSortedWeightLabel;
    @ValidatorField( validatorId = "validator",  propertyName = "speciesTotalSortedWeight",  editorName = "speciesTotalSortedWeightField")
    protected ComputableDataEditor<Float> speciesTotalSortedWeightField;
    protected JLabel speciesTotalSortedWeightLabel;
    protected JTextField speciesTotalUnsortedWeightField;
    protected JLabel speciesTotalUnsortedWeightLabel;
    protected JTextField speciesTotalWeightField;
    protected JLabel speciesTotalWeightLabel;
    protected JMenuItem splitSpeciesBatchMenu;
    protected JXTable table;
    protected JPopupMenu tablePopup;
    protected JScrollPane tableScrollPane;
    protected JPanel tableToolbar;
    @Validator( validatorId = "validator")
    protected SwingValidator<SpeciesBatchUIModel> validator;
    protected List<String> validatorIds = new ArrayList<String>();

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JPanel $JPanel0;
    private JPanel $JPanel1;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public SpeciesBatchUI(TuttiUI parentUI) {
        TuttiUIUtil.setParentUI(this, parentUI);
            $initialize();
    }

    public SpeciesBatchUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public SpeciesBatchUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SpeciesBatchUI() {
        $initialize();
    }

    public SpeciesBatchUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SpeciesBatchUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public SpeciesBatchUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SpeciesBatchUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public SpeciesBatchUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__addSampleCategoryMenu(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.addBatchCategory();
    }

    public void doActionPerformed__on__changeSampleCategoryMenu(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.changeBatchCategory();
    }

    public void doActionPerformed__on__createSpeciesBatchButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.createBatch();
    }

    public void doActionPerformed__on__editFrequenciesMenu(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.editFrequencies();
    }

    public void doActionPerformed__on__filterSpeciesBatchAllButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setTableViewMode(TableViewMode.ALL);
    }

    public void doActionPerformed__on__filterSpeciesBatchLeafButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setTableViewMode(TableViewMode.LEAF);
    }

    public void doActionPerformed__on__filterSpeciesBatchRootButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setTableViewMode(TableViewMode.ROOT);
    }

    public void doActionPerformed__on__speciesSortModeAscButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setSpeciesSortMode(SpeciesSortMode.ASC);
    }

    public void doActionPerformed__on__speciesSortModeDescButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setSpeciesSortMode(SpeciesSortMode.DESC);
    }

    public void doActionPerformed__on__speciesSortModeNoneButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setSpeciesSortMode(SpeciesSortMode.NONE);
    }

    public void doActionPerformed__on__splitSpeciesBatchMenu(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.splitBatch();
    }

    public void doKeyPressed__on__table(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.openRowMenu(event, tablePopup);
    }

    public void doMouseClicked__on__table(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.autoSelectRowInTable(event, tablePopup);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JMenuItem getAddSampleCategoryMenu() {
        return addSampleCategoryMenu;
    }

    public TuttiHelpBroker getBroker() {
        return broker;
    }

    public JMenuItem getChangeSampleCategoryMenu() {
        return changeSampleCategoryMenu;
    }

    public JButton getCreateSpeciesBatchButton() {
        return createSpeciesBatchButton;
    }

    public JMenuItem getCreateSpeciesMelagMenu() {
        return createSpeciesMelagMenu;
    }

    public JMenuItem getEditFrequenciesMenu() {
        return editFrequenciesMenu;
    }

    public JButton getExportMultiPostButton() {
        return exportMultiPostButton;
    }

    public JRadioButton getFilterSpeciesBatchAllButton() {
        return filterSpeciesBatchAllButton;
    }

    public JLabel getFilterSpeciesBatchLabel() {
        return filterSpeciesBatchLabel;
    }

    public JRadioButton getFilterSpeciesBatchLeafButton() {
        return filterSpeciesBatchLeafButton;
    }

    public JAXXButtonGroup getFilterSpeciesBatchMode() {
        return filterSpeciesBatchMode;
    }

    public JRadioButton getFilterSpeciesBatchRootButton() {
        return filterSpeciesBatchRootButton;
    }

    public JPanel getFilterTablePane() {
        return filterTablePane;
    }

    public Table getForm() {
        return form;
    }

    public SpeciesBatchUIHandler getHandler() {
        return handler;
    }

    public JButton getImportBigfinButton() {
        return importBigfinButton;
    }

    public JButton getImportMultiPostButton() {
        return importMultiPostButton;
    }

    public JButton getImportPsionButton() {
        return importPsionButton;
    }

    public JButton getImportPupitriButton() {
        return importPupitriButton;
    }

    public SpeciesBatchUIModel getModel() {
        return model;
    }

    public JMenuItem getRemoveSpeciesBatchMenu() {
        return removeSpeciesBatchMenu;
    }

    public JMenuItem getRemoveSpeciesSubBatchMenu() {
        return removeSpeciesSubBatchMenu;
    }

    public JMenuItem getRenameSpeciesBatchMenu() {
        return renameSpeciesBatchMenu;
    }

    public JToolBar getSpeciesBatchTabToolBar() {
        return speciesBatchTabToolBar;
    }

    public JAXXButtonGroup getSpeciesSort() {
        return speciesSort;
    }

    public JLabel getSpeciesSortBatchLabel() {
        return speciesSortBatchLabel;
    }

    public JRadioButton getSpeciesSortModeAscButton() {
        return speciesSortModeAscButton;
    }

    public JRadioButton getSpeciesSortModeDescButton() {
        return speciesSortModeDescButton;
    }

    public JRadioButton getSpeciesSortModeNoneButton() {
        return speciesSortModeNoneButton;
    }

    public JPanel getSpeciesSortTablePane() {
        return speciesSortTablePane;
    }

    public ComputableDataEditor<Float> getSpeciesTotalInertWeightField() {
        return speciesTotalInertWeightField;
    }

    public JLabel getSpeciesTotalInertWeightLabel() {
        return speciesTotalInertWeightLabel;
    }

    public ComputableDataEditor<Float> getSpeciesTotalLivingNotItemizedWeightField() {
        return speciesTotalLivingNotItemizedWeightField;
    }

    public JLabel getSpeciesTotalLivingNotItemizedWeightLabel() {
        return speciesTotalLivingNotItemizedWeightLabel;
    }

    public JTextField getSpeciesTotalSampleSortedWeightField() {
        return speciesTotalSampleSortedWeightField;
    }

    public JLabel getSpeciesTotalSampleSortedWeightLabel() {
        return speciesTotalSampleSortedWeightLabel;
    }

    public ComputableDataEditor<Float> getSpeciesTotalSortedWeightField() {
        return speciesTotalSortedWeightField;
    }

    public JLabel getSpeciesTotalSortedWeightLabel() {
        return speciesTotalSortedWeightLabel;
    }

    public JTextField getSpeciesTotalUnsortedWeightField() {
        return speciesTotalUnsortedWeightField;
    }

    public JLabel getSpeciesTotalUnsortedWeightLabel() {
        return speciesTotalUnsortedWeightLabel;
    }

    public JTextField getSpeciesTotalWeightField() {
        return speciesTotalWeightField;
    }

    public JLabel getSpeciesTotalWeightLabel() {
        return speciesTotalWeightLabel;
    }

    public JMenuItem getSplitSpeciesBatchMenu() {
        return splitSpeciesBatchMenu;
    }

    public JXTable getTable() {
        return table;
    }

    public JPopupMenu getTablePopup() {
        return tablePopup;
    }

    public JScrollPane getTableScrollPane() {
        return tableScrollPane;
    }

    public JPanel getTableToolbar() {
        return tableToolbar;
    }

    public SwingValidator<SpeciesBatchUIModel> getValidator() {
        return validator;
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Other methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void registerHelpId(TuttiHelpBroker broker, Component component, String helpId) {
        broker.installUI(component, helpId);
    }

    @Override
    public void showHelp(String helpId) {
        getBroker().showHelp(this, helpId);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected JPanel get$JPanel1() {
        return $JPanel1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToEditSpeciesBatchTopPanel() {
        if (!allComponentsCreated) {
            return;
        }
        add(speciesBatchTabToolBar);
        add(form, BorderLayout.NORTH);
        add(tableScrollPane, BorderLayout.CENTER);
    }

    protected void addChildrenToFilterSpeciesBatchAllButton() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = filterSpeciesBatchMode; filterSpeciesBatchAllButton.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(filterSpeciesBatchAllButton); }
    }

    protected void addChildrenToFilterSpeciesBatchLeafButton() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = filterSpeciesBatchMode; filterSpeciesBatchLeafButton.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(filterSpeciesBatchLeafButton); }
    }

    protected void addChildrenToFilterSpeciesBatchRootButton() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = filterSpeciesBatchMode; filterSpeciesBatchRootButton.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(filterSpeciesBatchRootButton); }
    }

    protected void addChildrenToFilterTablePane() {
        if (!allComponentsCreated) {
            return;
        }
        filterTablePane.add(filterSpeciesBatchLabel);
        filterTablePane.add(filterSpeciesBatchAllButton);
        filterTablePane.add(filterSpeciesBatchLeafButton);
        filterTablePane.add(filterSpeciesBatchRootButton);
    }

    protected void addChildrenToForm() {
        if (!allComponentsCreated) {
            return;
        }
        form.add(speciesTotalWeightLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(speciesTotalWeightField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(speciesTotalSortedWeightLabel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(SwingUtil.boxComponentWithJxLayer(speciesTotalSortedWeightField), new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(speciesTotalSampleSortedWeightLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(speciesTotalSampleSortedWeightField, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(speciesTotalUnsortedWeightLabel, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(speciesTotalUnsortedWeightField, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(speciesTotalInertWeightLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(speciesTotalInertWeightField, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(speciesTotalLivingNotItemizedWeightLabel, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(speciesTotalLivingNotItemizedWeightField, new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(tableToolbar, new GridBagConstraints(0, 3, 4, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToSpeciesBatchTabToolBar() {
        if (!allComponentsCreated) {
            return;
        }
        speciesBatchTabToolBar.add(importPupitriButton);
        speciesBatchTabToolBar.add(importPsionButton);
        speciesBatchTabToolBar.add(importBigfinButton);
        speciesBatchTabToolBar.add(importMultiPostButton);
        speciesBatchTabToolBar.add(exportMultiPostButton);
    }

    protected void addChildrenToSpeciesSortModeAscButton() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = speciesSort; speciesSortModeAscButton.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(speciesSortModeAscButton); }
    }

    protected void addChildrenToSpeciesSortModeDescButton() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = speciesSort; speciesSortModeDescButton.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(speciesSortModeDescButton); }
    }

    protected void addChildrenToSpeciesSortModeNoneButton() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = speciesSort; speciesSortModeNoneButton.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(speciesSortModeNoneButton); }
    }

    protected void addChildrenToSpeciesSortTablePane() {
        if (!allComponentsCreated) {
            return;
        }
        speciesSortTablePane.add(speciesSortBatchLabel);
        speciesSortTablePane.add(speciesSortModeNoneButton);
        speciesSortTablePane.add(speciesSortModeAscButton);
        speciesSortTablePane.add(speciesSortModeDescButton);
    }

    protected void addChildrenToTablePopup() {
        if (!allComponentsCreated) {
            return;
        }
        tablePopup.add(splitSpeciesBatchMenu);
        tablePopup.add(changeSampleCategoryMenu);
        tablePopup.add(addSampleCategoryMenu);
        tablePopup.add(removeSpeciesBatchMenu);
        tablePopup.add(removeSpeciesSubBatchMenu);
        tablePopup.add(renameSpeciesBatchMenu);
        tablePopup.add(createSpeciesMelagMenu);
        tablePopup.add(editFrequenciesMenu);
    }

    protected void addChildrenToTableScrollPane() {
        if (!allComponentsCreated) {
            return;
        }
        tableScrollPane.getViewport().add(table);
    }

    protected void addChildrenToTableToolbar() {
        if (!allComponentsCreated) {
            return;
        }
        tableToolbar.add($JPanel0, BorderLayout.WEST);
        tableToolbar.add($JPanel1, BorderLayout.CENTER);
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setUiClass(ImageValidationUI.class);
        validator.setBean(model);
    }

    protected void createAddSampleCategoryMenu() {
        $objectMap.put("addSampleCategoryMenu", addSampleCategoryMenu = new JMenuItem());
        
        addSampleCategoryMenu.setName("addSampleCategoryMenu");
        addSampleCategoryMenu.setText(t("tutti.editSpeciesBatch.action.addSampleCategory"));
        addSampleCategoryMenu.setToolTipText(t("tutti.editSpeciesBatch.action.addSampleCategory.tip"));
        addSampleCategoryMenu.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__addSampleCategoryMenu"));
        addSampleCategoryMenu.putClientProperty("help", "tutti.editSpeciesBatch.action.addSampleCategory.help");
    }

    protected void createBroker() {
        $objectMap.put("broker", broker = new TuttiHelpBroker("tutti.editSpeciesBatch.help"));
    }

    protected void createChangeSampleCategoryMenu() {
        $objectMap.put("changeSampleCategoryMenu", changeSampleCategoryMenu = new JMenuItem());
        
        changeSampleCategoryMenu.setName("changeSampleCategoryMenu");
        changeSampleCategoryMenu.setText(t("tutti.editSpeciesBatch.action.changeSampleCategory"));
        changeSampleCategoryMenu.setToolTipText(t("tutti.editSpeciesBatch.action.changeSampleCategory.tip"));
        changeSampleCategoryMenu.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__changeSampleCategoryMenu"));
        changeSampleCategoryMenu.putClientProperty("help", "tutti.editSpeciesBatch.action.changeSampleCategory.help");
    }

    protected void createCreateSpeciesBatchButton() {
        $objectMap.put("createSpeciesBatchButton", createSpeciesBatchButton = new JButton());
        
        createSpeciesBatchButton.setName("createSpeciesBatchButton");
        createSpeciesBatchButton.setText(t("tutti.editSpeciesBatch.action.createBatch"));
        createSpeciesBatchButton.setToolTipText(t("tutti.editSpeciesBatch.action.createBatch.tip"));
        createSpeciesBatchButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__createSpeciesBatchButton"));
        createSpeciesBatchButton.putClientProperty("help", "tutti.editSpeciesBatch.action.createBatch.help");
    }

    protected void createCreateSpeciesMelagMenu() {
        $objectMap.put("createSpeciesMelagMenu", createSpeciesMelagMenu = new JMenuItem());
        
        createSpeciesMelagMenu.setName("createSpeciesMelagMenu");
        createSpeciesMelagMenu.setText(t("tutti.editSpeciesBatch.action.createMelag"));
        createSpeciesMelagMenu.setToolTipText(t("tutti.editSpeciesBatch.action.createMelag.tip"));
        createSpeciesMelagMenu.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.action.CreateSpeciesMelagAction.class);
        createSpeciesMelagMenu.putClientProperty("help", "tutti.editSpeciesBatch.action.createMelag.help");
    }

    protected void createEditFrequenciesMenu() {
        $objectMap.put("editFrequenciesMenu", editFrequenciesMenu = new JMenuItem());
        
        editFrequenciesMenu.setName("editFrequenciesMenu");
        editFrequenciesMenu.setText(t("tutti.editSpeciesBatch.action.editFrequencies"));
        editFrequenciesMenu.setToolTipText(t("tutti.editSpeciesBatch.action.editFrequencies.tip"));
        editFrequenciesMenu.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__editFrequenciesMenu"));
        editFrequenciesMenu.putClientProperty("help", "tutti.editSpeciesBatch.action.editFrequencies.help");
    }

    protected void createExportMultiPostButton() {
        $objectMap.put("exportMultiPostButton", exportMultiPostButton = new JButton());
        
        exportMultiPostButton.setName("exportMultiPostButton");
        exportMultiPostButton.setText(t("tutti.editSpeciesBatch.action.exportMultiPost"));
        exportMultiPostButton.setToolTipText(t("tutti.editSpeciesBatch.action.exportMultiPost.tip"));
        exportMultiPostButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.action.ExportSpeciesMultiPostAction.class);
        exportMultiPostButton.putClientProperty("help", "tutti.editSpeciesBatch.action.exportMultiPost.help");
    }

    protected void createFilterSpeciesBatchAllButton() {
        $objectMap.put("filterSpeciesBatchAllButton", filterSpeciesBatchAllButton = new JRadioButton());
        
        filterSpeciesBatchAllButton.setName("filterSpeciesBatchAllButton");
        filterSpeciesBatchAllButton.setText(t("tutti.editSpeciesBatch.filterBatch.mode.all"));
        { filterSpeciesBatchAllButton.putClientProperty("$value", "all");  Object $buttonGroup = filterSpeciesBatchAllButton.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        filterSpeciesBatchAllButton.setToolTipText(t("tutti.editSpeciesBatch.filterBatch.mode.all.tip"));
        filterSpeciesBatchAllButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__filterSpeciesBatchAllButton"));
    }

    protected void createFilterSpeciesBatchLabel() {
        $objectMap.put("filterSpeciesBatchLabel", filterSpeciesBatchLabel = new JLabel());
        
        filterSpeciesBatchLabel.setName("filterSpeciesBatchLabel");
        filterSpeciesBatchLabel.setText(t("tutti.editSpeciesBatch.filterBatch"));
        filterSpeciesBatchLabel.setToolTipText(t("tutti.editSpeciesBatch.filterSpeciesBatch.tip"));
        filterSpeciesBatchLabel.putClientProperty("help", "tutti.editSpeciesBatch.filterSpeciesBatch.help");
        filterSpeciesBatchLabel.putClientProperty("strongStyle", true);
    }

    protected void createFilterSpeciesBatchLeafButton() {
        $objectMap.put("filterSpeciesBatchLeafButton", filterSpeciesBatchLeafButton = new JRadioButton());
        
        filterSpeciesBatchLeafButton.setName("filterSpeciesBatchLeafButton");
        filterSpeciesBatchLeafButton.setText(t("tutti.editSpeciesBatch.filterBatch.mode.leaf"));
        { filterSpeciesBatchLeafButton.putClientProperty("$value", "leaf");  Object $buttonGroup = filterSpeciesBatchLeafButton.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        filterSpeciesBatchLeafButton.setToolTipText(t("tutti.editSpeciesBatch.filterBatch.mode.leaf.tip"));
        filterSpeciesBatchLeafButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__filterSpeciesBatchLeafButton"));
    }

    protected void createFilterSpeciesBatchMode() {
        $objectMap.put("filterSpeciesBatchMode", filterSpeciesBatchMode = new JAXXButtonGroup());
    }

    protected void createFilterSpeciesBatchRootButton() {
        $objectMap.put("filterSpeciesBatchRootButton", filterSpeciesBatchRootButton = new JRadioButton());
        
        filterSpeciesBatchRootButton.setName("filterSpeciesBatchRootButton");
        { filterSpeciesBatchRootButton.putClientProperty("$value", "root");  Object $buttonGroup = filterSpeciesBatchRootButton.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        filterSpeciesBatchRootButton.setToolTipText(t("tutti.editSpeciesBatch.filterBatch.mode.root.tip"));
        filterSpeciesBatchRootButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__filterSpeciesBatchRootButton"));
    }

    protected void createFilterTablePane() {
        $objectMap.put("filterTablePane", filterTablePane = new JPanel());
        
        filterTablePane.setName("filterTablePane");
    }

    protected void createForm() {
        $objectMap.put("form", form = new Table());
        
        form.setName("form");
    }

    protected void createImportBigfinButton() {
        $objectMap.put("importBigfinButton", importBigfinButton = new JButton());
        
        importBigfinButton.setName("importBigfinButton");
        importBigfinButton.setText(t("tutti.editSpeciesBatch.action.importBigfin"));
        importBigfinButton.setToolTipText(t("tutti.editSpeciesBatch.action.importBigfin.tip"));
        importBigfinButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.action.ImportBigfinAction.class);
        importBigfinButton.putClientProperty("help", "tutti.editSpeciesBatch.action.importBigfin.help");
    }

    protected void createImportMultiPostButton() {
        $objectMap.put("importMultiPostButton", importMultiPostButton = new JButton());
        
        importMultiPostButton.setName("importMultiPostButton");
        importMultiPostButton.setText(t("tutti.editSpeciesBatch.action.importMultiPost"));
        importMultiPostButton.setToolTipText(t("tutti.editSpeciesBatch.action.importMultiPost.tip"));
        importMultiPostButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.action.ImportSpeciesMultiPostAction.class);
        importMultiPostButton.putClientProperty("help", "tutti.editSpeciesBatch.action.importMultiPost.help");
    }

    protected void createImportPsionButton() {
        $objectMap.put("importPsionButton", importPsionButton = new JButton());
        
        importPsionButton.setName("importPsionButton");
        importPsionButton.setText(t("tutti.editSpeciesBatch.action.importPsion"));
        importPsionButton.setToolTipText(t("tutti.editSpeciesBatch.action.importPsion.tip"));
        importPsionButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.action.ImportPsionAction.class);
        importPsionButton.putClientProperty("help", "tutti.editSpeciesBatch.action.importPsion.help");
    }

    protected void createImportPupitriButton() {
        $objectMap.put("importPupitriButton", importPupitriButton = new JButton());
        
        importPupitriButton.setName("importPupitriButton");
        importPupitriButton.setText(t("tutti.editSpeciesBatch.action.importPupitri"));
        importPupitriButton.setToolTipText(t("tutti.editSpeciesBatch.action.importPupitri.tip"));
        importPupitriButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.action.ImportPupitriAction.class);
        importPupitriButton.putClientProperty("help", "tutti.editSpeciesBatch.action.importPupitri.help");
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(SpeciesBatchUIModel.class));
    }

    protected void createRemoveSpeciesBatchMenu() {
        $objectMap.put("removeSpeciesBatchMenu", removeSpeciesBatchMenu = new JMenuItem());
        
        removeSpeciesBatchMenu.setName("removeSpeciesBatchMenu");
        removeSpeciesBatchMenu.setText(t("tutti.editSpeciesBatch.action.removeBatch"));
        removeSpeciesBatchMenu.setToolTipText(t("tutti.editSpeciesBatch.action.removeBatch.tip"));
        removeSpeciesBatchMenu.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.action.RemoveSpeciesBatchAction.class);
        removeSpeciesBatchMenu.putClientProperty("help", "tutti.editSpeciesBatch.action.removeBatch.help");
    }

    protected void createRemoveSpeciesSubBatchMenu() {
        $objectMap.put("removeSpeciesSubBatchMenu", removeSpeciesSubBatchMenu = new JMenuItem());
        
        removeSpeciesSubBatchMenu.setName("removeSpeciesSubBatchMenu");
        removeSpeciesSubBatchMenu.setText(t("tutti.editSpeciesBatch.action.removeSubBatch"));
        removeSpeciesSubBatchMenu.setToolTipText(t("tutti.editSpeciesBatch.action.removeSubBatch.tip"));
        removeSpeciesSubBatchMenu.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.action.RemoveSpeciesSubBatchAction.class);
        removeSpeciesSubBatchMenu.putClientProperty("help", "tutti.editSpeciesBatch.action.removeSubBatch.help");
    }

    protected void createRenameSpeciesBatchMenu() {
        $objectMap.put("renameSpeciesBatchMenu", renameSpeciesBatchMenu = new JMenuItem());
        
        renameSpeciesBatchMenu.setName("renameSpeciesBatchMenu");
        renameSpeciesBatchMenu.setText(t("tutti.editSpeciesBatch.action.renameBatch"));
        renameSpeciesBatchMenu.setToolTipText(t("tutti.editSpeciesBatch.action.renameBatch.tip"));
        renameSpeciesBatchMenu.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.action.RenameSpeciesBatchAction.class);
        renameSpeciesBatchMenu.putClientProperty("help", "tutti.editSpeciesBatch.action.renameBatch.help");
    }

    protected void createSpeciesBatchTabToolBar() {
        $objectMap.put("speciesBatchTabToolBar", speciesBatchTabToolBar = new JToolBar());
        
        speciesBatchTabToolBar.setName("speciesBatchTabToolBar");
        speciesBatchTabToolBar.setFloatable(false);
        speciesBatchTabToolBar.setOpaque(false);
        speciesBatchTabToolBar.setBorderPainted(false);
    }

    protected void createSpeciesSort() {
        $objectMap.put("speciesSort", speciesSort = new JAXXButtonGroup());
    }

    protected void createSpeciesSortBatchLabel() {
        $objectMap.put("speciesSortBatchLabel", speciesSortBatchLabel = new JLabel());
        
        speciesSortBatchLabel.setName("speciesSortBatchLabel");
        speciesSortBatchLabel.setText(t("tutti.editSpeciesBatch.sortSpeciesBatch"));
        speciesSortBatchLabel.setToolTipText(t("tutti.editSpeciesBatch.sortSpeciesBatch.tip"));
        speciesSortBatchLabel.putClientProperty("help", "tutti.editSpeciesBatch.sortSpeciesBatch.help");
        speciesSortBatchLabel.putClientProperty("strongStyle", true);
    }

    protected void createSpeciesSortModeAscButton() {
        $objectMap.put("speciesSortModeAscButton", speciesSortModeAscButton = new JRadioButton());
        
        speciesSortModeAscButton.setName("speciesSortModeAscButton");
        speciesSortModeAscButton.setText(t("tutti.editSpeciesBatch.speciesSortMode.asc"));
        { speciesSortModeAscButton.putClientProperty("$value", "ASC");  Object $buttonGroup = speciesSortModeAscButton.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        speciesSortModeAscButton.setToolTipText(t("tutti.editSpeciesBatch.speciesSortMode.asc.tip"));
        speciesSortModeAscButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__speciesSortModeAscButton"));
        speciesSortModeAscButton.putClientProperty("help", "tutti.editSpeciesBatch.field.speciesSortMode.asc.help");
    }

    protected void createSpeciesSortModeDescButton() {
        $objectMap.put("speciesSortModeDescButton", speciesSortModeDescButton = new JRadioButton());
        
        speciesSortModeDescButton.setName("speciesSortModeDescButton");
        speciesSortModeDescButton.setText(t("tutti.editSpeciesBatch.speciesSortMode.desc"));
        { speciesSortModeDescButton.putClientProperty("$value", "DESC");  Object $buttonGroup = speciesSortModeDescButton.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        speciesSortModeDescButton.setToolTipText(t("tutti.editSpeciesBatch.speciesSortMode.desc.tip"));
        speciesSortModeDescButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__speciesSortModeDescButton"));
        speciesSortModeDescButton.putClientProperty("help", "tutti.editSpeciesBatch.field.speciesSortMode.desc.help");
    }

    protected void createSpeciesSortModeNoneButton() {
        $objectMap.put("speciesSortModeNoneButton", speciesSortModeNoneButton = new JRadioButton());
        
        speciesSortModeNoneButton.setName("speciesSortModeNoneButton");
        speciesSortModeNoneButton.setText(t("tutti.editSpeciesBatch.speciesSortMode.none"));
        { speciesSortModeNoneButton.putClientProperty("$value", "NONE");  Object $buttonGroup = speciesSortModeNoneButton.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        speciesSortModeNoneButton.setToolTipText(t("tutti.editSpeciesBatch.speciesSortMode.none.tip"));
        speciesSortModeNoneButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__speciesSortModeNoneButton"));
        speciesSortModeNoneButton.putClientProperty("help", "tutti.editSpeciesBatch.field.speciesSortMode.none.help");
    }

    protected void createSpeciesSortTablePane() {
        $objectMap.put("speciesSortTablePane", speciesSortTablePane = new JPanel());
        
        speciesSortTablePane.setName("speciesSortTablePane");
    }

    protected void createSpeciesTotalInertWeightField() {
        $objectMap.put("speciesTotalInertWeightField", speciesTotalInertWeightField = new ComputableDataEditor<Float>(this));
        
        speciesTotalInertWeightField.setName("speciesTotalInertWeightField");
        speciesTotalInertWeightField.setUseFloat(true);
        speciesTotalInertWeightField.setShowReset(true);
        speciesTotalInertWeightField.putClientProperty("help", "tutti.editSpeciesBatch.field.speciesTotalInertWeight.help");
        speciesTotalInertWeightField.putClientProperty("selectOnFocus", true);
    }

    protected void createSpeciesTotalInertWeightLabel() {
        $objectMap.put("speciesTotalInertWeightLabel", speciesTotalInertWeightLabel = new JLabel());
        
        speciesTotalInertWeightLabel.setName("speciesTotalInertWeightLabel");
        speciesTotalInertWeightLabel.setText(t("tutti.editSpeciesBatch.field.speciesTotalInertWeight"));
        speciesTotalInertWeightLabel.setToolTipText(t("tutti.editSpeciesBatch.field.speciesTotalInertWeight.tip"));
        speciesTotalInertWeightLabel.putClientProperty("help", "tutti.editSpeciesBatch.field.speciesTotalInertWeight.help");
        speciesTotalInertWeightLabel.putClientProperty("addWeightUnit", handler.getConfig().getSpeciesWeightUnit());
    }

    protected void createSpeciesTotalLivingNotItemizedWeightField() {
        $objectMap.put("speciesTotalLivingNotItemizedWeightField", speciesTotalLivingNotItemizedWeightField = new ComputableDataEditor<Float>(this));
        
        speciesTotalLivingNotItemizedWeightField.setName("speciesTotalLivingNotItemizedWeightField");
        speciesTotalLivingNotItemizedWeightField.setUseFloat(true);
        speciesTotalLivingNotItemizedWeightField.setShowReset(true);
        speciesTotalLivingNotItemizedWeightField.putClientProperty("help", "tutti.editSpeciesBatch.field.speciesTotalLivingNotItemizedWeight.help");
        speciesTotalLivingNotItemizedWeightField.putClientProperty("selectOnFocus", true);
    }

    protected void createSpeciesTotalLivingNotItemizedWeightLabel() {
        $objectMap.put("speciesTotalLivingNotItemizedWeightLabel", speciesTotalLivingNotItemizedWeightLabel = new JLabel());
        
        speciesTotalLivingNotItemizedWeightLabel.setName("speciesTotalLivingNotItemizedWeightLabel");
        speciesTotalLivingNotItemizedWeightLabel.setText(t("tutti.editSpeciesBatch.field.speciesTotalLivingNotItemizedWeight"));
        speciesTotalLivingNotItemizedWeightLabel.setToolTipText(t("tutti.editSpeciesBatch.field.speciesTotalLivingNotItemizedWeight.tip"));
        speciesTotalLivingNotItemizedWeightLabel.putClientProperty("help", "tutti.editSpeciesBatch.field.speciesTotalLivingNotItemizedWeight.help");
        speciesTotalLivingNotItemizedWeightLabel.putClientProperty("addWeightUnit", handler.getConfig().getSpeciesWeightUnit());
    }

    protected void createSpeciesTotalSampleSortedWeightField() {
        $objectMap.put("speciesTotalSampleSortedWeightField", speciesTotalSampleSortedWeightField = new JTextField());
        
        speciesTotalSampleSortedWeightField.setName("speciesTotalSampleSortedWeightField");
        speciesTotalSampleSortedWeightField.setColumns(15);
        speciesTotalSampleSortedWeightField.putClientProperty("help", "tutti.editSpeciesBatch.field.speciesTotalSampleSortedWeight.help");
        speciesTotalSampleSortedWeightField.putClientProperty("computed", true);
    }

    protected void createSpeciesTotalSampleSortedWeightLabel() {
        $objectMap.put("speciesTotalSampleSortedWeightLabel", speciesTotalSampleSortedWeightLabel = new JLabel());
        
        speciesTotalSampleSortedWeightLabel.setName("speciesTotalSampleSortedWeightLabel");
        speciesTotalSampleSortedWeightLabel.setText(t("tutti.editSpeciesBatch.field.speciesTotalSampleSortedWeight"));
        speciesTotalSampleSortedWeightLabel.setToolTipText(t("tutti.editSpeciesBatch.field.speciesTotalSampleSortedWeight.tip"));
        speciesTotalSampleSortedWeightLabel.putClientProperty("help", "tutti.editSpeciesBatch.field.speciesTotalSampleSortedWeight.help");
        speciesTotalSampleSortedWeightLabel.putClientProperty("addWeightUnit", handler.getConfig().getSpeciesWeightUnit());
    }

    protected void createSpeciesTotalSortedWeightField() {
        $objectMap.put("speciesTotalSortedWeightField", speciesTotalSortedWeightField = new ComputableDataEditor<Float>(this));
        
        speciesTotalSortedWeightField.setName("speciesTotalSortedWeightField");
        speciesTotalSortedWeightField.setUseFloat(true);
        speciesTotalSortedWeightField.setShowReset(true);
        speciesTotalSortedWeightField.putClientProperty("help", "tutti.editSpeciesBatch.field.speciesTotalSortedWeight.help");
        speciesTotalSortedWeightField.putClientProperty("selectOnFocus", true);
    }

    protected void createSpeciesTotalSortedWeightLabel() {
        $objectMap.put("speciesTotalSortedWeightLabel", speciesTotalSortedWeightLabel = new JLabel());
        
        speciesTotalSortedWeightLabel.setName("speciesTotalSortedWeightLabel");
        speciesTotalSortedWeightLabel.setText(t("tutti.editSpeciesBatch.field.speciesTotalSortedWeight"));
        speciesTotalSortedWeightLabel.setToolTipText(t("tutti.editSpeciesBatch.field.speciesTotalSortedWeight.tip"));
        speciesTotalSortedWeightLabel.putClientProperty("help", "tutti.editSpeciesBatch.field.speciesTotalSortedWeight.help");
        speciesTotalSortedWeightLabel.putClientProperty("addWeightUnit", handler.getConfig().getSpeciesWeightUnit());
    }

    protected void createSpeciesTotalUnsortedWeightField() {
        $objectMap.put("speciesTotalUnsortedWeightField", speciesTotalUnsortedWeightField = new JTextField());
        
        speciesTotalUnsortedWeightField.setName("speciesTotalUnsortedWeightField");
        speciesTotalUnsortedWeightField.setColumns(15);
        speciesTotalUnsortedWeightField.putClientProperty("help", "tutti.editSpeciesBatch.field.speciesTotalUnsortedWeight.help");
        speciesTotalUnsortedWeightField.putClientProperty("computed", true);
    }

    protected void createSpeciesTotalUnsortedWeightLabel() {
        $objectMap.put("speciesTotalUnsortedWeightLabel", speciesTotalUnsortedWeightLabel = new JLabel());
        
        speciesTotalUnsortedWeightLabel.setName("speciesTotalUnsortedWeightLabel");
        speciesTotalUnsortedWeightLabel.setText(t("tutti.editSpeciesBatch.field.speciesTotalUnsortedWeight"));
        speciesTotalUnsortedWeightLabel.setToolTipText(t("tutti.editSpeciesBatch.field.speciesTotalUnsortedWeight.tip"));
        speciesTotalUnsortedWeightLabel.putClientProperty("help", "tutti.editSpeciesBatch.field.speciesTotalUnsortedWeight.help");
        speciesTotalUnsortedWeightLabel.putClientProperty("addWeightUnit", handler.getConfig().getSpeciesWeightUnit());
    }

    protected void createSpeciesTotalWeightField() {
        $objectMap.put("speciesTotalWeightField", speciesTotalWeightField = new JTextField());
        
        speciesTotalWeightField.setName("speciesTotalWeightField");
        speciesTotalWeightField.setColumns(15);
        speciesTotalWeightField.putClientProperty("help", "tutti.editSpeciesBatch.field.speciesTotalWeight.help");
        speciesTotalWeightField.putClientProperty("computed", true);
    }

    protected void createSpeciesTotalWeightLabel() {
        $objectMap.put("speciesTotalWeightLabel", speciesTotalWeightLabel = new JLabel());
        
        speciesTotalWeightLabel.setName("speciesTotalWeightLabel");
        speciesTotalWeightLabel.setText(t("tutti.editSpeciesBatch.field.speciesTotalWeight"));
        speciesTotalWeightLabel.setToolTipText(t("tutti.editSpeciesBatch.field.speciesTotalWeight.tip"));
        speciesTotalWeightLabel.putClientProperty("help", "tutti.editSpeciesBatch.field.speciesTotalWeight.help");
        speciesTotalWeightLabel.putClientProperty("addWeightUnit", handler.getConfig().getSpeciesWeightUnit());
    }

    protected void createSplitSpeciesBatchMenu() {
        $objectMap.put("splitSpeciesBatchMenu", splitSpeciesBatchMenu = new JMenuItem());
        
        splitSpeciesBatchMenu.setName("splitSpeciesBatchMenu");
        splitSpeciesBatchMenu.setText(t("tutti.editSpeciesBatch.action.splitBatch"));
        splitSpeciesBatchMenu.setToolTipText(t("tutti.editSpeciesBatch.action.splitBatch.tip"));
        splitSpeciesBatchMenu.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__splitSpeciesBatchMenu"));
        splitSpeciesBatchMenu.putClientProperty("help", "tutti.editSpeciesBatch.action.splitBatch.help");
    }

    protected void createTable() {
        $objectMap.put("table", table = new JXTable());
        
        table.setName("table");
        table.setSortable(false);
        table.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyPressed", this, "doKeyPressed__on__table"));
        table.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseClicked", this, "doMouseClicked__on__table"));
    }

    protected void createTablePopup() {
        $objectMap.put("tablePopup", tablePopup = new JPopupMenu());
        
        tablePopup.setName("tablePopup");
        tablePopup.setLabel("tutti.editSpeciesBatch.title.batchActions");
    }

    protected void createTableScrollPane() {
        $objectMap.put("tableScrollPane", tableScrollPane = new JScrollPane());
        
        tableScrollPane.setName("tableScrollPane");
    }

    protected void createTableToolbar() {
        $objectMap.put("tableToolbar", tableToolbar = new JPanel());
        
        tableToolbar.setName("tableToolbar");
        tableToolbar.setLayout(new BorderLayout());
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = SwingValidator.newValidator(SpeciesBatchUIModel.class, null));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToEditSpeciesBatchTopPanel();
        addChildrenToValidator();
        addChildrenToSpeciesBatchTabToolBar();
        addChildrenToTablePopup();
        addChildrenToForm();
        addChildrenToTableToolbar();
        // inline complete setup of $JPanel0
        $JPanel0.add(createSpeciesBatchButton);
        // inline complete setup of $JPanel1
        $JPanel1.add(filterTablePane);
        $JPanel1.add(speciesSortTablePane);
        addChildrenToFilterTablePane();
        addChildrenToFilterSpeciesBatchAllButton();
        addChildrenToFilterSpeciesBatchLeafButton();
        addChildrenToFilterSpeciesBatchRootButton();
        addChildrenToSpeciesSortTablePane();
        addChildrenToSpeciesSortModeNoneButton();
        addChildrenToSpeciesSortModeAscButton();
        addChildrenToSpeciesSortModeDescButton();
        addChildrenToTableScrollPane();
        
        // apply 24 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 53 property setters
        importPupitriButton.setIcon(SwingUtil.createActionIcon("pupitri-import"));
        importPupitriButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.editSpeciesBatch.action.importPupitri.mnemonic"),'Z'));
        importPsionButton.setIcon(SwingUtil.createActionIcon("psion-import"));
        importPsionButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.editSpeciesBatch.action.importPsion.mnemonic"),'Z'));
        importBigfinButton.setIcon(SwingUtil.createActionIcon("bigfin-import"));
        importBigfinButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.editSpeciesBatch.action.importBigfin.mnemonic"),'Z'));
        importMultiPostButton.setIcon(SwingUtil.createActionIcon("import"));
        importMultiPostButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.editSpeciesBatch.action.importMultiPost.mnemonic"),'Z'));
        exportMultiPostButton.setIcon(SwingUtil.createActionIcon("export"));
        exportMultiPostButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.editSpeciesBatch.action.exportMultiPost.mnemonic"),'Z'));
        splitSpeciesBatchMenu.setIcon(SwingUtil.createActionIcon("batch-split"));
        splitSpeciesBatchMenu.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.editSpeciesBatch.action.splitBatch.mnemonic"),'Z'));
        changeSampleCategoryMenu.setIcon(SwingUtil.createActionIcon("batch-split"));
        changeSampleCategoryMenu.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.editSpeciesBatch.action.changeSampleCategory.mnemonic"),'Z'));
        addSampleCategoryMenu.setIcon(SwingUtil.createActionIcon("batch-split"));
        addSampleCategoryMenu.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.editSpeciesBatch.action.addSampleCategory.mnemonic"),'Z'));
        removeSpeciesBatchMenu.setIcon(SwingUtil.createActionIcon("batch-delete"));
        removeSpeciesBatchMenu.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.editSpeciesBatch.action.removeBatch.mnemonic"),'Z'));
        removeSpeciesSubBatchMenu.setIcon(SwingUtil.createActionIcon("batch-delete"));
        removeSpeciesSubBatchMenu.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.editSpeciesBatch.action.removeSubBatch.mnemonic"),'Z'));
        renameSpeciesBatchMenu.setIcon(SwingUtil.createActionIcon("batch-rename"));
        renameSpeciesBatchMenu.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.editSpeciesBatch.action.renameBatch.mnemonic"),'Z'));
        createSpeciesMelagMenu.setIcon(SwingUtil.createActionIcon("batch-rename"));
        createSpeciesMelagMenu.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.editSpeciesBatch.action.createMelag.mnemonic"),'Z'));
        editFrequenciesMenu.setIcon(SwingUtil.createActionIcon("show-frequency"));
        editFrequenciesMenu.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.editSpeciesBatch.action.editFrequencies.mnemonic"),'Z'));
        speciesTotalWeightLabel.setLabelFor(speciesTotalWeightField);
        speciesTotalSortedWeightLabel.setLabelFor(speciesTotalSortedWeightField);
        speciesTotalSortedWeightField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        speciesTotalSortedWeightField.setComputedDataColor(handler.getConfig().getColorComputedWeights());
        speciesTotalSortedWeightField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        speciesTotalSampleSortedWeightLabel.setLabelFor(speciesTotalSampleSortedWeightField);
        speciesTotalUnsortedWeightLabel.setLabelFor(speciesTotalUnsortedWeightField);
        speciesTotalInertWeightLabel.setLabelFor(speciesTotalInertWeightField);
        speciesTotalInertWeightField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        speciesTotalInertWeightField.setComputedDataColor(handler.getConfig().getColorComputedWeights());
        speciesTotalInertWeightField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        speciesTotalLivingNotItemizedWeightLabel.setLabelFor(speciesTotalLivingNotItemizedWeightField);
        speciesTotalLivingNotItemizedWeightField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        speciesTotalLivingNotItemizedWeightField.setComputedDataColor(handler.getConfig().getColorComputedWeights());
        speciesTotalLivingNotItemizedWeightField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        createSpeciesBatchButton.setIcon(SwingUtil.createActionIcon("batch-create"));
        createSpeciesBatchButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.editSpeciesBatch.action.createBatch.mnemonic"),'Z'));
        filterTablePane.setBorder(new TitledBorder(null, ""));
        filterSpeciesBatchLabel.setIcon(SwingUtil.createActionIcon("filter"));
        speciesSortTablePane.setBorder(new TitledBorder(null, ""));
        speciesSortBatchLabel.setIcon(SwingUtil.createActionIcon("sort"));
        table.setSelectionMode(ListSelectionModel.MULTIPLE_INTERVAL_SELECTION);
        table.setSelectionForeground(Color.BLACK);
        // late initializer
        // help broker setup
        TuttiHelpBroker _broker = getBroker();
        registerHelpId(_broker, editSpeciesBatchTopPanel, "tutti.editSpeciesBatch.help");
        registerHelpId(_broker, importPupitriButton, "tutti.editSpeciesBatch.action.importPupitri.help");
        registerHelpId(_broker, importPsionButton, "tutti.editSpeciesBatch.action.importPsion.help");
        registerHelpId(_broker, importBigfinButton, "tutti.editSpeciesBatch.action.importBigfin.help");
        registerHelpId(_broker, importMultiPostButton, "tutti.editSpeciesBatch.action.importMultiPost.help");
        registerHelpId(_broker, exportMultiPostButton, "tutti.editSpeciesBatch.action.exportMultiPost.help");
        registerHelpId(_broker, splitSpeciesBatchMenu, "tutti.editSpeciesBatch.action.splitBatch.help");
        registerHelpId(_broker, changeSampleCategoryMenu, "tutti.editSpeciesBatch.action.changeSampleCategory.help");
        registerHelpId(_broker, addSampleCategoryMenu, "tutti.editSpeciesBatch.action.addSampleCategory.help");
        registerHelpId(_broker, removeSpeciesBatchMenu, "tutti.editSpeciesBatch.action.removeBatch.help");
        registerHelpId(_broker, removeSpeciesSubBatchMenu, "tutti.editSpeciesBatch.action.removeSubBatch.help");
        registerHelpId(_broker, renameSpeciesBatchMenu, "tutti.editSpeciesBatch.action.renameBatch.help");
        registerHelpId(_broker, createSpeciesMelagMenu, "tutti.editSpeciesBatch.action.createMelag.help");
        registerHelpId(_broker, editFrequenciesMenu, "tutti.editSpeciesBatch.action.editFrequencies.help");
        registerHelpId(_broker, speciesTotalWeightLabel, "tutti.editSpeciesBatch.field.speciesTotalWeight.help");
        registerHelpId(_broker, speciesTotalWeightField, "tutti.editSpeciesBatch.field.speciesTotalWeight.help");
        registerHelpId(_broker, speciesTotalSortedWeightLabel, "tutti.editSpeciesBatch.field.speciesTotalSortedWeight.help");
        registerHelpId(_broker, speciesTotalSortedWeightField, "tutti.editSpeciesBatch.field.speciesTotalSortedWeight.help");
        registerHelpId(_broker, speciesTotalSampleSortedWeightLabel, "tutti.editSpeciesBatch.field.speciesTotalSampleSortedWeight.help");
        registerHelpId(_broker, speciesTotalSampleSortedWeightField, "tutti.editSpeciesBatch.field.speciesTotalSampleSortedWeight.help");
        registerHelpId(_broker, speciesTotalUnsortedWeightLabel, "tutti.editSpeciesBatch.field.speciesTotalUnsortedWeight.help");
        registerHelpId(_broker, speciesTotalUnsortedWeightField, "tutti.editSpeciesBatch.field.speciesTotalUnsortedWeight.help");
        registerHelpId(_broker, speciesTotalInertWeightLabel, "tutti.editSpeciesBatch.field.speciesTotalInertWeight.help");
        registerHelpId(_broker, speciesTotalInertWeightField, "tutti.editSpeciesBatch.field.speciesTotalInertWeight.help");
        registerHelpId(_broker, speciesTotalLivingNotItemizedWeightLabel, "tutti.editSpeciesBatch.field.speciesTotalLivingNotItemizedWeight.help");
        registerHelpId(_broker, speciesTotalLivingNotItemizedWeightField, "tutti.editSpeciesBatch.field.speciesTotalLivingNotItemizedWeight.help");
        registerHelpId(_broker, createSpeciesBatchButton, "tutti.editSpeciesBatch.action.createBatch.help");
        registerHelpId(_broker, filterSpeciesBatchLabel, "tutti.editSpeciesBatch.filterSpeciesBatch.help");
        registerHelpId(_broker, speciesSortBatchLabel, "tutti.editSpeciesBatch.sortSpeciesBatch.help");
        registerHelpId(_broker, speciesSortModeNoneButton, "tutti.editSpeciesBatch.field.speciesSortMode.none.help");
        registerHelpId(_broker, speciesSortModeAscButton, "tutti.editSpeciesBatch.field.speciesSortMode.asc.help");
        registerHelpId(_broker, speciesSortModeDescButton, "tutti.editSpeciesBatch.field.speciesSortMode.desc.help");
        _broker.prepareUI(this);
        // register 1 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        handler.beforeInit(this);
        $objectMap.put("editSpeciesBatchTopPanel", editSpeciesBatchTopPanel);
        createModel();
        createValidator();
        createBroker();
        createSpeciesBatchTabToolBar();
        createImportPupitriButton();
        createImportPsionButton();
        createImportBigfinButton();
        createImportMultiPostButton();
        createExportMultiPostButton();
        createTablePopup();
        createSplitSpeciesBatchMenu();
        createChangeSampleCategoryMenu();
        createAddSampleCategoryMenu();
        createRemoveSpeciesBatchMenu();
        createRemoveSpeciesSubBatchMenu();
        createRenameSpeciesBatchMenu();
        createCreateSpeciesMelagMenu();
        createEditFrequenciesMenu();
        createForm();
        createSpeciesTotalWeightLabel();
        createSpeciesTotalWeightField();
        createSpeciesTotalSortedWeightLabel();
        createSpeciesTotalSortedWeightField();
        createSpeciesTotalSampleSortedWeightLabel();
        createSpeciesTotalSampleSortedWeightField();
        createSpeciesTotalUnsortedWeightLabel();
        createSpeciesTotalUnsortedWeightField();
        createSpeciesTotalInertWeightLabel();
        createSpeciesTotalInertWeightField();
        createSpeciesTotalLivingNotItemizedWeightLabel();
        createSpeciesTotalLivingNotItemizedWeightField();
        createTableToolbar();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new GridLayout(1,0));
        createCreateSpeciesBatchButton();
        // inline creation of $JPanel1
        $objectMap.put("$JPanel1", $JPanel1 = new JPanel());
        
        $JPanel1.setName("$JPanel1");
        $JPanel1.setLayout(new GridLayout());
        createFilterTablePane();
        createFilterSpeciesBatchLabel();
        createFilterSpeciesBatchAllButton();
        createFilterSpeciesBatchLeafButton();
        createFilterSpeciesBatchRootButton();
        createSpeciesSortTablePane();
        createSpeciesSortBatchLabel();
        createSpeciesSortModeNoneButton();
        createSpeciesSortModeAscButton();
        createSpeciesSortModeDescButton();
        createTableScrollPane();
        createTable();
        createFilterSpeciesBatchMode();
        createSpeciesSort();
        // inline creation of editSpeciesBatchTopPanel
        setName("editSpeciesBatchTopPanel");
        setLayout(new BorderLayout());
        editSpeciesBatchTopPanel.putClientProperty("help", "tutti.editSpeciesBatch.help");
        
        // registers 24 data bindings
        $registerDefaultBindings();
        $completeSetup();
        handler.afterInit(this);
    }

    private void $registerDefaultBindings() {
        // register 24 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SPLIT_SPECIES_BATCH_MENU_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("tableViewModeAll", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("splitBatchEnabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    splitSpeciesBatchMenu.setEnabled(model.isTableViewModeAll() && model.isSplitBatchEnabled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("tableViewModeAll", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("splitBatchEnabled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CHANGE_SAMPLE_CATEGORY_MENU_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("tableViewModeAll", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("changeSampleCategoryEnabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    changeSampleCategoryMenu.setEnabled(model.isTableViewModeAll() && model.isChangeSampleCategoryEnabled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("tableViewModeAll", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("changeSampleCategoryEnabled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_ADD_SAMPLE_CATEGORY_MENU_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("tableViewModeAll", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("addSampleCategoryEnabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    addSampleCategoryMenu.setEnabled(model.isTableViewModeAll() && model.isAddSampleCategoryEnabled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("tableViewModeAll", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("addSampleCategoryEnabled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_REMOVE_SPECIES_BATCH_MENU_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("tableViewModeAll", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("removeBatchEnabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    removeSpeciesBatchMenu.setEnabled(model.isTableViewModeAll() && model.isRemoveBatchEnabled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("tableViewModeAll", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("removeBatchEnabled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_REMOVE_SPECIES_SUB_BATCH_MENU_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("tableViewModeAll", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("removeSubBatchEnabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    removeSpeciesSubBatchMenu.setEnabled(model.isTableViewModeAll() && model.isRemoveSubBatchEnabled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("tableViewModeAll", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("removeSubBatchEnabled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_RENAME_SPECIES_BATCH_MENU_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("tableViewModeAll", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("renameBatchEnabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    renameSpeciesBatchMenu.setEnabled(model.isTableViewModeAll() && model.isRenameBatchEnabled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("tableViewModeAll", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("renameBatchEnabled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CREATE_SPECIES_MELAG_MENU_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("tableViewModeLeaf", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("createMelagEnabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    createSpeciesMelagMenu.setEnabled(!model.isTableViewModeLeaf() && model.isCreateMelagEnabled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("tableViewModeLeaf", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("createMelagEnabled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EDIT_FREQUENCIES_MENU_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("tableViewModeAll", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("editFrequenciesEnabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    editFrequenciesMenu.setEnabled(model.isTableViewModeAll() && model.isEditFrequenciesEnabled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("tableViewModeAll", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("editFrequenciesEnabled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SPECIES_TOTAL_WEIGHT_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("speciesTotalComputedWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(speciesTotalWeightField, handler.getWeightStringValue(speciesTotalWeightLabel, model.getSpeciesTotalComputedWeight()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("speciesTotalComputedWeight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SPECIES_TOTAL_SORTED_WEIGHT_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("speciesTotalSortedWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    speciesTotalSortedWeightField.setModel(model.getSpeciesTotalSortedWeight());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("speciesTotalSortedWeight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SPECIES_TOTAL_SORTED_WEIGHT_FIELD_BEAN, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("speciesTotalSortedComputedOrNotWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    speciesTotalSortedWeightField.setBean(model.getSpeciesTotalSortedComputedOrNotWeight());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("speciesTotalSortedComputedOrNotWeight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SPECIES_TOTAL_SAMPLE_SORTED_WEIGHT_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("speciesTotalSampleSortedComputedWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(speciesTotalSampleSortedWeightField, handler.getWeightStringValue(speciesTotalSampleSortedWeightLabel, model.getSpeciesTotalSampleSortedComputedWeight()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("speciesTotalSampleSortedComputedWeight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SPECIES_TOTAL_UNSORTED_WEIGHT_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("speciesTotalUnsortedComputedWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(speciesTotalUnsortedWeightField, handler.getWeightStringValue(speciesTotalUnsortedWeightLabel, model.getSpeciesTotalUnsortedComputedWeight()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("speciesTotalUnsortedComputedWeight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SPECIES_TOTAL_INERT_WEIGHT_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("speciesTotalInertWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    speciesTotalInertWeightField.setModel(model.getSpeciesTotalInertWeight());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("speciesTotalInertWeight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SPECIES_TOTAL_INERT_WEIGHT_FIELD_BEAN, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("speciesTotalInertComputedOrNotWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    speciesTotalInertWeightField.setBean(model.getSpeciesTotalInertComputedOrNotWeight());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("speciesTotalInertComputedOrNotWeight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SPECIES_TOTAL_LIVING_NOT_ITEMIZED_WEIGHT_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("speciesTotalLivingNotItemizedWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    speciesTotalLivingNotItemizedWeightField.setModel(model.getSpeciesTotalLivingNotItemizedWeight());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("speciesTotalLivingNotItemizedWeight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SPECIES_TOTAL_LIVING_NOT_ITEMIZED_WEIGHT_FIELD_BEAN, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("speciesTotalLivingNotItemizedComputedOrNotWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    speciesTotalLivingNotItemizedWeightField.setBean(model.getSpeciesTotalLivingNotItemizedComputedOrNotWeight());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("speciesTotalLivingNotItemizedComputedOrNotWeight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FILTER_SPECIES_BATCH_ALL_BUTTON_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("tableViewModeAll", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    filterSpeciesBatchAllButton.setSelected(model.isTableViewModeAll());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("tableViewModeAll", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FILTER_SPECIES_BATCH_LEAF_BUTTON_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("tableViewModeLeaf", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    filterSpeciesBatchLeafButton.setSelected(model.isTableViewModeLeaf());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("tableViewModeLeaf", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FILTER_SPECIES_BATCH_ROOT_BUTTON_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("rootNumber", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    filterSpeciesBatchRootButton.setText(t(handler.getFilterSpeciesBatchRootButtonText(model.getRootNumber())));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("rootNumber", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FILTER_SPECIES_BATCH_ROOT_BUTTON_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("tableViewModeRoot", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    filterSpeciesBatchRootButton.setSelected(model.isTableViewModeRoot());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("tableViewModeRoot", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SPECIES_SORT_MODE_NONE_BUTTON_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("speciesSortModeNone", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    speciesSortModeNoneButton.setSelected(model.isSpeciesSortModeNone());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("speciesSortModeNone", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SPECIES_SORT_MODE_ASC_BUTTON_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("speciesSortModeAsc", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    speciesSortModeAscButton.setSelected(model.isSpeciesSortModeAsc());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("speciesSortModeAsc", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SPECIES_SORT_MODE_DESC_BUTTON_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("speciesSortModeDesc", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    speciesSortModeDescButton.setSelected(model.isSpeciesSortModeDesc());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("speciesSortModeDesc", this);
                }
            }
        });
    }

}