/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.expression.spel.ast;

import java.math.BigDecimal;
import org.springframework.asm.MethodVisitor;
import org.springframework.expression.EvaluationException;
import org.springframework.expression.spel.CodeFlow;
import org.springframework.expression.spel.ExpressionState;
import org.springframework.expression.spel.ast.Operator;
import org.springframework.expression.spel.ast.SpelNodeImpl;
import org.springframework.expression.spel.support.BooleanTypedValue;
import org.springframework.util.NumberUtils;

public class OpLE
extends Operator {
    public OpLE(int pos, SpelNodeImpl ... operands) {
        super("<=", pos, operands);
        this.exitTypeDescriptor = "Z";
    }

    @Override
    public BooleanTypedValue getValueInternal(ExpressionState state) throws EvaluationException {
        Object left = this.getLeftOperand().getValueInternal(state).getValue();
        Object right = this.getRightOperand().getValueInternal(state).getValue();
        this.leftActualDescriptor = CodeFlow.toDescriptorFromObject(left);
        this.rightActualDescriptor = CodeFlow.toDescriptorFromObject(right);
        if (left instanceof Number && right instanceof Number) {
            Number leftNumber = (Number)left;
            Number rightNumber = (Number)right;
            if (leftNumber instanceof BigDecimal || rightNumber instanceof BigDecimal) {
                BigDecimal rightBigDecimal;
                BigDecimal leftBigDecimal = (BigDecimal)NumberUtils.convertNumberToTargetClass((Number)leftNumber, BigDecimal.class);
                return BooleanTypedValue.forValue(leftBigDecimal.compareTo(rightBigDecimal = (BigDecimal)NumberUtils.convertNumberToTargetClass((Number)rightNumber, BigDecimal.class)) <= 0);
            }
            if (leftNumber instanceof Double || rightNumber instanceof Double) {
                return BooleanTypedValue.forValue(leftNumber.doubleValue() <= rightNumber.doubleValue());
            }
            if (leftNumber instanceof Float || rightNumber instanceof Float) {
                return BooleanTypedValue.forValue(leftNumber.floatValue() <= rightNumber.floatValue());
            }
            if (leftNumber instanceof Long || rightNumber instanceof Long) {
                return BooleanTypedValue.forValue(leftNumber.longValue() <= rightNumber.longValue());
            }
            return BooleanTypedValue.forValue(leftNumber.intValue() <= rightNumber.intValue());
        }
        return BooleanTypedValue.forValue(state.getTypeComparator().compare(left, right) <= 0);
    }

    @Override
    public boolean isCompilable() {
        return this.isCompilableOperatorUsingNumerics();
    }

    @Override
    public void generateCode(MethodVisitor mv, CodeFlow codeflow) {
        this.generateComparisonCode(mv, codeflow, 157, 163);
    }
}

