/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.source.hbm;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.internal.jaxb.JaxbRoot;
import org.hibernate.internal.jaxb.mapping.hbm.JaxbHibernateMapping;
import org.hibernate.metamodel.MetadataSources;
import org.hibernate.metamodel.source.MetadataImplementor;
import org.hibernate.metamodel.source.MetadataSourceProcessor;
import org.hibernate.metamodel.source.binder.Binder;
import org.hibernate.metamodel.source.hbm.EntityHierarchyImpl;
import org.hibernate.metamodel.source.hbm.HibernateMappingProcessor;
import org.hibernate.metamodel.source.hbm.HierarchyBuilder;
import org.hibernate.metamodel.source.hbm.MappingDocument;

public class HbmMetadataSourceProcessorImpl
implements MetadataSourceProcessor {
    private final MetadataImplementor metadata;
    private List<HibernateMappingProcessor> processors = new ArrayList<HibernateMappingProcessor>();
    private List<EntityHierarchyImpl> entityHierarchies;

    public HbmMetadataSourceProcessorImpl(MetadataImplementor metadata) {
        this.metadata = metadata;
    }

    @Override
    public void prepare(MetadataSources sources) {
        HierarchyBuilder hierarchyBuilder = new HierarchyBuilder();
        for (JaxbRoot jaxbRoot : sources.getJaxbRootList()) {
            if (!JaxbHibernateMapping.class.isInstance(jaxbRoot.getRoot())) continue;
            MappingDocument mappingDocument = new MappingDocument(jaxbRoot, this.metadata);
            this.processors.add(new HibernateMappingProcessor(this.metadata, mappingDocument));
            hierarchyBuilder.processMappingDocument(mappingDocument);
        }
        this.entityHierarchies = hierarchyBuilder.groupEntityHierarchies();
    }

    @Override
    public void processIndependentMetadata(MetadataSources sources) {
        for (HibernateMappingProcessor processor : this.processors) {
            processor.processIndependentMetadata();
        }
    }

    @Override
    public void processTypeDependentMetadata(MetadataSources sources) {
        for (HibernateMappingProcessor processor : this.processors) {
            processor.processTypeDependentMetadata();
        }
    }

    @Override
    public void processMappingMetadata(MetadataSources sources, List<String> processedEntityNames) {
        Binder binder = new Binder(this.metadata, processedEntityNames);
        for (EntityHierarchyImpl entityHierarchy : this.entityHierarchies) {
            binder.processEntityHierarchy(entityHierarchy);
        }
    }

    @Override
    public void processMappingDependentMetadata(MetadataSources sources) {
        for (HibernateMappingProcessor processor : this.processors) {
            processor.processMappingDependentMetadata();
        }
    }
}

