/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.frequency;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.data.SampleCategoryModel;
import fr.ifremer.tutti.persistence.entities.protocol.SpeciesProtocol;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.type.WeightUnit;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.FrequencyConfigurationMode;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.BenthosBatchRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.frequency.BenthosFrequencyCellComponent;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.frequency.BenthosFrequencyRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.frequency.BenthosFrequencyTableModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.frequency.BenthosFrequencyUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.frequency.BenthosFrequencyUIModel;
import fr.ifremer.tutti.ui.swing.util.TuttiBeanMonitor;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import fr.ifremer.tutti.ui.swing.util.table.AbstractTuttiTableUIHandler;
import fr.ifremer.tutti.util.Numbers;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import jaxx.runtime.swing.editor.bean.BeanFilterableComboBox;
import jaxx.runtime.validator.swing.SwingValidator;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.table.DefaultTableColumnModelExt;
import org.jdesktop.swingx.table.TableColumnModelExt;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.swing.ApplicationUI;
import org.nuiton.jaxx.application.swing.util.Cancelable;
import org.nuiton.validator.bean.simple.SimpleBeanValidator;

public class BenthosFrequencyUIHandler
extends AbstractTuttiTableUIHandler<BenthosFrequencyRowModel, BenthosFrequencyUIModel, BenthosFrequencyUI>
implements Cancelable {
    private static final Log log = LogFactory.getLog(BenthosFrequencyUIHandler.class);
    private BenthosFrequencyCellComponent.FrequencyCellEditor frequencyEditor;
    private Map<Integer, SpeciesProtocol> speciesProtocol;
    private Map<String, Caracteristic> lengthStepCaracteristics;
    protected WeightUnit weightUnit;

    public BenthosFrequencyUIHandler() {
        super("lengthStep", "number", "weight");
    }

    public BenthosFrequencyTableModel getTableModel() {
        return (BenthosFrequencyTableModel)((Object)this.getTable().getModel());
    }

    @Override
    public JXTable getTable() {
        return ((BenthosFrequencyUI)this.ui).getTable();
    }

    @Override
    protected boolean isRowValid(BenthosFrequencyRowModel row) {
        return row.getLengthStepCaracteristic() != null && row.getLengthStep() != null && row.getLengthStep().floatValue() > 0.0f && (row.getNumber() == null && row.getWeight() == null || row.getNumber() != null && row.getNumber() > 0 && (((BenthosFrequencyUIModel)((Object)this.getModel())).getNbRowsWithWeight() == 0 || row.getWeight() != null && row.getWeight().floatValue() > 0.0f));
    }

    @Override
    protected void onModelRowsChanged(List<BenthosFrequencyRowModel> rows) {
        super.onModelRowsChanged(rows);
        BenthosFrequencyUIModel model = (BenthosFrequencyUIModel)((Object)this.getModel());
        model.setEmptyRows(Sets.newHashSet());
        if (CollectionUtils.isNotEmpty(rows)) {
            for (BenthosFrequencyRowModel row : rows) {
                model.updateRowWithWeight(row);
            }
            for (BenthosFrequencyRowModel row : rows) {
                this.recomputeRowValidState(row);
            }
        }
        model.recomputeTotalNumberAndWeight();
    }

    @Override
    protected void onRowModified(int rowIndex, BenthosFrequencyRowModel row, String propertyName, Object oldValue, Object newValue) {
        boolean recomputeAllRows;
        BenthosFrequencyUIModel model = (BenthosFrequencyUIModel)((Object)this.getModel());
        int nbRowsWithWeight = model.getNbRowsWithWeight();
        model.updateRowWithWeight(row);
        boolean bl = recomputeAllRows = nbRowsWithWeight != model.getNbRowsWithWeight();
        if (recomputeAllRows) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Revalidate all rows");
            }
            for (BenthosFrequencyRowModel r : model.getRows()) {
                this.recomputeRowValidState(r);
            }
        }
        model.recomputeTotalNumberAndWeight();
        if (!recomputeAllRows) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Revalidate the single selected row");
            }
            this.recomputeRowValidState(row);
        }
        model.updateEmptyRow(row);
    }

    @Override
    protected void saveSelectedRowIfRequired(TuttiBeanMonitor<BenthosFrequencyRowModel> rowMonitor, BenthosFrequencyRowModel row) {
    }

    @Override
    protected void onRowValidStateChanged(int rowIndex, BenthosFrequencyRowModel row, Boolean oldValue, Boolean newValue) {
        super.onRowValidStateChanged(rowIndex, row, oldValue, newValue);
        ((BenthosFrequencyUI)this.ui).getValidator().doValidate();
    }

    public SwingValidator<BenthosFrequencyUIModel> getValidator() {
        return ((BenthosFrequencyUI)this.ui).getValidator();
    }

    public void beforeInit(BenthosFrequencyUI ui) {
        super.beforeInit((ApplicationUI)ui);
        this.weightUnit = this.getConfig().getBenthosWeightUnit();
        SampleCategoryModel sampleCategoryModel = this.getDataContext().getSampleCategoryModel();
        BenthosFrequencyUIModel model = new BenthosFrequencyUIModel(this.weightUnit, sampleCategoryModel);
        ((BenthosFrequencyUI)this.ui).setContextValue(model);
    }

    public void afterInit(BenthosFrequencyUI ui) {
        this.initUI(ui);
        ArrayList lengthStepCaracterics = Lists.newArrayList((Iterable)this.getDataContext().getLengthStepCaracteristics());
        this.lengthStepCaracteristics = TuttiEntities.splitById((Iterable)lengthStepCaracterics);
        BenthosFrequencyUIModel model = (BenthosFrequencyUIModel)((Object)this.getModel());
        this.speciesProtocol = this.getContext().isProtocolFilled() ? this.getContext().getPersistenceService().toBenthosProtocolMap() : Maps.newHashMap();
        Caracteristic modelCaracteristic = model.getLengthStepCaracteristic();
        this.initBeanFilterableComboBox(ui.getLengthStepCaracteristicComboBox(), lengthStepCaracterics, modelCaracteristic);
        float step = this.getStep(modelCaracteristic);
        model.setStep(step);
        model.setMinStep(null);
        model.setMaxStep(null);
        ui.getRafaleStepField().getTextField().addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    e.consume();
                    Float step = (Float)((BenthosFrequencyUI)BenthosFrequencyUIHandler.this.ui).getRafaleStepField().getModel();
                    BenthosFrequencyUIHandler.this.applyRafaleStep(step);
                    JTextField field = (JTextField)e.getSource();
                    field.selectAll();
                }
            }
        });
        model.addPropertyChangeListener("lengthStepCaracteristic", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Caracteristic newValue = (Caracteristic)evt.getNewValue();
                float step = BenthosFrequencyUIHandler.this.getStep(newValue);
                ((BenthosFrequencyUIModel)((Object)BenthosFrequencyUIHandler.this.getModel())).setStep(step);
                if (((BenthosFrequencyUIModel)((Object)BenthosFrequencyUIHandler.this.getModel())).getRows() != null) {
                    for (BenthosFrequencyRowModel rowModel : ((BenthosFrequencyUIModel)((Object)BenthosFrequencyUIHandler.this.getModel())).getRows()) {
                        rowModel.setLengthStepCaracteristic(newValue);
                        BenthosFrequencyUIHandler.this.recomputeRowValidState(rowModel);
                    }
                }
                ((BenthosFrequencyUI)BenthosFrequencyUIHandler.this.ui).getValidator().doValidate();
            }
        });
        model.addPropertyChangeListener("configurationMode", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                final FrequencyConfigurationMode newValue = (FrequencyConfigurationMode)((Object)evt.getNewValue());
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JComponent componentToFocus = BenthosFrequencyUIHandler.this.getComponentToFocus(newValue);
                        if (componentToFocus != null) {
                            componentToFocus.grabFocus();
                        }
                    }
                });
            }
        });
        JXTable table = this.getTable();
        DefaultTableColumnModelExt columnModel = new DefaultTableColumnModelExt();
        this.addFloatColumnToModel((TableColumnModel)columnModel, BenthosFrequencyTableModel.LENGTH_STEP, "\\d{0,6}(\\.\\d{0,1})?", (JTable)table);
        this.addIntegerColumnToModel((TableColumnModel)columnModel, BenthosFrequencyTableModel.NUMBER, "\\d{0,6}", (JTable)table);
        this.addFloatColumnToModel((TableColumnModel)columnModel, BenthosFrequencyTableModel.WEIGHT, this.weightUnit, (JTable)table);
        BenthosFrequencyTableModel tableModel = new BenthosFrequencyTableModel(this.weightUnit, (TableColumnModelExt)columnModel, model);
        table.setModel((TableModel)((Object)tableModel));
        table.setColumnModel((TableColumnModel)columnModel);
        this.initTable(table);
        this.installTableKeyListener((TableColumnModel)columnModel, (JTable)table);
        this.listenValidatorValid((SimpleBeanValidator)ui.getValidator(), model);
    }

    protected JComponent getComponentToFocus() {
        FrequencyConfigurationMode configurationMode = ((BenthosFrequencyUIModel)((Object)this.getModel())).getConfigurationMode();
        BeanFilterableComboBox<Caracteristic> componentToFocus = this.getComponentToFocus(configurationMode);
        if (componentToFocus == null) {
            componentToFocus = ((BenthosFrequencyUI)this.getUI()).getLengthStepCaracteristicComboBox();
        }
        return componentToFocus;
    }

    public void onCloseUI() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("closing: " + this.ui));
        }
        this.frequencyEditor = null;
        ((BenthosFrequencyUI)this.ui).getValidator().setBean(null);
        ((BenthosFrequencyUIModel)((Object)this.getModel())).setValid(false);
        ((BenthosFrequencyUIModel)((Object)this.getModel())).setSimpleCount(null);
        EditCatchesUI parent = (EditCatchesUI)this.getParentContainer(EditCatchesUI.class);
        parent.getHandler().setBenthosSelectedCard("main");
    }

    public void cancel() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Cancel UI " + this.ui));
        }
        this.closeUI((TuttiUI)this.ui);
    }

    public void addLengthStepCaracteristic() {
        List allNumericCaracteristic = this.getPersistenceService().getAllNumericCaracteristic();
        ArrayList toSelect = Lists.newArrayList((Iterable)allNumericCaracteristic);
        List knownCaracteristics = ((BenthosFrequencyUI)this.getUI()).getLengthStepCaracteristicComboBox().getData();
        toSelect.removeAll(knownCaracteristics);
        BeanFilterableComboBox editor = new BeanFilterableComboBox();
        editor.setBeanType(Caracteristic.class);
        editor.setShowReset(Boolean.valueOf(true));
        this.initBeanFilterableComboBox(editor, toSelect, null);
        int response = JOptionPane.showConfirmDialog(this.getTopestUI(), editor, I18n.t((String)"tutti.editBenthosFrequencies.title.addLengthStepCaracteristic", (Object[])new Object[0]), 2);
        Caracteristic selectedItem = response == 0 ? (Caracteristic)editor.getSelectedItem() : null;
        ((BenthosFrequencyUIModel)((Object)this.getModel())).setLengthStepCaracteristic(selectedItem);
    }

    public void generateLengthSteps() {
        BenthosFrequencyUIModel model = (BenthosFrequencyUIModel)((Object)this.getModel());
        BenthosFrequencyTableModel tableModel = this.getTableModel();
        Map<Float, BenthosFrequencyRowModel> rowsByStep = this.getTableModel().getRowCache();
        Float minStep = Float.valueOf(model.getLengthStep(model.getMinStep().floatValue()));
        Float maxStep = Float.valueOf(model.getLengthStep(model.getMaxStep().floatValue()));
        Caracteristic lengthStepCaracteristic = model.getLengthStepCaracteristic();
        HashSet existingKeys = Sets.newHashSet(rowsByStep.keySet());
        ArrayList rows = Lists.newArrayList(rowsByStep.values());
        float i = minStep.floatValue();
        float step = model.getStep();
        while (i <= maxStep.floatValue()) {
            if (!existingKeys.contains(Float.valueOf(i))) {
                BenthosFrequencyRowModel newRow = tableModel.createNewRow();
                newRow.setLengthStep(Float.valueOf(i));
                newRow.setLengthStepCaracteristic(lengthStepCaracteristic);
                rows.add(newRow);
            }
            i = Numbers.getRoundedLengthStep((float)(i + step), (boolean)true);
        }
        Collections.sort(rows);
        model.setRows(rows);
        TuttiUIUtil.doSelectCell((JTable)((BenthosFrequencyUI)this.getUI()).getTable(), (int)0, (int)1);
    }

    public void applyRafaleStep(Float step) {
        int rowIndex;
        float aroundLengthStep;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Will apply rafale step: " + step));
        }
        BenthosFrequencyUIModel model = (BenthosFrequencyUIModel)((Object)this.getModel());
        BenthosFrequencyTableModel tableModel = this.getTableModel();
        Map<Float, BenthosFrequencyRowModel> rowsByStep = tableModel.getRowCache();
        BenthosFrequencyRowModel row = rowsByStep.get(Float.valueOf(aroundLengthStep = model.getLengthStep(step.floatValue())));
        if (row != null) {
            Integer number = row.getNumber();
            row.setNumber((number == null ? 0 : number) + 1);
            rowIndex = tableModel.updateRow((Serializable)((Object)row));
        } else {
            row = tableModel.createNewRow();
            row.setLengthStep(Float.valueOf(aroundLengthStep));
            row.setNumber(1);
            row.setValid(this.isRowValid(row));
            ArrayList steps = Lists.newArrayList(rowsByStep.keySet());
            steps.add(Float.valueOf(aroundLengthStep));
            Collections.sort(steps);
            rowIndex = steps.indexOf(Float.valueOf(aroundLengthStep));
            tableModel.addNewRow(rowIndex, (Serializable)((Object)row));
        }
        Integer totalNumber = model.getTotalNumber();
        if (totalNumber == null) {
            totalNumber = 0;
        }
        model.setTotalNumber(totalNumber + 1);
        this.getTable().scrollRowToVisible(rowIndex);
    }

    public void editBatch(BenthosFrequencyCellComponent.FrequencyCellEditor editor) {
        Integer number;
        Integer taxonId;
        SpeciesProtocol speciesProtocol;
        BenthosBatchRowModel speciesBatch = editor.getEditRow();
        BenthosFrequencyUIModel model = (BenthosFrequencyUIModel)((Object)this.getModel());
        model.clearWithWeightRows();
        model.setNextEditableRowIndex(editor.getNextEditableRowIndex());
        model.setTotalNumber(null);
        model.setTotalComputedWeight(null);
        model.setTotalWeight(speciesBatch.getWeight());
        model.setSimpleCount(null);
        model.setMinStep(null);
        model.setMaxStep(null);
        this.frequencyEditor = editor;
        Caracteristic lengthStepCaracteristic = null;
        ArrayList editFrequency = Lists.newArrayList();
        if (speciesBatch != null) {
            Species species;
            SpeciesProtocol sProtocol;
            List<BenthosFrequencyRowModel> previousFrequency;
            Float lengthStep;
            List<BenthosFrequencyRowModel> frequency = speciesBatch.getFrequency();
            if (CollectionUtils.isNotEmpty(frequency)) {
                BenthosFrequencyTableModel tableModel = this.getTableModel();
                for (BenthosFrequencyRowModel rowModel : frequency) {
                    BenthosFrequencyRowModel newRow = tableModel.createNewRow();
                    newRow.setLengthStepCaracteristic(rowModel.getLengthStepCaracteristic());
                    newRow.setLengthStep(rowModel.getLengthStep());
                    newRow.setNumber(rowModel.getNumber());
                    newRow.setWeight(rowModel.getWeight());
                    editFrequency.add(newRow);
                }
                BenthosFrequencyRowModel rowModel = frequency.get(0);
                lengthStepCaracteristic = rowModel.getLengthStepCaracteristic();
                lengthStep = rowModel.getLengthStep();
                if (log.isInfoEnabled()) {
                    log.info((Object)("Use existing lengthStep caracteristic / step " + this.decorate((Serializable)lengthStepCaracteristic) + " / " + lengthStep));
                }
            }
            BenthosBatchRowModel previousSiblingRow = this.frequencyEditor.getPreviousSiblingRow();
            if (lengthStepCaracteristic == null && previousSiblingRow != null && CollectionUtils.isNotEmpty(previousFrequency = previousSiblingRow.getFrequency())) {
                BenthosFrequencyRowModel rowModel;
                rowModel = previousFrequency.get(0);
                lengthStepCaracteristic = rowModel.getLengthStepCaracteristic();
                lengthStep = rowModel.getLengthStep();
                if (log.isInfoEnabled()) {
                    log.info((Object)("Use previous sibling existing lengthStep caracteristic / step " + this.decorate((Serializable)lengthStepCaracteristic) + " / " + lengthStep));
                }
            }
            if (lengthStepCaracteristic == null && (sProtocol = this.speciesProtocol.get((species = speciesBatch.getSpecies()).getReferenceTaxonId())) != null) {
                String lengthStepPmfmId = sProtocol.getLengthStepPmfmId();
                lengthStepCaracteristic = this.lengthStepCaracteristics.get(lengthStepPmfmId);
                lengthStep = sProtocol.getLengthStep();
                if (log.isInfoEnabled()) {
                    log.info((Object)("Use existing from protocol lengthStep caracteristic / step " + this.decorate((Serializable)lengthStepCaracteristic) + " / " + lengthStep));
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Will edit batch row: " + speciesBatch + " with " + editFrequency.size() + " frequency"));
        }
        FrequencyConfigurationMode mode = FrequencyConfigurationMode.AUTO_GEN;
        if (lengthStepCaracteristic == null && ((speciesProtocol = this.speciesProtocol.get(taxonId = speciesBatch.getSpecies().getReferenceTaxonId())) == null || speciesProtocol.getLengthStepPmfmId() == null)) {
            mode = FrequencyConfigurationMode.SIMPLE_COUNTING;
        }
        if ((number = speciesBatch.getNumber()) != null && editFrequency.isEmpty()) {
            mode = FrequencyConfigurationMode.SIMPLE_COUNTING;
            model.setSimpleCount(number);
        }
        model.setConfigurationMode(null);
        model.setConfigurationMode(mode);
        ((BenthosFrequencyUI)this.ui).getValidator().setBean((Object)model);
        Collections.sort(editFrequency);
        model.setLengthStepCaracteristic(lengthStepCaracteristic);
        model.setRows(editFrequency);
        model.setBatch(speciesBatch);
    }

    public void reset() {
        ((BenthosFrequencyUIModel)((Object)this.getModel())).setRows(Lists.newArrayList());
    }

    public void saveAndClose() {
        boolean doSave;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Save And Close UI " + this.ui));
        }
        if (doSave = this.canSaveFrequencies()) {
            this.frequencyEditor.save((BenthosFrequencyUIModel)((Object)this.getModel()), true);
            this.closeUI((TuttiUI)this.ui);
        }
    }

    public void saveAndContinue() {
        boolean doSave;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Save And Continue UI " + this.ui));
        }
        if (doSave = this.canSaveFrequencies()) {
            this.frequencyEditor.save((BenthosFrequencyUIModel)((Object)this.getModel()), false);
        }
    }

    protected JComponent getComponentToFocus(FrequencyConfigurationMode mode) {
        BeanFilterableComboBox<Caracteristic> componentToFocus = null;
        if (mode != null) {
            boolean withLengthStepCaracteristic = ((BenthosFrequencyUIModel)((Object)this.getModel())).getLengthStepCaracteristic() != null;
            switch (mode) {
                case AUTO_GEN: {
                    if (withLengthStepCaracteristic) {
                        componentToFocus = ((BenthosFrequencyUI)this.ui).getMinStepField();
                        break;
                    }
                    componentToFocus = ((BenthosFrequencyUI)this.ui).getLengthStepCaracteristicComboBox();
                    break;
                }
                case RAFALE: {
                    if (withLengthStepCaracteristic) {
                        componentToFocus = ((BenthosFrequencyUI)this.ui).getRafaleStepField();
                        break;
                    }
                    componentToFocus = ((BenthosFrequencyUI)this.ui).getLengthStepCaracteristicComboBox();
                    break;
                }
                case SIMPLE_COUNTING: {
                    componentToFocus = ((BenthosFrequencyUI)this.ui).getSimpleCountingField();
                    break;
                }
                default: {
                    componentToFocus = null;
                }
            }
        }
        return componentToFocus;
    }

    protected boolean canSaveFrequencies() {
        boolean doSave = true;
        HashSet lengths = Sets.newHashSet();
        Float doublon = null;
        int index = 0;
        List rows = ((BenthosFrequencyUIModel)((Object)this.getModel())).getRows();
        for (BenthosFrequencyRowModel row : rows) {
            Float lengthStep = row.getLengthStep();
            if (!lengths.add(lengthStep)) {
                doublon = lengthStep;
                break;
            }
            ++index;
        }
        if (doublon != null) {
            String message = I18n.t((String)"tutti.editBenthosFrequencies.error.length.doublon", (Object[])new Object[]{doublon, index + 1});
            this.getContext().getErrorHelper().showErrorDialog(message);
            TuttiUIUtil.selectFirstCellOnRow((JXTable)this.getTable(), (int)index, (boolean)false);
            doSave = false;
        }
        if (doSave && ((BenthosFrequencyUIModel)((Object)this.getModel())).isSomeRowsWithWeightAndOtherWithout()) {
            String htmlMessage = String.format("<html>%s<hr/><br/>%s</html>", I18n.t((String)"tutti.editBenthosFrequencies.askBeforeSave.message", (Object[])new Object[0]), I18n.t((String)"tutti.editBenthosFrequencies.askBeforeSave.help", (Object[])new Object[0]));
            int answer = JOptionPane.showConfirmDialog(this.getTopestUI(), htmlMessage, I18n.t((String)"tutti.editBenthosFrequencies.askBeforeSave.title", (Object[])new Object[0]), 0, 3);
            switch (answer) {
                case 0: {
                    break;
                }
                default: {
                    doSave = false;
                }
            }
        }
        return doSave;
    }

    protected float getStep(Caracteristic caracteristic) {
        Float precision = null;
        if (caracteristic != null) {
            precision = caracteristic.getPrecision();
        }
        if (precision == null) {
            precision = Float.valueOf(1.0f);
        }
        return precision.floatValue();
    }
}

