/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.action;

import com.google.common.base.Preconditions;
import fr.ifremer.tutti.persistence.ProgressionModel;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.ui.swing.action.AbstractTuttiAction;
import fr.ifremer.tutti.ui.swing.content.cruise.ValidateCruiseUI;
import fr.ifremer.tutti.ui.swing.content.cruise.ValidateCruiseUIHandler;
import fr.ifremer.tutti.ui.swing.content.cruise.ValidateCruiseUIModel;
import java.awt.Component;
import java.util.List;
import javax.swing.JOptionPane;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class SaveCruiseToReadyToSynchAction
extends AbstractTuttiAction<ValidateCruiseUIModel, ValidateCruiseUI, ValidateCruiseUIHandler> {
    private static final Log log = LogFactory.getLog(SaveCruiseToReadyToSynchAction.class);

    public SaveCruiseToReadyToSynchAction(ValidateCruiseUIHandler handler) {
        super(handler, false);
        this.setActionDescription(I18n.t((String)"tutti.validationCruise.action.saveCruiseToReadyToSynch.tip", (Object[])new Object[0]));
    }

    public boolean prepareAction() throws Exception {
        boolean doAction = super.prepareAction();
        if (doAction) {
            int answer = JOptionPane.showConfirmDialog((Component)this.getContext().getActionUI(), I18n.t((String)"tutti.validationCruise.action.saveCruiseToReadyToSynch.message", (Object[])new Object[0]), I18n.t((String)"tutti.validationCruise.action.saveCruiseToReadyToSynch.title", (Object[])new Object[0]), 0);
            doAction = answer == 0;
        }
        PersistenceService persistenceService = this.getContext().getPersistenceService();
        int fishingOperationCount = persistenceService.getFishingOperationCount(((ValidateCruiseUIModel)this.getModel()).getCruise().getId());
        this.createProgressionModelIfRequired(fishingOperationCount + 1);
        return doAction;
    }

    @Override
    public void doAction() throws Exception {
        Preconditions.checkState((boolean)this.getContext().isProgramFilled());
        Preconditions.checkState((boolean)this.getContext().isCruiseFilled());
        PersistenceService persistenceService = this.getContext().getPersistenceService();
        ProgressionModel progressionModel = this.getProgressionModel();
        List allFishingOperation = persistenceService.getAllFishingOperationIds(((ValidateCruiseUIModel)this.getModel()).getCruise().getId());
        for (String fishingOperationId : allFishingOperation) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Recompute sample ratios for operation " + fishingOperationId));
            }
            persistenceService.recomputeCatchBatchSampleRatios(fishingOperationId);
            progressionModel.increments("Recalcul des poids r\u00e9f\u00e9rents pour l'op\u00e9ration " + fishingOperationId);
        }
        Integer cruiseId = ((ValidateCruiseUIModel)this.getModel()).getCruise().getIdAsInt();
        if (log.isInfoEnabled()) {
            log.info((Object)("Pass synchronizationStatus to *ready to synch* for cruise: " + cruiseId));
        }
        progressionModel.increments("Mise en place des donn\u00e9es synchronisables");
        persistenceService.setCruiseReadyToSynch(cruiseId);
    }

    public void postSuccessAction() {
        super.postSuccessAction();
        this.getDataContext().reloadCruise();
        ((ValidateCruiseUIModel)this.getModel()).setCruise(this.getDataContext().getCruise());
    }
}

