/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches.species;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import fr.ifremer.adagio.core.dao.referential.pmfm.ObjectTypeCode2;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.data.Attachment;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.data.SampleCategory;
import fr.ifremer.tutti.persistence.entities.data.SampleCategoryModel;
import fr.ifremer.tutti.persistence.entities.data.SampleCategoryModelEntry;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatch;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatchFrequency;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatchs;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.type.WeightUnit;
import fr.ifremer.tutti.ui.swing.content.operation.catches.SampleCategoryAble;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyRowModel;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiBeanUIModel;
import fr.ifremer.tutti.ui.swing.util.attachment.AttachmentModelAware;
import fr.ifremer.tutti.ui.swing.util.computable.ComputableData;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.nuiton.util.beans.Binder;
import org.nuiton.util.beans.BinderFactory;

public class SpeciesBatchRowModel
extends AbstractTuttiBeanUIModel<SpeciesBatch, SpeciesBatchRowModel>
implements SpeciesBatch,
AttachmentModelAware,
SampleCategoryAble<SpeciesBatchRowModel> {
    private static final long serialVersionUID = 1L;
    public static final String PROPERTY_SPECIES_ROW = "speciesRow";
    public static final String PROPERTY_SAMPLE_CATEGORY = "sampleCategory";
    public static final String PROPERTY_SAMPLE_CATEGORY_VALUE = "sampleCategoryValue";
    public static final String PROPERTY_SAMPLE_CATEGORY_WEIGHT = "sampleCategoryWeight";
    public static final String PROPERTY_SAMPLE_CATEGORY_COMPUTED_WEIGHT = "sampleCategoryComputedWeight";
    public static final String PROPERTY_FREQUENCY = "frequency";
    public static final String PROPERTY_COMPUTED_NUMBER = "computedOrNotNumber";
    public static final String PROPERTY_COMPUTED_WEIGHT = "computedOrNotWeight";
    public static final String PROPERTY_CHILD_BATCH = "childBatch";
    public static final String PROPERTY_BATCH_LEAF = "batchLeaf";
    public static final String PROPERTY_BATCH_ROOT = "batchRoot";
    protected final SpeciesBatch editObject = SpeciesBatchs.newSpeciesBatch();
    protected final SampleCategory<?>[] categories;
    protected ComputableData<Float> computedOrNotWeight = new ComputableData();
    protected ComputableData<Integer> computedOrNotNumber = new ComputableData();
    protected final List<Attachment> attachment = Lists.newArrayList();
    protected List<SpeciesFrequencyRowModel> frequency = Lists.newArrayList();
    protected List<SpeciesBatchRowModel> childBatch;
    protected final SampleCategoryModel sampleCategoryModel;
    protected final WeightUnit weightUnit;
    protected static final Binder<SpeciesBatch, SpeciesBatchRowModel> fromBeanBinder = BinderFactory.newBinder(SpeciesBatch.class, SpeciesBatchRowModel.class);
    protected static final Binder<SpeciesBatchRowModel, SpeciesBatch> toBeanBinder = BinderFactory.newBinder(SpeciesBatchRowModel.class, SpeciesBatch.class);

    public SpeciesBatchRowModel(WeightUnit weightUnit, SampleCategoryModel sampleCategoryModel) {
        super(fromBeanBinder, toBeanBinder);
        this.weightUnit = weightUnit;
        this.sampleCategoryModel = sampleCategoryModel;
        this.categories = new SampleCategory[sampleCategoryModel.getNbSampling()];
        for (int i = 0; i < this.categories.length; ++i) {
            SampleCategory category;
            SampleCategoryModelEntry entry = sampleCategoryModel.getCategoryByIndex(i);
            this.categories[i] = category = SampleCategory.newSample((SampleCategoryModelEntry)entry);
        }
        this.computedOrNotWeight.addPropagateListener("weight", this);
        this.computedOrNotWeight.addPropagateListener(PROPERTY_COMPUTED_WEIGHT, this);
        this.computedOrNotNumber.addPropagateListener("number", this);
        this.computedOrNotNumber.addPropagateListener(PROPERTY_COMPUTED_NUMBER, this);
    }

    public SpeciesBatchRowModel getSpeciesRow() {
        return this;
    }

    public SpeciesBatchRowModel(WeightUnit weightUnit, SampleCategoryModel sampleCategoryModel, SpeciesBatch aBatch, List<SpeciesBatchFrequency> frequencies) {
        this(weightUnit, sampleCategoryModel);
        this.fromEntity(aBatch);
        List<SpeciesFrequencyRowModel> frequencyRows = SpeciesFrequencyRowModel.fromEntity(weightUnit, frequencies);
        this.frequency.addAll(frequencyRows);
        Collections.sort(this.frequency);
    }

    @Override
    protected SpeciesBatch newEntity() {
        return SpeciesBatchs.newSpeciesBatch();
    }

    @Override
    public void fromEntity(SpeciesBatch entity) {
        super.fromEntity(entity);
        this.setWeight(this.weightUnit.fromEntity(this.getWeight()));
        this.setComputedWeight(this.weightUnit.fromEntity(this.getComputedWeight()));
    }

    @Override
    public SpeciesBatch toEntity() {
        SpeciesBatch result = (SpeciesBatch)super.toEntity();
        result.setWeight(this.weightUnit.toEntity(this.getWeight()));
        SampleCategory sampleCategory = this.getFinestCategory();
        Preconditions.checkNotNull((Object)sampleCategory);
        Preconditions.checkNotNull((Object)sampleCategory.getCategoryId());
        Preconditions.checkNotNull((Object)sampleCategory.getCategoryValue());
        result.setSampleCategoryId(sampleCategory.getCategoryId());
        result.setSampleCategoryValue(sampleCategory.getCategoryValue());
        Float categoryWeight = sampleCategory.getCategoryWeight();
        result.setSampleCategoryWeight(this.weightUnit.toEntity(categoryWeight));
        return result;
    }

    public Species getSpecies() {
        return this.editObject.getSpecies();
    }

    public void setSpecies(Species species) {
        Species oldCategory = this.getSpecies();
        this.editObject.setSpecies(species);
        this.firePropertyChange("species", oldCategory, species);
    }

    public String getComment() {
        return this.editObject.getComment();
    }

    public void setComment(String comment) {
        String oldValue = this.getComment();
        this.editObject.setComment(comment);
        this.firePropertyChange("comment", oldValue, comment);
    }

    public boolean isSpeciesToConfirm() {
        return this.editObject.isSpeciesToConfirm();
    }

    public void setSpeciesToConfirm(boolean speciesToConfirm) {
        boolean oldValue = this.isSpeciesToConfirm();
        this.editObject.setSpeciesToConfirm(speciesToConfirm);
        this.firePropertyChange("speciesToConfirm", oldValue, speciesToConfirm);
    }

    public Integer getComputedNumber() {
        return this.computedOrNotNumber.getComputedData();
    }

    public void setComputedNumber(Integer computedNumber) {
        this.computedOrNotNumber.setComputedData(computedNumber);
    }

    public Float getComputedWeight() {
        return this.computedOrNotWeight.getComputedData();
    }

    public void setComputedWeight(Float computedWeight) {
        this.computedOrNotWeight.setComputedData(computedWeight);
    }

    public FishingOperation getFishingOperation() {
        return this.editObject.getFishingOperation();
    }

    public void setFishingOperation(FishingOperation fishingOperation) {
        this.editObject.setFishingOperation(fishingOperation);
    }

    public SpeciesBatchRowModel getParentBatch() {
        return (SpeciesBatchRowModel)this.editObject.getParentBatch();
    }

    public void setParentBatch(SpeciesBatch parentBatch) {
        SpeciesBatchRowModel oldValue = this.getParentBatch();
        this.editObject.setParentBatch(parentBatch);
        this.firePropertyChange("parentBatch", oldValue, parentBatch);
        this.firePropertyChange(PROPERTY_BATCH_ROOT, null, this.isBatchRoot());
    }

    public Float getWeight() {
        return this.computedOrNotWeight.getData();
    }

    public void setWeight(Float weight) {
        this.computedOrNotWeight.setData(weight);
    }

    public Integer getSampleCategoryId() {
        return null;
    }

    public void setSampleCategoryId(Integer sampleCategoryId) {
    }

    public Serializable getSampleCategoryValue() {
        return null;
    }

    public void setSampleCategoryValue(Serializable sampleCategoryValue) {
    }

    public Float getSampleCategoryWeight() {
        return null;
    }

    public void setSampleCategoryWeight(Float sampleCategoryWeight) {
    }

    public Integer getNumber() {
        return this.computedOrNotNumber.getData();
    }

    public void setNumber(Integer number) {
        this.computedOrNotNumber.setData(number);
    }

    public Float getSampleCategoryComputedWeight() {
        return null;
    }

    public void setSampleCategoryComputedWeight(Float sampleCategoryComputedWeight) {
    }

    public SpeciesBatch getChildBatchs(int index) {
        return this.childBatch.get(index);
    }

    public boolean isChildBatchsEmpty() {
        return this.childBatch == null || this.childBatch.isEmpty();
    }

    public int sizeChildBatchs() {
        return this.childBatch == null ? 0 : this.childBatch.size();
    }

    public void addChildBatchs(SpeciesBatch childBatchs) {
    }

    public void addAllChildBatchs(Collection<SpeciesBatch> childBatchs) {
    }

    public boolean removeChildBatchs(SpeciesBatch childBatchs) {
        return false;
    }

    public boolean removeAllChildBatchs(Collection<SpeciesBatch> childBatchs) {
        return false;
    }

    public boolean containsChildBatchs(SpeciesBatch childBatchs) {
        return false;
    }

    public boolean containsAllChildBatchs(Collection<SpeciesBatch> childBatchs) {
        return false;
    }

    public List<SpeciesBatch> getChildBatchs() {
        return null;
    }

    public void setChildBatchs(List<SpeciesBatch> childBatchs) {
    }

    public Integer getRankOrder() {
        return this.editObject.getRankOrder();
    }

    public void setRankOrder(Integer rankOrder) {
        this.editObject.setRankOrder(rankOrder);
    }

    @Override
    public Integer getCategoryIndex(Integer id) {
        SampleCategory<?> category;
        int result = 0;
        SampleCategory<?>[] arr$ = this.categories;
        int len$ = arr$.length;
        for (int i$ = 0; !(i$ >= len$ || (category = arr$[i$]) != null && id.equals(category.getCategoryId())); ++i$) {
            ++result;
        }
        return result;
    }

    @Override
    public void setSampleCategory(SampleCategory sampleCategory) {
        int index = this.getCategoryIndex(sampleCategory.getCategoryId());
        SampleCategory<?> oldCategory = this.categories[index];
        Serializable oldValue = oldCategory.getCategoryValue();
        Float oldWeight = oldCategory.getCategoryWeight();
        Float oldComputedWeight = oldCategory.getComputedWeight();
        this.categories[index] = sampleCategory;
        this.fireIndexedPropertyChange(PROPERTY_SAMPLE_CATEGORY, index, oldCategory, sampleCategory);
        this.fireIndexedPropertyChange(PROPERTY_SAMPLE_CATEGORY_VALUE, index, oldValue, sampleCategory.getCategoryValue());
        this.fireIndexedPropertyChange(PROPERTY_SAMPLE_CATEGORY_WEIGHT, index, oldWeight, sampleCategory.getCategoryWeight());
        this.fireIndexedPropertyChange(PROPERTY_SAMPLE_CATEGORY_COMPUTED_WEIGHT, index, oldComputedWeight, sampleCategory.getComputedWeight());
    }

    @Override
    public SampleCategory<?> getSampleCategoryById(Integer sampleCategoryId) {
        Integer index = this.getCategoryIndex(sampleCategoryId);
        SampleCategory<?> result = index == null ? null : this.categories[index];
        return result;
    }

    @Override
    public SampleCategory<?> getSampleCategoryByIndex(int sampleCategoryIndex) {
        SampleCategory<?> result = this.categories[sampleCategoryIndex];
        return result;
    }

    @Override
    public void setSampleCategoryValue(Integer sampleCategoryId, Serializable value) {
        SampleCategory<?> sampleCategory = this.getSampleCategoryById(sampleCategoryId);
        TuttiEntities.setProperty(sampleCategory, (String)"categoryValue", (Object)value);
        this.firePropertyChange(PROPERTY_SAMPLE_CATEGORY_VALUE, null, sampleCategory);
    }

    @Override
    public void setSampleCategoryWeight(Integer sampleCategoryId, Object value) {
        SampleCategory<?> sampleCategory = this.getSampleCategoryById(sampleCategoryId);
        TuttiEntities.setProperty(sampleCategory, (String)"categoryWeight", (Object)value);
        this.firePropertyChange(PROPERTY_SAMPLE_CATEGORY_WEIGHT, null, sampleCategory);
    }

    @Override
    public SampleCategory getFinestCategory() {
        SampleCategory<?> result = null;
        for (int i = this.categories.length - 1; i > -1; --i) {
            SampleCategory<?> category = this.categories[i];
            if (category == null || !category.isValid()) continue;
            result = category;
            break;
        }
        return result;
    }

    @Override
    public SampleCategory<?> getFirstSampleCategory() {
        return this.categories[0];
    }

    @Override
    public SpeciesBatchRowModel getFirstAncestor(SampleCategory<?> entrySampleCategory) {
        SpeciesBatchRowModel parentBatch;
        SampleCategory<?> parentSampleCategory;
        SampleCategoryAble<SpeciesBatchRowModel> result = this;
        if (this.getParentBatch() != null && Objects.equals(entrySampleCategory, parentSampleCategory = (parentBatch = this.getParentBatch()).getSampleCategoryById(entrySampleCategory.getCategoryId()))) {
            result = parentBatch.getFirstAncestor((SampleCategory)entrySampleCategory);
        }
        return result;
    }

    @Override
    public Iterator<SampleCategory<?>> iterator() {
        return Arrays.asList(this.categories).iterator();
    }

    @Override
    public ObjectTypeCode2 getObjectType() {
        return ObjectTypeCode2.BATCH;
    }

    @Override
    public Integer getObjectId() {
        return this.getIdAsInt();
    }

    @Override
    public List<Attachment> getAttachment() {
        return this.attachment;
    }

    @Override
    public void addAllAttachment(Collection<Attachment> attachments) {
        this.attachment.addAll(attachments);
        this.firePropertyChange("attachment", null, this.getAttachment());
    }

    @Override
    public void addAttachment(Attachment attachment) {
        this.attachment.add(attachment);
        this.firePropertyChange("attachment", null, this.getAttachment());
    }

    @Override
    public void removeAllAttachment(Collection<Attachment> attachments) {
        this.attachment.removeAll(attachments);
        this.firePropertyChange("attachment", null, this.getAttachment());
    }

    @Override
    public void removeAttachment(Attachment attachment) {
        this.attachment.remove(attachment);
        this.firePropertyChange("attachment", null, this.getAttachment());
    }

    public SpeciesBatchRowModel getFirstAncestor(Integer sampleCategoryId) {
        SampleCategory<?> sampleCategory = this.getSampleCategoryById(sampleCategoryId);
        SampleCategoryAble firstAncestor = this.getFirstAncestor((SampleCategory)sampleCategory);
        return firstAncestor;
    }

    public List<SpeciesBatchRowModel> getChildBatch() {
        return this.childBatch;
    }

    public void setChildBatch(List<SpeciesBatchRowModel> childBatch) {
        this.childBatch = childBatch;
        this.firePropertyChange(PROPERTY_CHILD_BATCH, null, childBatch);
        this.firePropertyChange(PROPERTY_BATCH_LEAF, null, this.isBatchLeaf());
    }

    public boolean isBatchLeaf() {
        return CollectionUtils.isEmpty(this.childBatch);
    }

    public boolean isBatchRoot() {
        return this.getParentBatch() == null;
    }

    public List<SpeciesFrequencyRowModel> getFrequency() {
        return this.frequency;
    }

    public void setFrequency(List<SpeciesFrequencyRowModel> frequency) {
        this.frequency = frequency;
        this.firePropertyChange(PROPERTY_FREQUENCY, null, frequency);
    }

    public ComputableData<Integer> getComputedOrNotNumber() {
        return this.computedOrNotNumber;
    }

    public void setComputedOrNotNumber(ComputableData<Integer> computedOrNotNumber) {
        this.computedOrNotNumber = computedOrNotNumber;
    }

    public ComputableData<Float> getComputedOrNotWeight() {
        return this.computedOrNotWeight;
    }

    public void setComputedOrNotWeight(ComputableData<Float> computedOrNotWeight) {
        this.computedOrNotWeight = computedOrNotWeight;
    }

    public void collectShell(Set<SpeciesBatchRowModel> collectedRows) {
        collectedRows.add(this);
        if (!this.isBatchLeaf()) {
            for (SpeciesBatchRowModel batchChild : this.getChildBatch()) {
                collectedRows.add(batchChild);
                batchChild.collectShell(collectedRows);
            }
        }
    }
}

