/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.util;

import java.awt.Color;
import java.lang.reflect.Field;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.SystemUtils;
import org.nuiton.util.MD5InputStream;
import org.nuiton.util.StringUtilException;

public class StringUtil {
    public static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final Character[] openingChars = new Character[]{Character.valueOf('('), Character.valueOf('{'), Character.valueOf('[')};
    private static final Character[] closingChars = new Character[]{Character.valueOf(')'), Character.valueOf('}'), Character.valueOf(']')};
    private static final char[] HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    protected static final double[] timeFactors = new double[]{1000000.0, 1000.0, 60.0, 60.0, 24.0};
    protected static final String[] timeUnites = new String[]{"ns", "ms", "s", "m", "h", "d"};
    protected static final double[] memoryFactors = new double[]{1024.0, 1024.0, 1024.0, 1024.0};
    protected static final String[] memoryUnites = new String[]{"o", "Ko", "Mo", "Go", "To"};

    protected StringUtil() {
    }

    public static boolean isEmail(String str) {
        return str.matches("^[a-zA-Z0-9!#$%&'*+/=?^_`{|}~-]+((\\.[a-zA-Z0-9!#$%&'*+/=?^_`{|}~-]+)?)+@(?:[a-zA-Z0-9](?:[a-zA-Z0-9-]*[a-zA-Z0-9])?\\.)+[a-zA-Z0-9](?:[a-zA-Z0-9\\-]*[a-zA-Z0-9])?$");
    }

    public static String escapeCsvValue(String value, String csvSeparator) {
        boolean valueNeedQuotes;
        boolean bl = valueNeedQuotes = value.contains("\n") || value.contains("\t") || value.contains(",") || value.contains(";") || value.contains("\"") || value.contains(csvSeparator);
        if (valueNeedQuotes) {
            value = value.replaceAll("\"", "\"\"");
            value = "\"" + value + "\"";
        }
        return value;
    }

    public static String join(Iterable<?> iterable, String separator, boolean trim) {
        String result = StringUtil.join(iterable, null, separator, trim);
        return result;
    }

    public static <O> String join(Iterable<O> iterable, ToString<O> ts, String separator, boolean trim) throws NullPointerException {
        if (iterable == null) {
            throw new NullPointerException("null iterable can't be used to join the elements with " + separator);
        }
        if (!iterable.iterator().hasNext()) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        for (O o : iterable) {
            if (o == null) continue;
            String str = ts != null ? ts.toString(o) : o.toString();
            if (trim) {
                str = str.trim();
            }
            builder.append(separator).append(str);
        }
        String result = builder.substring(separator.length());
        return result;
    }

    public static String substring(String s, int begin) {
        String result = StringUtil.substring(s, begin, s.length());
        return result;
    }

    public static String substring(String s, int begin, int end) {
        if (begin < 0) {
            begin = s.length() + begin;
        }
        if (end < 0) {
            end = s.length() + end;
        }
        if (end < begin) {
            end = begin;
        }
        String result = s.substring(begin, end);
        return result;
    }

    public static String[] split(String args, String separator) {
        return StringUtil.split(openingChars, closingChars, args, separator);
    }

    public static String[] split(String stringList) {
        String[] result = StringUtil.split(stringList, ",");
        return result;
    }

    public static String[] split(Character[] openingChars, Character[] closingChars, String args, String separator) {
        if (args == null) {
            return EMPTY_STRING_ARRAY;
        }
        ArrayList<String> result = new ArrayList<String>();
        int start = 0;
        StringBuilder op = new StringBuilder();
        char last = '\u0000';
        List<Character> opening = Arrays.asList(openingChars);
        List<Character> closing = Arrays.asList(closingChars);
        for (int i = 0; i < args.length(); ++i) {
            char c = args.charAt(i);
            if (c == '\\') {
                ++i;
                continue;
            }
            if (last != '\"' && last != '\'') {
                if (opening.contains(Character.valueOf(c))) {
                    op.append(c);
                    continue;
                }
                if (closing.contains(Character.valueOf(c))) {
                    op.deleteCharAt(op.length() - 1);
                    continue;
                }
                if (c == '\"' || c == '\'') {
                    last = c;
                    continue;
                }
                if (op.length() != 0 || !args.regionMatches(i, separator, 0, separator.length())) continue;
                int end = i;
                i += separator.length() - 1;
                String a = args.substring(start, end);
                result.add(a);
                start = end + separator.length();
                continue;
            }
            if (c != last) continue;
            last = '\u0000';
        }
        if (start < args.length()) {
            String a = args.substring(start, args.length());
            result.add(a);
        }
        return result.toArray(new String[result.size()]);
    }

    public static boolean toBoolean(String s) {
        return "true".equalsIgnoreCase(s);
    }

    public static byte toByte(String s) {
        return Byte.parseByte(s);
    }

    public static double toDouble(String s) {
        return Double.parseDouble(s);
    }

    public static float toFloat(String s) {
        return Float.parseFloat(s);
    }

    public static long toLong(String s) {
        return Long.parseLong(s);
    }

    public static short toShort(String s) {
        return Short.parseShort(s);
    }

    public static int toInt(String s) {
        return Integer.parseInt(s);
    }

    public static char toChar(String s) {
        return s.charAt(0);
    }

    public static boolean[] toArrayBoolean(String ... s) {
        boolean[] result = new boolean[s.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = StringUtil.toBoolean(s[i]);
        }
        return result;
    }

    public static byte[] toArrayByte(String ... s) {
        byte[] result = new byte[s.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = StringUtil.toByte(s[i]);
        }
        return result;
    }

    public static double[] toArrayDouble(String ... s) {
        double[] result = new double[s.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = StringUtil.toDouble(s[i]);
        }
        return result;
    }

    public static float[] toArrayFloat(String ... s) {
        float[] result = new float[s.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = StringUtil.toFloat(s[i]);
        }
        return result;
    }

    public static long[] toArrayLong(String ... s) {
        long[] result = new long[s.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = StringUtil.toLong(s[i]);
        }
        return result;
    }

    public static short[] toArrayShort(String ... s) {
        short[] result = new short[s.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = StringUtil.toShort(s[i]);
        }
        return result;
    }

    public static int[] toArrayInt(String ... s) {
        int[] result = new int[s.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = StringUtil.toInt(s[i]);
        }
        return result;
    }

    public static char[] toArrayChar(String ... s) {
        char[] result = new char[s.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = StringUtil.toChar(s[i]);
        }
        return result;
    }

    public static String asHex(byte[] hash) {
        char[] buf = new char[hash.length * 2];
        int x = 0;
        for (int i = 0; i < hash.length; ++i) {
            buf[x++] = HEX_CHARS[hash[i] >>> 4 & 0xF];
            buf[x++] = HEX_CHARS[hash[i] & 0xF];
        }
        return new String(buf);
    }

    public static Color toColor(String s) throws StringUtilException {
        try {
            if (s.startsWith("#")) {
                String hr = s.substring(1, 3);
                String hg = s.substring(3, 5);
                String hb = s.substring(5, 7);
                int r = Integer.parseInt(hr, 16);
                int g = Integer.parseInt(hg, 16);
                int b = Integer.parseInt(hb, 16);
                if (s.length() == 9) {
                    String ha = s.substring(7, 9);
                    int a = Integer.parseInt(ha, 16);
                    return new Color(r, g, b, a);
                }
                return new Color(r, g, b);
            }
            Field f = Color.class.getField(s);
            return (Color)f.get(Color.class);
        }
        catch (NumberFormatException e) {
            throw new StringUtilException("Error during conversion from string to color", e);
        }
        catch (SecurityException e) {
            throw new StringUtilException("Error during conversion from string to color", e);
        }
        catch (NoSuchFieldException e) {
            throw new StringUtilException("Error during conversion from string to color", e);
        }
        catch (IllegalArgumentException e) {
            throw new StringUtilException("Error during conversion from string to color", e);
        }
        catch (IllegalAccessException e) {
            throw new StringUtilException("Error during conversion from string to color", e);
        }
    }

    public static Date toDate(String s) throws ParseException {
        return DateFormat.getDateInstance().parse(s);
    }

    public static String convertTime(long value) {
        return StringUtil.convert(value, timeFactors, timeUnites);
    }

    public static String convertTime(long value, long value2) {
        return StringUtil.convertTime(value2 - value);
    }

    public static String convertMemory(long value) {
        return StringUtil.convert(value, memoryFactors, memoryUnites);
    }

    public static String convert(long value, double[] factors, String[] unites) {
        long sign = value == 0L ? 1L : value / Math.abs(value);
        int i = 0;
        for (double tmp = (double)Math.abs(value); i < factors.length && i < unites.length && tmp > factors[i]; tmp /= factors[i++]) {
        }
        String result = MessageFormat.format("{0,number,0.###}{1}", tmp *= (double)sign, unites[i]);
        return result;
    }

    public static boolean checkEnclosure(String txt, char opener, char closer) {
        if (txt.indexOf(opener) == -1 && txt.indexOf(closer) == -1) {
            return true;
        }
        ArrayList<Integer> opens = new ArrayList<Integer>();
        for (int i = 0; i < txt.length(); ++i) {
            char c = txt.charAt(i);
            if (c == opener) {
                opens.add(i);
                continue;
            }
            if (c != closer) continue;
            if (opens.isEmpty()) {
                return false;
            }
            opens.remove(opens.size() - 1);
        }
        return opens.isEmpty();
    }

    public static String convertToConstantName(String name) {
        StringBuilder sb = new StringBuilder();
        int lastChar = 0;
        int j = name.length();
        for (int i = 0; i < j; ++i) {
            int c = name.charAt(i);
            if (Character.isDigit((char)c)) {
                sb.append((char)c);
                lastChar = c;
                continue;
            }
            if (!Character.isLetter((char)c)) {
                if (lastChar != 95) {
                    sb.append('_');
                }
                lastChar = 95;
                continue;
            }
            if (Character.isUpperCase((char)c)) {
                if (!Character.isUpperCase((char)lastChar) && lastChar != 95) {
                    sb.append('_');
                }
                sb.append((char)c);
            } else {
                sb.append(Character.toUpperCase((char)c));
            }
            lastChar = c;
        }
        String result = sb.toString();
        while (!result.isEmpty() && result.endsWith("_")) {
            result = result.substring(0, result.length() - 1);
        }
        while (!result.isEmpty() && result.startsWith("_")) {
            result = result.substring(1);
        }
        return result;
    }

    public static String encodeMD5(String toEncode) {
        byte[] uniqueKey = toEncode.getBytes();
        byte[] hash = MD5InputStream.getMD5Digest().digest(uniqueKey);
        StringBuilder hashString = new StringBuilder();
        for (byte aHash : hash) {
            String hex = Integer.toHexString(aHash);
            if (hex.length() == 1) {
                hashString.append("0");
                hashString.append(hex.charAt(hex.length() - 1));
                continue;
            }
            hashString.append(hex.substring(hex.length() - 2));
        }
        return hashString.toString();
    }

    public static String encodeSHA1(String toEncode) {
        String result;
        try {
            MessageDigest sha1Md = MessageDigest.getInstance("SHA-1");
            byte[] digest = sha1Md.digest(toEncode.getBytes());
            result = StringUtil.asHex(digest);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new IllegalStateException("Can't find SHA-1 message digest algorithm", ex);
        }
        return result;
    }

    public static String getFileSeparatorRegex() {
        String result = SystemUtils.IS_OS_WINDOWS ? "\\\\" : "/";
        return result;
    }

    public static class ToCSV<O>
    implements ToString<O> {
        protected String csvSeparator;

        public ToCSV(String csvSeparator) {
            this.csvSeparator = csvSeparator;
        }

        @Override
        public String toString(O o) {
            String value = this.getStringValue(o);
            return StringUtil.escapeCsvValue(value, this.csvSeparator);
        }

        public String getStringValue(O o) {
            return o.toString();
        }
    }

    public static interface ToString<O> {
        public String toString(O var1);
    }
}

