package fr.ifremer.tutti.ui.swing.content.operation.catches;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2014 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.ui.swing.TuttiHelpBroker;
import fr.ifremer.tutti.ui.swing.content.operation.FishingOperationsUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.accidental.AccidentalBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.accidental.create.CreateAccidentalBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.BenthosBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.create.CreateBenthosBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.frequency.BenthosFrequencyUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.split.SplitBenthosBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.individualobservation.IndividualObservationBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.individualobservation.create.CreateIndividualObservationBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.marinelitter.MarineLitterBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.marinelitter.create.CreateMarineLitterBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.create.CreateSpeciesBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.split.SplitSpeciesBatchUI;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import fr.ifremer.tutti.ui.swing.util.attachment.ButtonAttachment;
import fr.ifremer.tutti.ui.swing.util.caracteristics.CaracteristicMapEditorUI;
import fr.ifremer.tutti.ui.swing.util.computable.ComputableDataEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.CardLayout2Ext;
import jaxx.runtime.swing.TabInfo;
import jaxx.runtime.swing.TabInfoPropertyChangeListener;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.help.JAXXHelpUI;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import jaxx.runtime.validator.swing.ui.ImageValidationUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTitledPanel;
import static org.nuiton.i18n.I18n.t;

public class EditCatchesUI extends JPanel implements JAXXHelpUI<TuttiHelpBroker>, TuttiUI<EditCatchesUIModel, EditCatchesUIHandler>, JAXXObject, JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_ACCIDENTAL_TAB_FISHING_OPERATION_REMINDER_LABEL_RIGHT_DECORATION = "accidentalTabFishingOperationReminderLabel.rightDecoration";
    public static final String BINDING_BENTHOS_TAB_FISHING_OPERATION_REMINDER_LABEL_RIGHT_DECORATION = "benthosTabFishingOperationReminderLabel.rightDecoration";
    public static final String BINDING_BENTHOS_TOTAL_SAMPLE_SORTED_WEIGHT_FIELD_TEXT = "benthosTotalSampleSortedWeightField.text";
    public static final String BINDING_BENTHOS_TOTAL_SORTED_WEIGHT_FIELD_BEAN = "benthosTotalSortedWeightField.bean";
    public static final String BINDING_BENTHOS_TOTAL_SORTED_WEIGHT_FIELD_MODEL = "benthosTotalSortedWeightField.model";
    public static final String BINDING_BENTHOS_TOTAL_UNSORTED_WEIGHT_FIELD_TEXT = "benthosTotalUnsortedWeightField.text";
    public static final String BINDING_BENTHOS_TOTAL_WEIGHT_FIELD_DISABLED_TEXT_COLOR = "benthosTotalWeightField.disabledTextColor";
    public static final String BINDING_BENTHOS_TOTAL_WEIGHT_FIELD_TEXT = "benthosTotalWeightField.text";
    public static final String BINDING_CATCHES_CARACTERISTICS_ATTACHMENTS_BUTTON_ENABLED = "catchesCaracteristicsAttachmentsButton.enabled";
    public static final String BINDING_CATCH_TOTAL_REJECTED_WEIGHT_FIELD_BEAN = "catchTotalRejectedWeightField.bean";
    public static final String BINDING_CATCH_TOTAL_REJECTED_WEIGHT_FIELD_MODEL = "catchTotalRejectedWeightField.model";
    public static final String BINDING_CATCH_TOTAL_SORTED_CAROUSSEL_WEIGHT_FIELD_TEXT = "catchTotalSortedCarousselWeightField.text";
    public static final String BINDING_CATCH_TOTAL_SORTED_TREMIS_WEIGHT_FIELD_TEXT = "catchTotalSortedTremisWeightField.text";
    public static final String BINDING_CATCH_TOTAL_SORTED_WEIGHT_FIELD_TEXT = "catchTotalSortedWeightField.text";
    public static final String BINDING_CATCH_TOTAL_UNSORTED_WEIGHT_FIELD_TEXT = "catchTotalUnsortedWeightField.text";
    public static final String BINDING_CATCH_TOTAL_WEIGHT_FIELD_BEAN = "catchTotalWeightField.bean";
    public static final String BINDING_CATCH_TOTAL_WEIGHT_FIELD_MODEL = "catchTotalWeightField.model";
    public static final String BINDING_INDIVIDUAL_OBSERVATION_TAB_FISHING_OPERATION_REMINDER_LABEL_RIGHT_DECORATION = "individualObservationTabFishingOperationReminderLabel.rightDecoration";
    public static final String BINDING_MARINE_LITTER_TAB_FISHING_OPERATION_REMINDER_LABEL_RIGHT_DECORATION = "marineLitterTabFishingOperationReminderLabel.rightDecoration";
    public static final String BINDING_MARINE_LITTER_TOTAL_WEIGHT_FIELD_BEAN = "marineLitterTotalWeightField.bean";
    public static final String BINDING_MARINE_LITTER_TOTAL_WEIGHT_FIELD_MODEL = "marineLitterTotalWeightField.model";
    public static final String BINDING_SAVE_BUTTON_ENABLED = "saveButton.enabled";
    public static final String BINDING_SPECIES_TAB_FISHING_OPERATION_REMINDER_LABEL_RIGHT_DECORATION = "speciesTabFishingOperationReminderLabel.rightDecoration";
    public static final String BINDING_SPECIES_TOTAL_SAMPLE_SORTED_WEIGHT_FIELD_TEXT = "speciesTotalSampleSortedWeightField.text";
    public static final String BINDING_SPECIES_TOTAL_SORTED_WEIGHT_FIELD_BEAN = "speciesTotalSortedWeightField.bean";
    public static final String BINDING_SPECIES_TOTAL_SORTED_WEIGHT_FIELD_MODEL = "speciesTotalSortedWeightField.model";
    public static final String BINDING_SPECIES_TOTAL_UNSORTED_WEIGHT_FIELD_TEXT = "speciesTotalUnsortedWeightField.text";
    public static final String BINDING_SPECIES_TOTAL_WEIGHT_FIELD_DISABLED_TEXT_COLOR = "speciesTotalWeightField.disabledTextColor";
    public static final String BINDING_SPECIES_TOTAL_WEIGHT_FIELD_TEXT = "speciesTotalWeightField.text";
    public static final String BINDING_TREMIE_CARROUSEL_ROW_VISIBLE = "tremieCarrouselRow.visible";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(EditCatchesUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected CaracteristicMapEditorUI accidentalCaracteristicMapEditor;
    protected JXTitledPanel accidentalCaracteristicMapEditorReminderLabel;
    protected TabInfo accidentalTab;
    protected AccidentalBatchUI accidentalTabContent;
    protected CreateAccidentalBatchUI accidentalTabCreateBatch;
    protected JXTitledPanel accidentalTabCreateBatchReminderLabel;
    protected JXTitledPanel accidentalTabFishingOperationReminderLabel;
    protected JPanel accidentalTabPanel;
    protected CardLayout2Ext accidentalTabPanelLayout;
    protected TabInfo benthosTab;
    protected SplitBenthosBatchUI benthosTabAddSampleCategoryBatch;
    protected JXTitledPanel benthosTabAddSampleCategoryBatchReminderLabel;
    protected BenthosBatchUI benthosTabContent;
    protected CreateBenthosBatchUI benthosTabCreateBatch;
    protected JXTitledPanel benthosTabCreateBatchReminderLabel;
    protected JXTitledPanel benthosTabFishingOperationReminderLabel;
    protected BenthosFrequencyUI benthosTabFrequencyEditor;
    protected JXTitledPanel benthosTabFrequencyEditorReminderLabel;
    protected JPanel benthosTabPanel;
    protected CardLayout2Ext benthosTabPanelLayout;
    protected SplitBenthosBatchUI benthosTabSplitBatch;
    protected JXTitledPanel benthosTabSplitBatchReminderLabel;
    protected Table benthosTable;
    protected JTextField benthosTotalSampleSortedWeightField;
    protected JLabel benthosTotalSampleSortedWeightLabel;
    @ValidatorField( validatorId = "validator",  propertyName = "benthosTotalSortedWeight",  editorName = "benthosTotalSortedWeightField")
    protected ComputableDataEditor<Float> benthosTotalSortedWeightField;
    protected JLabel benthosTotalSortedWeightLabel;
    protected JTextField benthosTotalUnsortedWeightField;
    protected JLabel benthosTotalUnsortedWeightLabel;
    protected JTextField benthosTotalWeightField;
    protected JLabel benthosTotalWeightLabel;
    protected TuttiHelpBroker broker;
    protected JButton cancelButton;
    protected Table catchTable;
    @ValidatorField( validatorId = "validator",  propertyName = "catchTotalRejectedWeight",  editorName = "catchTotalRejectedWeightField")
    protected ComputableDataEditor<Float> catchTotalRejectedWeightField;
    protected JLabel catchTotalRejectedWeightLabel;
    protected JTextField catchTotalSortedCarousselWeightField;
    protected JLabel catchTotalSortedCarousselWeightLabel;
    protected JTextField catchTotalSortedTremisWeightField;
    protected JLabel catchTotalSortedTremisWeightLabel;
    protected JTextField catchTotalSortedWeightField;
    protected JLabel catchTotalSortedWeightLabel;
    protected JTextField catchTotalUnsortedWeightField;
    protected JLabel catchTotalUnsortedWeightLabel;
    @ValidatorField( validatorId = "validator",  propertyName = "catchTotalWeight",  editorName = "catchTotalWeightField")
    protected ComputableDataEditor<Float> catchTotalWeightField;
    protected JLabel catchTotalWeightLabel;
    protected ButtonAttachment catchesCaracteristicsAttachmentsButton;
    protected TabInfo catchesCaracteristicsTab;
    protected JXTitledPanel catchesCaracteristicsTabPane;
    protected JScrollPane catchesCaracteristicsTabScrollPane;
    protected JToolBar catchesCaracteristicsTabToolBar;
    protected Table catchesForm;
    protected JButton cleanSpeciesBatchButton;
    protected JButton computeSpeciesBatchButton;
    protected Table createFishingOperationActions;
    protected EditCatchesUI editCatchesTopPanel = this;
    protected JButton exportFishingOperationReportButton;
    protected JButton exportFishingOperationReportForSumatraButton;
    protected final EditCatchesUIHandler handler = new EditCatchesUIHandler();
    protected CaracteristicMapEditorUI individualObservationCaracteristicMapEditor;
    protected JXTitledPanel individualObservationCaracteristicMapEditorReminderLabel;
    protected TabInfo individualObservationTab;
    protected IndividualObservationBatchUI individualObservationTabContent;
    protected CreateIndividualObservationBatchUI individualObservationTabCreateBatch;
    protected JXTitledPanel individualObservationTabCreateBatchReminderLabel;
    protected JXTitledPanel individualObservationTabFishingOperationReminderLabel;
    protected JPanel individualObservationTabPanel;
    protected CardLayout2Ext individualObservationTabPanelLayout;
    protected TabInfo marineLitterTab;
    protected MarineLitterBatchUI marineLitterTabContent;
    protected CreateMarineLitterBatchUI marineLitterTabCreateBatch;
    protected JXTitledPanel marineLitterTabCreateBatchReminderLabel;
    protected JXTitledPanel marineLitterTabFishingOperationReminderLabel;
    protected JPanel marineLitterTabPanel;
    protected CardLayout2Ext marineLitterTabPanelLayout;
    protected Table marineLitterTable;
    @ValidatorField( validatorId = "validator",  propertyName = "marineLitterTotalWeight",  editorName = "marineLitterTotalWeightField")
    protected ComputableDataEditor<Float> marineLitterTotalWeightField;
    protected JLabel marineLitterTotalWeightLabel;
    protected EditCatchesUIModel model;
    protected JButton saveButton;
    protected TabInfo speciesTab;
    protected SplitSpeciesBatchUI speciesTabAddSampleCategoryBatch;
    protected JXTitledPanel speciesTabAddSampleCategoryBatchReminderLabel;
    protected SpeciesBatchUI speciesTabContent;
    protected CreateSpeciesBatchUI speciesTabCreateBatch;
    protected JXTitledPanel speciesTabCreateBatchReminderLabel;
    protected JXTitledPanel speciesTabFishingOperationReminderLabel;
    protected SpeciesFrequencyUI speciesTabFrequencyEditor;
    protected JXTitledPanel speciesTabFrequencyEditorReminderLabel;
    protected JPanel speciesTabPanel;
    protected CardLayout2Ext speciesTabPanelLayout;
    protected SplitSpeciesBatchUI speciesTabSplitBatch;
    protected JXTitledPanel speciesTabSplitBatchReminderLabel;
    protected Table speciesTable;
    protected JTextField speciesTotalSampleSortedWeightField;
    protected JLabel speciesTotalSampleSortedWeightLabel;
    @ValidatorField( validatorId = "validator",  propertyName = "speciesTotalSortedWeight",  editorName = "speciesTotalSortedWeightField")
    protected ComputableDataEditor<Float> speciesTotalSortedWeightField;
    protected JLabel speciesTotalSortedWeightLabel;
    protected JTextField speciesTotalUnsortedWeightField;
    protected JLabel speciesTotalUnsortedWeightLabel;
    protected JTextField speciesTotalWeightField;
    protected JLabel speciesTotalWeightLabel;
    protected JTabbedPane tabPane;
    protected Table tremieCarrouselRow;
    @Validator( validatorId = "validator")
    protected SwingValidator<EditCatchesUIModel> validator;
    protected List<String> validatorIds = new ArrayList<String>();

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JPanel $JPanel0;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public EditCatchesUI(FishingOperationsUI parentUI) {
        TuttiUIUtil.setParentUI(this, parentUI);
            $initialize();
    }

    public EditCatchesUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public EditCatchesUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EditCatchesUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public EditCatchesUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EditCatchesUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public EditCatchesUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EditCatchesUI() {
        $initialize();
    }

    public EditCatchesUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public CaracteristicMapEditorUI getAccidentalCaracteristicMapEditor() {
        return accidentalCaracteristicMapEditor;
    }

    public JXTitledPanel getAccidentalCaracteristicMapEditorReminderLabel() {
        return accidentalCaracteristicMapEditorReminderLabel;
    }

    public TabInfo getAccidentalTab() {
        return accidentalTab;
    }

    public AccidentalBatchUI getAccidentalTabContent() {
        return accidentalTabContent;
    }

    public CreateAccidentalBatchUI getAccidentalTabCreateBatch() {
        return accidentalTabCreateBatch;
    }

    public JXTitledPanel getAccidentalTabCreateBatchReminderLabel() {
        return accidentalTabCreateBatchReminderLabel;
    }

    public JXTitledPanel getAccidentalTabFishingOperationReminderLabel() {
        return accidentalTabFishingOperationReminderLabel;
    }

    public JPanel getAccidentalTabPanel() {
        return accidentalTabPanel;
    }

    public CardLayout2Ext getAccidentalTabPanelLayout() {
        return accidentalTabPanelLayout;
    }

    public TabInfo getBenthosTab() {
        return benthosTab;
    }

    public SplitBenthosBatchUI getBenthosTabAddSampleCategoryBatch() {
        return benthosTabAddSampleCategoryBatch;
    }

    public JXTitledPanel getBenthosTabAddSampleCategoryBatchReminderLabel() {
        return benthosTabAddSampleCategoryBatchReminderLabel;
    }

    public BenthosBatchUI getBenthosTabContent() {
        return benthosTabContent;
    }

    public CreateBenthosBatchUI getBenthosTabCreateBatch() {
        return benthosTabCreateBatch;
    }

    public JXTitledPanel getBenthosTabCreateBatchReminderLabel() {
        return benthosTabCreateBatchReminderLabel;
    }

    public JXTitledPanel getBenthosTabFishingOperationReminderLabel() {
        return benthosTabFishingOperationReminderLabel;
    }

    public BenthosFrequencyUI getBenthosTabFrequencyEditor() {
        return benthosTabFrequencyEditor;
    }

    public JXTitledPanel getBenthosTabFrequencyEditorReminderLabel() {
        return benthosTabFrequencyEditorReminderLabel;
    }

    public JPanel getBenthosTabPanel() {
        return benthosTabPanel;
    }

    public CardLayout2Ext getBenthosTabPanelLayout() {
        return benthosTabPanelLayout;
    }

    public SplitBenthosBatchUI getBenthosTabSplitBatch() {
        return benthosTabSplitBatch;
    }

    public JXTitledPanel getBenthosTabSplitBatchReminderLabel() {
        return benthosTabSplitBatchReminderLabel;
    }

    public Table getBenthosTable() {
        return benthosTable;
    }

    public JTextField getBenthosTotalSampleSortedWeightField() {
        return benthosTotalSampleSortedWeightField;
    }

    public JLabel getBenthosTotalSampleSortedWeightLabel() {
        return benthosTotalSampleSortedWeightLabel;
    }

    public ComputableDataEditor<Float> getBenthosTotalSortedWeightField() {
        return benthosTotalSortedWeightField;
    }

    public JLabel getBenthosTotalSortedWeightLabel() {
        return benthosTotalSortedWeightLabel;
    }

    public JTextField getBenthosTotalUnsortedWeightField() {
        return benthosTotalUnsortedWeightField;
    }

    public JLabel getBenthosTotalUnsortedWeightLabel() {
        return benthosTotalUnsortedWeightLabel;
    }

    public JTextField getBenthosTotalWeightField() {
        return benthosTotalWeightField;
    }

    public JLabel getBenthosTotalWeightLabel() {
        return benthosTotalWeightLabel;
    }

    public TuttiHelpBroker getBroker() {
        return broker;
    }

    public JButton getCancelButton() {
        return cancelButton;
    }

    public Table getCatchTable() {
        return catchTable;
    }

    public ComputableDataEditor<Float> getCatchTotalRejectedWeightField() {
        return catchTotalRejectedWeightField;
    }

    public JLabel getCatchTotalRejectedWeightLabel() {
        return catchTotalRejectedWeightLabel;
    }

    public JTextField getCatchTotalSortedCarousselWeightField() {
        return catchTotalSortedCarousselWeightField;
    }

    public JLabel getCatchTotalSortedCarousselWeightLabel() {
        return catchTotalSortedCarousselWeightLabel;
    }

    public JTextField getCatchTotalSortedTremisWeightField() {
        return catchTotalSortedTremisWeightField;
    }

    public JLabel getCatchTotalSortedTremisWeightLabel() {
        return catchTotalSortedTremisWeightLabel;
    }

    public JTextField getCatchTotalSortedWeightField() {
        return catchTotalSortedWeightField;
    }

    public JLabel getCatchTotalSortedWeightLabel() {
        return catchTotalSortedWeightLabel;
    }

    public JTextField getCatchTotalUnsortedWeightField() {
        return catchTotalUnsortedWeightField;
    }

    public JLabel getCatchTotalUnsortedWeightLabel() {
        return catchTotalUnsortedWeightLabel;
    }

    public ComputableDataEditor<Float> getCatchTotalWeightField() {
        return catchTotalWeightField;
    }

    public JLabel getCatchTotalWeightLabel() {
        return catchTotalWeightLabel;
    }

    public ButtonAttachment getCatchesCaracteristicsAttachmentsButton() {
        return catchesCaracteristicsAttachmentsButton;
    }

    public TabInfo getCatchesCaracteristicsTab() {
        return catchesCaracteristicsTab;
    }

    public JXTitledPanel getCatchesCaracteristicsTabPane() {
        return catchesCaracteristicsTabPane;
    }

    public JScrollPane getCatchesCaracteristicsTabScrollPane() {
        return catchesCaracteristicsTabScrollPane;
    }

    public JToolBar getCatchesCaracteristicsTabToolBar() {
        return catchesCaracteristicsTabToolBar;
    }

    public Table getCatchesForm() {
        return catchesForm;
    }

    public JButton getCleanSpeciesBatchButton() {
        return cleanSpeciesBatchButton;
    }

    public JButton getComputeSpeciesBatchButton() {
        return computeSpeciesBatchButton;
    }

    public Table getCreateFishingOperationActions() {
        return createFishingOperationActions;
    }

    public JButton getExportFishingOperationReportButton() {
        return exportFishingOperationReportButton;
    }

    public JButton getExportFishingOperationReportForSumatraButton() {
        return exportFishingOperationReportForSumatraButton;
    }

    public EditCatchesUIHandler getHandler() {
        return handler;
    }

    public CaracteristicMapEditorUI getIndividualObservationCaracteristicMapEditor() {
        return individualObservationCaracteristicMapEditor;
    }

    public JXTitledPanel getIndividualObservationCaracteristicMapEditorReminderLabel() {
        return individualObservationCaracteristicMapEditorReminderLabel;
    }

    public TabInfo getIndividualObservationTab() {
        return individualObservationTab;
    }

    public IndividualObservationBatchUI getIndividualObservationTabContent() {
        return individualObservationTabContent;
    }

    public CreateIndividualObservationBatchUI getIndividualObservationTabCreateBatch() {
        return individualObservationTabCreateBatch;
    }

    public JXTitledPanel getIndividualObservationTabCreateBatchReminderLabel() {
        return individualObservationTabCreateBatchReminderLabel;
    }

    public JXTitledPanel getIndividualObservationTabFishingOperationReminderLabel() {
        return individualObservationTabFishingOperationReminderLabel;
    }

    public JPanel getIndividualObservationTabPanel() {
        return individualObservationTabPanel;
    }

    public CardLayout2Ext getIndividualObservationTabPanelLayout() {
        return individualObservationTabPanelLayout;
    }

    public TabInfo getMarineLitterTab() {
        return marineLitterTab;
    }

    public MarineLitterBatchUI getMarineLitterTabContent() {
        return marineLitterTabContent;
    }

    public CreateMarineLitterBatchUI getMarineLitterTabCreateBatch() {
        return marineLitterTabCreateBatch;
    }

    public JXTitledPanel getMarineLitterTabCreateBatchReminderLabel() {
        return marineLitterTabCreateBatchReminderLabel;
    }

    public JXTitledPanel getMarineLitterTabFishingOperationReminderLabel() {
        return marineLitterTabFishingOperationReminderLabel;
    }

    public JPanel getMarineLitterTabPanel() {
        return marineLitterTabPanel;
    }

    public CardLayout2Ext getMarineLitterTabPanelLayout() {
        return marineLitterTabPanelLayout;
    }

    public Table getMarineLitterTable() {
        return marineLitterTable;
    }

    public ComputableDataEditor<Float> getMarineLitterTotalWeightField() {
        return marineLitterTotalWeightField;
    }

    public JLabel getMarineLitterTotalWeightLabel() {
        return marineLitterTotalWeightLabel;
    }

    public EditCatchesUIModel getModel() {
        return model;
    }

    public JButton getSaveButton() {
        return saveButton;
    }

    public TabInfo getSpeciesTab() {
        return speciesTab;
    }

    public SplitSpeciesBatchUI getSpeciesTabAddSampleCategoryBatch() {
        return speciesTabAddSampleCategoryBatch;
    }

    public JXTitledPanel getSpeciesTabAddSampleCategoryBatchReminderLabel() {
        return speciesTabAddSampleCategoryBatchReminderLabel;
    }

    public SpeciesBatchUI getSpeciesTabContent() {
        return speciesTabContent;
    }

    public CreateSpeciesBatchUI getSpeciesTabCreateBatch() {
        return speciesTabCreateBatch;
    }

    public JXTitledPanel getSpeciesTabCreateBatchReminderLabel() {
        return speciesTabCreateBatchReminderLabel;
    }

    public JXTitledPanel getSpeciesTabFishingOperationReminderLabel() {
        return speciesTabFishingOperationReminderLabel;
    }

    public SpeciesFrequencyUI getSpeciesTabFrequencyEditor() {
        return speciesTabFrequencyEditor;
    }

    public JXTitledPanel getSpeciesTabFrequencyEditorReminderLabel() {
        return speciesTabFrequencyEditorReminderLabel;
    }

    public JPanel getSpeciesTabPanel() {
        return speciesTabPanel;
    }

    public CardLayout2Ext getSpeciesTabPanelLayout() {
        return speciesTabPanelLayout;
    }

    public SplitSpeciesBatchUI getSpeciesTabSplitBatch() {
        return speciesTabSplitBatch;
    }

    public JXTitledPanel getSpeciesTabSplitBatchReminderLabel() {
        return speciesTabSplitBatchReminderLabel;
    }

    public Table getSpeciesTable() {
        return speciesTable;
    }

    public JTextField getSpeciesTotalSampleSortedWeightField() {
        return speciesTotalSampleSortedWeightField;
    }

    public JLabel getSpeciesTotalSampleSortedWeightLabel() {
        return speciesTotalSampleSortedWeightLabel;
    }

    public ComputableDataEditor<Float> getSpeciesTotalSortedWeightField() {
        return speciesTotalSortedWeightField;
    }

    public JLabel getSpeciesTotalSortedWeightLabel() {
        return speciesTotalSortedWeightLabel;
    }

    public JTextField getSpeciesTotalUnsortedWeightField() {
        return speciesTotalUnsortedWeightField;
    }

    public JLabel getSpeciesTotalUnsortedWeightLabel() {
        return speciesTotalUnsortedWeightLabel;
    }

    public JTextField getSpeciesTotalWeightField() {
        return speciesTotalWeightField;
    }

    public JLabel getSpeciesTotalWeightLabel() {
        return speciesTotalWeightLabel;
    }

    public JTabbedPane getTabPane() {
        return tabPane;
    }

    public Table getTremieCarrouselRow() {
        return tremieCarrouselRow;
    }

    public SwingValidator<EditCatchesUIModel> getValidator() {
        return validator;
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Other methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void registerHelpId(TuttiHelpBroker broker, Component component, String helpId) {
        broker.installUI(component, helpId);
    }

    @Override
    public void showHelp(String helpId) {
        getBroker().showHelp(this, helpId);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToAccidentalCaracteristicMapEditorReminderLabel() {
        if (!allComponentsCreated) {
            return;
        }
        accidentalCaracteristicMapEditorReminderLabel.add(accidentalCaracteristicMapEditor);
    }

    protected void addChildrenToAccidentalTabCreateBatchReminderLabel() {
        if (!allComponentsCreated) {
            return;
        }
        accidentalTabCreateBatchReminderLabel.add(accidentalTabCreateBatch);
    }

    protected void addChildrenToAccidentalTabFishingOperationReminderLabel() {
        if (!allComponentsCreated) {
            return;
        }
        accidentalTabFishingOperationReminderLabel.add(accidentalTabContent);
    }

    protected void addChildrenToAccidentalTabPanel() {
        if (!allComponentsCreated) {
            return;
        }
        accidentalTabPanel.add(accidentalTabFishingOperationReminderLabel, EditCatchesUIHandler.MAIN_CARD);
        accidentalTabPanel.add(accidentalTabCreateBatchReminderLabel, EditCatchesUIHandler.CREATE_BATCH_CARD);
        accidentalTabPanel.add(accidentalCaracteristicMapEditorReminderLabel, EditCatchesUIHandler.EDIT_CARACTERISTICS_CARD);
    }

    protected void addChildrenToBenthosTabAddSampleCategoryBatchReminderLabel() {
        if (!allComponentsCreated) {
            return;
        }
        benthosTabAddSampleCategoryBatchReminderLabel.add(benthosTabAddSampleCategoryBatch);
    }

    protected void addChildrenToBenthosTabCreateBatchReminderLabel() {
        if (!allComponentsCreated) {
            return;
        }
        benthosTabCreateBatchReminderLabel.add(benthosTabCreateBatch);
    }

    protected void addChildrenToBenthosTabFishingOperationReminderLabel() {
        if (!allComponentsCreated) {
            return;
        }
        benthosTabFishingOperationReminderLabel.add(benthosTabContent);
    }

    protected void addChildrenToBenthosTabFrequencyEditorReminderLabel() {
        if (!allComponentsCreated) {
            return;
        }
        benthosTabFrequencyEditorReminderLabel.add(benthosTabFrequencyEditor);
    }

    protected void addChildrenToBenthosTabPanel() {
        if (!allComponentsCreated) {
            return;
        }
        benthosTabPanel.add(benthosTabFishingOperationReminderLabel, EditCatchesUIHandler.MAIN_CARD);
        benthosTabPanel.add(benthosTabCreateBatchReminderLabel, EditCatchesUIHandler.CREATE_BATCH_CARD);
        benthosTabPanel.add(benthosTabSplitBatchReminderLabel, EditCatchesUIHandler.SPLIT_BATCH_CARD);
        benthosTabPanel.add(benthosTabAddSampleCategoryBatchReminderLabel, EditCatchesUIHandler.ADD_SAMPLE_CATEGORY_BATCH_CARD);
        benthosTabPanel.add(benthosTabFrequencyEditorReminderLabel, EditCatchesUIHandler.EDIT_FREQUENCY_CARD);
    }

    protected void addChildrenToBenthosTabSplitBatchReminderLabel() {
        if (!allComponentsCreated) {
            return;
        }
        benthosTabSplitBatchReminderLabel.add(benthosTabSplitBatch);
    }

    protected void addChildrenToBenthosTable() {
        if (!allComponentsCreated) {
            return;
        }
        benthosTable.add(benthosTotalWeightLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        benthosTable.add(benthosTotalWeightField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        benthosTable.add(benthosTotalSortedWeightLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        benthosTable.add(SwingUtil.boxComponentWithJxLayer(benthosTotalSortedWeightField), new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        benthosTable.add(benthosTotalSampleSortedWeightLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        benthosTable.add(benthosTotalSampleSortedWeightField, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        benthosTable.add(benthosTotalUnsortedWeightLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        benthosTable.add(benthosTotalUnsortedWeightField, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToCatchTable() {
        if (!allComponentsCreated) {
            return;
        }
        catchTable.add(catchTotalWeightLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        catchTable.add(SwingUtil.boxComponentWithJxLayer(catchTotalWeightField), new GridBagConstraints(1, 0, 4, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        catchTable.add(catchTotalSortedWeightLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        catchTable.add(catchTotalSortedWeightField, new GridBagConstraints(1, 1, 4, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        catchTable.add(tremieCarrouselRow, new GridBagConstraints(0, 2, 5, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        catchTable.add(catchTotalUnsortedWeightLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        catchTable.add(catchTotalUnsortedWeightField, new GridBagConstraints(1, 3, 4, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        catchTable.add(catchTotalRejectedWeightLabel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        catchTable.add(SwingUtil.boxComponentWithJxLayer(catchTotalRejectedWeightField), new GridBagConstraints(1, 4, 4, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToCatchesCaracteristicsTabPane() {
        if (!allComponentsCreated) {
            return;
        }
        catchesCaracteristicsTabPane.add(catchesCaracteristicsTabScrollPane);
    }

    protected void addChildrenToCatchesCaracteristicsTabScrollPane() {
        if (!allComponentsCreated) {
            return;
        }
        catchesCaracteristicsTabScrollPane.getViewport().add($JPanel0);
    }

    protected void addChildrenToCatchesCaracteristicsTabToolBar() {
        if (!allComponentsCreated) {
            return;
        }
        catchesCaracteristicsTabToolBar.add(exportFishingOperationReportButton);
        catchesCaracteristicsTabToolBar.add(exportFishingOperationReportForSumatraButton);
        catchesCaracteristicsTabToolBar.add(catchesCaracteristicsAttachmentsButton);
    }

    protected void addChildrenToCatchesForm() {
        if (!allComponentsCreated) {
            return;
        }
        catchesForm.add(catchTable, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        catchesForm.add(speciesTable, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        catchesForm.add(benthosTable, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        catchesForm.add(marineLitterTable, new GridBagConstraints(0, 3, 2, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToCreateFishingOperationActions() {
        if (!allComponentsCreated) {
            return;
        }
        createFishingOperationActions.add(cancelButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        createFishingOperationActions.add(saveButton, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        createFishingOperationActions.add(cleanSpeciesBatchButton, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        createFishingOperationActions.add(computeSpeciesBatchButton, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    protected void addChildrenToEditCatchesTopPanel() {
        if (!allComponentsCreated) {
            return;
        }
        add(catchesCaracteristicsTabToolBar);
        add(tabPane, BorderLayout.CENTER);
        add(createFishingOperationActions, BorderLayout.SOUTH);
    }

    protected void addChildrenToIndividualObservationCaracteristicMapEditorReminderLabel() {
        if (!allComponentsCreated) {
            return;
        }
        individualObservationCaracteristicMapEditorReminderLabel.add(individualObservationCaracteristicMapEditor);
    }

    protected void addChildrenToIndividualObservationTabCreateBatchReminderLabel() {
        if (!allComponentsCreated) {
            return;
        }
        individualObservationTabCreateBatchReminderLabel.add(individualObservationTabCreateBatch);
    }

    protected void addChildrenToIndividualObservationTabFishingOperationReminderLabel() {
        if (!allComponentsCreated) {
            return;
        }
        individualObservationTabFishingOperationReminderLabel.add(individualObservationTabContent);
    }

    protected void addChildrenToIndividualObservationTabPanel() {
        if (!allComponentsCreated) {
            return;
        }
        individualObservationTabPanel.add(individualObservationTabFishingOperationReminderLabel, EditCatchesUIHandler.MAIN_CARD);
        individualObservationTabPanel.add(individualObservationTabCreateBatchReminderLabel, EditCatchesUIHandler.CREATE_BATCH_CARD);
        individualObservationTabPanel.add(individualObservationCaracteristicMapEditorReminderLabel, EditCatchesUIHandler.EDIT_CARACTERISTICS_CARD);
    }

    protected void addChildrenToMarineLitterTabCreateBatchReminderLabel() {
        if (!allComponentsCreated) {
            return;
        }
        marineLitterTabCreateBatchReminderLabel.add(marineLitterTabCreateBatch);
    }

    protected void addChildrenToMarineLitterTabFishingOperationReminderLabel() {
        if (!allComponentsCreated) {
            return;
        }
        marineLitterTabFishingOperationReminderLabel.add(marineLitterTabContent);
    }

    protected void addChildrenToMarineLitterTabPanel() {
        if (!allComponentsCreated) {
            return;
        }
        marineLitterTabPanel.add(marineLitterTabFishingOperationReminderLabel, EditCatchesUIHandler.MAIN_CARD);
        marineLitterTabPanel.add(marineLitterTabCreateBatchReminderLabel, EditCatchesUIHandler.CREATE_BATCH_CARD);
    }

    protected void addChildrenToMarineLitterTable() {
        if (!allComponentsCreated) {
            return;
        }
        marineLitterTable.add(marineLitterTotalWeightLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        marineLitterTable.add(SwingUtil.boxComponentWithJxLayer(marineLitterTotalWeightField), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToSpeciesTabAddSampleCategoryBatchReminderLabel() {
        if (!allComponentsCreated) {
            return;
        }
        speciesTabAddSampleCategoryBatchReminderLabel.add(speciesTabAddSampleCategoryBatch);
    }

    protected void addChildrenToSpeciesTabCreateBatchReminderLabel() {
        if (!allComponentsCreated) {
            return;
        }
        speciesTabCreateBatchReminderLabel.add(speciesTabCreateBatch);
    }

    protected void addChildrenToSpeciesTabFishingOperationReminderLabel() {
        if (!allComponentsCreated) {
            return;
        }
        speciesTabFishingOperationReminderLabel.add(speciesTabContent);
    }

    protected void addChildrenToSpeciesTabFrequencyEditorReminderLabel() {
        if (!allComponentsCreated) {
            return;
        }
        speciesTabFrequencyEditorReminderLabel.add(speciesTabFrequencyEditor);
    }

    protected void addChildrenToSpeciesTabPanel() {
        if (!allComponentsCreated) {
            return;
        }
        speciesTabPanel.add(speciesTabFishingOperationReminderLabel, EditCatchesUIHandler.MAIN_CARD);
        speciesTabPanel.add(speciesTabCreateBatchReminderLabel, EditCatchesUIHandler.CREATE_BATCH_CARD);
        speciesTabPanel.add(speciesTabSplitBatchReminderLabel, EditCatchesUIHandler.SPLIT_BATCH_CARD);
        speciesTabPanel.add(speciesTabAddSampleCategoryBatchReminderLabel, EditCatchesUIHandler.ADD_SAMPLE_CATEGORY_BATCH_CARD);
        speciesTabPanel.add(speciesTabFrequencyEditorReminderLabel, EditCatchesUIHandler.EDIT_FREQUENCY_CARD);
    }

    protected void addChildrenToSpeciesTabSplitBatchReminderLabel() {
        if (!allComponentsCreated) {
            return;
        }
        speciesTabSplitBatchReminderLabel.add(speciesTabSplitBatch);
    }

    protected void addChildrenToSpeciesTable() {
        if (!allComponentsCreated) {
            return;
        }
        speciesTable.add(speciesTotalWeightLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        speciesTable.add(speciesTotalWeightField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        speciesTable.add(speciesTotalSortedWeightLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        speciesTable.add(SwingUtil.boxComponentWithJxLayer(speciesTotalSortedWeightField), new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        speciesTable.add(speciesTotalSampleSortedWeightLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        speciesTable.add(speciesTotalSampleSortedWeightField, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        speciesTable.add(speciesTotalUnsortedWeightLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        speciesTable.add(speciesTotalUnsortedWeightField, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToTabPane() {
        if (!allComponentsCreated) {
            return;
        }
        tabPane.add(catchesCaracteristicsTabPane);
        tabPane.add(speciesTabPanel);
        tabPane.add(benthosTabPanel);
        tabPane.add(marineLitterTabPanel);
        tabPane.add(individualObservationTabPanel);
        tabPane.add(accidentalTabPanel);
        catchesCaracteristicsTab.addPropertyChangeListener(new TabInfoPropertyChangeListener(tabPane, 0));
        speciesTab.addPropertyChangeListener(new TabInfoPropertyChangeListener(tabPane, 1));
        benthosTab.addPropertyChangeListener(new TabInfoPropertyChangeListener(tabPane, 2));
        marineLitterTab.addPropertyChangeListener(new TabInfoPropertyChangeListener(tabPane, 3));
        tabPane.setTitleAt(3, t("tutti.label.tab.marineLitter"));
        individualObservationTab.addPropertyChangeListener(new TabInfoPropertyChangeListener(tabPane, 4));
        accidentalTab.addPropertyChangeListener(new TabInfoPropertyChangeListener(tabPane, 5));
    }

    protected void addChildrenToTremieCarrouselRow() {
        if (!allComponentsCreated) {
            return;
        }
        tremieCarrouselRow.add(catchTotalSortedCarousselWeightLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        tremieCarrouselRow.add(catchTotalSortedCarousselWeightField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        tremieCarrouselRow.add(catchTotalSortedTremisWeightLabel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        tremieCarrouselRow.add(catchTotalSortedTremisWeightField, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setUiClass(ImageValidationUI.class);
        validator.setBean(model);
    }

    protected void createAccidentalCaracteristicMapEditor() {
        $objectMap.put("accidentalCaracteristicMapEditor", accidentalCaracteristicMapEditor = new CaracteristicMapEditorUI(accidentalTabContent));
        
        accidentalCaracteristicMapEditor.setName("accidentalCaracteristicMapEditor");
    }

    protected void createAccidentalCaracteristicMapEditorReminderLabel() {
        $objectMap.put("accidentalCaracteristicMapEditorReminderLabel", accidentalCaracteristicMapEditorReminderLabel = new JXTitledPanel());
        
        accidentalCaracteristicMapEditorReminderLabel.setName("accidentalCaracteristicMapEditorReminderLabel");
    }

    protected void createAccidentalTab() {
        $objectMap.put("accidentalTab", accidentalTab = new TabInfo());
    }

    protected void createAccidentalTabContent() {
        $objectMap.put("accidentalTabContent", accidentalTabContent = new AccidentalBatchUI(this));
        
        accidentalTabContent.setName("accidentalTabContent");
    }

    protected void createAccidentalTabCreateBatch() {
        $objectMap.put("accidentalTabCreateBatch", accidentalTabCreateBatch = new CreateAccidentalBatchUI(this));
        
        accidentalTabCreateBatch.setName("accidentalTabCreateBatch");
    }

    protected void createAccidentalTabCreateBatchReminderLabel() {
        $objectMap.put("accidentalTabCreateBatchReminderLabel", accidentalTabCreateBatchReminderLabel = new JXTitledPanel());
        
        accidentalTabCreateBatchReminderLabel.setName("accidentalTabCreateBatchReminderLabel");
    }

    protected void createAccidentalTabFishingOperationReminderLabel() {
        $objectMap.put("accidentalTabFishingOperationReminderLabel", accidentalTabFishingOperationReminderLabel = new JXTitledPanel());
        
        accidentalTabFishingOperationReminderLabel.setName("accidentalTabFishingOperationReminderLabel");
    }

    protected void createAccidentalTabPanel() {
        $objectMap.put("accidentalTabPanel", accidentalTabPanel = new JPanel());
        
        accidentalTabPanel.setName("accidentalTabPanel");
        accidentalTabPanel.setLayout(accidentalTabPanelLayout);
    }

    protected void createAccidentalTabPanelLayout() {
        $objectMap.put("accidentalTabPanelLayout", accidentalTabPanelLayout = new CardLayout2Ext(this, "accidentalTabPanel"));
    }

    protected void createBenthosTab() {
        $objectMap.put("benthosTab", benthosTab = new TabInfo());
    }

    protected void createBenthosTabAddSampleCategoryBatch() {
        $objectMap.put("benthosTabAddSampleCategoryBatch", benthosTabAddSampleCategoryBatch = new SplitBenthosBatchUI(this));
        
        benthosTabAddSampleCategoryBatch.setName("benthosTabAddSampleCategoryBatch");
    }

    protected void createBenthosTabAddSampleCategoryBatchReminderLabel() {
        $objectMap.put("benthosTabAddSampleCategoryBatchReminderLabel", benthosTabAddSampleCategoryBatchReminderLabel = new JXTitledPanel());
        
        benthosTabAddSampleCategoryBatchReminderLabel.setName("benthosTabAddSampleCategoryBatchReminderLabel");
    }

    protected void createBenthosTabContent() {
        $objectMap.put("benthosTabContent", benthosTabContent = new BenthosBatchUI(this));
        
        benthosTabContent.setName("benthosTabContent");
    }

    protected void createBenthosTabCreateBatch() {
        $objectMap.put("benthosTabCreateBatch", benthosTabCreateBatch = new CreateBenthosBatchUI(this));
        
        benthosTabCreateBatch.setName("benthosTabCreateBatch");
    }

    protected void createBenthosTabCreateBatchReminderLabel() {
        $objectMap.put("benthosTabCreateBatchReminderLabel", benthosTabCreateBatchReminderLabel = new JXTitledPanel());
        
        benthosTabCreateBatchReminderLabel.setName("benthosTabCreateBatchReminderLabel");
    }

    protected void createBenthosTabFishingOperationReminderLabel() {
        $objectMap.put("benthosTabFishingOperationReminderLabel", benthosTabFishingOperationReminderLabel = new JXTitledPanel());
        
        benthosTabFishingOperationReminderLabel.setName("benthosTabFishingOperationReminderLabel");
    }

    protected void createBenthosTabFrequencyEditor() {
        $objectMap.put("benthosTabFrequencyEditor", benthosTabFrequencyEditor = new BenthosFrequencyUI(benthosTabContent));
        
        benthosTabFrequencyEditor.setName("benthosTabFrequencyEditor");
    }

    protected void createBenthosTabFrequencyEditorReminderLabel() {
        $objectMap.put("benthosTabFrequencyEditorReminderLabel", benthosTabFrequencyEditorReminderLabel = new JXTitledPanel());
        
        benthosTabFrequencyEditorReminderLabel.setName("benthosTabFrequencyEditorReminderLabel");
    }

    protected void createBenthosTabPanel() {
        $objectMap.put("benthosTabPanel", benthosTabPanel = new JPanel());
        
        benthosTabPanel.setName("benthosTabPanel");
        benthosTabPanel.setLayout(benthosTabPanelLayout);
    }

    protected void createBenthosTabPanelLayout() {
        $objectMap.put("benthosTabPanelLayout", benthosTabPanelLayout = new CardLayout2Ext(this, "benthosTabPanel"));
    }

    protected void createBenthosTabSplitBatch() {
        $objectMap.put("benthosTabSplitBatch", benthosTabSplitBatch = new SplitBenthosBatchUI(this));
        
        benthosTabSplitBatch.setName("benthosTabSplitBatch");
    }

    protected void createBenthosTabSplitBatchReminderLabel() {
        $objectMap.put("benthosTabSplitBatchReminderLabel", benthosTabSplitBatchReminderLabel = new JXTitledPanel());
        
        benthosTabSplitBatchReminderLabel.setName("benthosTabSplitBatchReminderLabel");
    }

    protected void createBenthosTable() {
        $objectMap.put("benthosTable", benthosTable = new Table());
        
        benthosTable.setName("benthosTable");
    }

    protected void createBenthosTotalSampleSortedWeightField() {
        $objectMap.put("benthosTotalSampleSortedWeightField", benthosTotalSampleSortedWeightField = new JTextField());
        
        benthosTotalSampleSortedWeightField.setName("benthosTotalSampleSortedWeightField");
        benthosTotalSampleSortedWeightField.setColumns(15);
        benthosTotalSampleSortedWeightField.putClientProperty("help", "tutti.editCatchBatch.field.benthosTotalSampleSortedWeight.help");
        benthosTotalSampleSortedWeightField.putClientProperty("computed", true);
    }

    protected void createBenthosTotalSampleSortedWeightLabel() {
        $objectMap.put("benthosTotalSampleSortedWeightLabel", benthosTotalSampleSortedWeightLabel = new JLabel());
        
        benthosTotalSampleSortedWeightLabel.setName("benthosTotalSampleSortedWeightLabel");
        benthosTotalSampleSortedWeightLabel.setText(t("tutti.editCatchBatch.field.benthosTotalSampleSortedWeight"));
        benthosTotalSampleSortedWeightLabel.putClientProperty("help", "tutti.editCatchBatch.field.benthosTotalSampleSortedWeight.help");
        benthosTotalSampleSortedWeightLabel.putClientProperty("addWeightUnit", handler.getConfig().getBenthosWeightUnit());
    }

    protected void createBenthosTotalSortedWeightField() {
        $objectMap.put("benthosTotalSortedWeightField", benthosTotalSortedWeightField = new ComputableDataEditor<Float>(this));
        
        benthosTotalSortedWeightField.setName("benthosTotalSortedWeightField");
        benthosTotalSortedWeightField.setUseFloat(true);
        benthosTotalSortedWeightField.setShowReset(true);
        benthosTotalSortedWeightField.putClientProperty("help", "tutti.editCatchBatch.field.benthosTotalSortedWeight.help");
    }

    protected void createBenthosTotalSortedWeightLabel() {
        $objectMap.put("benthosTotalSortedWeightLabel", benthosTotalSortedWeightLabel = new JLabel());
        
        benthosTotalSortedWeightLabel.setName("benthosTotalSortedWeightLabel");
        benthosTotalSortedWeightLabel.setText(t("tutti.editCatchBatch.field.benthosTotalSortedWeight"));
        benthosTotalSortedWeightLabel.putClientProperty("help", "tutti.editCatchBatch.field.benthosTotalSortedWeight.help");
        benthosTotalSortedWeightLabel.putClientProperty("addWeightUnit", handler.getConfig().getBenthosWeightUnit());
    }

    protected void createBenthosTotalUnsortedWeightField() {
        $objectMap.put("benthosTotalUnsortedWeightField", benthosTotalUnsortedWeightField = new JTextField());
        
        benthosTotalUnsortedWeightField.setName("benthosTotalUnsortedWeightField");
        benthosTotalUnsortedWeightField.setColumns(15);
        benthosTotalUnsortedWeightField.putClientProperty("help", "tutti.editCatchBatch.field.benthosTotalUnsortedWeight.help");
        benthosTotalUnsortedWeightField.putClientProperty("computed", true);
    }

    protected void createBenthosTotalUnsortedWeightLabel() {
        $objectMap.put("benthosTotalUnsortedWeightLabel", benthosTotalUnsortedWeightLabel = new JLabel());
        
        benthosTotalUnsortedWeightLabel.setName("benthosTotalUnsortedWeightLabel");
        benthosTotalUnsortedWeightLabel.setText(t("tutti.editCatchBatch.field.benthosTotalUnsortedWeight"));
        benthosTotalUnsortedWeightLabel.putClientProperty("help", "tutti.editCatchBatch.field.benthosTotalUnsortedWeight.help");
        benthosTotalUnsortedWeightLabel.putClientProperty("addWeightUnit", handler.getConfig().getBenthosWeightUnit());
    }

    protected void createBenthosTotalWeightField() {
        $objectMap.put("benthosTotalWeightField", benthosTotalWeightField = new JTextField());
        
        benthosTotalWeightField.setName("benthosTotalWeightField");
        benthosTotalWeightField.setColumns(15);
        benthosTotalWeightField.putClientProperty("help", "tutti.editCatchBatch.field.benthosTotalWeight.help");
        benthosTotalWeightField.putClientProperty("computed", true);
    }

    protected void createBenthosTotalWeightLabel() {
        $objectMap.put("benthosTotalWeightLabel", benthosTotalWeightLabel = new JLabel());
        
        benthosTotalWeightLabel.setName("benthosTotalWeightLabel");
        benthosTotalWeightLabel.setText(t("tutti.editCatchBatch.field.benthosTotalWeight"));
        benthosTotalWeightLabel.putClientProperty("help", "tutti.editCatchBatch.field.benthosTotalWeight.help");
        benthosTotalWeightLabel.putClientProperty("strongStyle", true);
        benthosTotalWeightLabel.putClientProperty("addWeightUnit", handler.getConfig().getBenthosWeightUnit());
    }

    protected void createBroker() {
        $objectMap.put("broker", broker = new TuttiHelpBroker("tutti.editCatchBatch.help"));
    }

    protected void createCancelButton() {
        $objectMap.put("cancelButton", cancelButton = new JButton());
        
        cancelButton.setName("cancelButton");
        cancelButton.setText(t("tutti.editCatchBatch.action.cancelEditCatchBatch"));
        cancelButton.setToolTipText(t("tutti.editCatchBatch.action.cancelEditCatchBatch.tip"));
        cancelButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.action.CancelEditCatchBatchAction.class);
        cancelButton.putClientProperty("help", "tutti.editCatchBatch.action.cancelEditCatchBatch.help");
    }

    protected void createCatchTable() {
        $objectMap.put("catchTable", catchTable = new Table());
        
        catchTable.setName("catchTable");
    }

    protected void createCatchTotalRejectedWeightField() {
        $objectMap.put("catchTotalRejectedWeightField", catchTotalRejectedWeightField = new ComputableDataEditor<Float>(this));
        
        catchTotalRejectedWeightField.setName("catchTotalRejectedWeightField");
        catchTotalRejectedWeightField.setUseFloat(true);
        catchTotalRejectedWeightField.setShowReset(true);
        catchTotalRejectedWeightField.putClientProperty("help", "tutti.editCatchBatch.field.catchTotalRejectedWeight.help");
        catchTotalRejectedWeightField.putClientProperty("validatorLabel", t("tutti.editCatchBatch.field.catchTotalRejectedWeight"));
    }

    protected void createCatchTotalRejectedWeightLabel() {
        $objectMap.put("catchTotalRejectedWeightLabel", catchTotalRejectedWeightLabel = new JLabel());
        
        catchTotalRejectedWeightLabel.setName("catchTotalRejectedWeightLabel");
        catchTotalRejectedWeightLabel.setText(t("tutti.editCatchBatch.field.catchTotalRejectedWeight"));
        catchTotalRejectedWeightLabel.putClientProperty("help", "tutti.editCatchBatch.field.catchTotalRejectedWeight.help");
        catchTotalRejectedWeightLabel.putClientProperty("addWeightUnit", model.getCatchWeightUnit());
    }

    protected void createCatchTotalSortedCarousselWeightField() {
        $objectMap.put("catchTotalSortedCarousselWeightField", catchTotalSortedCarousselWeightField = new JTextField());
        
        catchTotalSortedCarousselWeightField.setName("catchTotalSortedCarousselWeightField");
        catchTotalSortedCarousselWeightField.setColumns(15);
        catchTotalSortedCarousselWeightField.setEnabled(false);
        catchTotalSortedCarousselWeightField.putClientProperty("help", "tutti.editCatchBatch.field.catchTotalSortedCarousselWeight.help");
    }

    protected void createCatchTotalSortedCarousselWeightLabel() {
        $objectMap.put("catchTotalSortedCarousselWeightLabel", catchTotalSortedCarousselWeightLabel = new JLabel());
        
        catchTotalSortedCarousselWeightLabel.setName("catchTotalSortedCarousselWeightLabel");
        catchTotalSortedCarousselWeightLabel.setText(t("tutti.editCatchBatch.field.catchTotalSortedCarousselWeight"));
        catchTotalSortedCarousselWeightLabel.putClientProperty("help", "tutti.editCatchBatch.field.catchTotalSortedCarousselWeight.help");
        catchTotalSortedCarousselWeightLabel.putClientProperty("addWeightUnit", model.getCatchWeightUnit());
    }

    protected void createCatchTotalSortedTremisWeightField() {
        $objectMap.put("catchTotalSortedTremisWeightField", catchTotalSortedTremisWeightField = new JTextField());
        
        catchTotalSortedTremisWeightField.setName("catchTotalSortedTremisWeightField");
        catchTotalSortedTremisWeightField.setColumns(15);
        catchTotalSortedTremisWeightField.setEnabled(false);
        catchTotalSortedTremisWeightField.putClientProperty("help", "tutti.editCatchBatch.field.catchTotalSortedTremisWeight.help");
    }

    protected void createCatchTotalSortedTremisWeightLabel() {
        $objectMap.put("catchTotalSortedTremisWeightLabel", catchTotalSortedTremisWeightLabel = new JLabel());
        
        catchTotalSortedTremisWeightLabel.setName("catchTotalSortedTremisWeightLabel");
        catchTotalSortedTremisWeightLabel.setText(t("tutti.editCatchBatch.field.catchTotalSortedTremisWeight"));
        catchTotalSortedTremisWeightLabel.putClientProperty("help", "tutti.editCatchBatch.field.catchTotalSortedTremisWeight.help");
        catchTotalSortedTremisWeightLabel.putClientProperty("addWeightUnit", model.getCatchWeightUnit());
    }

    protected void createCatchTotalSortedWeightField() {
        $objectMap.put("catchTotalSortedWeightField", catchTotalSortedWeightField = new JTextField());
        
        catchTotalSortedWeightField.setName("catchTotalSortedWeightField");
        catchTotalSortedWeightField.setColumns(15);
        catchTotalSortedWeightField.putClientProperty("help", "tutti.editCatchBatch.field.catchTotalSortedWeight.help");
        catchTotalSortedWeightField.putClientProperty("computed", true);
    }

    protected void createCatchTotalSortedWeightLabel() {
        $objectMap.put("catchTotalSortedWeightLabel", catchTotalSortedWeightLabel = new JLabel());
        
        catchTotalSortedWeightLabel.setName("catchTotalSortedWeightLabel");
        catchTotalSortedWeightLabel.setText(t("tutti.editCatchBatch.field.catchTotalSortedWeight"));
        catchTotalSortedWeightLabel.putClientProperty("help", "tutti.editCatchBatch.field.catchTotalSortedWeight.help");
        catchTotalSortedWeightLabel.putClientProperty("addWeightUnit", model.getCatchWeightUnit());
    }

    protected void createCatchTotalUnsortedWeightField() {
        $objectMap.put("catchTotalUnsortedWeightField", catchTotalUnsortedWeightField = new JTextField());
        
        catchTotalUnsortedWeightField.setName("catchTotalUnsortedWeightField");
        catchTotalUnsortedWeightField.setColumns(15);
        catchTotalUnsortedWeightField.putClientProperty("help", "tutti.editCatchBatch.field.catchTotalUnsortedWeight.help");
        catchTotalUnsortedWeightField.putClientProperty("computed", true);
    }

    protected void createCatchTotalUnsortedWeightLabel() {
        $objectMap.put("catchTotalUnsortedWeightLabel", catchTotalUnsortedWeightLabel = new JLabel());
        
        catchTotalUnsortedWeightLabel.setName("catchTotalUnsortedWeightLabel");
        catchTotalUnsortedWeightLabel.setText(t("tutti.editCatchBatch.field.catchTotalUnsortedWeight"));
        catchTotalUnsortedWeightLabel.putClientProperty("help", "tutti.editCatchBatch.field.catchTotalUnsortedWeight.help");
        catchTotalUnsortedWeightLabel.putClientProperty("addWeightUnit", model.getCatchWeightUnit());
    }

    protected void createCatchTotalWeightField() {
        $objectMap.put("catchTotalWeightField", catchTotalWeightField = new ComputableDataEditor<Float>(this));
        
        catchTotalWeightField.setName("catchTotalWeightField");
        catchTotalWeightField.setUseFloat(true);
        catchTotalWeightField.setShowReset(true);
        catchTotalWeightField.putClientProperty("help", "tutti.editCatchBatch.field.catchTotalWeight.help");
    }

    protected void createCatchTotalWeightLabel() {
        $objectMap.put("catchTotalWeightLabel", catchTotalWeightLabel = new JLabel());
        
        catchTotalWeightLabel.setName("catchTotalWeightLabel");
        catchTotalWeightLabel.setText(t("tutti.editCatchBatch.field.catchTotalWeight"));
        catchTotalWeightLabel.putClientProperty("help", "tutti.editCatchBatch.field.catchTotalWeight.help");
        catchTotalWeightLabel.putClientProperty("strongStyle", true);
        catchTotalWeightLabel.putClientProperty("addWeightUnit", model.getCatchWeightUnit());
    }

    protected void createCatchesCaracteristicsAttachmentsButton() {
        $objectMap.put("catchesCaracteristicsAttachmentsButton", catchesCaracteristicsAttachmentsButton = new ButtonAttachment(getHandler().getContext(), getModel()));
        
        catchesCaracteristicsAttachmentsButton.setName("catchesCaracteristicsAttachmentsButton");
    }

    protected void createCatchesCaracteristicsTab() {
        $objectMap.put("catchesCaracteristicsTab", catchesCaracteristicsTab = new TabInfo());
    }

    protected void createCatchesCaracteristicsTabPane() {
        $objectMap.put("catchesCaracteristicsTabPane", catchesCaracteristicsTabPane = new JXTitledPanel());
        
        catchesCaracteristicsTabPane.setName("catchesCaracteristicsTabPane");
    }

    protected void createCatchesCaracteristicsTabScrollPane() {
        $objectMap.put("catchesCaracteristicsTabScrollPane", catchesCaracteristicsTabScrollPane = new JScrollPane());
        
        catchesCaracteristicsTabScrollPane.setName("catchesCaracteristicsTabScrollPane");
    }

    protected void createCatchesCaracteristicsTabToolBar() {
        $objectMap.put("catchesCaracteristicsTabToolBar", catchesCaracteristicsTabToolBar = new JToolBar());
        
        catchesCaracteristicsTabToolBar.setName("catchesCaracteristicsTabToolBar");
        catchesCaracteristicsTabToolBar.setFloatable(false);
        catchesCaracteristicsTabToolBar.setOpaque(false);
        catchesCaracteristicsTabToolBar.setBorderPainted(false);
    }

    protected void createCatchesForm() {
        $objectMap.put("catchesForm", catchesForm = new Table());
        
        catchesForm.setName("catchesForm");
    }

    protected void createCleanSpeciesBatchButton() {
        $objectMap.put("cleanSpeciesBatchButton", cleanSpeciesBatchButton = new JButton());
        
        cleanSpeciesBatchButton.setName("cleanSpeciesBatchButton");
        cleanSpeciesBatchButton.setText(t("tutti.editCatchBatch.action.cleanWeights"));
        cleanSpeciesBatchButton.setToolTipText(t("tutti.editCatchBatch.action.cleanWeights.tip"));
        cleanSpeciesBatchButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.action.CleanBatchWeightsAction.class);
        cleanSpeciesBatchButton.putClientProperty("help", "tutti.editCatchBatch.action.cleanWeights.help");
    }

    protected void createComputeSpeciesBatchButton() {
        $objectMap.put("computeSpeciesBatchButton", computeSpeciesBatchButton = new JButton());
        
        computeSpeciesBatchButton.setName("computeSpeciesBatchButton");
        computeSpeciesBatchButton.setText(t("tutti.editCatchBatch.action.computeWeights"));
        computeSpeciesBatchButton.setToolTipText(t("tutti.editCatchBatch.action.computeWeights.tip"));
        computeSpeciesBatchButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.action.ComputeBatchWeightsAction.class);
        computeSpeciesBatchButton.putClientProperty("help", "tutti.editCatchBatch.action.computeWeights.help");
    }

    protected void createCreateFishingOperationActions() {
        $objectMap.put("createFishingOperationActions", createFishingOperationActions = new Table());
        
        createFishingOperationActions.setName("createFishingOperationActions");
    }

    protected void createExportFishingOperationReportButton() {
        $objectMap.put("exportFishingOperationReportButton", exportFishingOperationReportButton = new JButton());
        
        exportFishingOperationReportButton.setName("exportFishingOperationReportButton");
        exportFishingOperationReportButton.setText(t("tutti.editCatchBatch.action.exportFishingOperationReport"));
        exportFishingOperationReportButton.setToolTipText(t("tutti.editCatchBatch.action.exportFishingOperationReport.tip"));
        exportFishingOperationReportButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.action.ExportFishingOperationReportAction.class);
        exportFishingOperationReportButton.putClientProperty("help", "tutti.editCatchBatch.action.exportFishingOperationReport.help");
    }

    protected void createExportFishingOperationReportForSumatraButton() {
        $objectMap.put("exportFishingOperationReportForSumatraButton", exportFishingOperationReportForSumatraButton = new JButton());
        
        exportFishingOperationReportForSumatraButton.setName("exportFishingOperationReportForSumatraButton");
        exportFishingOperationReportForSumatraButton.setText(t("tutti.editCatchBatch.action.exportFishingOperationReportForSumatra"));
        exportFishingOperationReportForSumatraButton.setToolTipText(t("tutti.editCatchBatch.action.exportFishingOperationReportForSumatra.tip"));
        exportFishingOperationReportForSumatraButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.action.ExportFishingOperationForSumatraAction.class);
        exportFishingOperationReportForSumatraButton.putClientProperty("help", "tutti.editCatchBatch.action.exportFishingOperationReportForSumatra.help");
    }

    protected void createIndividualObservationCaracteristicMapEditor() {
        $objectMap.put("individualObservationCaracteristicMapEditor", individualObservationCaracteristicMapEditor = new CaracteristicMapEditorUI(individualObservationTabContent));
        
        individualObservationCaracteristicMapEditor.setName("individualObservationCaracteristicMapEditor");
    }

    protected void createIndividualObservationCaracteristicMapEditorReminderLabel() {
        $objectMap.put("individualObservationCaracteristicMapEditorReminderLabel", individualObservationCaracteristicMapEditorReminderLabel = new JXTitledPanel());
        
        individualObservationCaracteristicMapEditorReminderLabel.setName("individualObservationCaracteristicMapEditorReminderLabel");
    }

    protected void createIndividualObservationTab() {
        $objectMap.put("individualObservationTab", individualObservationTab = new TabInfo());
    }

    protected void createIndividualObservationTabContent() {
        $objectMap.put("individualObservationTabContent", individualObservationTabContent = new IndividualObservationBatchUI(this));
        
        individualObservationTabContent.setName("individualObservationTabContent");
    }

    protected void createIndividualObservationTabCreateBatch() {
        $objectMap.put("individualObservationTabCreateBatch", individualObservationTabCreateBatch = new CreateIndividualObservationBatchUI(this));
        
        individualObservationTabCreateBatch.setName("individualObservationTabCreateBatch");
    }

    protected void createIndividualObservationTabCreateBatchReminderLabel() {
        $objectMap.put("individualObservationTabCreateBatchReminderLabel", individualObservationTabCreateBatchReminderLabel = new JXTitledPanel());
        
        individualObservationTabCreateBatchReminderLabel.setName("individualObservationTabCreateBatchReminderLabel");
    }

    protected void createIndividualObservationTabFishingOperationReminderLabel() {
        $objectMap.put("individualObservationTabFishingOperationReminderLabel", individualObservationTabFishingOperationReminderLabel = new JXTitledPanel());
        
        individualObservationTabFishingOperationReminderLabel.setName("individualObservationTabFishingOperationReminderLabel");
    }

    protected void createIndividualObservationTabPanel() {
        $objectMap.put("individualObservationTabPanel", individualObservationTabPanel = new JPanel());
        
        individualObservationTabPanel.setName("individualObservationTabPanel");
        individualObservationTabPanel.setLayout(individualObservationTabPanelLayout);
    }

    protected void createIndividualObservationTabPanelLayout() {
        $objectMap.put("individualObservationTabPanelLayout", individualObservationTabPanelLayout = new CardLayout2Ext(this, "individualObservationTabPanel"));
    }

    protected void createMarineLitterTab() {
        $objectMap.put("marineLitterTab", marineLitterTab = new TabInfo());
        
        marineLitterTab.setTitle(t("tutti.label.tab.marineLitter"));
    }

    protected void createMarineLitterTabContent() {
        $objectMap.put("marineLitterTabContent", marineLitterTabContent = new MarineLitterBatchUI(this));
        
        marineLitterTabContent.setName("marineLitterTabContent");
    }

    protected void createMarineLitterTabCreateBatch() {
        $objectMap.put("marineLitterTabCreateBatch", marineLitterTabCreateBatch = new CreateMarineLitterBatchUI(this));
        
        marineLitterTabCreateBatch.setName("marineLitterTabCreateBatch");
    }

    protected void createMarineLitterTabCreateBatchReminderLabel() {
        $objectMap.put("marineLitterTabCreateBatchReminderLabel", marineLitterTabCreateBatchReminderLabel = new JXTitledPanel());
        
        marineLitterTabCreateBatchReminderLabel.setName("marineLitterTabCreateBatchReminderLabel");
    }

    protected void createMarineLitterTabFishingOperationReminderLabel() {
        $objectMap.put("marineLitterTabFishingOperationReminderLabel", marineLitterTabFishingOperationReminderLabel = new JXTitledPanel());
        
        marineLitterTabFishingOperationReminderLabel.setName("marineLitterTabFishingOperationReminderLabel");
    }

    protected void createMarineLitterTabPanel() {
        $objectMap.put("marineLitterTabPanel", marineLitterTabPanel = new JPanel());
        
        marineLitterTabPanel.setName("marineLitterTabPanel");
        marineLitterTabPanel.setLayout(marineLitterTabPanelLayout);
    }

    protected void createMarineLitterTabPanelLayout() {
        $objectMap.put("marineLitterTabPanelLayout", marineLitterTabPanelLayout = new CardLayout2Ext(this, "marineLitterTabPanel"));
    }

    protected void createMarineLitterTable() {
        $objectMap.put("marineLitterTable", marineLitterTable = new Table());
        
        marineLitterTable.setName("marineLitterTable");
    }

    protected void createMarineLitterTotalWeightField() {
        $objectMap.put("marineLitterTotalWeightField", marineLitterTotalWeightField = new ComputableDataEditor<Float>(this));
        
        marineLitterTotalWeightField.setName("marineLitterTotalWeightField");
        marineLitterTotalWeightField.setUseFloat(true);
        marineLitterTotalWeightField.setShowReset(true);
        marineLitterTotalWeightField.putClientProperty("help", "tutti.editCatchBatch.field.marineLitterTotalWeight.help");
    }

    protected void createMarineLitterTotalWeightLabel() {
        $objectMap.put("marineLitterTotalWeightLabel", marineLitterTotalWeightLabel = new JLabel());
        
        marineLitterTotalWeightLabel.setName("marineLitterTotalWeightLabel");
        marineLitterTotalWeightLabel.setText(t("tutti.editCatchBatch.field.marineLitterTotalWeight"));
        marineLitterTotalWeightLabel.putClientProperty("help", "tutti.editCatchBatch.field.marineLitterTotalWeight.help");
        marineLitterTotalWeightLabel.putClientProperty("strongStyle", true);
        marineLitterTotalWeightLabel.putClientProperty("addWeightUnit", handler.getConfig().getMarineLitterWeightUnit());
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(EditCatchesUIModel.class));
    }

    protected void createSaveButton() {
        $objectMap.put("saveButton", saveButton = new JButton());
        
        saveButton.setName("saveButton");
        saveButton.setText(t("tutti.editCatchBatch.action.saveCatchBatch"));
        saveButton.setToolTipText(t("tutti.editCatchBatch.action.saveCatchBatch.tip"));
        saveButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.action.SaveCatchBatchAction.class);
        saveButton.putClientProperty("help", "tutti.editCatchBatch.action.saveCatchBatch.help");
    }

    protected void createSpeciesTab() {
        $objectMap.put("speciesTab", speciesTab = new TabInfo());
    }

    protected void createSpeciesTabAddSampleCategoryBatch() {
        $objectMap.put("speciesTabAddSampleCategoryBatch", speciesTabAddSampleCategoryBatch = new SplitSpeciesBatchUI(this));
        
        speciesTabAddSampleCategoryBatch.setName("speciesTabAddSampleCategoryBatch");
    }

    protected void createSpeciesTabAddSampleCategoryBatchReminderLabel() {
        $objectMap.put("speciesTabAddSampleCategoryBatchReminderLabel", speciesTabAddSampleCategoryBatchReminderLabel = new JXTitledPanel());
        
        speciesTabAddSampleCategoryBatchReminderLabel.setName("speciesTabAddSampleCategoryBatchReminderLabel");
    }

    protected void createSpeciesTabContent() {
        $objectMap.put("speciesTabContent", speciesTabContent = new SpeciesBatchUI(this));
        
        speciesTabContent.setName("speciesTabContent");
    }

    protected void createSpeciesTabCreateBatch() {
        $objectMap.put("speciesTabCreateBatch", speciesTabCreateBatch = new CreateSpeciesBatchUI(this));
        
        speciesTabCreateBatch.setName("speciesTabCreateBatch");
    }

    protected void createSpeciesTabCreateBatchReminderLabel() {
        $objectMap.put("speciesTabCreateBatchReminderLabel", speciesTabCreateBatchReminderLabel = new JXTitledPanel());
        
        speciesTabCreateBatchReminderLabel.setName("speciesTabCreateBatchReminderLabel");
    }

    protected void createSpeciesTabFishingOperationReminderLabel() {
        $objectMap.put("speciesTabFishingOperationReminderLabel", speciesTabFishingOperationReminderLabel = new JXTitledPanel());
        
        speciesTabFishingOperationReminderLabel.setName("speciesTabFishingOperationReminderLabel");
    }

    protected void createSpeciesTabFrequencyEditor() {
        $objectMap.put("speciesTabFrequencyEditor", speciesTabFrequencyEditor = new SpeciesFrequencyUI(speciesTabContent));
        
        speciesTabFrequencyEditor.setName("speciesTabFrequencyEditor");
    }

    protected void createSpeciesTabFrequencyEditorReminderLabel() {
        $objectMap.put("speciesTabFrequencyEditorReminderLabel", speciesTabFrequencyEditorReminderLabel = new JXTitledPanel());
        
        speciesTabFrequencyEditorReminderLabel.setName("speciesTabFrequencyEditorReminderLabel");
    }

    protected void createSpeciesTabPanel() {
        $objectMap.put("speciesTabPanel", speciesTabPanel = new JPanel());
        
        speciesTabPanel.setName("speciesTabPanel");
        speciesTabPanel.setLayout(speciesTabPanelLayout);
    }

    protected void createSpeciesTabPanelLayout() {
        $objectMap.put("speciesTabPanelLayout", speciesTabPanelLayout = new CardLayout2Ext(this, "speciesTabPanel"));
    }

    protected void createSpeciesTabSplitBatch() {
        $objectMap.put("speciesTabSplitBatch", speciesTabSplitBatch = new SplitSpeciesBatchUI(this));
        
        speciesTabSplitBatch.setName("speciesTabSplitBatch");
    }

    protected void createSpeciesTabSplitBatchReminderLabel() {
        $objectMap.put("speciesTabSplitBatchReminderLabel", speciesTabSplitBatchReminderLabel = new JXTitledPanel());
        
        speciesTabSplitBatchReminderLabel.setName("speciesTabSplitBatchReminderLabel");
    }

    protected void createSpeciesTable() {
        $objectMap.put("speciesTable", speciesTable = new Table());
        
        speciesTable.setName("speciesTable");
    }

    protected void createSpeciesTotalSampleSortedWeightField() {
        $objectMap.put("speciesTotalSampleSortedWeightField", speciesTotalSampleSortedWeightField = new JTextField());
        
        speciesTotalSampleSortedWeightField.setName("speciesTotalSampleSortedWeightField");
        speciesTotalSampleSortedWeightField.setColumns(15);
        speciesTotalSampleSortedWeightField.putClientProperty("help", "tutti.editCatchBatch.field.speciesTotalSampleSortedWeight.help");
        speciesTotalSampleSortedWeightField.putClientProperty("computed", true);
    }

    protected void createSpeciesTotalSampleSortedWeightLabel() {
        $objectMap.put("speciesTotalSampleSortedWeightLabel", speciesTotalSampleSortedWeightLabel = new JLabel());
        
        speciesTotalSampleSortedWeightLabel.setName("speciesTotalSampleSortedWeightLabel");
        speciesTotalSampleSortedWeightLabel.setText(t("tutti.editCatchBatch.field.speciesTotalSampleSortedWeight"));
        speciesTotalSampleSortedWeightLabel.putClientProperty("help", "tutti.editCatchBatch.field.speciesTotalSampleSortedWeight.help");
        speciesTotalSampleSortedWeightLabel.putClientProperty("addWeightUnit", handler.getConfig().getSpeciesWeightUnit());
    }

    protected void createSpeciesTotalSortedWeightField() {
        $objectMap.put("speciesTotalSortedWeightField", speciesTotalSortedWeightField = new ComputableDataEditor<Float>(this));
        
        speciesTotalSortedWeightField.setName("speciesTotalSortedWeightField");
        speciesTotalSortedWeightField.setUseFloat(true);
        speciesTotalSortedWeightField.setShowReset(true);
        speciesTotalSortedWeightField.putClientProperty("help", "tutti.editCatchBatch.field.speciesTotalSortedWeight.help");
    }

    protected void createSpeciesTotalSortedWeightLabel() {
        $objectMap.put("speciesTotalSortedWeightLabel", speciesTotalSortedWeightLabel = new JLabel());
        
        speciesTotalSortedWeightLabel.setName("speciesTotalSortedWeightLabel");
        speciesTotalSortedWeightLabel.setText(t("tutti.editCatchBatch.field.speciesTotalSortedWeight"));
        speciesTotalSortedWeightLabel.putClientProperty("help", "tutti.editCatchBatch.field.speciesTotalSortedWeight.help");
        speciesTotalSortedWeightLabel.putClientProperty("addWeightUnit", handler.getConfig().getSpeciesWeightUnit());
    }

    protected void createSpeciesTotalUnsortedWeightField() {
        $objectMap.put("speciesTotalUnsortedWeightField", speciesTotalUnsortedWeightField = new JTextField());
        
        speciesTotalUnsortedWeightField.setName("speciesTotalUnsortedWeightField");
        speciesTotalUnsortedWeightField.setColumns(15);
        speciesTotalUnsortedWeightField.putClientProperty("help", "tutti.editCatchBatch.field.speciesTotalUnsortedWeight.help");
        speciesTotalUnsortedWeightField.putClientProperty("computed", true);
    }

    protected void createSpeciesTotalUnsortedWeightLabel() {
        $objectMap.put("speciesTotalUnsortedWeightLabel", speciesTotalUnsortedWeightLabel = new JLabel());
        
        speciesTotalUnsortedWeightLabel.setName("speciesTotalUnsortedWeightLabel");
        speciesTotalUnsortedWeightLabel.setText(t("tutti.editCatchBatch.field.speciesTotalUnsortedWeight"));
        speciesTotalUnsortedWeightLabel.putClientProperty("help", "tutti.editCatchBatch.field.speciesTotalUnsortedWeight.help");
        speciesTotalUnsortedWeightLabel.putClientProperty("addWeightUnit", handler.getConfig().getSpeciesWeightUnit());
    }

    protected void createSpeciesTotalWeightField() {
        $objectMap.put("speciesTotalWeightField", speciesTotalWeightField = new JTextField());
        
        speciesTotalWeightField.setName("speciesTotalWeightField");
        speciesTotalWeightField.setColumns(15);
        speciesTotalWeightField.putClientProperty("help", "tutti.editCatchBatch.field.speciesTotalWeight.help");
        speciesTotalWeightField.putClientProperty("computed", true);
    }

    protected void createSpeciesTotalWeightLabel() {
        $objectMap.put("speciesTotalWeightLabel", speciesTotalWeightLabel = new JLabel());
        
        speciesTotalWeightLabel.setName("speciesTotalWeightLabel");
        speciesTotalWeightLabel.setText(t("tutti.editCatchBatch.field.speciesTotalWeight"));
        speciesTotalWeightLabel.putClientProperty("help", "tutti.editCatchBatch.field.speciesTotalWeight.help");
        speciesTotalWeightLabel.putClientProperty("strongStyle", true);
        speciesTotalWeightLabel.putClientProperty("addWeightUnit", handler.getConfig().getSpeciesWeightUnit());
    }

    protected void createTabPane() {
        $objectMap.put("tabPane", tabPane = new JTabbedPane());
        
        tabPane.setName("tabPane");
    }

    protected void createTremieCarrouselRow() {
        $objectMap.put("tremieCarrouselRow", tremieCarrouselRow = new Table());
        
        tremieCarrouselRow.setName("tremieCarrouselRow");
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = SwingValidator.newValidator(EditCatchesUIModel.class, "validate"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToEditCatchesTopPanel();
        addChildrenToValidator();
        addChildrenToCatchesCaracteristicsTabToolBar();
        addChildrenToTabPane();
        addChildrenToCatchesCaracteristicsTabPane();
        addChildrenToCatchesCaracteristicsTabScrollPane();
        // inline complete setup of $JPanel0
        $JPanel0.add(catchesForm, BorderLayout.NORTH);
        addChildrenToCatchesForm();
        addChildrenToCatchTable();
        addChildrenToTremieCarrouselRow();
        addChildrenToSpeciesTable();
        addChildrenToBenthosTable();
        addChildrenToMarineLitterTable();
        addChildrenToSpeciesTabPanel();
        addChildrenToSpeciesTabFishingOperationReminderLabel();
        addChildrenToSpeciesTabCreateBatchReminderLabel();
        addChildrenToSpeciesTabSplitBatchReminderLabel();
        addChildrenToSpeciesTabAddSampleCategoryBatchReminderLabel();
        addChildrenToSpeciesTabFrequencyEditorReminderLabel();
        addChildrenToBenthosTabPanel();
        addChildrenToBenthosTabFishingOperationReminderLabel();
        addChildrenToBenthosTabCreateBatchReminderLabel();
        addChildrenToBenthosTabSplitBatchReminderLabel();
        addChildrenToBenthosTabAddSampleCategoryBatchReminderLabel();
        addChildrenToBenthosTabFrequencyEditorReminderLabel();
        addChildrenToMarineLitterTabPanel();
        addChildrenToMarineLitterTabFishingOperationReminderLabel();
        addChildrenToMarineLitterTabCreateBatchReminderLabel();
        addChildrenToIndividualObservationTabPanel();
        addChildrenToIndividualObservationTabFishingOperationReminderLabel();
        addChildrenToIndividualObservationTabCreateBatchReminderLabel();
        addChildrenToIndividualObservationCaracteristicMapEditorReminderLabel();
        addChildrenToAccidentalTabPanel();
        addChildrenToAccidentalTabFishingOperationReminderLabel();
        addChildrenToAccidentalTabCreateBatchReminderLabel();
        addChildrenToAccidentalCaracteristicMapEditorReminderLabel();
        addChildrenToCreateFishingOperationActions();
        
        // apply 30 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 69 property setters
        exportFishingOperationReportButton.setIcon(SwingUtil.createActionIcon("export"));
        exportFishingOperationReportButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.editCatchBatch.action.exportFishingOperationReport.mnemonic"),'Z'));
        exportFishingOperationReportForSumatraButton.setIcon(SwingUtil.createActionIcon("export"));
        exportFishingOperationReportForSumatraButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.editCatchBatch.action.exportFishingOperationReportForSumatra.mnemonic"),'Z'));
        catchesCaracteristicsTabPane.setRightDecoration(catchesCaracteristicsTabToolBar);
        catchTable.setBorder(BorderFactory.createTitledBorder(t("tutti.editCatchBatch.legend.total")));
        catchTotalWeightLabel.setLabelFor(catchTotalWeightField);
        catchTotalWeightLabel.setToolTipText(t("tutti.editCatchBatch.field.catchTotalWeight.tip"));
        catchTotalWeightField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        catchTotalWeightField.setComputedDataColor(handler.getConfig().getColorComputedWeights());
        catchTotalWeightField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        catchTotalSortedWeightLabel.setLabelFor(catchTotalSortedWeightField);
        catchTotalSortedWeightLabel.setToolTipText(t("tutti.editCatchBatch.field.catchTotalSortedWeight.tip"));
        catchTotalSortedCarousselWeightLabel.setLabelFor(catchTotalSortedCarousselWeightField);
        catchTotalSortedCarousselWeightLabel.setToolTipText(t("tutti.editCatchBatch.field.catchTotalSortedCarousselWeight.tip"));
        catchTotalSortedTremisWeightLabel.setLabelFor(catchTotalSortedTremisWeightField);
        catchTotalSortedTremisWeightLabel.setToolTipText(t("tutti.editCatchBatch.field.catchTotalSortedTremisWeight.tip"));
        catchTotalUnsortedWeightLabel.setLabelFor(catchTotalUnsortedWeightField);
        catchTotalUnsortedWeightLabel.setToolTipText(t("tutti.editCatchBatch.field.catchTotalUnsortedWeight.tip"));
        catchTotalRejectedWeightLabel.setLabelFor(catchTotalRejectedWeightField);
        catchTotalRejectedWeightLabel.setToolTipText(t("tutti.editCatchBatch.field.catchTotalRejectedWeight.tip"));
        catchTotalRejectedWeightField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        catchTotalRejectedWeightField.setComputedDataColor(handler.getConfig().getColorComputedWeights());
        catchTotalRejectedWeightField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        speciesTable.setBorder(BorderFactory.createTitledBorder(t("tutti.editCatchBatch.legend.species")));
        speciesTotalWeightLabel.setLabelFor(speciesTotalWeightField);
        speciesTotalWeightLabel.setToolTipText(t("tutti.editCatchBatch.field.speciesTotalWeight.tip"));
        speciesTotalSortedWeightLabel.setLabelFor(speciesTotalSortedWeightField);
        speciesTotalSortedWeightLabel.setToolTipText(t("tutti.editCatchBatch.field.speciesTotalSortedWeight.tip"));
        speciesTotalSortedWeightField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        speciesTotalSortedWeightField.setComputedDataColor(handler.getConfig().getColorComputedWeights());
        speciesTotalSortedWeightField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        speciesTotalSampleSortedWeightLabel.setLabelFor(speciesTotalSampleSortedWeightField);
        speciesTotalSampleSortedWeightLabel.setToolTipText(t("tutti.editCatchBatch.field.speciesTotalSampleSortedWeight.tip"));
        speciesTotalUnsortedWeightLabel.setLabelFor(speciesTotalUnsortedWeightField);
        speciesTotalUnsortedWeightLabel.setToolTipText(t("tutti.editCatchBatch.field.speciesTotalUnsortedWeight.tip"));
        benthosTable.setBorder(BorderFactory.createTitledBorder(t("tutti.editCatchBatch.legend.benthos")));
        benthosTotalWeightLabel.setLabelFor(benthosTotalWeightField);
        benthosTotalWeightLabel.setToolTipText(t("tutti.editCatchBatch.field.benthosTotalWeight.tip"));
        benthosTotalSortedWeightLabel.setLabelFor(benthosTotalSortedWeightField);
        benthosTotalSortedWeightLabel.setToolTipText(t("tutti.editCatchBatch.field.benthosTotalSortedWeight.tip"));
        benthosTotalSortedWeightField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        benthosTotalSortedWeightField.setComputedDataColor(handler.getConfig().getColorComputedWeights());
        benthosTotalSortedWeightField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        benthosTotalSampleSortedWeightLabel.setLabelFor(benthosTotalSampleSortedWeightField);
        benthosTotalSampleSortedWeightLabel.setToolTipText(t("tutti.editCatchBatch.field.benthosTotalSampleSortedWeight.tip"));
        benthosTotalUnsortedWeightLabel.setLabelFor(benthosTotalUnsortedWeightField);
        benthosTotalUnsortedWeightLabel.setToolTipText(t("tutti.editCatchBatch.field.benthosTotalUnsortedWeight.tip"));
        marineLitterTable.setBorder(BorderFactory.createTitledBorder(t("tutti.editCatchBatch.legend.marineLitter")));
        marineLitterTotalWeightLabel.setLabelFor(marineLitterTotalWeightField);
        marineLitterTotalWeightLabel.setToolTipText(t("tutti.editCatchBatch.field.marineLitterTotalWeight.tip"));
        marineLitterTotalWeightField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        marineLitterTotalWeightField.setComputedDataColor(handler.getConfig().getColorComputedWeights());
        marineLitterTotalWeightField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        cancelButton.setIcon(SwingUtil.createActionIcon("cancel"));
        cancelButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.editCatchBatch.action.cancelEditCatchBatch.mnemonic"),'Z'));
        saveButton.setIcon(SwingUtil.createActionIcon("save"));
        saveButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.editCatchBatch.action.saveCatchBatch.mnemonic"),'Z'));
        cleanSpeciesBatchButton.setIcon(SwingUtil.createActionIcon("clean"));
        cleanSpeciesBatchButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.editCatchBatch.action.cleanWeights.mnemonic"),'Z'));
        computeSpeciesBatchButton.setIcon(SwingUtil.createActionIcon("generate"));
        computeSpeciesBatchButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.editCatchBatch.action.computeWeights.mnemonic"),'Z'));
        // late initializer
        // help broker setup
        TuttiHelpBroker _broker = getBroker();
        registerHelpId(_broker, editCatchesTopPanel, "tutti.editCatchBatch.help");
        registerHelpId(_broker, exportFishingOperationReportButton, "tutti.editCatchBatch.action.exportFishingOperationReport.help");
        registerHelpId(_broker, exportFishingOperationReportForSumatraButton, "tutti.editCatchBatch.action.exportFishingOperationReportForSumatra.help");
        registerHelpId(_broker, catchTotalWeightLabel, "tutti.editCatchBatch.field.catchTotalWeight.help");
        registerHelpId(_broker, catchTotalWeightField, "tutti.editCatchBatch.field.catchTotalWeight.help");
        registerHelpId(_broker, catchTotalSortedWeightLabel, "tutti.editCatchBatch.field.catchTotalSortedWeight.help");
        registerHelpId(_broker, catchTotalSortedWeightField, "tutti.editCatchBatch.field.catchTotalSortedWeight.help");
        registerHelpId(_broker, catchTotalSortedCarousselWeightLabel, "tutti.editCatchBatch.field.catchTotalSortedCarousselWeight.help");
        registerHelpId(_broker, catchTotalSortedCarousselWeightField, "tutti.editCatchBatch.field.catchTotalSortedCarousselWeight.help");
        registerHelpId(_broker, catchTotalSortedTremisWeightLabel, "tutti.editCatchBatch.field.catchTotalSortedTremisWeight.help");
        registerHelpId(_broker, catchTotalSortedTremisWeightField, "tutti.editCatchBatch.field.catchTotalSortedTremisWeight.help");
        registerHelpId(_broker, catchTotalUnsortedWeightLabel, "tutti.editCatchBatch.field.catchTotalUnsortedWeight.help");
        registerHelpId(_broker, catchTotalUnsortedWeightField, "tutti.editCatchBatch.field.catchTotalUnsortedWeight.help");
        registerHelpId(_broker, catchTotalRejectedWeightLabel, "tutti.editCatchBatch.field.catchTotalRejectedWeight.help");
        registerHelpId(_broker, catchTotalRejectedWeightField, "tutti.editCatchBatch.field.catchTotalRejectedWeight.help");
        registerHelpId(_broker, speciesTotalWeightLabel, "tutti.editCatchBatch.field.speciesTotalWeight.help");
        registerHelpId(_broker, speciesTotalWeightField, "tutti.editCatchBatch.field.speciesTotalWeight.help");
        registerHelpId(_broker, speciesTotalSortedWeightLabel, "tutti.editCatchBatch.field.speciesTotalSortedWeight.help");
        registerHelpId(_broker, speciesTotalSortedWeightField, "tutti.editCatchBatch.field.speciesTotalSortedWeight.help");
        registerHelpId(_broker, speciesTotalSampleSortedWeightLabel, "tutti.editCatchBatch.field.speciesTotalSampleSortedWeight.help");
        registerHelpId(_broker, speciesTotalSampleSortedWeightField, "tutti.editCatchBatch.field.speciesTotalSampleSortedWeight.help");
        registerHelpId(_broker, speciesTotalUnsortedWeightLabel, "tutti.editCatchBatch.field.speciesTotalUnsortedWeight.help");
        registerHelpId(_broker, speciesTotalUnsortedWeightField, "tutti.editCatchBatch.field.speciesTotalUnsortedWeight.help");
        registerHelpId(_broker, benthosTotalWeightLabel, "tutti.editCatchBatch.field.benthosTotalWeight.help");
        registerHelpId(_broker, benthosTotalWeightField, "tutti.editCatchBatch.field.benthosTotalWeight.help");
        registerHelpId(_broker, benthosTotalSortedWeightLabel, "tutti.editCatchBatch.field.benthosTotalSortedWeight.help");
        registerHelpId(_broker, benthosTotalSortedWeightField, "tutti.editCatchBatch.field.benthosTotalSortedWeight.help");
        registerHelpId(_broker, benthosTotalSampleSortedWeightLabel, "tutti.editCatchBatch.field.benthosTotalSampleSortedWeight.help");
        registerHelpId(_broker, benthosTotalSampleSortedWeightField, "tutti.editCatchBatch.field.benthosTotalSampleSortedWeight.help");
        registerHelpId(_broker, benthosTotalUnsortedWeightLabel, "tutti.editCatchBatch.field.benthosTotalUnsortedWeight.help");
        registerHelpId(_broker, benthosTotalUnsortedWeightField, "tutti.editCatchBatch.field.benthosTotalUnsortedWeight.help");
        registerHelpId(_broker, marineLitterTotalWeightLabel, "tutti.editCatchBatch.field.marineLitterTotalWeight.help");
        registerHelpId(_broker, marineLitterTotalWeightField, "tutti.editCatchBatch.field.marineLitterTotalWeight.help");
        registerHelpId(_broker, cancelButton, "tutti.editCatchBatch.action.cancelEditCatchBatch.help");
        registerHelpId(_broker, saveButton, "tutti.editCatchBatch.action.saveCatchBatch.help");
        registerHelpId(_broker, cleanSpeciesBatchButton, "tutti.editCatchBatch.action.cleanWeights.help");
        registerHelpId(_broker, computeSpeciesBatchButton, "tutti.editCatchBatch.action.computeWeights.help");
        _broker.prepareUI(this);
        // register 1 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        handler.beforeInit(this);
        $objectMap.put("editCatchesTopPanel", editCatchesTopPanel);
        createModel();
        createValidator();
        createSpeciesTabPanelLayout();
        createBenthosTabPanelLayout();
        createMarineLitterTabPanelLayout();
        createAccidentalTabPanelLayout();
        createIndividualObservationTabPanelLayout();
        createBroker();
        createCatchesCaracteristicsTabToolBar();
        createExportFishingOperationReportButton();
        createExportFishingOperationReportForSumatraButton();
        createCatchesCaracteristicsAttachmentsButton();
        createTabPane();
        createCatchesCaracteristicsTabPane();
        createCatchesCaracteristicsTabScrollPane();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new BorderLayout());
        createCatchesForm();
        createCatchTable();
        createCatchTotalWeightLabel();
        createCatchTotalWeightField();
        createCatchTotalSortedWeightLabel();
        createCatchTotalSortedWeightField();
        createTremieCarrouselRow();
        createCatchTotalSortedCarousselWeightLabel();
        createCatchTotalSortedCarousselWeightField();
        createCatchTotalSortedTremisWeightLabel();
        createCatchTotalSortedTremisWeightField();
        createCatchTotalUnsortedWeightLabel();
        createCatchTotalUnsortedWeightField();
        createCatchTotalRejectedWeightLabel();
        createCatchTotalRejectedWeightField();
        createSpeciesTable();
        createSpeciesTotalWeightLabel();
        createSpeciesTotalWeightField();
        createSpeciesTotalSortedWeightLabel();
        createSpeciesTotalSortedWeightField();
        createSpeciesTotalSampleSortedWeightLabel();
        createSpeciesTotalSampleSortedWeightField();
        createSpeciesTotalUnsortedWeightLabel();
        createSpeciesTotalUnsortedWeightField();
        createBenthosTable();
        createBenthosTotalWeightLabel();
        createBenthosTotalWeightField();
        createBenthosTotalSortedWeightLabel();
        createBenthosTotalSortedWeightField();
        createBenthosTotalSampleSortedWeightLabel();
        createBenthosTotalSampleSortedWeightField();
        createBenthosTotalUnsortedWeightLabel();
        createBenthosTotalUnsortedWeightField();
        createMarineLitterTable();
        createMarineLitterTotalWeightLabel();
        createMarineLitterTotalWeightField();
        createSpeciesTabPanel();
        createSpeciesTabFishingOperationReminderLabel();
        createSpeciesTabContent();
        createSpeciesTabCreateBatchReminderLabel();
        createSpeciesTabCreateBatch();
        createSpeciesTabSplitBatchReminderLabel();
        createSpeciesTabSplitBatch();
        createSpeciesTabAddSampleCategoryBatchReminderLabel();
        createSpeciesTabAddSampleCategoryBatch();
        createSpeciesTabFrequencyEditorReminderLabel();
        createSpeciesTabFrequencyEditor();
        createBenthosTabPanel();
        createBenthosTabFishingOperationReminderLabel();
        createBenthosTabContent();
        createBenthosTabCreateBatchReminderLabel();
        createBenthosTabCreateBatch();
        createBenthosTabSplitBatchReminderLabel();
        createBenthosTabSplitBatch();
        createBenthosTabAddSampleCategoryBatchReminderLabel();
        createBenthosTabAddSampleCategoryBatch();
        createBenthosTabFrequencyEditorReminderLabel();
        createBenthosTabFrequencyEditor();
        createMarineLitterTabPanel();
        createMarineLitterTabFishingOperationReminderLabel();
        createMarineLitterTabContent();
        createMarineLitterTabCreateBatchReminderLabel();
        createMarineLitterTabCreateBatch();
        createIndividualObservationTabPanel();
        createIndividualObservationTabFishingOperationReminderLabel();
        createIndividualObservationTabContent();
        createIndividualObservationTabCreateBatchReminderLabel();
        createIndividualObservationTabCreateBatch();
        createIndividualObservationCaracteristicMapEditorReminderLabel();
        createIndividualObservationCaracteristicMapEditor();
        createAccidentalTabPanel();
        createAccidentalTabFishingOperationReminderLabel();
        createAccidentalTabContent();
        createAccidentalTabCreateBatchReminderLabel();
        createAccidentalTabCreateBatch();
        createAccidentalCaracteristicMapEditorReminderLabel();
        createAccidentalCaracteristicMapEditor();
        createCreateFishingOperationActions();
        createCancelButton();
        createSaveButton();
        createCleanSpeciesBatchButton();
        createComputeSpeciesBatchButton();
        createCatchesCaracteristicsTab();
        createSpeciesTab();
        createBenthosTab();
        createMarineLitterTab();
        createIndividualObservationTab();
        createAccidentalTab();
        // inline creation of editCatchesTopPanel
        setName("editCatchesTopPanel");
        setLayout(new BorderLayout());
        editCatchesTopPanel.putClientProperty("help", "tutti.editCatchBatch.help");
        
        // registers 30 data bindings
        $registerDefaultBindings();
        $completeSetup();
        handler.afterInit(this);
    }

    private void $registerDefaultBindings() {
        // register 30 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CATCHES_CARACTERISTICS_ATTACHMENTS_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("objectId", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    catchesCaracteristicsAttachmentsButton.setEnabled(model.getObjectId() != null);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("objectId", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CATCH_TOTAL_WEIGHT_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("catchTotalWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    catchTotalWeightField.setModel(model.getCatchTotalWeight());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("catchTotalWeight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CATCH_TOTAL_WEIGHT_FIELD_BEAN, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("catchTotalComputedOrNotWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    catchTotalWeightField.setBean(model.getCatchTotalComputedOrNotWeight());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("catchTotalComputedOrNotWeight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CATCH_TOTAL_SORTED_WEIGHT_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("catchTotalSortedComputedWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(catchTotalSortedWeightField, handler.getWeightStringValue(catchTotalSortedWeightLabel, model.getCatchTotalSortedComputedWeight()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("catchTotalSortedComputedWeight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_TREMIE_CARROUSEL_ROW_VISIBLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("fishingOperation", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null && model.getFishingOperation() != null && handler != null && handler.getConfig() != null) {
                    tremieCarrouselRow.setVisible(model.getFishingOperation().getVessel() != null && model.getFishingOperation().getVessel().getId().equals(handler.getConfig().getTremieCarousselVesselId()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("fishingOperation", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CATCH_TOTAL_SORTED_CAROUSSEL_WEIGHT_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("catchTotalSortedCarousselWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(catchTotalSortedCarousselWeightField, handler.getWeightStringValue(catchTotalSortedCarousselWeightLabel, model.getCatchTotalSortedCarousselWeight()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("catchTotalSortedCarousselWeight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CATCH_TOTAL_SORTED_TREMIS_WEIGHT_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("catchTotalSortedTremisWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(catchTotalSortedTremisWeightField, handler.getWeightStringValue(catchTotalSortedTremisWeightLabel, model.getCatchTotalSortedTremisWeight()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("catchTotalSortedTremisWeight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CATCH_TOTAL_UNSORTED_WEIGHT_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("catchTotalUnsortedComputedWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(catchTotalUnsortedWeightField, handler.getWeightStringValue(catchTotalUnsortedWeightLabel, model.getCatchTotalUnsortedComputedWeight()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("catchTotalUnsortedComputedWeight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CATCH_TOTAL_REJECTED_WEIGHT_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("catchTotalRejectedWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    catchTotalRejectedWeightField.setModel(model.getCatchTotalRejectedWeight());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("catchTotalRejectedWeight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CATCH_TOTAL_REJECTED_WEIGHT_FIELD_BEAN, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("catchTotalRejectedComputedOrNotWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    catchTotalRejectedWeightField.setBean(model.getCatchTotalRejectedComputedOrNotWeight());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("catchTotalRejectedComputedOrNotWeight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SPECIES_TOTAL_WEIGHT_FIELD_TEXT, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("catchTotalRejectedWeight", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("speciesTotalComputedWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(speciesTotalWeightField, handler.getWeightStringValueForTotalWeight(speciesTotalWeightLabel, model.getCatchTotalRejectedWeight(), model.getSpeciesTotalComputedWeight()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("catchTotalRejectedWeight", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("speciesTotalComputedWeight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SPECIES_TOTAL_WEIGHT_FIELD_DISABLED_TEXT_COLOR, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("catchTotalRejectedWeight", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("speciesTotalComputedWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    speciesTotalWeightField.setDisabledTextColor(handler.getWeightColorForTotalWeight(model.getCatchTotalRejectedWeight(), model.getSpeciesTotalComputedWeight()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("catchTotalRejectedWeight", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("speciesTotalComputedWeight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SPECIES_TOTAL_SORTED_WEIGHT_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("speciesTotalSortedWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    speciesTotalSortedWeightField.setModel(model.getSpeciesTotalSortedWeight());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("speciesTotalSortedWeight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SPECIES_TOTAL_SORTED_WEIGHT_FIELD_BEAN, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("speciesTotalSortedComputedOrNotWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    speciesTotalSortedWeightField.setBean(model.getSpeciesTotalSortedComputedOrNotWeight());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("speciesTotalSortedComputedOrNotWeight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SPECIES_TOTAL_SAMPLE_SORTED_WEIGHT_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("speciesTotalSampleSortedComputedWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(speciesTotalSampleSortedWeightField, handler.getWeightStringValue(speciesTotalSampleSortedWeightLabel, model.getSpeciesTotalSampleSortedComputedWeight()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("speciesTotalSampleSortedComputedWeight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SPECIES_TOTAL_UNSORTED_WEIGHT_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("speciesTotalUnsortedComputedWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(speciesTotalUnsortedWeightField, handler.getWeightStringValue(speciesTotalUnsortedWeightLabel, model.getSpeciesTotalUnsortedComputedWeight()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("speciesTotalUnsortedComputedWeight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_BENTHOS_TOTAL_WEIGHT_FIELD_TEXT, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("catchTotalRejectedWeight", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("benthosTotalComputedWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(benthosTotalWeightField, handler.getWeightStringValueForTotalWeight(benthosTotalWeightLabel, model.getCatchTotalRejectedWeight(), model.getBenthosTotalComputedWeight()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("catchTotalRejectedWeight", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("benthosTotalComputedWeight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_BENTHOS_TOTAL_WEIGHT_FIELD_DISABLED_TEXT_COLOR, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("catchTotalRejectedWeight", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("benthosTotalComputedWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    benthosTotalWeightField.setDisabledTextColor(handler.getWeightColorForTotalWeight(model.getCatchTotalRejectedWeight(), model.getBenthosTotalComputedWeight()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("catchTotalRejectedWeight", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("benthosTotalComputedWeight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_BENTHOS_TOTAL_SORTED_WEIGHT_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("benthosTotalSortedWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    benthosTotalSortedWeightField.setModel(model.getBenthosTotalSortedWeight());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("benthosTotalSortedWeight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_BENTHOS_TOTAL_SORTED_WEIGHT_FIELD_BEAN, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("benthosTotalSortedComputedOrNotWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    benthosTotalSortedWeightField.setBean(model.getBenthosTotalSortedComputedOrNotWeight());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("benthosTotalSortedComputedOrNotWeight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_BENTHOS_TOTAL_SAMPLE_SORTED_WEIGHT_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("benthosTotalSampleSortedComputedWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(benthosTotalSampleSortedWeightField, handler.getWeightStringValue(benthosTotalSampleSortedWeightLabel, model.getBenthosTotalSampleSortedComputedWeight()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("benthosTotalSampleSortedComputedWeight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_BENTHOS_TOTAL_UNSORTED_WEIGHT_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("benthosTotalUnsortedComputedWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(benthosTotalUnsortedWeightField, handler.getWeightStringValue(benthosTotalUnsortedWeightLabel, model.getBenthosTotalUnsortedComputedWeight()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("benthosTotalUnsortedComputedWeight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MARINE_LITTER_TOTAL_WEIGHT_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("marineLitterTotalWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    marineLitterTotalWeightField.setModel(model.getMarineLitterTotalWeight());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("marineLitterTotalWeight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MARINE_LITTER_TOTAL_WEIGHT_FIELD_BEAN, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("marineLitterTotalComputedOrNotWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    marineLitterTotalWeightField.setBean(model.getMarineLitterTotalComputedOrNotWeight());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("marineLitterTotalComputedOrNotWeight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SPECIES_TAB_FISHING_OPERATION_REMINDER_LABEL_RIGHT_DECORATION, true) {
        
            @Override
            public void applyDataBinding() {
                if (speciesTabContent != null) {
                    speciesTabContent.addPropertyChangeListener("speciesBatchTabToolBar", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (speciesTabContent != null) {
                    speciesTabFishingOperationReminderLabel.setRightDecoration(speciesTabContent.getSpeciesBatchTabToolBar());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (speciesTabContent != null) {
                    speciesTabContent.removePropertyChangeListener("speciesBatchTabToolBar", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_BENTHOS_TAB_FISHING_OPERATION_REMINDER_LABEL_RIGHT_DECORATION, true) {
        
            @Override
            public void applyDataBinding() {
                if (benthosTabContent != null) {
                    benthosTabContent.addPropertyChangeListener("benthosBatchTabToolBar", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (benthosTabContent != null) {
                    benthosTabFishingOperationReminderLabel.setRightDecoration(benthosTabContent.getBenthosBatchTabToolBar());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (benthosTabContent != null) {
                    benthosTabContent.removePropertyChangeListener("benthosBatchTabToolBar", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MARINE_LITTER_TAB_FISHING_OPERATION_REMINDER_LABEL_RIGHT_DECORATION, true) {
        
            @Override
            public void applyDataBinding() {
                if (marineLitterTabContent != null) {
                    marineLitterTabContent.addPropertyChangeListener("marineLitterBatchTabToolBar", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (marineLitterTabContent != null) {
                    marineLitterTabFishingOperationReminderLabel.setRightDecoration(marineLitterTabContent.getMarineLitterBatchTabToolBar());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (marineLitterTabContent != null) {
                    marineLitterTabContent.removePropertyChangeListener("marineLitterBatchTabToolBar", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_INDIVIDUAL_OBSERVATION_TAB_FISHING_OPERATION_REMINDER_LABEL_RIGHT_DECORATION, true) {
        
            @Override
            public void applyDataBinding() {
                if (individualObservationTabContent != null) {
                    individualObservationTabContent.addPropertyChangeListener("individualObservationBatchTabToolBar", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (individualObservationTabContent != null) {
                    individualObservationTabFishingOperationReminderLabel.setRightDecoration(individualObservationTabContent.getIndividualObservationBatchTabToolBar());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (individualObservationTabContent != null) {
                    individualObservationTabContent.removePropertyChangeListener("individualObservationBatchTabToolBar", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_ACCIDENTAL_TAB_FISHING_OPERATION_REMINDER_LABEL_RIGHT_DECORATION, true) {
        
            @Override
            public void applyDataBinding() {
                if (accidentalTabContent != null) {
                    accidentalTabContent.addPropertyChangeListener("accidentalBatchTabToolBar", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (accidentalTabContent != null) {
                    accidentalTabFishingOperationReminderLabel.setRightDecoration(accidentalTabContent.getAccidentalBatchTabToolBar());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (accidentalTabContent != null) {
                    accidentalTabContent.removePropertyChangeListener("accidentalBatchTabToolBar", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SAVE_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("modify", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    saveButton.setEnabled(model.isModify());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("modify", this);
                }
            }
        });
    }

}