/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.help.search;

import com.sun.java.help.search.ConceptData;
import com.sun.java.help.search.NonnegativeIntegerGenerator;
import com.sun.java.help.search.SearchEnvironment;

class NextDocGenerator {
    private int _document = 0;
    private final int _concept;
    private final int _queryMask;
    private final ConceptData _terms;
    private final NonnegativeIntegerGenerator _iterator;

    public NextDocGenerator(ConceptData conceptData, SearchEnvironment searchEnvironment) {
        this._concept = conceptData.getConcept();
        this._queryMask = conceptData.getQueryMask();
        this._terms = conceptData;
        this._iterator = searchEnvironment.getDocumentIterator(this._concept);
    }

    public int first() throws Exception {
        this._document = this._iterator != null ? this._iterator.first() : -1;
        return this._document;
    }

    public int next() throws Exception {
        this._document = this._iterator.next();
        return this._document;
    }

    public int getDocument() {
        return this._document;
    }

    public int getConcept() {
        return this._concept;
    }

    public ConceptData getTerms() {
        return this._terms;
    }

    public int getQueryMask() {
        return this._queryMask;
    }

    public boolean compareWith(NextDocGenerator nextDocGenerator) {
        return this._document > nextDocGenerator._document || this._document == nextDocGenerator._document && this._concept > nextDocGenerator._concept;
    }

    public boolean smallerThan(NextDocGenerator nextDocGenerator) {
        return this._document < nextDocGenerator._document || this._document == nextDocGenerator._document && this._concept < nextDocGenerator._concept;
    }
}

