/*
 * Decompiled with CFR 0.152.
 */
package liquibase.diff;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import liquibase.database.Database;
import liquibase.diff.Difference;
import liquibase.diff.compare.CompareControl;
import liquibase.diff.compare.DatabaseObjectComparatorFactory;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.DataType;

public class ObjectDifferences {
    private CompareControl compareControl;
    private HashMap<String, Difference> differences = new HashMap();

    public ObjectDifferences(CompareControl compareControl) {
        this.compareControl = compareControl;
    }

    public Set<Difference> getDifferences() {
        return Collections.unmodifiableSet(new HashSet<Difference>(this.differences.values()));
    }

    public Difference getDifference(String field) {
        return this.differences.get(field);
    }

    public boolean isDifferent(String field) {
        return this.differences.containsKey(field);
    }

    public ObjectDifferences addDifference(String changedField, Object referenceValue, Object compareToValue) {
        this.differences.put(changedField, new Difference(changedField, referenceValue, compareToValue));
        return this;
    }

    public ObjectDifferences addDifference(String message, String changedField, Object referenceValue, Object compareToValue) {
        this.differences.put(changedField, new Difference(message, changedField, referenceValue, compareToValue));
        return this;
    }

    public boolean hasDifferences() {
        return this.differences.size() > 0;
    }

    public void compare(String attribute, DatabaseObject referenceObject, DatabaseObject compareToObject, CompareFunction compareFunction) {
        this.compare(null, attribute, referenceObject, compareToObject, compareFunction);
    }

    public void compare(String message, String attribute, DatabaseObject referenceObject, DatabaseObject compareToObject, CompareFunction compareFunction) {
        boolean different;
        if (this.compareControl.isSuppressedField(referenceObject.getClass(), attribute)) {
            return;
        }
        Object referenceValue = referenceObject.getAttribute(attribute, Object.class);
        Object compareValue = compareToObject.getAttribute(attribute, Object.class);
        if (referenceValue == null && compareValue == null) {
            different = false;
        } else if (referenceValue == null && compareValue != null || referenceValue != null && compareValue == null) {
            different = true;
        } else {
            boolean bl = different = !compareFunction.areEqual(referenceValue, compareValue);
        }
        if (different) {
            this.addDifference(message, attribute, referenceValue, compareValue);
        }
    }

    public boolean removeDifference(String attribute) {
        return this.differences.remove(attribute) != null;
    }

    public static interface CompareFunction {
        public boolean areEqual(Object var1, Object var2);
    }

    public static class DataTypeCompareFunction
    implements CompareFunction {
        private final Database accordingTo;

        public DataTypeCompareFunction(Database accordingTo) {
            this.accordingTo = accordingTo;
        }

        @Override
        public boolean areEqual(Object referenceValue, Object compareToValue) {
            if (referenceValue == null && compareToValue == null) {
                return true;
            }
            if (referenceValue == null || compareToValue == null) {
                return false;
            }
            DataType referenceType = (DataType)referenceValue;
            DataType compareToType = (DataType)compareToValue;
            if (!referenceType.getTypeName().equalsIgnoreCase(compareToType.getTypeName())) {
                return false;
            }
            if (compareToType.toString().contains("(") && referenceType.toString().contains("(")) {
                return compareToType.toString().equalsIgnoreCase(referenceType.toString());
            }
            return true;
        }
    }

    public static class DatabaseObjectNameCompareFunction
    implements CompareFunction {
        private final Database accordingTo;
        private Class<? extends DatabaseObject> type;

        public DatabaseObjectNameCompareFunction(Class<? extends DatabaseObject> type, Database accordingTo) {
            this.type = type;
            this.accordingTo = accordingTo;
        }

        @Override
        public boolean areEqual(Object referenceValue, Object compareToValue) {
            if (referenceValue instanceof Collection) {
                if (((Collection)referenceValue).size() != ((Collection)compareToValue).size()) {
                    return false;
                }
                Iterator referenceIterator = ((Collection)referenceValue).iterator();
                Iterator compareToIterator = ((Collection)compareToValue).iterator();
                while (referenceIterator.hasNext()) {
                    if (this.areEqual(referenceIterator.next(), compareToIterator.next())) continue;
                    return false;
                }
                return true;
            }
            if (referenceValue == null && compareToValue == null) {
                return true;
            }
            if (referenceValue == null || compareToValue == null) {
                return false;
            }
            String object1Name = referenceValue instanceof DatabaseObject ? this.accordingTo.correctObjectName(((DatabaseObject)referenceValue).getAttribute("name", String.class), this.type) : referenceValue.toString();
            String object2Name = compareToValue instanceof DatabaseObject ? this.accordingTo.correctObjectName(((DatabaseObject)compareToValue).getAttribute("name", String.class), this.type) : compareToValue.toString();
            if (object1Name == null && object2Name == null) {
                return true;
            }
            if (object1Name == null || object2Name == null) {
                return false;
            }
            if (this.accordingTo.isCaseSensitive()) {
                return object1Name.equals(object2Name);
            }
            return object1Name.equalsIgnoreCase(object2Name);
        }
    }

    public static class OrderedCollectionCompareFunction
    implements CompareFunction {
        private StandardCompareFunction compareFunction;

        public OrderedCollectionCompareFunction(StandardCompareFunction compareFunction) {
            this.compareFunction = compareFunction;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public boolean areEqual(Object referenceValue, Object compareToValue) {
            if (referenceValue == null && compareToValue == null) {
                return true;
            }
            if (referenceValue == null || compareToValue == null) {
                return false;
            }
            if (!(referenceValue instanceof Collection) || !(compareToValue instanceof Collection)) {
                return false;
            }
            if (((Collection)referenceValue).size() != ((Collection)compareToValue).size()) {
                return false;
            }
            referenceIterator = ((Collection)referenceValue).iterator();
            compareIterator = ((Collection)compareToValue).iterator();
            if (((Collection)referenceValue).size() == ((Collection)compareToValue).size()) ** GOTO lbl16
            return false;
lbl-1000:
            // 1 sources

            {
                referenceObj = referenceIterator.next();
                if (this.compareFunction.areEqual(referenceObj, compareObj = compareIterator.next())) continue;
                return false;
lbl16:
                // 2 sources

                ** while (referenceIterator.hasNext())
            }
lbl17:
            // 1 sources

            return true;
        }
    }

    public static class StandardCompareFunction
    implements CompareFunction {
        private Database accordingTo;

        public StandardCompareFunction(Database accordingTo) {
            this.accordingTo = accordingTo;
        }

        @Override
        public boolean areEqual(Object referenceValue, Object compareToValue) {
            if (referenceValue == null && compareToValue == null) {
                return true;
            }
            if (referenceValue == null || compareToValue == null) {
                return false;
            }
            if (referenceValue instanceof DatabaseObject && compareToValue instanceof DatabaseObject) {
                return DatabaseObjectComparatorFactory.getInstance().isSameObject((DatabaseObject)referenceValue, (DatabaseObject)compareToValue, this.accordingTo);
            }
            return referenceValue.equals(compareToValue);
        }
    }

    public static class ToStringCompareFunction
    implements CompareFunction {
        private boolean caseSensitive;

        public ToStringCompareFunction(boolean caseSensitive) {
            this.caseSensitive = caseSensitive;
        }

        @Override
        public boolean areEqual(Object referenceValue, Object compareToValue) {
            if (referenceValue == null && compareToValue == null) {
                return true;
            }
            if (referenceValue == null || compareToValue == null) {
                return false;
            }
            if (this.caseSensitive) {
                return referenceValue.toString().equals(compareToValue.toString());
            }
            return referenceValue.toString().equalsIgnoreCase(compareToValue.toString());
        }
    }

    public static class UnOrderedCollectionCompareFunction
    implements CompareFunction {
        private StandardCompareFunction compareFunction;

        public UnOrderedCollectionCompareFunction(StandardCompareFunction compareFunction) {
            this.compareFunction = compareFunction;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public boolean areEqual(Object referenceValue, Object compareToValue) {
            if (referenceValue == null && compareToValue == null) {
                return true;
            }
            if (referenceValue == null || compareToValue == null) {
                return false;
            }
            if (!(referenceValue instanceof Collection) || !(compareToValue instanceof Collection)) {
                return false;
            }
            if (((Collection)referenceValue).size() != ((Collection)compareToValue).size()) {
                return false;
            }
            referenceIterator = ((Collection)referenceValue).iterator();
            unmatchedCompareToValues = new ArrayList<E>((Collection)compareToValue);
            if (((Collection)referenceValue).size() == ((Collection)compareToValue).size()) ** GOTO lbl23
            return false;
lbl-1000:
            // 1 sources

            {
                referenceObj = referenceIterator.next();
                foundMatch = null;
                for (E compareObj : unmatchedCompareToValues) {
                    if (!this.compareFunction.areEqual(referenceObj, compareObj)) continue;
                    foundMatch = compareObj;
                    break;
                }
                if (foundMatch == null) {
                    return false;
                }
                unmatchedCompareToValues.remove(foundMatch);
lbl23:
                // 2 sources

                ** while (referenceIterator.hasNext())
            }
lbl24:
            // 1 sources

            return true;
        }
    }
}

