package fr.ifremer.tutti.ui.swing.content.operation.catches.individualobservation.create;

/*
 * #%L
 * Tutti :: UI
 * %%
 * Copyright (C) 2012 - 2014 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.data.IndividualObservationBatch;
import fr.ifremer.tutti.persistence.entities.protocol.SpeciesProtocol;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValue;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.service.DecoratorService;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUIHandler;
import fr.ifremer.tutti.ui.swing.content.operation.catches.individualobservation.IndividualObservationBatchRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.individualobservation.IndividualObservationBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.individualobservation.IndividualObservationBatchUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchUIModel;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiUIHandler;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.editor.NumberEditor;
import jaxx.runtime.swing.editor.bean.BeanFilterableComboBox;
import jaxx.runtime.validator.swing.SwingValidator;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.decorator.Decorator;
import org.nuiton.jaxx.application.swing.util.Cancelable;

import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * @author kmorin <kmorin@codelutin.com>
 * @since 1.4
 */
public class CreateIndividualObservationBatchUIHandler extends AbstractTuttiUIHandler<CreateIndividualObservationBatchUIModel, CreateIndividualObservationBatchUI>
        implements Cancelable {

    private static final Log log =
            LogFactory.getLog(CreateIndividualObservationBatchUIHandler.class);

    //------------------------------------------------------------------------//
    //-- AbstractTuttiUIHandler methods                                     --//
    //------------------------------------------------------------------------//

    @Override
    public void beforeInit(CreateIndividualObservationBatchUI ui) {

        super.beforeInit(ui);

        // get the default caracteristics
        List<Caracteristic> defaultCaracteristic =
                getDataContext().getDefaultIndividualObservationCaracteristics();

        CreateIndividualObservationBatchUIModel model =
                new CreateIndividualObservationBatchUIModel(defaultCaracteristic);
        ui.setContextValue(model);
        listModelIsModify(model);
    }


    @Override
    public void afterInit(CreateIndividualObservationBatchUI ui) {

        initUI(ui);

        initBeanFilterableComboBox(ui.getIndividualObservationSpeciesComboBox(),
                                   Lists.newArrayList(getDataContext().getReferentSpeciesWithSurveyCode()),
                                   null,
                                   DecoratorService.FROM_PROTOCOL);

        List<Caracteristic> lengthStepCaracteristics = getDataContext().getLengthStepCaracteristics();
        initBeanFilterableComboBox(ui.getIndividualObservationLengthStepCaracteristicComboBox(),
                                   Lists.newArrayList(lengthStepCaracteristics),
                                   null);

        final Set<JComponent> editorComponents = Sets.newHashSet();

        editorComponents.add(ui.getIndividualObservationWeightField());
        editorComponents.add(ui.getIndividualObservationSizeField());
        editorComponents.add(ui.getIndividualObservationLengthStepCaracteristicComboBox());

        if (getDataContext().isProtocolFilled()) {

            final Map<Integer, SpeciesProtocol> speciesProtocolMap =
                    getContext().getPersistenceService().toSpeciesProtocolMap();

            final Map<String, Caracteristic> lengthStepCaracteristicMap = TuttiEntities.splitById(lengthStepCaracteristics);

            getModel().addPropertyChangeListener(IndividualObservationBatch.PROPERTY_SPECIES,
                                                 new PropertyChangeListener() {
                                                     @Override
                                                     public void propertyChange(PropertyChangeEvent evt) {
                                                         Species species = (Species) evt.getNewValue();
                                                         if (species != null) {
                                                             SpeciesProtocol speciesProtocol = speciesProtocolMap.get(species.getReferenceTaxonId());
                                                             if (speciesProtocol != null) {
                                                                 String lengthStepPmfmId = speciesProtocol.getLengthStepPmfmId();
                                                                 Caracteristic lengthStepCaracteristic = lengthStepCaracteristicMap.get(lengthStepPmfmId);
                                                                 getModel().setLengthStepCaracteristic(lengthStepCaracteristic);
                                                             }
                                                         }
                                                     }
                                                 });

            // add default caracteristic editors
            List<Caracteristic> caracteristics =
                    getDataContext().getDefaultIndividualObservationCaracteristics();

            Table configurationPanel = ui.getConfigurationPanel();

            Decorator<Caracteristic> caracteristicDecorator =
                    getDecorator(Caracteristic.class, DecoratorService.CARACTERISTIC_PARAMETER_ONLY_WITH_UNIT);

            Decorator<Caracteristic> caracteristicTipDecorator =
                    getDecorator(Caracteristic.class, DecoratorService.CARACTERISTIC_WITH_UNIT);

            int index = 6;
            for (Caracteristic caracteristic : caracteristics) {

                final CreateIndividualObservationBatchUIModel.CaracteristicMapPropertyEditor editorModel =
                        getModel().newCaracteristicEditor(caracteristic);

                JComponent editor = null;

                switch (caracteristic.getCaracteristicType()) {

                    case NUMBER: {
                        final NumberEditor numberEditor = new NumberEditor(ui);

                        String name = caracteristic.getId() + "CaracteristicField";
                        numberEditor.setName(name);
                        numberEditor.setProperty(CreateIndividualObservationBatchUIModel.CaracteristicMapPropertyEditor.PROPERTY_PROPERTY);
                        numberEditor.setUseFloat(true);
                        numberEditor.setShowReset(true);
                        numberEditor.setBean(editorModel);
                        numberEditor.setAutoPopup(getConfig().isAutoPopupNumberEditor());
                        numberEditor.setShowPopupButton(getConfig().isShowNumberEditorButton());
                        numberEditor.setNumberPattern(TuttiUI.DECIMAL3_PATTERN);

                        editorModel.addPropertyChangeListener(CreateIndividualObservationBatchUIModel.CaracteristicMapPropertyEditor.PROPERTY_PROPERTY, new PropertyChangeListener() {
                            @Override
                            public void propertyChange(PropertyChangeEvent evt) {
                                numberEditor.setModel((Number) evt.getNewValue());
                            }
                        });

                        editor = numberEditor;
                        ui.get$objectMap().put(name, editor);

                        initNumberEditor(numberEditor);
                    }
                    break;
                    case QUALITATIVE:

                    {
                        final BeanFilterableComboBox<CaracteristicQualitativeValue> qualitativeValuesEditor = new BeanFilterableComboBox<CaracteristicQualitativeValue>(ui);

                        String name = caracteristic.getId() + "CaracteristicComboBox";
                        qualitativeValuesEditor.setName(name);
                        qualitativeValuesEditor.setI18nPrefix("tutti.property.");
                        qualitativeValuesEditor.setProperty(CreateIndividualObservationBatchUIModel.CaracteristicMapPropertyEditor.PROPERTY_PROPERTY);
                        qualitativeValuesEditor.setShowReset(true);
                        qualitativeValuesEditor.setBeanType(CaracteristicQualitativeValue.class);

                        qualitativeValuesEditor.setBean(editorModel);

                        editorModel.addPropertyChangeListener(CreateIndividualObservationBatchUIModel.CaracteristicMapPropertyEditor.PROPERTY_PROPERTY, new PropertyChangeListener() {
                            @Override
                            public void propertyChange(PropertyChangeEvent evt) {
                                qualitativeValuesEditor.setSelectedItem(evt.getNewValue());
                            }
                        });

                        editor = qualitativeValuesEditor;
                        ui.get$objectMap().put(name, editor);

                        initBeanFilterableComboBox(qualitativeValuesEditor,
                                                   Lists.newArrayList(caracteristic.getQualitativeValue()),
                                                   null);
                    }

                    break;
                    case TEXT:
                        final JTextField textField = new JTextField();
                        String name = caracteristic.getId() + "TextField";
                        editorModel.addPropertyChangeListener(CreateIndividualObservationBatchUIModel.CaracteristicMapPropertyEditor.PROPERTY_PROPERTY, new PropertyChangeListener() {
                            @Override
                            public void propertyChange(PropertyChangeEvent evt) {
                                textField.setText((String) evt.getNewValue());
                            }
                        });
                        textField.addKeyListener(new KeyAdapter() {

                            @Override
                            public void keyReleased(KeyEvent e) {
                                String value = textField.getText();
                                TuttiEntities.setProperty(editorModel, CreateIndividualObservationBatchUIModel.CaracteristicMapPropertyEditor.PROPERTY_PROPERTY, value);
                            }
                        });
                        editor = textField;
                        ui.get$objectMap().put(name, editor);
                        initTextField(textField);
                        break;
                }

                editorComponents.add(editor);
                JLabel jLabel = new JLabel();
                jLabel.setText(caracteristicDecorator.toString(caracteristic));
                jLabel.setToolTipText(caracteristicTipDecorator.toString(caracteristic));
                jLabel.setLabelFor(editor);
                jLabel.putClientProperty("help", "tutti.createIndividualObservationBatch.field.defaultCaracteristic.help");
                ui.registerHelpId(ui.getBroker(), jLabel, "tutti.createIndividualObservationBatch.field.defaultCaracteristic.help");

                configurationPanel.add(jLabel, new GridBagConstraints(0, index, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
                configurationPanel.add(SwingUtil.boxComponentWithJxLayer(editor), new GridBagConstraints(1, index, 2, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
                index++;
            }
        }

        getModel().addPropertyChangeListener(IndividualObservationBatch.PROPERTY_SPECIES,
                                             new PropertyChangeListener() {
                                                 @Override
                                                 public void propertyChange(PropertyChangeEvent evt) {

                                                     CreateIndividualObservationBatchUIModel source = (CreateIndividualObservationBatchUIModel) evt.getSource();

                                                     Species species = (Species) evt.getNewValue();

                                                     source.setValueIsAdjusting(true);

                                                     try {
                                                         if (species == null ||
                                                             !source.isSpeciesFromBatch()) {

                                                             // reset create from batch flag
                                                             source.setCreateFromBatch(false);
                                                         }

                                                         // compute editors enable property
                                                         boolean enabled = species != null &&
                                                                           (!source.isCreateFromBatch() ||
                                                                            !source.isSpeciesFromBatch());
//                                                         boolean enabled = species != null &&
//                                                                           (!source.isCreateFromBatch() ||
//                                                                            !source.isSpeciesFromBatch() ||
//                                                                            source.isSpeciesFromBatchWithOneCount());
                                                         if (log.isInfoEnabled()) {
                                                             log.info("can edit? " + enabled + " (species changed: " + species + ")");
                                                         }
                                                         for (JComponent editorComponent : editorComponents) {
                                                             editorComponent.setEnabled(enabled);
                                                         }
                                                     } finally {
                                                         source.setValueIsAdjusting(false);
                                                     }
                                                 }
                                             });

        getModel().addPropertyChangeListener(CreateIndividualObservationBatchUIModel.PROPERTY_CREATE_FROM_BATCH,
                                             new PropertyChangeListener() {
                                                 @Override
                                                 public void propertyChange(PropertyChangeEvent evt) {

                                                     CreateIndividualObservationBatchUIModel source = (CreateIndividualObservationBatchUIModel) evt.getSource();
                                                     Boolean newValue = (Boolean) evt.getNewValue();
                                                     newValue = newValue != null && newValue;

                                                     // compute editors enable property
                                                     boolean enabled = !newValue || !source.isSpeciesFromBatch();
//                                                     boolean enabled = !newValue ||
//                                                                       !source.isSpeciesFromBatch() ||
//                                                                       source.isSpeciesFromBatchWithOneCount();
                                                     if (log.isInfoEnabled()) {
                                                         log.info("can edit? " + enabled + " (createFromBatch changed: " + newValue + ")");
                                                     }
                                                     for (JComponent editorComponent : editorComponents) {
                                                         editorComponent.setEnabled(enabled);
                                                     }
                                                 }
                                             });

        listenValidatorValid(getValidator(), getModel());
    }

    @Override
    protected JComponent getComponentToFocus() {
        return getUI().getIndividualObservationSpeciesComboBox();
    }

    @Override
    public void onCloseUI() {

        if (log.isDebugEnabled()) {
            log.debug("closing: " + ui);
        }

        // evict model from validator
        getValidator().setBean(null);

        // when canceling always invalid model
        getModel().setValid(false);

        EditCatchesUI parent = getParentContainer(EditCatchesUI.class);
        parent.getHandler().setIndividualObservationSelectedCard(EditCatchesUIHandler.MAIN_CARD);
    }

    @Override
    public SwingValidator<CreateIndividualObservationBatchUIModel> getValidator() {
        return ui.getValidator();
    }

    //------------------------------------------------------------------------//
    //-- Cancelable methods                                                 --//
    //------------------------------------------------------------------------//

    @Override
    public void cancel() {
        if (log.isDebugEnabled()) {
            log.debug("Cancel UI " + ui);
        }
        closeUI(ui);
    }

    //------------------------------------------------------------------------//
    //-- Public methods                                                     --//
    //------------------------------------------------------------------------//

    public void openUI(IndividualObservationBatchUIModel batchModel) {

        CreateIndividualObservationBatchUIModel model = getModel();

        // connect model to validator
        getValidator().setBean(model);

        model.reset();

        // compute list of available species

        List<Species> speciesListWithSurveyCode =
                getDataContext().getReferentSpeciesWithSurveyCode();

        Map<Species, Integer> batchesSpeciesList;

        List<Species> speciesList;

        EditCatchesUI parent = getParentContainer(EditCatchesUI.class);
        SpeciesBatchUIModel speciesBatchUIModel = parent.getSpeciesTabContent().getModel();

        boolean withSpeciesBatch =
                CollectionUtils.isNotEmpty(speciesBatchUIModel.getRows());
        if (withSpeciesBatch) {

            // use species from species batch
            batchesSpeciesList = speciesBatchUIModel.getSpeciesCount();

            Set<Species> speciesSet = Sets.newHashSet(batchesSpeciesList.keySet());

            // plus readd the species filled here (individualObservations)
            List<IndividualObservationBatchRowModel> rows = batchModel.getRows();

            if (CollectionUtils.isNotEmpty(rows)) {
                for (IndividualObservationBatchRowModel row : rows) {
                    Species species = row.getSpecies();
                    speciesSet.add(species);
                }
            }
            speciesList = Lists.newArrayList(speciesSet);
            if (log.isInfoEnabled()) {
                log.info("Use speciesBatch + individualObservation species : " + speciesList.size());
            }
        } else {

            batchesSpeciesList = Maps.newHashMap();

            if (getDataContext().isProtocolFilled()) {

                // using protocol species
                speciesList = Lists.newArrayList(speciesListWithSurveyCode);

                // readd the species filled here (individualObservations)
                List<IndividualObservationBatchRowModel> rows = batchModel.getRows();

                if (CollectionUtils.isNotEmpty(rows)) {
                    for (IndividualObservationBatchRowModel row : rows) {

                        Species species = row.getSpecies();
                        if (!speciesList.contains(species)) {
                            speciesList.add(species);
                        }
                    }
                }

                if (log.isInfoEnabled()) {
                    log.info("Use protocol + individualObservation species : " + speciesList.size());
                }
            } else {

                // no species batch, no protocol use all possible species
                speciesList = speciesListWithSurveyCode;

                if (log.isInfoEnabled()) {
                    log.info("Use all species : " + speciesList.size());
                }
            }
        }

        model.setBatchSpecies(batchesSpeciesList);
        model.setAvailableSpecies(speciesList);

        // set last species filled here
        Species lastSpeciesUsed = batchModel.getLastSpeciesUsed();
        model.setSpecies(lastSpeciesUsed);
        model.setLengthStepCaracteristic(batchModel.getLastLengthStepCaracteristicUsed());
    }

    public void saveAndContinue() {

        if (log.isDebugEnabled()) {
            log.debug("Save And Continue UI " + ui);
        }

        EditCatchesUI parent = getParentContainer(EditCatchesUI.class);
        IndividualObservationBatchUI individualObservationTabContent = parent.getIndividualObservationTabContent();
        individualObservationTabContent.getHandler().addBatch(getModel());

        // re-open dialog
        openUI(individualObservationTabContent.getModel());

        // set focus to weight field
        ui.getIndividualObservationWeightField().grabFocus();
    }

    public void saveAndClose() {

        if (log.isDebugEnabled()) {
            log.debug("Save And Close UI " + ui);
        }

        EditCatchesUI parent = getParentContainer(EditCatchesUI.class);
        parent.getIndividualObservationTabContent().getHandler().addBatch(getModel());

        // close dialog
        closeUI(ui);
    }

}
