/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.synchro.service;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import fr.ifremer.adagio.synchro.intercept.SynchroWriteBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections4.MapUtils;

public class SynchroPendingOperationBuffer
implements SynchroWriteBuffer {
    private List<List<Object>> pks;
    private Map<Integer, Integer> remoteIdsMap;
    private Map<Integer, Map<String, Integer>> missingRemoteIdByColumnIndex = Maps.newHashMap();
    private final String tableName;

    public SynchroPendingOperationBuffer(String tableName) {
        this.tableName = tableName;
    }

    public List<List<Object>> getPks() {
        return this.pks;
    }

    public void setPks(List<List<Object>> pks) {
        this.pks = pks;
    }

    public void addPks(List<List<Object>> updatedPks) {
        if (this.pks == null) {
            this.pks = Lists.newArrayList();
        }
        this.pks.addAll(updatedPks);
    }

    public String getTableName() {
        return this.tableName;
    }

    public Map<Integer, Integer> getRemoteIdsMap() {
        return this.remoteIdsMap;
    }

    public void addRemoteIdsMap(Map<Integer, Integer> updatedRemoteIds) {
        if (this.remoteIdsMap == null) {
            this.remoteIdsMap = updatedRemoteIds;
        }
        this.remoteIdsMap.putAll(updatedRemoteIds);
    }

    public boolean isEmpty() {
        return MapUtils.isEmpty(this.remoteIdsMap) && CollectionUtils.isEmpty(this.pks);
    }

    @Override
    public void addMissingRemoteId(String tablename, int columnIndex, String pkStr, Integer remoteId) {
        HashMap missingRemoteIds = this.missingRemoteIdByColumnIndex.get(columnIndex);
        if (missingRemoteIds == null) {
            missingRemoteIds = Maps.newHashMap();
            this.missingRemoteIdByColumnIndex.put(columnIndex, missingRemoteIds);
        }
        missingRemoteIds.put(pkStr, remoteId);
    }
}

