/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.application.swing.table;

import java.awt.event.ActionEvent;
import javax.swing.JTable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.jaxx.application.swing.table.AbstractApplicationTableModel;
import org.nuiton.jaxx.application.swing.table.AbstractSelectTableAction;

public class MoveToNextEditableCellAction<M extends AbstractApplicationTableModel>
extends AbstractSelectTableAction<M> {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(MoveToNextEditableCellAction.class);

    public static <M extends AbstractApplicationTableModel> MoveToNextEditableCellAction<M> newAction(M model, JTable table) {
        return new MoveToNextEditableCellAction<M>(model, table);
    }

    protected MoveToNextEditableCellAction(M model, JTable table) {
        super(model, table);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int currentRow = this.getSelectedRow();
        int currentColumn = this.getSelectedColumn();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Move to previous editable cell " + this.getCellCoordinate(currentRow, currentColumn)));
        }
        int columnCount = this.getColumnCount();
        int rowCount = this.getRowCount();
        if (currentRow <= rowCount || currentColumn <= columnCount) {
            boolean canSelect = true;
            if (++currentColumn >= columnCount) {
                currentColumn = 0;
                if (++currentRow == rowCount) {
                    if (this.isCreateNewRow()) {
                        this.addNewRow();
                    } else {
                        canSelect = false;
                    }
                }
            }
            if (canSelect) {
                this.doSelectCell(currentRow, currentColumn);
            }
        }
    }
}

