/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.core.dao.technical.hibernate;

import fr.ifremer.adagio.core.AdagioTechnicalException;
import fr.ifremer.adagio.core.config.AdagioConfiguration;
import fr.ifremer.adagio.core.dao.technical.DaoUtils;
import fr.ifremer.adagio.core.dao.technical.DatabaseSchemaDao;
import fr.ifremer.adagio.core.dao.technical.DatabaseSchemaUpdateException;
import fr.ifremer.adagio.core.dao.technical.Version;
import fr.ifremer.adagio.core.dao.technical.VersionNotFoundException;
import fr.ifremer.adagio.core.dao.technical.hibernate.HibernateConnectionProvider;
import fr.ifremer.adagio.core.dao.technical.hibernate.HibernateDaoSupport;
import fr.ifremer.adagio.core.dao.technical.liquibase.Liquibase;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import liquibase.exception.LiquibaseException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.tool.hbm2ddl.SchemaExport;
import org.hibernate.tool.hbm2ddl.SchemaUpdate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.io.Resource;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.jdbc.CannotGetJdbcConnectionException;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.stereotype.Repository;

@Repository(value="databaseSchemaDao")
@Lazy
public class DatabaseSchemaDaoImpl
extends HibernateDaoSupport
implements DatabaseSchemaDao {
    private static final Log log = LogFactory.getLog(DatabaseSchemaDaoImpl.class);
    @Autowired
    private ApplicationContext appContext;
    @Autowired
    private Liquibase liquibase;
    @Autowired
    private DataSource dataSource;
    @Autowired
    private AdagioConfiguration config;
    private Dialect localDialect = null;

    @Autowired
    public DatabaseSchemaDaoImpl(SessionFactory sessionFactory) {
        this.setSessionFactory(sessionFactory);
    }

    @Override
    public void generateCreateSchemaFile(String filename) {
        if (filename == null || filename.isEmpty()) {
            throw new IllegalArgumentException("filename could not be null or empty.");
        }
        this.generateCreateSchemaFile(filename, false, false, true);
    }

    @Override
    public void generateCreateSchemaFile(String filename, boolean doExecute, boolean withDrop, boolean withCreate) {
        Configuration cfg = this.getHibernateConfiguration();
        SchemaExport se = new SchemaExport(cfg);
        se.setDelimiter(";");
        se.setOutputFile(filename);
        se.execute(false, doExecute, !withCreate, !withDrop);
    }

    @Override
    public void generateUpdateSchemaFile(String filename) {
        if (filename == null || filename.isEmpty()) {
            throw new IllegalArgumentException("filename could not be null or empty.");
        }
        this.generateUpdateSchemaFile(filename, false);
    }

    @Override
    public void generateUpdateSchemaFile(String filename, boolean doUpdate) {
        Configuration cfg = this.getHibernateConfiguration();
        SchemaUpdate su = new SchemaUpdate(cfg);
        su.setDelimiter(";");
        su.setOutputFile(filename);
        su.execute(false, false);
    }

    private Configuration getHibernateConfiguration() {
        Configuration cfg = new Configuration();
        try {
            this.addRessourceToHibernateConfiguration(cfg, Package.getPackage("fr.ifremer.adagio.core.dao"), "**/*.hbm.xml");
            this.addRessourceToHibernateConfiguration(cfg, "", "queries.hbm.xml");
            this.addRessourceToHibernateConfiguration(cfg, "", AdagioConfiguration.getInstance().getHibernateClientQueriesFile());
        }
        catch (IOException e) {
            log.error((Object)"exportExtractorSchemaToFile failed", (Throwable)e);
            throw new DataAccessResourceFailureException(e.getMessage(), (Throwable)e);
        }
        cfg.setProperty("hibernate.dialect", AdagioConfiguration.getInstance().getHibernateDialect());
        HibernateConnectionProvider.setDataSource(this.dataSource);
        cfg.setProperty("hibernate.connection.provider_class", HibernateConnectionProvider.class.getName());
        return cfg;
    }

    private void addRessourceToHibernateConfiguration(Configuration cfg, Package aPackage, String filePattern) throws IOException {
        String packageName = aPackage.getName().replace(".", "/");
        this.addRessourceToHibernateConfiguration(cfg, packageName, "**/*.hbm.xml");
    }

    private void addRessourceToHibernateConfiguration(Configuration cfg, String classPathFolder, String filePattern) throws IOException {
        Resource[] resources;
        String fullName = null;
        fullName = classPathFolder != null && !classPathFolder.isEmpty() ? classPathFolder + "/" + filePattern : filePattern;
        for (Resource resource : resources = this.appContext.getResources("classpath*:" + fullName)) {
            int index;
            String path = resource.getURL().toString();
            if (classPathFolder != null && !classPathFolder.isEmpty()) {
                index = path.lastIndexOf(classPathFolder);
                if (index != -1) {
                    path = path.substring(index);
                }
            } else {
                index = path.lastIndexOf("/");
                if (index != -1) {
                    path = path.substring(index + 1);
                }
            }
            cfg.addResource(path);
        }
    }

    public Dialect getLocalDialect() {
        if (this.localDialect == null) {
            this.localDialect = ((SessionFactoryImplementor)this.getSessionFactory()).getDialect();
        }
        return this.localDialect;
    }

    @Override
    public void updateSchema() throws DatabaseSchemaUpdateException {
        try {
            this.liquibase.executeUpdate();
        }
        catch (LiquibaseException le) {
            if (log.isErrorEnabled()) {
                log.error((Object)le.getMessage(), (Throwable)le);
            }
            throw new DatabaseSchemaUpdateException("Could not update schema", le);
        }
    }

    @Override
    public void generateStatusReport(File outputFile) throws IOException {
        FileWriter fw = new FileWriter(outputFile);
        try {
            this.liquibase.reportStatus(fw);
        }
        catch (LiquibaseException le) {
            if (log.isErrorEnabled()) {
                log.error((Object)le.getMessage(), (Throwable)le);
            }
            throw new AdagioTechnicalException("Could not report database status", le);
        }
    }

    @Override
    public void generateDiffReport(File outputFile, String typesToControl) throws IOException {
        try {
            this.liquibase.reportDiff(outputFile, typesToControl);
        }
        catch (LiquibaseException le) {
            if (log.isErrorEnabled()) {
                log.error((Object)le.getMessage(), (Throwable)le);
            }
            throw new AdagioTechnicalException("Could not report database diff", le);
        }
    }

    @Override
    public void generateDiffChangeLog(File outputChangeLogFile, String typesToControl) throws IOException {
        try {
            this.liquibase.generateDiffChangelog(outputChangeLogFile, typesToControl);
        }
        catch (LiquibaseException le) {
            if (log.isErrorEnabled()) {
                log.error((Object)le.getMessage(), (Throwable)le);
            }
            throw new AdagioTechnicalException("Could not create database diff changelog", le);
        }
    }

    @Override
    public Version getSchemaVersion() throws VersionNotFoundException {
        String systemVersion;
        try {
            systemVersion = (String)this.queryUniqueTyped("lastSystemVersion", new Object[0]);
            if (StringUtils.isBlank((CharSequence)systemVersion)) {
                throw new VersionNotFoundException(String.format("Could not get the schema version. No version found in SYSTEM_VERSION table.", new Object[0]));
            }
        }
        catch (HibernateException he) {
            throw new VersionNotFoundException(String.format("Could not get the schema version: %s", he.getMessage()));
        }
        try {
            return Version.parseVersion(systemVersion);
        }
        catch (IllegalArgumentException iae) {
            throw new VersionNotFoundException(String.format("Could not get the schema version. Bad schema version found table SYSTEM_VERSION: %s", systemVersion));
        }
    }

    @Override
    public Version getSchemaVersionIfUpdate() {
        return this.liquibase.getMaxChangeLogFileVersion();
    }

    @Override
    public boolean shouldUpdateSchema() throws VersionNotFoundException {
        return this.getSchemaVersion().compareTo(this.getSchemaVersionIfUpdate()) >= 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDbLoaded() {
        if (!this.isDbExists()) {
            log.warn((Object)"Database directory not found. Could not load database.");
            return false;
        }
        Connection connection = null;
        try {
            connection = DataSourceUtils.getConnection((DataSource)this.dataSource);
        }
        catch (CannotGetJdbcConnectionException ex) {
            log.error((Object)ex);
            DataSourceUtils.releaseConnection((Connection)connection, (DataSource)this.dataSource);
            return false;
        }
        String dbValidatioNQuery = this.config.getDbValidationQuery();
        if (StringUtils.isNotBlank((CharSequence)dbValidatioNQuery)) {
            log.debug((Object)String.format("Check if the database is loaded, using validation query: %s", dbValidatioNQuery));
            Statement stmt = null;
            try {
                stmt = connection.createStatement();
                stmt.execute(dbValidatioNQuery);
            }
            catch (SQLException ex) {
                log.error((Object)ex);
                boolean bl = false;
                return bl;
            }
            finally {
                DaoUtils.closeSilently(stmt);
                DataSourceUtils.releaseConnection((Connection)connection, (DataSource)this.dataSource);
            }
        } else {
            DataSourceUtils.releaseConnection((Connection)connection, (DataSource)this.dataSource);
        }
        return true;
    }

    @Override
    public boolean isDbExists() {
        String jdbcUrl = this.config.getJdbcURL();
        if (!DaoUtils.isFileDatabase(jdbcUrl)) {
            return true;
        }
        File f = new File(this.config.getDbDirectory(), this.config.getDbName() + ".data");
        return f.exists();
    }
}

