/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.pdf.font;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.birt.report.engine.layout.pdf.font.CompositeFontConfig;

public class FontMappingConfig {
    protected Set fontPaths = new HashSet();
    protected HashMap fontAliases = new HashMap();
    protected HashMap fontEncodings = new HashMap();
    protected HashMap searchSequences = new HashMap();
    protected HashMap compositeFonts = new HashMap();

    public void merge(FontMappingConfig config) {
        this.fontPaths.addAll(config.fontPaths);
        this.fontAliases.putAll(config.fontAliases);
        this.fontEncodings.putAll(config.fontEncodings);
        this.searchSequences.putAll(config.searchSequences);
        for (Map.Entry entry : config.compositeFonts.entrySet()) {
            String fontName = (String)entry.getKey();
            CompositeFontConfig newConfig = (CompositeFontConfig)entry.getValue();
            CompositeFontConfig oldConfig = (CompositeFontConfig)this.compositeFonts.get(fontName);
            if (oldConfig != null) {
                oldConfig.merge(newConfig);
                continue;
            }
            this.compositeFonts.put(fontName, new CompositeFontConfig(newConfig));
        }
    }

    public void addFontPath(String fontPath) {
        this.fontPaths.add(fontPath);
    }

    public void addFontAlias(String alias, String fontName) {
        this.fontAliases.put(alias, fontName);
    }

    public void addFontEncoding(String fontName, String fontEncoding) {
        this.fontEncodings.put(fontName, fontEncoding);
    }

    public void addSearchSequence(String localeKey, String[] sequence) {
        this.searchSequences.put(localeKey, sequence);
    }

    public Map getSearchSequences() {
        return this.searchSequences;
    }

    public void addCompositeFont(CompositeFontConfig fontConfig) {
        this.compositeFonts.put(fontConfig.fontName, fontConfig);
    }

    public Collection getAllCompositeFonts() {
        return this.compositeFonts.values();
    }
}

