/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.oda.mongodb.impl;

import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.data.oda.mongodb.impl.MongoDBDriver;
import org.eclipse.birt.data.oda.mongodb.internal.impl.MDbMetaData;
import org.eclipse.datatools.connectivity.oda.IResultSetMetaData;
import org.eclipse.datatools.connectivity.oda.OdaException;

public class MDbResultSetMetaData
implements IResultSetMetaData {
    private Map<String, MDbMetaData.FieldMetaData> m_resultFieldsMD;
    private List<String> m_resultFieldFullNames;
    private List<Integer> m_resultFieldDataTypes;
    private MDbMetaData.DocumentsMetaData m_docsMetaData;
    private boolean m_isAutoFlattening;

    public MDbResultSetMetaData(DBCursor resultCursor, List<String> resultFieldNames, boolean isAutoFlattening) {
        this.m_docsMetaData = MDbMetaData.getMetaData(resultCursor);
        this.init(resultFieldNames, isAutoFlattening);
    }

    public MDbResultSetMetaData(Iterable<DBObject> resultObjs, int searchLimit, List<String> resultFieldNames, boolean isAutoFlattening) {
        this.m_docsMetaData = MDbMetaData.getMetaData(resultObjs, searchLimit);
        this.init(resultFieldNames, isAutoFlattening);
    }

    private void init(List<String> resultFieldNames, boolean isAutoFlattening) {
        this.m_resultFieldsMD = MDbResultSetMetaData.mapResultFieldsMetaData(resultFieldNames, this.m_docsMetaData);
        this.m_isAutoFlattening = isAutoFlattening;
        if (this.m_isAutoFlattening) {
            this.m_docsMetaData.setFlattenableFields(this.m_resultFieldsMD, true);
        }
    }

    private static Map<String, MDbMetaData.FieldMetaData> mapResultFieldsMetaData(List<String> resultFieldNames, MDbMetaData.DocumentsMetaData fromDocMetaData) {
        if (resultFieldNames == null || resultFieldNames.isEmpty()) {
            return MDbMetaData.flattenFieldsMetaData(fromDocMetaData, null);
        }
        return MDbMetaData.flattenFieldsMetaData(resultFieldNames, fromDocMetaData);
    }

    private List<String> getFieldFullNames() {
        if (this.m_resultFieldFullNames == null) {
            if (this.m_resultFieldsMD == null) {
                return Collections.emptyList();
            }
            this.m_resultFieldFullNames = new ArrayList<String>(this.m_resultFieldsMD.keySet());
        }
        return this.m_resultFieldFullNames;
    }

    private List<Integer> getFieldDataTypes() {
        if (this.m_resultFieldDataTypes == null) {
            if (this.m_resultFieldsMD == null) {
                return Collections.emptyList();
            }
            this.m_resultFieldDataTypes = new ArrayList<Integer>(this.m_resultFieldsMD.size());
            int i = 0;
            while (i < this.m_resultFieldsMD.size()) {
                this.m_resultFieldDataTypes.add(null);
                ++i;
            }
        }
        return this.m_resultFieldDataTypes;
    }

    public int getColumnCount() throws OdaException {
        return this.m_resultFieldsMD.size();
    }

    public String getColumnName(int index) throws OdaException {
        int numColumns = this.getColumnCount();
        if (numColumns == 0 || index <= 0 || index > numColumns) {
            return "";
        }
        return this.getFieldFullNames().get(index - 1);
    }

    int getColumnNumber(String columnName) {
        return this.getFieldFullNames().indexOf(columnName) + 1;
    }

    private MDbMetaData.FieldMetaData getColumnMetaData(int index) {
        String fieldName;
        try {
            fieldName = this.getColumnName(index);
        }
        catch (OdaException odaException) {
            return null;
        }
        return this.getColumnMetaData(fieldName);
    }

    public MDbMetaData.FieldMetaData getColumnMetaData(String columnName) {
        if (columnName == null || columnName.isEmpty()) {
            return null;
        }
        return this.m_resultFieldsMD.get(columnName);
    }

    public MDbMetaData.DocumentsMetaData getDocumentsMetaData() {
        return this.m_docsMetaData;
    }

    public String getColumnLabel(int index) throws OdaException {
        return this.getColumnName(index);
    }

    public int getColumnType(int index) throws OdaException {
        if (index <= 0 || index > this.getFieldDataTypes().size()) {
            throw new OdaException((Throwable)new IndexOutOfBoundsException());
        }
        Integer nativeDataType = this.getFieldDataTypes().get(index - 1);
        if (nativeDataType != null) {
            return nativeDataType;
        }
        nativeDataType = this.doGetColumnType(index);
        if (nativeDataType != null) {
            this.getFieldDataTypes().set(index - 1, nativeDataType);
        }
        return nativeDataType;
    }

    private int doGetColumnType(int index) throws OdaException {
        MDbMetaData.FieldMetaData columnMD = this.getColumnMetaData(index);
        if (columnMD == null) {
            return 2;
        }
        if (columnMD.hasDocumentDataType()) {
            return columnMD.getPreferredNativeDataType(this.m_isAutoFlattening);
        }
        if (columnMD.isDescendantOfArrayField()) {
            if (!this.m_isAutoFlattening || columnMD.isArrayOfScalarValues()) {
                return 2;
            }
            String arrayAncestorName = columnMD.getArrayAncestorName();
            if (arrayAncestorName != null && !this.isFlattenableNestedField(columnMD)) {
                return 2;
            }
        } else if (columnMD.isArrayOfScalarValues()) {
            if (!this.m_isAutoFlattening) {
                return 2;
            }
            String flattenableFieldName = this.m_docsMetaData.getFlattenableFieldName();
            if (flattenableFieldName != null && !flattenableFieldName.equals(columnMD.getFullName())) {
                return 2;
            }
        }
        return columnMD.getPreferredNativeDataType(this.m_isAutoFlattening);
    }

    private boolean isFlattenableNestedField(MDbMetaData.FieldMetaData columnMD) {
        return MDbMetaData.isFlattenableNestedField(columnMD, this.m_docsMetaData);
    }

    public String getColumnTypeName(int index) throws OdaException {
        int nativeTypeCode = this.getColumnType(index);
        return MongoDBDriver.getNativeDataTypeName(nativeTypeCode);
    }

    public int getColumnDisplayLength(int index) throws OdaException {
        return -1;
    }

    public int getPrecision(int index) throws OdaException {
        return -1;
    }

    public int getScale(int index) throws OdaException {
        return -1;
    }

    public int isNullable(int index) throws OdaException {
        return 1;
    }
}

