/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.persistence;

import com.google.common.base.Predicate;
import com.google.common.collect.Multimap;
import fr.ifremer.tutti.persistence.InvalidBatchModelException;
import fr.ifremer.tutti.persistence.TuttiPersistenceServiceImplementor;
import fr.ifremer.tutti.persistence.entities.CaracteristicMap;
import fr.ifremer.tutti.persistence.entities.data.AccidentalBatch;
import fr.ifremer.tutti.persistence.entities.data.AttachementObjectTypeEnum;
import fr.ifremer.tutti.persistence.entities.data.Attachment;
import fr.ifremer.tutti.persistence.entities.data.BatchContainer;
import fr.ifremer.tutti.persistence.entities.data.BenthosBatch;
import fr.ifremer.tutti.persistence.entities.data.BenthosBatchFrequency;
import fr.ifremer.tutti.persistence.entities.data.CatchBatch;
import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.data.IndividualObservationBatch;
import fr.ifremer.tutti.persistence.entities.data.MarineLitterBatch;
import fr.ifremer.tutti.persistence.entities.data.Program;
import fr.ifremer.tutti.persistence.entities.data.SampleCategoryModel;
import fr.ifremer.tutti.persistence.entities.data.SpeciesAbleBatch;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatch;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatchFrequency;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocol;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.Gear;
import fr.ifremer.tutti.persistence.entities.referential.ObjectType;
import fr.ifremer.tutti.persistence.entities.referential.Person;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.persistence.entities.referential.TuttiLocation;
import fr.ifremer.tutti.persistence.entities.referential.TuttiReferentialEntity;
import fr.ifremer.tutti.persistence.entities.referential.Vessel;
import fr.ifremer.tutti.persistence.service.TuttiEnumerationFile;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import org.nuiton.util.Version;
import org.springframework.transaction.annotation.Transactional;

@Transactional(readOnly=true)
public interface TuttiPersistence
extends TuttiPersistenceServiceImplementor {
    public String getImplementationName();

    public void clearAllCaches();

    public TuttiEnumerationFile getEnumerationFile();

    @Transactional(readOnly=false)
    public <V> V invoke(Callable<V> var1);

    public Version getDbVersion();

    public Version getApplicationVersion();

    public void updateSchema();

    public void sanityDb();

    public List<TuttiLocation> getAllProgramZone();

    public List<TuttiLocation> getAllCountry();

    public List<TuttiLocation> getAllHarbour();

    public List<TuttiLocation> getAllFishingOperationStrata(String var1);

    public List<TuttiLocation> getAllFishingOperationSubStrata(String var1, String var2);

    public List<TuttiLocation> getAllFishingOperationLocation(String var1, String var2, String var3);

    public List<Vessel> getAllScientificVessel();

    public List<Vessel> getAllFishingVessel();

    public List<Species> getAllSpecies();

    public List<Species> getAllReferentSpecies();

    public Species getSpeciesByReferenceTaxonIdWithVernacularCode(Integer var1);

    public List<Caracteristic> getAllCaracteristic();

    public List<Caracteristic> getAllCaracteristicWithProtected();

    public List<Caracteristic> getAllCaracteristicForSampleCategory();

    public List<Caracteristic> getAllNumericCaracteristic();

    public Caracteristic getSizeCategoryCaracteristic();

    public Caracteristic getSexCaracteristic();

    public Caracteristic getSortedUnsortedCaracteristic();

    public Caracteristic getMaturityCaracteristic();

    public Caracteristic getAgeCaracteristic();

    public Caracteristic getMarineLitterCategoryCaracteristic();

    public Caracteristic getMarineLitterSizeCategoryCaracteristic();

    public Caracteristic getVerticalOpeningCaracteristic();

    public Caracteristic getHorizontalOpeningWingCaracteristic();

    public Caracteristic getHorizontalOpeningDoorCaracteristic();

    public Caracteristic getDeadOrAliveCaracteristic();

    public Caracteristic getPmfmIdCaracteristic();

    public Caracteristic getWeightMeasuredCaracteristic();

    public Caracteristic getCaracteristic(Integer var1);

    public Predicate<SpeciesAbleBatch> getVracBatchPredicate();

    public boolean isVracBatch(SpeciesAbleBatch var1);

    public boolean isHorsVracBatch(SpeciesAbleBatch var1);

    public boolean isTemporary(TuttiReferentialEntity var1);

    public List<Gear> getAllScientificGear();

    public List<Gear> getAllFishingGear();

    public List<Person> getAllPerson();

    public List<ObjectType> getAllObjectType();

    public Person getPerson(Integer var1);

    public Gear getGear(Integer var1);

    public Vessel getVessel(String var1);

    public ObjectType getObjectType(String var1);

    @Transactional(readOnly=false)
    public List<Species> importTemporarySpecies(List<Species> var1);

    @Transactional(readOnly=false)
    public List<Vessel> importTemporaryVessel(List<Vessel> var1);

    @Transactional(readOnly=false)
    public List<Person> importTemporaryPerson(List<Person> var1);

    @Transactional(readOnly=false)
    public List<Gear> importTemporaryGear(List<Gear> var1);

    public List<Attachment> getAllAttachments(AttachementObjectTypeEnum var1, Integer var2);

    public File getAttachmentFile(String var1);

    @Transactional(readOnly=false)
    public Attachment createAttachment(Attachment var1, File var2);

    @Transactional(readOnly=false)
    public Attachment saveAttachment(Attachment var1);

    @Transactional(readOnly=false)
    public void deleteAttachment(String var1);

    public List<Program> getAllProgram();

    public Program getProgram(String var1);

    @Transactional(readOnly=false)
    public Program createProgram(Program var1);

    @Transactional(readOnly=false)
    public Program saveProgram(Program var1);

    public List<Cruise> getAllCruise(String var1);

    public Cruise getCruise(String var1);

    @Transactional(readOnly=false)
    public Cruise createCruise(Cruise var1);

    @Transactional(readOnly=false)
    public Cruise saveCruise(Cruise var1, boolean var2, boolean var3);

    public CaracteristicMap getGearCaracteristics(String var1, String var2, short var3);

    public boolean isOperationUseGears(Integer var1, Collection<Gear> var2);

    @Transactional(readOnly=false)
    public void saveGearCaracteristics(Gear var1, Cruise var2);

    public TuttiProtocol getProtocol();

    public void setProtocol(TuttiProtocol var1);

    public List<String> getAllProtocolNames();

    public List<TuttiProtocol> getAllProtocol();

    public boolean isProtocolExist(String var1);

    public TuttiProtocol getProtocol(String var1);

    @Transactional(readOnly=false)
    public TuttiProtocol createProtocol(TuttiProtocol var1);

    @Transactional(readOnly=false)
    public TuttiProtocol saveProtocol(TuttiProtocol var1);

    @Transactional(readOnly=false)
    public void deleteProtocol(String var1);

    public int getFishingOperationCount(String var1);

    public List<String> getAllFishingOperationIds(String var1);

    public List<FishingOperation> getAllFishingOperation(String var1);

    public FishingOperation getFishingOperation(String var1);

    public List<Vessel> getFishingOperationSecondaryVessel(String var1);

    @Transactional(readOnly=false)
    public FishingOperation createFishingOperation(FishingOperation var1);

    @Transactional(readOnly=false)
    public FishingOperation saveFishingOperation(FishingOperation var1);

    @Transactional(readOnly=false)
    public void deleteFishingOperation(String var1);

    public boolean isFishingOperationWithCatchBatch(String var1);

    public CatchBatch getCatchBatchFromFishingOperation(String var1) throws InvalidBatchModelException;

    @Transactional(readOnly=false)
    public CatchBatch createCatchBatch(CatchBatch var1);

    @Transactional(readOnly=false)
    public CatchBatch saveCatchBatch(CatchBatch var1);

    public BatchContainer<SpeciesBatch> getRootSpeciesBatch(String var1, SampleCategoryModel var2) throws InvalidBatchModelException;

    @Transactional(readOnly=false)
    public SpeciesBatch createSpeciesBatch(SpeciesBatch var1, String var2);

    @Transactional(readOnly=false)
    public SpeciesBatch saveSpeciesBatch(SpeciesBatch var1);

    @Transactional(readOnly=false)
    public void deleteSpeciesBatch(String var1);

    @Transactional(readOnly=false)
    public void deleteSpeciesSubBatch(String var1);

    @Transactional(readOnly=false)
    public void changeSpeciesBatchSpecies(String var1, Species var2);

    public List<SpeciesBatchFrequency> getAllSpeciesBatchFrequency(String var1);

    public Multimap<Species, SpeciesBatchFrequency> getAllSpeciesBatchFrequencyForBatch(BatchContainer<SpeciesBatch> var1);

    @Transactional(readOnly=false)
    public List<SpeciesBatchFrequency> saveSpeciesBatchFrequency(String var1, List<SpeciesBatchFrequency> var2);

    public BatchContainer<BenthosBatch> getRootBenthosBatch(String var1, SampleCategoryModel var2) throws InvalidBatchModelException;

    @Transactional(readOnly=false)
    public BenthosBatch createBenthosBatch(BenthosBatch var1, String var2);

    @Transactional(readOnly=false)
    public BenthosBatch saveBenthosBatch(BenthosBatch var1);

    @Transactional(readOnly=false)
    public void deleteBenthosBatch(String var1);

    @Transactional(readOnly=false)
    public void deleteBenthosSubBatch(String var1);

    @Transactional(readOnly=false)
    public void changeBenthosBatchSpecies(String var1, Species var2);

    public List<BenthosBatchFrequency> getAllBenthosBatchFrequency(String var1);

    public Multimap<Species, BenthosBatchFrequency> getAllBenthosBatchFrequencyForBatch(BatchContainer<BenthosBatch> var1);

    @Transactional(readOnly=false)
    public List<BenthosBatchFrequency> saveBenthosBatchFrequency(String var1, List<BenthosBatchFrequency> var2);

    public BatchContainer<MarineLitterBatch> getRootMarineLitterBatch(String var1);

    @Transactional(readOnly=false)
    public MarineLitterBatch createMarineLitterBatch(MarineLitterBatch var1);

    @Transactional(readOnly=false)
    public MarineLitterBatch saveMarineLitterBatch(MarineLitterBatch var1);

    @Transactional(readOnly=false)
    public void deleteMarineLitterBatch(String var1);

    public List<AccidentalBatch> getAllAccidentalBatch(String var1);

    @Transactional(readOnly=false)
    public AccidentalBatch createAccidentalBatch(AccidentalBatch var1);

    @Transactional(readOnly=false)
    public AccidentalBatch saveAccidentalBatch(AccidentalBatch var1);

    @Transactional(readOnly=false)
    public void deleteAccidentalBatch(String var1);

    public List<IndividualObservationBatch> getAllIndividualObservationBatch(String var1);

    @Transactional(readOnly=false)
    public IndividualObservationBatch createIndividualObservationBatch(IndividualObservationBatch var1);

    @Transactional(readOnly=false)
    public IndividualObservationBatch saveIndividualObservationBatch(IndividualObservationBatch var1);

    @Transactional(readOnly=false)
    public void deleteIndividualObservationBatch(String var1);
}

