package fr.ifremer.tutti.ui.swing.content.home;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2014 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.persistence.entities.data.Program;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocol;
import fr.ifremer.tutti.ui.swing.TuttiHelpBroker;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.editor.bean.BeanFilterableComboBox;
import jaxx.runtime.swing.help.JAXXHelpUI;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import jaxx.runtime.validator.swing.ui.ImageValidationUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.jaxx.application.swing.util.ActionListCellRenderer;
import static org.nuiton.i18n.I18n.t;

public class SelectCruiseUI extends JPanel implements JAXXHelpUI<TuttiHelpBroker>, TuttiUI<SelectCruiseUIModel, SelectCruiseUIHandler>, JAXXObject, JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_CRUISE_COMBOBOX_ENABLED = "cruiseCombobox.enabled";
    public static final String BINDING_CRUISE_COMBOBOX_SELECTED_ITEM = "cruiseCombobox.selectedItem";
    public static final String BINDING_EDIT_CATCHES_BUTTON_ENABLED = "editCatchesButton.enabled";
    public static final String BINDING_EDIT_CRUISE_COMBO_BOX_ENABLED = "editCruiseComboBox.enabled";
    public static final String BINDING_EDIT_PROGRAM_COMBO_BOX_ENABLED = "editProgramComboBox.enabled";
    public static final String BINDING_EDIT_PROTOCOL_COMBO_BOX_ENABLED = "editProtocolComboBox.enabled";
    public static final String BINDING_NEW_CRUISE_BUTTON_ENABLED = "newCruiseButton.enabled";
    public static final String BINDING_PROGRAM_COMBOBOX_ENABLED = "programCombobox.enabled";
    public static final String BINDING_PROGRAM_COMBOBOX_SELECTED_ITEM = "programCombobox.selectedItem";
    public static final String BINDING_PROTOCOL_COMBOBOX_ENABLED = "protocolCombobox.enabled";
    public static final String BINDING_PROTOCOL_COMBOBOX_SELECTED_ITEM = "protocolCombobox.selectedItem";
    public static final String BINDING_VALIDATE_CATCHES_BUTTON_ENABLED = "validateCatchesButton.enabled";
    public static final String BINDING_WARNING_CONTAINER_VISIBLE = "warningContainer.visible";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(SelectCruiseUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected TuttiHelpBroker broker;
    protected JButton cloneProtocolButton;
    @ValidatorField( validatorId = "validator",  propertyName = "cruise",  editorName = "cruiseCombobox")
    protected BeanFilterableComboBox<Cruise> cruiseCombobox;
    protected JLabel cruiseLabel;
    protected JButton deleteProtocolButton;
    protected JButton editCatchesButton;
    protected JButton editCruiseButton;
    protected JComboBox editCruiseComboBox;
    protected JButton editProgramButton;
    protected JComboBox editProgramComboBox;
    protected JButton editProtocolButton;
    protected JComboBox editProtocolComboBox;
    protected JButton exportCruiseButton;
    protected JButton exportCruiseForSumatraButton;
    protected JButton exportProgramButton;
    protected JButton exportProtocolButton;
    protected final SelectCruiseUIHandler handler = new SelectCruiseUIHandler();
    protected JButton importProtocolButton;
    protected SelectCruiseUIModel model;
    protected JButton newCruiseButton;
    protected JButton newProgramButton;
    protected JButton newProtocolButton;
    protected JComboBox newProtocolComboBox;
    @ValidatorField( validatorId = "validator",  propertyName = "program",  editorName = "programCombobox")
    protected BeanFilterableComboBox<Program> programCombobox;
    protected JLabel programLabel;
    @ValidatorField( validatorId = "validator",  propertyName = "protocol",  editorName = "protocolCombobox")
    protected BeanFilterableComboBox<TuttiProtocol> protocolCombobox;
    protected JLabel protocolLabel;
    protected SelectCruiseUI selectCruiseTopPanel = this;
    protected JButton sendCruiseReportButton;
    protected JButton validateCatchesButton;
    @Validator( validatorId = "validator")
    protected SwingValidator<SelectCruiseUIModel> validator;
    protected List<String> validatorIds = new ArrayList<String>();
    protected JPanel warningContainer;
    protected JLabel warningLabel;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JPanel $JPanel0;
    private JPanel $JPanel1;
    private JPanel $JPanel2;
    private JPanel $JPanel3;
    private Table $Table0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected TuttiUIContext uiContext;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public SelectCruiseUI(TuttiUI parentUI) {
        TuttiUIUtil.setParentUI(this, parentUI);
                uiContext = TuttiUIUtil.getApplicationContext(parentUI);
            $initialize();
    }

    public SelectCruiseUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public SelectCruiseUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SelectCruiseUI() {
        $initialize();
    }

    public SelectCruiseUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SelectCruiseUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public SelectCruiseUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SelectCruiseUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public SelectCruiseUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__editCruiseComboBox(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.startEditCruiseAction(event);
    }

    public void doActionPerformed__on__editProgramComboBox(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.startEditProgramAction(event);
    }

    public void doActionPerformed__on__editProtocolComboBox(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.startExistingProtocolAction(event);
    }

    public void doActionPerformed__on__newProtocolComboBox(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.startNewProtocolAction(event);
    }

    public void doMouseClicked__on__editCruiseComboBox(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        if (editCruiseComboBox.isEnabled()) { handler.startEditCruiseAction(event); }
    }

    public void doMouseClicked__on__editProgramComboBox(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        if (editProgramComboBox.isEnabled()) { handler.startEditProgramAction(event); }
    }

    public void doMouseClicked__on__editProtocolComboBox(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        if (editProtocolComboBox.isEnabled()) { handler.startExistingProtocolAction(event); }
    }

    public void doMouseClicked__on__newProtocolComboBox(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.startNewProtocolAction(event);
    }

    public void doMouseEntered__on__editCruiseComboBox(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        if (editCruiseComboBox.isEnabled()) { editCruiseComboBox.showPopup(); }
    }

    public void doMouseEntered__on__editProgramComboBox(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        if (editProgramComboBox.isEnabled()) { editProgramComboBox.showPopup(); }
    }

    public void doMouseEntered__on__editProtocolComboBox(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        if (editProtocolComboBox.isEnabled()) { editProtocolComboBox.showPopup(); }
    }

    public void doMouseEntered__on__newProtocolComboBox(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        newProtocolComboBox.showPopup();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public TuttiHelpBroker getBroker() {
        return broker;
    }

    public JButton getCloneProtocolButton() {
        return cloneProtocolButton;
    }

    public BeanFilterableComboBox<Cruise> getCruiseCombobox() {
        return cruiseCombobox;
    }

    public JLabel getCruiseLabel() {
        return cruiseLabel;
    }

    public JButton getDeleteProtocolButton() {
        return deleteProtocolButton;
    }

    public JButton getEditCatchesButton() {
        return editCatchesButton;
    }

    public JButton getEditCruiseButton() {
        return editCruiseButton;
    }

    public JComboBox getEditCruiseComboBox() {
        return editCruiseComboBox;
    }

    public JButton getEditProgramButton() {
        return editProgramButton;
    }

    public JComboBox getEditProgramComboBox() {
        return editProgramComboBox;
    }

    public JButton getEditProtocolButton() {
        return editProtocolButton;
    }

    public JComboBox getEditProtocolComboBox() {
        return editProtocolComboBox;
    }

    public JButton getExportCruiseButton() {
        return exportCruiseButton;
    }

    public JButton getExportCruiseForSumatraButton() {
        return exportCruiseForSumatraButton;
    }

    public JButton getExportProgramButton() {
        return exportProgramButton;
    }

    public JButton getExportProtocolButton() {
        return exportProtocolButton;
    }

    public SelectCruiseUIHandler getHandler() {
        return handler;
    }

    public JButton getImportProtocolButton() {
        return importProtocolButton;
    }

    public SelectCruiseUIModel getModel() {
        return model;
    }

    public JButton getNewCruiseButton() {
        return newCruiseButton;
    }

    public JButton getNewProgramButton() {
        return newProgramButton;
    }

    public JButton getNewProtocolButton() {
        return newProtocolButton;
    }

    public JComboBox getNewProtocolComboBox() {
        return newProtocolComboBox;
    }

    public BeanFilterableComboBox<Program> getProgramCombobox() {
        return programCombobox;
    }

    public JLabel getProgramLabel() {
        return programLabel;
    }

    public BeanFilterableComboBox<TuttiProtocol> getProtocolCombobox() {
        return protocolCombobox;
    }

    public JLabel getProtocolLabel() {
        return protocolLabel;
    }

    public JButton getSendCruiseReportButton() {
        return sendCruiseReportButton;
    }

    public JButton getValidateCatchesButton() {
        return validateCatchesButton;
    }

    public SwingValidator<SelectCruiseUIModel> getValidator() {
        return validator;
    }

    public JPanel getWarningContainer() {
        return warningContainer;
    }

    public JLabel getWarningLabel() {
        return warningLabel;
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Other methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void registerHelpId(TuttiHelpBroker broker, Component component, String helpId) {
        broker.installUI(component, helpId);
    }

    @Override
    public void showHelp(String helpId) {
        getBroker().showHelp(this, helpId);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected JPanel get$JPanel1() {
        return $JPanel1;
    }

    protected JPanel get$JPanel2() {
        return $JPanel2;
    }

    protected JPanel get$JPanel3() {
        return $JPanel3;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToSelectCruiseTopPanel() {
        if (!allComponentsCreated) {
            return;
        }
        add(editProgramButton);
        add(exportProgramButton);
        add(editCruiseButton);
        add(exportCruiseButton);
        add(sendCruiseReportButton);
        add(exportCruiseForSumatraButton);
        add(newProtocolButton);
        add(importProtocolButton);
        add(editProtocolButton);
        add(cloneProtocolButton);
        add(exportProtocolButton);
        add(deleteProtocolButton);
        add($Table0, BorderLayout.CENTER);
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setUiClass(ImageValidationUI.class);
        validator.setBean(model);
    }

    protected void addChildrenToWarningContainer() {
        if (!allComponentsCreated) {
            return;
        }
        warningContainer.add(warningLabel, BorderLayout.CENTER);
    }

    protected void createBroker() {
        $objectMap.put("broker", broker = new TuttiHelpBroker("tutti.selectCruise.help"));
    }

    protected void createCloneProtocolButton() {
        $objectMap.put("cloneProtocolButton", cloneProtocolButton = new JButton());
        
        cloneProtocolButton.setName("cloneProtocolButton");
        cloneProtocolButton.setText(t("tutti.selectCruise.action.cloneProtocol"));
        cloneProtocolButton.setToolTipText(t("tutti.selectCruise.action.cloneProtocol.tip"));
        cloneProtocolButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.action.CloneProtocolAction.class);
        cloneProtocolButton.putClientProperty("help", "tutti.selectCruise.action.cloneProtocol.help");
    }

    protected void createCruiseCombobox() {
        $objectMap.put("cruiseCombobox", cruiseCombobox = new BeanFilterableComboBox<Cruise>(this));
        
        cruiseCombobox.setName("cruiseCombobox");
        cruiseCombobox.setProperty("cruise");
        cruiseCombobox.setShowReset(true);
        cruiseCombobox.putClientProperty("help", "tutti.selectCruise.field.cruise.help");
        cruiseCombobox.putClientProperty("validatorLabel", t("tutti.selectCruise.field.cruise"));
    }

    protected void createCruiseLabel() {
        $objectMap.put("cruiseLabel", cruiseLabel = new JLabel());
        
        cruiseLabel.setName("cruiseLabel");
        cruiseLabel.setText(t("tutti.selectCruise.field.cruise"));
        cruiseLabel.setToolTipText(t("tutti.selectCruise.field.cruise.tip"));
        cruiseLabel.putClientProperty("help", "tutti.selectCruise.field.cruise.help");
    }

    protected void createDeleteProtocolButton() {
        $objectMap.put("deleteProtocolButton", deleteProtocolButton = new JButton());
        
        deleteProtocolButton.setName("deleteProtocolButton");
        deleteProtocolButton.setText(t("tutti.selectCruise.action.deleteProtocol"));
        deleteProtocolButton.setToolTipText(t("tutti.selectCruise.action.deleteProtocol.tip"));
        deleteProtocolButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.action.DeleteProtocolAction.class);
        deleteProtocolButton.putClientProperty("help", "tutti.selectCruise.action.deleteProtocol.help");
    }

    protected void createEditCatchesButton() {
        $objectMap.put("editCatchesButton", editCatchesButton = new JButton());
        
        editCatchesButton.setName("editCatchesButton");
        editCatchesButton.setText(t("tutti.selectCruise.action.editCatches"));
        editCatchesButton.setToolTipText(t("tutti.selectCruise.action.editCatches.tip"));
        editCatchesButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.action.EditCatchesAction.class);
        editCatchesButton.putClientProperty("help", "tutti.selectCruise.action.editCatches.help");
    }

    protected void createEditCruiseButton() {
        $objectMap.put("editCruiseButton", editCruiseButton = new JButton());
        
        editCruiseButton.setName("editCruiseButton");
        editCruiseButton.setText(t("tutti.selectCruise.action.editCruise"));
        editCruiseButton.setToolTipText(t("tutti.selectCruise.action.editCruise.tip"));
        editCruiseButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.action.EditCruiseAction.class);
        editCruiseButton.putClientProperty("help", "tutti.selectCruise.action.editCruise.help");
    }

    protected void createEditCruiseComboBox() {
        $objectMap.put("editCruiseComboBox", editCruiseComboBox = new JComboBox());
        
        editCruiseComboBox.setName("editCruiseComboBox");
        editCruiseComboBox.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__editCruiseComboBox"));
        editCruiseComboBox.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseClicked", this, "doMouseClicked__on__editCruiseComboBox"));
        editCruiseComboBox.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseEntered", this, "doMouseEntered__on__editCruiseComboBox"));
    }

    protected void createEditProgramButton() {
        $objectMap.put("editProgramButton", editProgramButton = new JButton());
        
        editProgramButton.setName("editProgramButton");
        editProgramButton.setText(t("tutti.selectCruise.action.editProgram"));
        editProgramButton.setToolTipText(t("tutti.selectCruise.action.editProgram.tip"));
        editProgramButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.action.EditProgramAction.class);
        editProgramButton.putClientProperty("help", "tutti.selectCruise.action.editProgram.help");
    }

    protected void createEditProgramComboBox() {
        $objectMap.put("editProgramComboBox", editProgramComboBox = new JComboBox());
        
        editProgramComboBox.setName("editProgramComboBox");
        editProgramComboBox.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__editProgramComboBox"));
        editProgramComboBox.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseClicked", this, "doMouseClicked__on__editProgramComboBox"));
        editProgramComboBox.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseEntered", this, "doMouseEntered__on__editProgramComboBox"));
    }

    protected void createEditProtocolButton() {
        $objectMap.put("editProtocolButton", editProtocolButton = new JButton());
        
        editProtocolButton.setName("editProtocolButton");
        editProtocolButton.setText(t("tutti.selectCruise.action.editProtocol"));
        editProtocolButton.setToolTipText(t("tutti.selectCruise.action.editProtocol.tip"));
        editProtocolButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.action.EditProtocolAction.class);
        editProtocolButton.putClientProperty("help", "tutti.selectCruise.action.editProtocol.help");
    }

    protected void createEditProtocolComboBox() {
        $objectMap.put("editProtocolComboBox", editProtocolComboBox = new JComboBox());
        
        editProtocolComboBox.setName("editProtocolComboBox");
        editProtocolComboBox.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__editProtocolComboBox"));
        editProtocolComboBox.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseClicked", this, "doMouseClicked__on__editProtocolComboBox"));
        editProtocolComboBox.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseEntered", this, "doMouseEntered__on__editProtocolComboBox"));
    }

    protected void createExportCruiseButton() {
        $objectMap.put("exportCruiseButton", exportCruiseButton = new JButton());
        
        exportCruiseButton.setName("exportCruiseButton");
        exportCruiseButton.setEnabled(false);
        exportCruiseButton.setText(t("tutti.selectCruise.action.exportCruise"));
        exportCruiseButton.setToolTipText(t("tutti.selectCruise.action.exportCruise.tip"));
        exportCruiseButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.action.ExportCruiseAction.class);
        exportCruiseButton.putClientProperty("help", "tutti.selectCruise.action.exportCruise.help");
    }

    protected void createExportCruiseForSumatraButton() {
        $objectMap.put("exportCruiseForSumatraButton", exportCruiseForSumatraButton = new JButton());
        
        exportCruiseForSumatraButton.setName("exportCruiseForSumatraButton");
        exportCruiseForSumatraButton.setText(t("tutti.selectCruise.action.exportCruiseForSumatra"));
        exportCruiseForSumatraButton.setToolTipText(t("tutti.selectCruise.action.exportCruiseForSumatra.tip"));
        exportCruiseForSumatraButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.action.ExportCruiseForSumatraAction.class);
        exportCruiseForSumatraButton.putClientProperty("help", "tutti.selectCruise.action.exportCruiseForSumatra.help");
    }

    protected void createExportProgramButton() {
        $objectMap.put("exportProgramButton", exportProgramButton = new JButton());
        
        exportProgramButton.setName("exportProgramButton");
        exportProgramButton.setEnabled(false);
        exportProgramButton.setText(t("tutti.selectCruise.action.exportProgram"));
        exportProgramButton.setToolTipText(t("tutti.selectCruise.action.exportProgram.tip"));
        exportProgramButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.action.ExportProgramAction.class);
        exportProgramButton.putClientProperty("help", "tutti.selectCruise.action.exportProgram.help");
    }

    protected void createExportProtocolButton() {
        $objectMap.put("exportProtocolButton", exportProtocolButton = new JButton());
        
        exportProtocolButton.setName("exportProtocolButton");
        exportProtocolButton.setText(t("tutti.selectCruise.action.exportProtocol"));
        exportProtocolButton.setToolTipText(t("tutti.selectCruise.action.exportProtocol.tip"));
        exportProtocolButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.action.ExportProtocolAction.class);
        exportProtocolButton.putClientProperty("help", "tutti.selectCruise.action.exportProtocol.help");
    }

    protected void createImportProtocolButton() {
        $objectMap.put("importProtocolButton", importProtocolButton = new JButton());
        
        importProtocolButton.setName("importProtocolButton");
        importProtocolButton.setText(t("tutti.selectCruise.action.importProtocol"));
        importProtocolButton.setToolTipText(t("tutti.selectCruise.action.importProtocol.tip"));
        importProtocolButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.action.ImportProtocolAction.class);
        importProtocolButton.putClientProperty("help", "tutti.selectCruise.action.importProtocol.help");
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(SelectCruiseUIModel.class));
    }

    protected void createNewCruiseButton() {
        $objectMap.put("newCruiseButton", newCruiseButton = new JButton());
        
        newCruiseButton.setName("newCruiseButton");
        newCruiseButton.setText(t("tutti.selectCruise.action.newCruise"));
        newCruiseButton.setToolTipText(t("tutti.selectCruise.action.newCruise.tip"));
        newCruiseButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.action.NewCruiseAction.class);
        newCruiseButton.putClientProperty("help", "tutti.selectCruise.action.newCruise.help");
    }

    protected void createNewProgramButton() {
        $objectMap.put("newProgramButton", newProgramButton = new JButton());
        
        newProgramButton.setName("newProgramButton");
        newProgramButton.setText(t("tutti.selectCruise.action.newProgram"));
        newProgramButton.setToolTipText(t("tutti.selectCruise.action.newProgram.tip"));
        newProgramButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.action.NewProgramAction.class);
        newProgramButton.putClientProperty("help", "tutti.selectCruise.action.newProgram.help");
    }

    protected void createNewProtocolButton() {
        $objectMap.put("newProtocolButton", newProtocolButton = new JButton());
        
        newProtocolButton.setName("newProtocolButton");
        newProtocolButton.setText(t("tutti.selectCruise.action.newProtocol"));
        newProtocolButton.setToolTipText(t("tutti.selectCruise.action.newProtocol.tip"));
        newProtocolButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.action.NewProtocolAction.class);
        newProtocolButton.putClientProperty("help", "tutti.selectCruise.action.newProtocol.help");
    }

    protected void createNewProtocolComboBox() {
        $objectMap.put("newProtocolComboBox", newProtocolComboBox = new JComboBox());
        
        newProtocolComboBox.setName("newProtocolComboBox");
        newProtocolComboBox.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__newProtocolComboBox"));
        newProtocolComboBox.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseClicked", this, "doMouseClicked__on__newProtocolComboBox"));
        newProtocolComboBox.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseEntered", this, "doMouseEntered__on__newProtocolComboBox"));
    }

    protected void createProgramCombobox() {
        $objectMap.put("programCombobox", programCombobox = new BeanFilterableComboBox<Program>(this));
        
        programCombobox.setName("programCombobox");
        programCombobox.setProperty("program");
        programCombobox.setShowReset(true);
        programCombobox.putClientProperty("help", "tutti.selectCruise.field.program.help");
        programCombobox.putClientProperty("validatorLabel", t("tutti.selectCruise.field.program"));
    }

    protected void createProgramLabel() {
        $objectMap.put("programLabel", programLabel = new JLabel());
        
        programLabel.setName("programLabel");
        programLabel.setText(t("tutti.selectCruise.field.program"));
        programLabel.setToolTipText(t("tutti.selectCruise.field.program.tip"));
        programLabel.putClientProperty("help", "tutti.selectCruise.field.program.help");
    }

    protected void createProtocolCombobox() {
        $objectMap.put("protocolCombobox", protocolCombobox = new BeanFilterableComboBox<TuttiProtocol>(this));
        
        protocolCombobox.setName("protocolCombobox");
        protocolCombobox.setProperty("protocol");
        protocolCombobox.setShowReset(true);
        protocolCombobox.putClientProperty("help", "tutti.selectCruise.field.protocol.help");
        protocolCombobox.putClientProperty("validatorLabel", t("tutti.selectCruise.field.protocol"));
    }

    protected void createProtocolLabel() {
        $objectMap.put("protocolLabel", protocolLabel = new JLabel());
        
        protocolLabel.setName("protocolLabel");
        protocolLabel.setText(t("tutti.selectCruise.field.protocol"));
        protocolLabel.setToolTipText(t("tutti.selectCruise.field.protocol.tip"));
        protocolLabel.putClientProperty("help", "tutti.selectCruise.field.protocol.help");
    }

    protected void createSendCruiseReportButton() {
        $objectMap.put("sendCruiseReportButton", sendCruiseReportButton = new JButton());
        
        sendCruiseReportButton.setName("sendCruiseReportButton");
        sendCruiseReportButton.setText(t("tutti.selectCruise.action.sendCruiseReport"));
        sendCruiseReportButton.setToolTipText(t("tutti.selectCruise.action.sendCruiseReport.tip"));
        sendCruiseReportButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.action.SendCruiseReportAction.class);
        sendCruiseReportButton.putClientProperty("help", "tutti.selectCruise.action.sendCruiseReport.help");
    }

    protected void createValidateCatchesButton() {
        $objectMap.put("validateCatchesButton", validateCatchesButton = new JButton());
        
        validateCatchesButton.setName("validateCatchesButton");
        validateCatchesButton.setText(t("tutti.selectCruise.action.validateCatches"));
        validateCatchesButton.setToolTipText(t("tutti.selectCruise.action.validateCatches.tip"));
        validateCatchesButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.action.ValidateCatchesAction.class);
        validateCatchesButton.putClientProperty("help", "tutti.selectCruise.action.validateCatches.help");
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = SwingValidator.newValidator(SelectCruiseUIModel.class, null));
    }

    protected void createWarningContainer() {
        $objectMap.put("warningContainer", warningContainer = new JPanel());
        
        warningContainer.setName("warningContainer");
        warningContainer.setLayout(new BorderLayout(10, 10));
    }

    protected void createWarningLabel() {
        $objectMap.put("warningLabel", warningLabel = new JLabel());
        
        warningLabel.setName("warningLabel");
        warningLabel.setText(t("tutti.selectCruise.warn.invalid.selected.data"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToSelectCruiseTopPanel();
        addChildrenToValidator();
        // inline complete setup of $Table0
        $Table0.add(warningContainer, new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(programLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(programCombobox), new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JPanel0, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(cruiseLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(cruiseCombobox), new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JPanel1, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(protocolLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(protocolCombobox), new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JPanel2, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JPanel3, new GridBagConstraints(0, 4, 3, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        addChildrenToWarningContainer();
        // inline complete setup of $JPanel0
        $JPanel0.add(editProgramComboBox);
        $JPanel0.add(newProgramButton);
        // inline complete setup of $JPanel1
        $JPanel1.add(editCruiseComboBox);
        $JPanel1.add(newCruiseButton);
        // inline complete setup of $JPanel2
        $JPanel2.add(editProtocolComboBox);
        $JPanel2.add(newProtocolComboBox);
        // inline complete setup of $JPanel3
        $JPanel3.add(editCatchesButton);
        $JPanel3.add(validateCatchesButton);
        
        // apply 13 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 46 property setters
        programCombobox.setBeanType(Program.class);
        cruiseCombobox.setBeanType(Cruise.class);
        protocolCombobox.setBeanType(TuttiProtocol.class);
        editProgramButton.setIcon(SwingUtil.createActionIcon("edit"));
        exportProgramButton.setIcon(SwingUtil.createActionIcon("export"));
        editCruiseButton.setIcon(SwingUtil.createActionIcon("edit"));
        exportCruiseButton.setIcon(SwingUtil.createActionIcon("export"));
        sendCruiseReportButton.setIcon(SwingUtil.createActionIcon("email"));
        exportCruiseForSumatraButton.setIcon(SwingUtil.createActionIcon("export"));
        newProtocolButton.setIcon(SwingUtil.createActionIcon("add"));
        importProtocolButton.setIcon(SwingUtil.createActionIcon("import"));
        editProtocolButton.setIcon(SwingUtil.createActionIcon("edit"));
        cloneProtocolButton.setIcon(SwingUtil.createActionIcon("copy"));
        exportProtocolButton.setIcon(SwingUtil.createActionIcon("export"));
        deleteProtocolButton.setIcon(SwingUtil.createActionIcon("delete"));
        warningContainer.setBackground(new java.awt.Color(245, 218, 88));
        warningLabel.setIcon(SwingUtil.createActionIcon("warning"));
        warningLabel.setBorder(new javax.swing.border.EmptyBorder(5, 10, 5, 10));
        programLabel.setIcon(SwingUtil.createActionIcon("program"));
        programCombobox.setBean(model);
        editProgramComboBox.setModel(handler.newComboModel(editProgramButton, exportProgramButton));
        editProgramComboBox.setRenderer(new ActionListCellRenderer());
        newProgramButton.setIcon(SwingUtil.createActionIcon("add"));
        cruiseLabel.setLabelFor(cruiseCombobox);
        cruiseLabel.setIcon(SwingUtil.createActionIcon("cruise"));
        cruiseCombobox.setBean(model);
        editCruiseComboBox.setModel(handler.newComboModel(editCruiseButton, exportCruiseButton, sendCruiseReportButton, exportCruiseForSumatraButton));
        editCruiseComboBox.setRenderer(new ActionListCellRenderer());
        newCruiseButton.setIcon(SwingUtil.createActionIcon("add"));
        protocolLabel.setLabelFor(protocolCombobox);
        protocolLabel.setIcon(SwingUtil.createActionIcon("protocol"));
        protocolCombobox.setBean(model);
        editProtocolComboBox.setModel(handler.newComboModel(editProtocolButton, cloneProtocolButton, exportProtocolButton, deleteProtocolButton));
        editProtocolComboBox.setRenderer(new ActionListCellRenderer());
        newProtocolComboBox.setModel(handler.newComboModel(newProtocolButton, importProtocolButton));
        newProtocolComboBox.setRenderer(new ActionListCellRenderer());
        editCatchesButton.setIcon(SwingUtil.createActionIcon("edit"));
        editCatchesButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.selectCruise.action.editCatches.mnemonic"),'Z'));
        validateCatchesButton.setIcon(SwingUtil.createActionIcon("validate"));
        validateCatchesButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.selectCruise.action.validateCatches.mnemonic"),'Z'));
        // late initializer
        // help broker setup
        TuttiHelpBroker _broker = getBroker();
        registerHelpId(_broker, selectCruiseTopPanel, "tutti.selectCruise.help");
        registerHelpId(_broker, editProgramButton, "tutti.selectCruise.action.editProgram.help");
        registerHelpId(_broker, exportProgramButton, "tutti.selectCruise.action.exportProgram.help");
        registerHelpId(_broker, editCruiseButton, "tutti.selectCruise.action.editCruise.help");
        registerHelpId(_broker, exportCruiseButton, "tutti.selectCruise.action.exportCruise.help");
        registerHelpId(_broker, sendCruiseReportButton, "tutti.selectCruise.action.sendCruiseReport.help");
        registerHelpId(_broker, exportCruiseForSumatraButton, "tutti.selectCruise.action.exportCruiseForSumatra.help");
        registerHelpId(_broker, newProtocolButton, "tutti.selectCruise.action.newProtocol.help");
        registerHelpId(_broker, importProtocolButton, "tutti.selectCruise.action.importProtocol.help");
        registerHelpId(_broker, editProtocolButton, "tutti.selectCruise.action.editProtocol.help");
        registerHelpId(_broker, cloneProtocolButton, "tutti.selectCruise.action.cloneProtocol.help");
        registerHelpId(_broker, exportProtocolButton, "tutti.selectCruise.action.exportProtocol.help");
        registerHelpId(_broker, deleteProtocolButton, "tutti.selectCruise.action.deleteProtocol.help");
        registerHelpId(_broker, programLabel, "tutti.selectCruise.field.program.help");
        registerHelpId(_broker, programCombobox, "tutti.selectCruise.field.program.help");
        registerHelpId(_broker, newProgramButton, "tutti.selectCruise.action.newProgram.help");
        registerHelpId(_broker, cruiseLabel, "tutti.selectCruise.field.cruise.help");
        registerHelpId(_broker, cruiseCombobox, "tutti.selectCruise.field.cruise.help");
        registerHelpId(_broker, newCruiseButton, "tutti.selectCruise.action.newCruise.help");
        registerHelpId(_broker, protocolLabel, "tutti.selectCruise.field.protocol.help");
        registerHelpId(_broker, protocolCombobox, "tutti.selectCruise.field.protocol.help");
        registerHelpId(_broker, editCatchesButton, "tutti.selectCruise.action.editCatches.help");
        registerHelpId(_broker, validateCatchesButton, "tutti.selectCruise.action.validateCatches.help");
        _broker.prepareUI(this);
        // register 1 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        handler.beforeInit(this);
        $objectMap.put("selectCruiseTopPanel", selectCruiseTopPanel);
        createModel();
        createValidator();
        createBroker();
        createEditProgramButton();
        createExportProgramButton();
        createEditCruiseButton();
        createExportCruiseButton();
        createSendCruiseReportButton();
        createExportCruiseForSumatraButton();
        createNewProtocolButton();
        createImportProtocolButton();
        createEditProtocolButton();
        createCloneProtocolButton();
        createExportProtocolButton();
        createDeleteProtocolButton();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        createWarningContainer();
        createWarningLabel();
        createProgramLabel();
        createProgramCombobox();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new GridLayout(1,0));
        createEditProgramComboBox();
        createNewProgramButton();
        createCruiseLabel();
        createCruiseCombobox();
        // inline creation of $JPanel1
        $objectMap.put("$JPanel1", $JPanel1 = new JPanel());
        
        $JPanel1.setName("$JPanel1");
        $JPanel1.setLayout(new GridLayout(1,0));
        createEditCruiseComboBox();
        createNewCruiseButton();
        createProtocolLabel();
        createProtocolCombobox();
        // inline creation of $JPanel2
        $objectMap.put("$JPanel2", $JPanel2 = new JPanel());
        
        $JPanel2.setName("$JPanel2");
        $JPanel2.setLayout(new GridLayout(1,0));
        createEditProtocolComboBox();
        createNewProtocolComboBox();
        // inline creation of $JPanel3
        $objectMap.put("$JPanel3", $JPanel3 = new JPanel());
        
        $JPanel3.setName("$JPanel3");
        $JPanel3.setLayout(new GridLayout(1,0));
        createEditCatchesButton();
        createValidateCatchesButton();
        // inline creation of selectCruiseTopPanel
        setName("selectCruiseTopPanel");
        setLayout(new BorderLayout());
        selectCruiseTopPanel.putClientProperty("help", "tutti.selectCruise.help");
        
        // registers 13 data bindings
        $registerDefaultBindings();
        $completeSetup();
        handler.afterInit(this);
    }

    private void $registerDefaultBindings() {
        // register 13 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_WARNING_CONTAINER_VISIBLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("valid", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    warningContainer.setVisible(!model.isValid());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("valid", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_PROGRAM_COMBOBOX_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (programCombobox != null) {
                    programCombobox.addPropertyChangeListener("empty", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (programCombobox != null) {
                    programCombobox.setEnabled(!programCombobox.isEmpty());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (programCombobox != null) {
                    programCombobox.removePropertyChangeListener("empty", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_PROGRAM_COMBOBOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("program", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    programCombobox.setSelectedItem(model.getProgram());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("program", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EDIT_PROGRAM_COMBO_BOX_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("programFound", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    editProgramComboBox.setEnabled(model.isProgramFound());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("programFound", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CRUISE_COMBOBOX_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (cruiseCombobox != null) {
                    cruiseCombobox.addPropertyChangeListener("empty", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (cruiseCombobox != null) {
                    cruiseCombobox.setEnabled(!cruiseCombobox.isEmpty());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (cruiseCombobox != null) {
                    cruiseCombobox.removePropertyChangeListener("empty", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CRUISE_COMBOBOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("cruise", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    cruiseCombobox.setSelectedItem(model.getCruise());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("cruise", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EDIT_CRUISE_COMBO_BOX_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("programFound", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("cruiseFound", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    editCruiseComboBox.setEnabled(model.isProgramFound() && model.isCruiseFound());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("programFound", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("cruiseFound", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_NEW_CRUISE_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("programFound", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    newCruiseButton.setEnabled(model.isProgramFound());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("programFound", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_PROTOCOL_COMBOBOX_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (protocolCombobox != null) {
                    protocolCombobox.addPropertyChangeListener("empty", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (protocolCombobox != null) {
                    protocolCombobox.setEnabled(!protocolCombobox.isEmpty());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (protocolCombobox != null) {
                    protocolCombobox.removePropertyChangeListener("empty", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_PROTOCOL_COMBOBOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("protocol", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    protocolCombobox.setSelectedItem(model.getProtocol());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("protocol", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EDIT_PROTOCOL_COMBO_BOX_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("protocolFound", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    editProtocolComboBox.setEnabled(model.isProtocolFound());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("protocolFound", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EDIT_CATCHES_BUTTON_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("valid", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("cruiseFound", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    editCatchesButton.setEnabled(model.isValid() && model.isCruiseFound());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("valid", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("cruiseFound", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_VALIDATE_CATCHES_BUTTON_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("valid", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("cruiseFound", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    validateCatchesButton.setEnabled(model.isValid() && model.isCruiseFound());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("valid", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("cruiseFound", this);
                }
            }
        });
    }

}