/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.env;

import java.util.Map;
import org.springframework.core.env.MapPropertySource;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SystemEnvironmentPropertySource
extends MapPropertySource {
    public SystemEnvironmentPropertySource(String name, Map<String, Object> source) {
        super(name, source);
    }

    @Override
    public boolean containsProperty(String name) {
        return this.getProperty(name) != null;
    }

    @Override
    public Object getProperty(String name) {
        Assert.notNull(name, "property name must not be null");
        String actualName = this.resolvePropertyName(name);
        if (this.logger.isDebugEnabled() && !name.equals(actualName)) {
            this.logger.debug((Object)String.format("PropertySource [%s] does not contain '%s', but found equivalent '%s'", this.getName(), name, actualName));
        }
        return super.getProperty(actualName);
    }

    private String resolvePropertyName(String name) {
        if (super.containsProperty(name)) {
            return name;
        }
        String usName = name.replace('.', '_');
        if (!name.equals(usName) && super.containsProperty(usName)) {
            return usName;
        }
        String ucName = name.toUpperCase();
        if (!name.equals(ucName)) {
            if (super.containsProperty(ucName)) {
                return ucName;
            }
            String usUcName = ucName.replace('.', '_');
            if (!ucName.equals(usUcName) && super.containsProperty(usUcName)) {
                return usUcName;
            }
        }
        return name;
    }
}

