package fr.ifremer.tutti.ui.swing.content.operation.catches.species;

/*
 * #%L
 * Tutti :: UI
 * $Id: ImportPupitriPopupUIHandler.java 1566 2014-02-04 08:31:02Z tchemit $
 * $HeadURL: https://svn.codelutin.com/tutti/tags/tutti-3.3.5/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/operation/catches/species/ImportPupitriPopupUIHandler.java $
 * %%
 * Copyright (C) 2012 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.spi.UIHandler;

import javax.swing.JOptionPane;

import static org.nuiton.i18n.I18n.t;

/**
 * @author kmorin <morin@codelutin.com>
 * @author tchemit <chemit@codelutin.com>
 * @since 0.2
 */
public class ImportPupitriPopupUIHandler implements UIHandler<ImportPupitriPopupUI> {

    protected ImportPupitriPopupUI ui;

    @Override
    public void beforeInit(ImportPupitriPopupUI ui) {
        this.ui = ui;
    }

    @Override
    public void afterInit(ImportPupitriPopupUI ui) {
        ui.getTrunkFile().setDialogOwner(ui);
        ui.getCarrouselFile().setDialogOwner(ui);
        ui.pack();
        ui.setResizable(true);
    }

    protected void resetFields() {
        ui.getTrunkFile().setSelectedFilePath(null);
        ui.getCarrouselFile().setSelectedFilePath(null);
    }

    public void open() {
        resetFields();
        SwingUtil.center(TuttiUIUtil.getApplicationContext(ui).getMainUI(), ui);
        ui.setVisible(true);
    }

    public void cancel() {
        resetFields();
        ui.dispose();
    }

    public void validate() {
        if (ui.getTrunkFile().getSelectedFile() != null
            && ui.getCarrouselFile().getSelectedFile() != null) {
            ui.dispose();

        } else {
            JOptionPane.showMessageDialog(ui,
                                          t("tutti.importPupitri.error.fileMissing.message"),
                                          t("tutti.importPupitri.error.fileMissing.title"),
                                          JOptionPane.ERROR_MESSAGE);
        }
    }

}
