package fr.ifremer.tutti.ui.swing.action;

/*
 * #%L
 * Tutti :: UI
 * $Id: EditCruiseAction.java 1388 2013-11-26 08:03:42Z tchemit $
 * $HeadURL: https://svn.codelutin.com/tutti/tags/tutti-3.3.5/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/action/EditCruiseAction.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.google.common.base.Preconditions;
import fr.ifremer.tutti.ui.swing.TuttiScreen;
import fr.ifremer.tutti.ui.swing.content.MainUIHandler;

/**
 * Opens the cruise edition screen.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.0
 */
public class EditCruiseAction extends AbstractChangeScreenAction {

    public EditCruiseAction(MainUIHandler handler) {
        super(handler, true, TuttiScreen.EDIT_CRUISE);
    }

    @Override
    public void doAction() throws Exception {
        Preconditions.checkState(getContext().isProgramFilled());
        Preconditions.checkState(getContext().isCruiseFilled());
        super.doAction();
    }
}
