
package fr.ifremer.tutti.ui.swing.util.computable;

/*
 * #%L
 * Tutti :: UI
 * $Id: ComputableDataEditorHandler.java 1573 2014-02-04 16:41:40Z tchemit $
 * $HeadURL: https://svn.codelutin.com/tutti/tags/tutti-3.3.4/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/util/computable/ComputableDataEditorHandler.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer, CodeLutin, Tony CHEMIT
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.swing.editor.NumberEditorHandler;

import javax.swing.JTextField;
import java.awt.Color;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;

/**
 * @author kmorin <kmorin@codelutin.com>
 * @since 1.0
 */
public class ComputableDataEditorHandler extends NumberEditorHandler {

    protected Integer decimalNumber;

    public ComputableDataEditorHandler(ComputableDataEditor ui) {
        super(ui);
    }

    @Override
    public void init() {
        final PropertyChangeListener l = new PropertyChangeListener() {

            public void propertyChange(PropertyChangeEvent evt) {
                setComputedTextIfNullModel();
            }
        };

        ComputableData bean = (ComputableData) editor.getBean();
        if (bean != null) {
            bean.addPropertyChangeListener(l);
        }
        editor.addPropertyChangeListener(ComputableDataEditor.PROPERTY_BEAN, new PropertyChangeListener() {

            public void propertyChange(PropertyChangeEvent evt) {

                ComputableData bean = (ComputableData) evt.getOldValue();
                if (bean != null) {
                    bean.removePropertyChangeListener(ComputableData.PROPERTY_COMPUTED_DATA, l);
                }

                bean = (ComputableData) evt.getNewValue();
                if (bean != null) {
                    bean.addPropertyChangeListener(ComputableData.PROPERTY_COMPUTED_DATA, l);
                }
            }
        });

        editor.addPropertyChangeListener(ComputableDataEditor.PROPERTY_MODEL, l);

        editor.getTextField().addFocusListener(new FocusListener() {

            public void focusGained(FocusEvent e) {
                JTextField tf = editor.getTextField();
                tf.setFont(TuttiUI.TEXTFIELD_NORMAL_FONT);
                tf.setForeground(Color.BLACK);
                if (editor.getModel() == null) {
                    tf.setText("");
                }
            }

            public void focusLost(FocusEvent e) {
                setComputedTextIfNullModel();
            }
        });

        editor.addPropertyChangeListener(ComputableDataEditor.PROPERTY_DECIMAL_NUMBER,
                                         new PropertyChangeListener() {

                                             public void propertyChange(PropertyChangeEvent evt) {
                                                 decimalNumber = (Integer) evt.getNewValue();
                                             }
                                         });

        decimalNumber = ((ComputableDataEditor) editor).getDecimalNumber();

        super.init();

    }

    protected void setComputedTextIfNullModel() {
        ComputableData bean = (ComputableData) editor.getBean();
        JTextField tf = editor.getTextField();
        if (bean != null && editor.getModel() == null) {
            tf.setFont(TuttiUI.TEXTFIELD_COMPUTED_FONT);
            tf.setForeground(((ComputableDataEditor) editor).getComputedDataColor());

            String modelText;
            Number computedData = bean.getComputedData();
            if (editor.isUseFloat()
                && decimalNumber != null && computedData != null) {
                DecimalFormat decimalFormat = TuttiEntities.getDecimalFormat(1, decimalNumber);
                modelText = decimalFormat.format(computedData);
            } else {
                modelText = JAXXUtil.getStringValue(computedData);
            }
            tf.setText(modelText);

        } else {
            tf.setFont(TuttiUI.TEXTFIELD_NORMAL_FONT);
            tf.setForeground(Color.BLACK);
        }
    }

}
