/*
 * Decompiled with CFR 0.152.
 */
package jaxx.runtime.swing.editor;

import java.util.EnumSet;
import java.util.Iterator;
import javax.swing.JComboBox;
import org.nuiton.util.ReflectUtil;

public class EnumEditor<E extends Enum<E>>
extends JComboBox {
    private static final long serialVersionUID = 2L;
    protected Class<E> type;

    public static <E extends Enum<E>> EnumEditor<E> newEditor(Class<E> type) {
        return new EnumEditor<E>(type);
    }

    public static <E extends Enum<E>> EnumEditor<E> newEditor(Class<E> type, int maxOrdinal) {
        return new EnumEditor<E>(type, maxOrdinal);
    }

    public static <E extends Enum<E>> EnumEditor<E> newEditor(E ... universe) {
        return new EnumEditor(universe);
    }

    public EnumEditor(Class<E> type) {
        super(EnumEditor.buildModel(type));
    }

    public EnumEditor(Class<E> type, int maxOrdinal) {
        super(EnumEditor.buildModel(type, maxOrdinal));
    }

    public EnumEditor(E ... universe) {
        super(universe);
    }

    public E getSelectedItem() {
        return (E)((Enum)super.getSelectedItem());
    }

    protected static <E extends Enum<E>> Object[] buildModel(Class<E> type) {
        Class enumClass = ReflectUtil.getEnumClass(type);
        EnumSet result = EnumSet.allOf(enumClass);
        return result.toArray(new Object[result.size()]);
    }

    protected static <E extends Enum<E>> Object[] buildModel(Class<E> type, int maxOrdinal) {
        Class enumClass = ReflectUtil.getEnumClass(type);
        EnumSet result = EnumSet.allOf(enumClass);
        Iterator itr = result.iterator();
        while (itr.hasNext()) {
            Enum e = (Enum)itr.next();
            if (e.ordinal() <= maxOrdinal) continue;
            itr.remove();
        }
        return result.toArray(new Object[result.size()]);
    }
}

