/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2;

import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.XWorkException;
import com.opensymphony.xwork2.inject.Container;
import com.opensymphony.xwork2.util.ValueStack;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionContext
implements Serializable {
    static ThreadLocal<ActionContext> actionContext = new ThreadLocal();
    public static final String ACTION_NAME = "com.opensymphony.xwork2.ActionContext.name";
    public static final String VALUE_STACK = "com.opensymphony.xwork2.util.ValueStack.ValueStack";
    public static final String SESSION = "com.opensymphony.xwork2.ActionContext.session";
    public static final String APPLICATION = "com.opensymphony.xwork2.ActionContext.application";
    public static final String PARAMETERS = "com.opensymphony.xwork2.ActionContext.parameters";
    public static final String LOCALE = "com.opensymphony.xwork2.ActionContext.locale";
    public static final String TYPE_CONVERTER = "com.opensymphony.xwork2.ActionContext.typeConverter";
    public static final String ACTION_INVOCATION = "com.opensymphony.xwork2.ActionContext.actionInvocation";
    public static final String CONVERSION_ERRORS = "com.opensymphony.xwork2.ActionContext.conversionErrors";
    public static final String CONTAINER = "com.opensymphony.xwork2.ActionContext.container";
    private Map<String, Object> context;

    public ActionContext(Map<String, Object> context) {
        this.context = context;
    }

    public void setActionInvocation(ActionInvocation actionInvocation) {
        this.put(ACTION_INVOCATION, actionInvocation);
    }

    public ActionInvocation getActionInvocation() {
        return (ActionInvocation)this.get(ACTION_INVOCATION);
    }

    public void setApplication(Map<String, Object> application) {
        this.put(APPLICATION, application);
    }

    public Map<String, Object> getApplication() {
        return (Map)this.get(APPLICATION);
    }

    public static void setContext(ActionContext context) {
        actionContext.set(context);
    }

    public static ActionContext getContext() {
        return actionContext.get();
    }

    public void setContextMap(Map<String, Object> contextMap) {
        ActionContext.getContext().context = contextMap;
    }

    public Map<String, Object> getContextMap() {
        return this.context;
    }

    public void setConversionErrors(Map<String, Object> conversionErrors) {
        this.put(CONVERSION_ERRORS, conversionErrors);
    }

    public Map<String, Object> getConversionErrors() {
        HashMap<String, Object> errors = (HashMap<String, Object>)this.get(CONVERSION_ERRORS);
        if (errors == null) {
            errors = new HashMap<String, Object>();
            this.setConversionErrors(errors);
        }
        return errors;
    }

    public void setLocale(Locale locale) {
        this.put(LOCALE, locale);
    }

    public Locale getLocale() {
        Locale locale = (Locale)this.get(LOCALE);
        if (locale == null) {
            locale = Locale.getDefault();
            this.setLocale(locale);
        }
        return locale;
    }

    public void setName(String name) {
        this.put(ACTION_NAME, name);
    }

    public String getName() {
        return (String)this.get(ACTION_NAME);
    }

    public void setParameters(Map<String, Object> parameters) {
        this.put(PARAMETERS, parameters);
    }

    public Map<String, Object> getParameters() {
        return (Map)this.get(PARAMETERS);
    }

    public void setSession(Map<String, Object> session) {
        this.put(SESSION, session);
    }

    public Map<String, Object> getSession() {
        return (Map)this.get(SESSION);
    }

    public void setValueStack(ValueStack stack) {
        this.put(VALUE_STACK, stack);
    }

    public ValueStack getValueStack() {
        return (ValueStack)this.get(VALUE_STACK);
    }

    public void setContainer(Container cont) {
        this.put(CONTAINER, cont);
    }

    public Container getContainer() {
        return (Container)this.get(CONTAINER);
    }

    public <T> T getInstance(Class<T> type) {
        Container cont = this.getContainer();
        if (cont != null) {
            return cont.getInstance(type);
        }
        throw new XWorkException("Cannot find an initialized container for this request.");
    }

    public Object get(String key) {
        return this.context.get(key);
    }

    public void put(String key, Object value) {
        this.context.put(key, value);
    }
}

