package fr.ifremer.tutti.ui.swing.util.computable;

/*
 * #%L
 * Tutti :: UI
 * $Id: ComputableData.java 1573 2014-02-04 16:41:40Z tchemit $
 * $HeadURL: https://svn.codelutin.com/tutti/tags/tutti-3.3.2/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/util/computable/ComputableData.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer, CodeLutin, Tony CHEMIT
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import org.jdesktop.beans.AbstractSerializableBean;
import org.nuiton.jaxx.application.listener.PropagatePropertyChangeListener;


/**
 * A number data plus a possible computed value.
 *
 * @author kmorin <kmorin@codelutin.com>
 * @since 1.0
 */
public class ComputableData<N extends Number> extends AbstractSerializableBean {

    public static final String PROPERTY_DATA = "data";

    public static final String PROPERTY_COMPUTED_DATA = "computedData";

    private static final long serialVersionUID = 1L;

    protected N data;

    protected N computedData;

    public ComputableData() {
        data = null;
        computedData = null;
    }

    public ComputableData(N data, N computedData) {
        this.data = data;
        this.computedData = computedData;
    }

    public N getData() {
        return data;
    }

    public void setData(N data) {
        Object oldValue = getData();
        this.data = data;
        firePropertyChange(PROPERTY_DATA, oldValue, data);
    }

    public N getComputedData() {
        return computedData;
    }

    public void setComputedData(N computedData) {
        Object oldValue = getComputedData();
        this.computedData = computedData;
        firePropertyChange(PROPERTY_COMPUTED_DATA, oldValue, computedData);
    }

    @Override
    public String toString() {
        String result = null;
        if (data != null) {
            result = data.toString();
        } else if (computedData != null) {
            result = computedData.toString();
        }
        return result;
    }

    /**
     * Add a listener to propagate the modification of the
     * {@link #PROPERTY_DATA} property to a given {@code propertyName}.
     *
     * @param propertyName name of the property to fire on given bean
     * @param otherBean    bean that will fires
     * @since 1.2
     */
    public void addPropagateListener(String propertyName,
                                     PropagatePropertyChangeListener.PropagatePropertyChange otherBean) {

        PropagatePropertyChangeListener.listenAndPropagate(this,
                                                           otherBean,
                                                           PROPERTY_DATA,
                                                           propertyName);

//        PropagatePropertyChangeListener listener = new PropagatePropertyChangeListener(propertyName, otherBean);
//        addPropertyChangeListener(PROPERTY_DATA, listener);
    }

//    private static class PropagateProperyChangeListener implements PropertyChangeListener {
//
//        private String propertyName;
//
//        private AbstractTuttiBeanUIModel otherBean;
//
//        public PropagatePropertyChangeLstener(String propertyName,
//                                               AbstractTuttiBeanUIModel otherBean) {
//            this.propertyName = propertyName;
//            this.otherBean = otherBean;
//        }
//
//        @Override
//        public void propertyChange(PropertyChangeEvent evt) {
//            otherBean.firePropertyChanged(propertyName, evt.getOldValue(), evt.getNewValue());
//        }
//    }
}
