/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.pupitri;

import com.google.common.base.Preconditions;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;

public class SpeciesRow
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String PROPERTY_CODE_FIRST_PART = "codeFirstPart";
    public static final String PROPERTY_CODE_SECOND_PART = "codeSecondPart";
    public static final String PROPERTY_SCIENTIFIC_NAME = "scientificName";
    protected final Species species;

    public SpeciesRow(Species species) {
        Preconditions.checkNotNull((Object)species.getSurveyCode(), (Object)("Unable to export a species with a null survey code : " + species));
        this.species = species;
    }

    public String getCodeFirstPart() {
        String codeFirstPart = StringUtils.substring((String)this.species.getSurveyCode(), (int)0, (int)4);
        String result = StringUtils.rightPad((String)codeFirstPart, (int)4);
        return result;
    }

    public String getCodeSecondPart() {
        String codeSecondPart = StringUtils.substring((String)this.species.getSurveyCode(), (int)4, (int)7);
        String result = StringUtils.rightPad((String)codeSecondPart, (int)3);
        return result;
    }

    public String getScientificName() {
        return this.species.getName();
    }
}

