/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.script.internal;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.birt.report.engine.api.script.ScriptException;
import org.eclipse.birt.report.engine.api.script.element.IHideRule;
import org.eclipse.birt.report.engine.script.internal.element.HideRuleImpl;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.HideRuleHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;

public class HideRuleMethodUtil {
    public static IHideRule[] getHideRules(DesignElementHandle handle) {
        PropertyHandle propHandle = handle.getPropertyHandle("visibility");
        Iterator iterator = propHandle.iterator();
        ArrayList<HideRuleImpl> rList = new ArrayList<HideRuleImpl>();
        int count = 0;
        while (iterator.hasNext()) {
            HideRuleHandle ruleHandle = (HideRuleHandle)iterator.next();
            HideRuleImpl rule = new HideRuleImpl(ruleHandle);
            rList.add(rule);
            ++count;
        }
        return rList.toArray(new IHideRule[count]);
    }

    public static void removeHideRule(DesignElementHandle handle, IHideRule rule) throws ScriptException {
        PropertyHandle propHandle = handle.getPropertyHandle("visibility");
        try {
            propHandle.removeItem(rule.getStructure());
        }
        catch (SemanticException e) {
            throw new ScriptException(e.getLocalizedMessage());
        }
    }

    public static void addHideRule(DesignElementHandle handle, IHideRule rule) throws ScriptException {
        if (rule == null) {
            return;
        }
        PropertyHandle propHandle = handle.getPropertyHandle("visibility");
        try {
            propHandle.addItem(rule.getStructure());
        }
        catch (SemanticException e) {
            throw new ScriptException(e.getLocalizedMessage());
        }
    }

    public static void removeHideRules(DesignElementHandle handle) throws ScriptException {
        PropertyHandle propHandle = handle.getPropertyHandle("visibility");
        try {
            propHandle.clearValue();
        }
        catch (SemanticException e) {
            throw new ScriptException(e.getLocalizedMessage());
        }
    }
}

