/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.executor;

import org.eclipse.birt.report.engine.content.IAutoTextContent;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.executor.ExecutorManager;
import org.eclipse.birt.report.engine.executor.StyledItemExecutor;
import org.eclipse.birt.report.engine.ir.AutoTextItemDesign;

public class AutoTextItemExecutor
extends StyledItemExecutor {
    public AutoTextItemExecutor(ExecutorManager manager) {
        super(manager, 10);
    }

    @Override
    public IContent execute() {
        AutoTextItemDesign textDesign = (AutoTextItemDesign)this.getDesign();
        IAutoTextContent textContent = this.report.createAutoTextContent();
        this.setContent(textContent);
        this.restoreResultSet();
        this.initializeContent(textDesign, textContent);
        this.processStyle(this.design, this.content);
        this.processVisibility(this.design, this.content);
        String type = ((AutoTextItemDesign)this.design).getType();
        if ("page-number".equalsIgnoreCase(type)) {
            textContent.setType(1);
        } else if ("total-page".equalsIgnoreCase(type)) {
            textContent.setType(0);
        } else if ("page-number-unfiltered".equalsIgnoreCase(type)) {
            textContent.setType(3);
        } else if ("total-page-unfiltered".equalsIgnoreCase(type)) {
            textContent.setType(2);
        } else if ("page-variable".equalsIgnoreCase(type)) {
            textContent.setType(4);
        }
        if (this.context.isInFactory()) {
            this.handleOnCreate(textContent);
        }
        return textContent;
    }
}

