/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.persistence.service.referential;

import fr.ifremer.tutti.persistence.TuttiPersistenceServiceImplementor;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import java.util.Collection;
import java.util.List;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.transaction.annotation.Transactional;

@Transactional(readOnly=true)
public interface SpeciesPersistenceService
extends TuttiPersistenceServiceImplementor {
    @Cacheable(value={"referentSpecies"})
    public List<Species> getAllReferentSpecies();

    @Cacheable(value={"species"})
    public List<Species> getAllSpecies();

    @Cacheable(value={"referentSpeciesById"}, key="#referenceTaxonId")
    public Species getSpeciesByReferenceTaxonId(Integer var1);

    @Cacheable(value={"referentSpeciesByIdVernacular"}, key="#referenceTaxonId")
    public Species getSpeciesByReferenceTaxonIdWithVernacularCode(Integer var1);

    public boolean isTemporarySpeciesUsed(Integer var1);

    @Transactional(readOnly=false)
    @CacheEvict(value={"species", "referentSpecies", "referentSpeciesById", "referentSpeciesByIdVernacular"}, allEntries=true)
    public List<Species> addTemporarySpecies(List<Species> var1);

    @Transactional(readOnly=false)
    @CacheEvict(value={"species", "referentSpecies", "referentSpeciesById", "referentSpeciesByIdVernacular"}, allEntries=true)
    public List<Species> updateTemporarySpecies(List<Species> var1);

    public List<Species> linkTemporarySpecies(List<Species> var1);

    @Transactional(readOnly=false)
    @CacheEvict(value={"fr.ifremer.adagio.core.dao.data.batch.CatchBatchCache", "species", "referentSpecies", "referentSpeciesById", "referentSpeciesByIdVernacular"}, allEntries=true)
    public void replaceSpecies(Species var1, Species var2, boolean var3);

    @Transactional(readOnly=false)
    @CacheEvict(value={"species", "referentSpecies", "referentSpeciesById", "referentSpeciesByIdVernacular"}, allEntries=true)
    public void deleteTemporarySpecies(Collection<Integer> var1);

    @Transactional(readOnly=false)
    @CacheEvict(value={"species", "referentSpecies", "referentSpeciesById", "referentSpeciesByIdVernacular"}, allEntries=true)
    public void deleteTemporarySpecies(Integer var1);
}

