/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.genericformat;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import fr.ifremer.tutti.persistence.entities.CaracteristicMap;
import fr.ifremer.tutti.persistence.entities.data.CatchBatch;
import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.data.FishingOperations;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.Gear;
import fr.ifremer.tutti.persistence.entities.referential.GearWithOriginalRankOrder;
import fr.ifremer.tutti.service.genericformat.GenericFormatImportOperationContext;
import fr.ifremer.tutti.service.genericformat.csv.RowWithOperationContextSupport;
import java.io.Closeable;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class GenericFormatImportCruiseContext
implements Closeable {
    private final Cruise cruise;
    private final boolean override;
    private final String cruiseLabel;
    private final Map<String, GenericFormatImportOperationContext> fishingOperationContexts;
    private final Set<Gear> gearsWithcaracteristics;

    public GenericFormatImportCruiseContext(Cruise cruise, boolean override, String cruiseLabel) {
        this.cruise = cruise;
        this.override = override;
        this.cruiseLabel = cruiseLabel;
        this.fishingOperationContexts = new TreeMap<String, GenericFormatImportOperationContext>();
        this.gearsWithcaracteristics = new HashSet<Gear>();
    }

    @Override
    public void close() {
        for (GenericFormatImportOperationContext cruiseContext : this.fishingOperationContexts.values()) {
            cruiseContext.close();
        }
        this.fishingOperationContexts.clear();
    }

    public Cruise getCruise() {
        return this.cruise;
    }

    public boolean isOverride() {
        return this.override;
    }

    public String getCruiseLabel() {
        return this.cruiseLabel;
    }

    public Gear getGear(Gear gear, int rankOrder) {
        GearWithOriginalRankOrder cruiseGear;
        boolean gearExists;
        GearWithOriginalRankOrder result = null;
        int index = rankOrder - 1;
        boolean bl = gearExists = this.cruise.sizeGear() > index;
        if (gearExists && (gearExists = (cruiseGear = this.cruise.getGear(index)).getId().equals(gear.getId()))) {
            result = cruiseGear;
        }
        return result;
    }

    public void addFishingOperation(FishingOperation fishingOperation, CatchBatch catchBatch, String fishingOperationLabel) {
        this.fishingOperationContexts.put(fishingOperation.getId(), new GenericFormatImportOperationContext(fishingOperation, catchBatch, fishingOperationLabel));
    }

    public GenericFormatImportOperationContext getFishingOperationContext(FishingOperation fishingOperation) {
        GenericFormatImportOperationContext result = this.fishingOperationContexts.get(fishingOperation.getId());
        return result;
    }

    public boolean isFishingOperationAlreadyImported(RowWithOperationContextSupport row) {
        GenericFormatImportOperationContext fishingOperationContext = this.getFishingOperationContext(row);
        boolean found = fishingOperationContext != null;
        return found;
    }

    public GenericFormatImportOperationContext getFishingOperationContext(RowWithOperationContextSupport row) {
        FishingOperation fishingOperation = row.getFishingOperation();
        GenericFormatImportOperationContext result = null;
        for (GenericFormatImportOperationContext importOperationContext : this.fishingOperationContexts.values()) {
            FishingOperation importedFishingOperation = importOperationContext.getFishingOperation();
            boolean equals = FishingOperations.equals((FishingOperation)importedFishingOperation, (FishingOperation)fishingOperation);
            if (!equals) continue;
            result = importOperationContext;
            break;
        }
        return result;
    }

    public Collection<GenericFormatImportOperationContext> getFishingOperationContexts() {
        return ImmutableList.copyOf(this.fishingOperationContexts.values());
    }

    public Iterable<FishingOperation> getFishingOperations() {
        return Iterables.transform(this.fishingOperationContexts.values(), GenericFormatImportOperationContext.TO_FISHING_OPERATION_FUNCTION);
    }

    public boolean withGearCaracteristics() {
        return !this.gearsWithcaracteristics.isEmpty();
    }

    public void addGearCaracteristic(Gear gear, Caracteristic caracteristic, Serializable caracteristicValue) {
        this.gearsWithcaracteristics.add(gear);
        CaracteristicMap caracteristics = gear.getCaracteristics();
        if (caracteristics == null) {
            caracteristics = new CaracteristicMap();
            gear.setCaracteristics(caracteristics);
        }
        caracteristics.put((Object)caracteristic, (Object)caracteristicValue);
    }

    public Set<Gear> getGearsWithcaracteristics() {
        return this.gearsWithcaracteristics;
    }
}

