/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.genericformat;

import fr.ifremer.tutti.persistence.ProgressionModel;
import fr.ifremer.tutti.persistence.entities.data.CatchBatch;
import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.persistence.entities.data.Cruises;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.data.FishingOperations;
import fr.ifremer.tutti.persistence.model.CruiseDataModel;
import fr.ifremer.tutti.persistence.model.OperationDataModel;
import fr.ifremer.tutti.persistence.model.ProgramDataModel;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.service.genericformat.GenericFormatContextSupport;
import fr.ifremer.tutti.service.genericformat.GenericFormatImportCruiseContext;
import fr.ifremer.tutti.service.genericformat.GenericFormatImportOperationContext;
import fr.ifremer.tutti.service.genericformat.GenericFormatImportRequest;
import fr.ifremer.tutti.service.genericformat.importactions.RestoreAfterValidateAction;
import java.util.LinkedHashSet;
import org.nuiton.decorator.Decorator;

public class GenericFormatValidateFileContext
extends GenericFormatContextSupport {
    private final RestoreAfterValidateAction closeAction;
    private int fishinOperationId = -1;
    private int catchBatchId = -1;

    public GenericFormatValidateFileContext(GenericFormatImportRequest importRequest, ProgressionModel progressionModel, PersistenceService persistenceService, Decorator<Cruise> cruiseDecorator, Decorator<FishingOperation> fishingOperationDecorator) {
        super(importRequest, progressionModel, persistenceService, cruiseDecorator, fishingOperationDecorator);
        this.closeAction = new RestoreAfterValidateAction(this, persistenceService);
    }

    @Override
    protected void onClose() {
        this.closeAction.execute();
    }

    public ProgramDataModel toDataModel() {
        final LinkedHashSet importedCruises = new LinkedHashSet();
        this.doActionOnCruiseContexts(new GenericFormatContextSupport.CruiseContextAction(){

            @Override
            public void onCruise(GenericFormatImportCruiseContext cruiseContext, ProgressionModel progressionModel) {
                Cruise cruise = cruiseContext.getCruise();
                CruiseDataModel existingCruiseData = cruiseContext.getExistingCruiseData();
                LinkedHashSet<OperationDataModel> operations = new LinkedHashSet<OperationDataModel>();
                for (GenericFormatImportOperationContext fishingOperationContext : cruiseContext) {
                    FishingOperation fishingOperation = fishingOperationContext.getFishingOperation();
                    String naturalId = FishingOperations.getNaturalId((FishingOperation)fishingOperation);
                    fishingOperation.setId(naturalId);
                    OperationDataModel operation = new OperationDataModel(fishingOperation);
                    fishingOperation.setId((String)null);
                    OperationDataModel existingFishingOperationData = fishingOperationContext.getExistingFishingOperationData();
                    if (existingFishingOperationData != null) {
                        operation.setOptionalId(existingFishingOperationData.getId());
                    }
                    operations.add(operation);
                }
                String naturalId = Cruises.getNaturalId((Cruise)cruise);
                cruise.setId(naturalId);
                CruiseDataModel cruiseModel = new CruiseDataModel(cruise, operations);
                cruise.setId((String)null);
                if (existingCruiseData != null) {
                    cruiseModel.setOptionalId(existingCruiseData.getId());
                }
                importedCruises.add(cruiseModel);
            }
        });
        ProgramDataModel result = new ProgramDataModel(this.getImportRequest().getProgram(), importedCruises);
        return result;
    }

    @Override
    public void addImportedFishingOperation(FishingOperation fishingOperation, CatchBatch catchBatch) {
        fishingOperation.setId(Integer.valueOf(this.getNextFishingOperationId()));
        catchBatch.setId(Integer.valueOf(this.getNextCatchBatchId()));
        super.addImportedFishingOperation(fishingOperation, catchBatch);
    }

    private int getNextFishingOperationId() {
        return this.fishinOperationId--;
    }

    private int getNextCatchBatchId() {
        return this.catchBatchId--;
    }
}

